/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.regression;

import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class Regression_146642
extends BaseTestCase {
    private static final String INPUT = "Regression_146642.xml";
    private static final String LIB = "Regression_146642_lib.xml";

    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(INPUT, INPUT);
        this.copyResource_INPUT(LIB, LIB);
    }

    public void tearDown() {
        this.removeResource();
    }

    public void test_Regression_146642_Test1() throws DesignFileException, SemanticException {
        this.openDesign(INPUT);
        LabelHandle label = (LabelHandle)this.designHandle.findElement("label");
        Regression_146642.assertNotNull((Object)label);
        SharedStyleHandle style = this.designHandle.findStyle("Style");
        Regression_146642.assertNotNull((Object)style);
        HighlightRule rule = StructureFactory.createHighlightRule();
        HighlightRuleHandle ruleHandle = (HighlightRuleHandle)label.getPropertyHandle("highlightRules").addItem((IStructure)rule);
        ruleHandle.setStyle((StyleHandle)style);
        Regression_146642.assertNotNull((Object)ruleHandle.getStyle());
        Regression_146642.assertEquals((String)"solid", (String)ruleHandle.getStyle().getBorderTopStyle());
        Regression_146642.assertEquals((String)"#FF0000", (String)ruleHandle.getStyle().getBorderTopColor().getStringValue());
        Regression_146642.assertEquals((Object)"thick", (Object)ruleHandle.getStyle().getBorderTopWidth().getValue());
    }

    public void test_Regression_146642_Test2() throws DesignFileException, SemanticException {
        this.openDesign(INPUT);
        TableHandle table = (TableHandle)this.designHandle.findElement("table");
        Regression_146642.assertNotNull((Object)table);
        SharedStyleHandle style = this.designHandle.findStyle("table");
        Regression_146642.assertNotNull((Object)style);
        HighlightRule rule = StructureFactory.createHighlightRule();
        HighlightRuleHandle ruleHandle = (HighlightRuleHandle)table.getPropertyHandle("highlightRules").addItem((IStructure)rule);
        ruleHandle.setStyle((StyleHandle)style);
        Regression_146642.assertNotNull((Object)ruleHandle.getStyle());
        Regression_146642.assertEquals((String)"small", (String)ruleHandle.getStyle().getFontSize().getStringValue());
        Regression_146642.assertEquals((String)"bold", (String)ruleHandle.getStyle().getFontWeight());
        Regression_146642.assertEquals((String)"italic", (String)ruleHandle.getStyle().getFontStyle());
        Regression_146642.assertEquals((String)"#0000FF", (String)ruleHandle.getColor().getStringValue());
        Regression_146642.assertEquals((Object)"\"Arial\"", (Object)ruleHandle.getStyle().getFontFamilyHandle().getValue());
    }

    public void test_Regression_146642_Test3() throws DesignFileException, SemanticException {
        this.openLibrary(LIB);
        TextItemHandle text = (TextItemHandle)this.libraryHandle.findElement("text");
        Regression_146642.assertNotNull((Object)text);
        SharedStyleHandle style = this.libraryHandle.findStyle("Style3");
        Regression_146642.assertNotNull((Object)style);
        HighlightRule rule = StructureFactory.createHighlightRule();
        HighlightRuleHandle ruleHandle = (HighlightRuleHandle)text.getPropertyHandle("highlightRules").addItem((IStructure)rule);
        ruleHandle.setStyle((StyleHandle)style);
        Regression_146642.assertNotNull((Object)ruleHandle.getStyle());
        Regression_146642.assertEquals((String)"line-through", (String)ruleHandle.getStyle().getTextLineThrough());
        Regression_146642.assertEquals((String)"overline", (String)ruleHandle.getStyle().getTextOverline());
        Regression_146642.assertEquals((String)"underline", (String)ruleHandle.getStyle().getTextUnderline());
        Regression_146642.assertEquals((String)"center", (String)ruleHandle.getStyle().getTextAlign());
        Regression_146642.assertEquals((String)"6pt", (String)ruleHandle.getStyle().getTextIndent().getStringValue());
        Regression_146642.assertEquals((String)"uppercase", (String)ruleHandle.getStyle().getTextTransform());
        Regression_146642.assertEquals((String)"pre", (String)ruleHandle.getStyle().getWhiteSpace());
    }
}

