/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.regression;

import java.io.File;
import java.io.IOException;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class Regression_148747
extends BaseTestCase {
    private static final String REPORT = "regression_148747.xml";
    private static final String LIB = "regression_148747_lib.xml";

    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/regression_148747.xml");
        this.copyInputToFile("input/regression_148747_lib.xml");
    }

    public void tearDown() {
        this.removeResource();
    }

    public void test_regression_148747() throws IOException, DesignFileException, ExtendsException, ContentException, NameException {
        String tempDir = System.getProperty("java.io.tmpdir");
        if (!tempDir.endsWith(File.separator)) {
            tempDir = String.valueOf(tempDir) + File.separator;
        }
        String outputFolder = String.valueOf(tempDir) + this.getFullQualifiedClassName() + File.separator + "output" + File.separator;
        String inputFolder = String.valueOf(this.getTempFolder()) + File.separator + "input" + File.separator;
        this.copyFile(String.valueOf(inputFolder) + REPORT, String.valueOf(outputFolder) + REPORT);
        this.copyFile(String.valueOf(inputFolder) + LIB, String.valueOf(outputFolder) + LIB);
        SessionHandle session = new DesignEngine(new DesignConfig()).newSessionHandle(null);
        ReportDesignHandle reportHandle = session.openDesign(String.valueOf(outputFolder) + "/" + REPORT);
        LibraryHandle lib = reportHandle.getLibrary("regression_148747_lib");
        Regression_148747.assertNotNull((Object)lib);
        MasterPageHandle page1 = lib.findMasterPage("page1");
        MasterPageHandle extendPage = (MasterPageHandle)reportHandle.getElementFactory().newElementFrom((DesignElementHandle)page1, "childPage");
        reportHandle.getMasterPages().add((DesignElementHandle)extendPage);
        reportHandle.save();
        reportHandle = session.openDesign(String.valueOf(outputFolder) + "/" + REPORT);
        Regression_148747.assertNotNull((Object)reportHandle.findMasterPage("childPage"));
        Regression_148747.assertEquals((int)0, (int)reportHandle.getErrorList().size());
        Regression_148747.assertTrue((boolean)reportHandle.isValid());
    }
}

