/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.regression;

import java.io.IOException;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TOCHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.TOC;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class Regression_159499
extends BaseTestCase {
    private static final String REPORT = "Regression_159499.xml";
    private static final String LIB = "Regression_159499_lib.xml";
    private static final String LIB_TEMP = "Regression_159499_lib_temp.xml";

    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(REPORT, REPORT);
        this.copyResource_INPUT(LIB, LIB);
        this.copyResource_INPUT(LIB_TEMP, LIB_TEMP);
    }

    public void tearDown() {
        this.removeResource();
    }

    public void test_Regression_159499_Test1() throws DesignFileException, SemanticException, IOException {
        this.openDesign(REPORT);
        LabelHandle label = (LabelHandle)this.designHandle.findElement("label");
        Regression_159499.assertNotNull((Object)label);
        SharedStyleHandle style1 = this.designHandle.findStyle("NewStyle");
        SharedStyleHandle style2 = this.designHandle.findStyle("Style2");
        Regression_159499.assertNotNull((Object)style1);
        Regression_159499.assertNotNull((Object)style2);
        TOC toc = StructureFactory.createTOC((String)"toc111");
        TOCHandle tocHandle = label.addTOC(toc);
        tocHandle.setStyleName(style1.getName());
        Regression_159499.assertEquals((String)"NewStyle", (String)tocHandle.getStyleName());
        Regression_159499.assertEquals((String)"#FF0000", (String)tocHandle.getColor().getStringValue());
        Regression_159499.assertEquals((Object)"\"Arial\"", (Object)tocHandle.getFontFamily().getValue());
        Regression_159499.assertEquals((String)"#FFFF00", (String)tocHandle.getBackgroundColor().getStringValue());
    }

    public void test_Regression_159499_Test2() throws DesignFileException, SemanticException, IOException {
        this.openLibrary(LIB_TEMP);
        LabelHandle lib_label = (LabelHandle)this.libraryHandle.findElement("label1");
        Regression_159499.assertNotNull((Object)lib_label);
        SharedStyleHandle style = this.libraryHandle.findStyle("Style");
        Regression_159499.assertNotNull((Object)style);
        this.openDesign(REPORT);
        this.designHandle.includeLibrary(LIB_TEMP, "lib");
        LabelHandle label = (LabelHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)lib_label, "label1");
        Regression_159499.assertNotNull((Object)label);
        TOCHandle tocHandle = label.getTOC();
        Regression_159499.assertNotNull((Object)tocHandle);
        Regression_159499.assertEquals((String)"#FF0000", (String)tocHandle.getColor().getStringValue());
        Regression_159499.assertEquals((Object)"\"Arial\"", (Object)tocHandle.getFontFamily().getValue());
        Regression_159499.assertEquals((String)"#FFFF00", (String)tocHandle.getBackgroundColor().getStringValue());
    }

    public void test_Regression_159499_Test3() throws DesignFileException, SemanticException {
        this.openDesign(REPORT);
        LabelHandle label = (LabelHandle)this.designHandle.findElement("label");
        Regression_159499.assertNotNull((Object)label);
        SharedStyleHandle style1 = this.designHandle.findStyle("NewStyle");
        SharedStyleHandle style2 = this.designHandle.findStyle("Style2");
        Regression_159499.assertNotNull((Object)style1);
        Regression_159499.assertNotNull((Object)style2);
        TOC toc = StructureFactory.createTOC();
        TOCHandle tocHandle = label.addTOC(toc);
        tocHandle.setStyleName(style1.getName());
        Regression_159499.assertEquals((String)"NewStyle", (String)tocHandle.getStyleName());
        Regression_159499.assertEquals((String)"#FF0000", (String)tocHandle.getColor().getStringValue());
        Regression_159499.assertEquals((Object)"\"Arial\"", (Object)tocHandle.getFontFamily().getValue());
        Regression_159499.assertEquals((String)"#FFFF00", (String)tocHandle.getBackgroundColor().getStringValue());
        TOC toc1 = StructureFactory.createTOC();
        TOCHandle tocHandle1 = label.addTOC(toc1);
        tocHandle1.setStyleName(style2.getName());
        Regression_159499.assertEquals((String)"Style2", (String)tocHandle1.getStyleName());
        Regression_159499.assertEquals((String)"#FF00FF", (String)tocHandle1.getColor().getStringValue());
        Regression_159499.assertEquals((Object)"cursive", (Object)tocHandle1.getFontFamily().getValue());
        Regression_159499.assertEquals((String)"#0000FF", (String)tocHandle1.getBackgroundColor().getStringValue());
    }

    public void test_Regression_159499_Test4() throws DesignFileException, SemanticException {
        this.openDesign(REPORT);
        TableHandle tableHandle = (TableHandle)this.designHandle.findElement("table");
        SlotHandle slot = tableHandle.getGroups();
        GroupHandle group1 = (GroupHandle)slot.get(0);
        GroupHandle group2 = (GroupHandle)slot.get(1);
        GroupHandle group3 = (GroupHandle)slot.get(2);
        Regression_159499.assertEquals((String)"row[\"COUNTRY\"]", (String)group1.getTOC().getExpression());
        Regression_159499.assertEquals((String)"row[\"STATE\"]", (String)group2.getTOC().getExpression());
        Regression_159499.assertEquals((String)"row[\"CITY\"]", (String)group3.getTOC().getExpression());
        TOCHandle tocHandle1 = group1.getTOC();
        TOCHandle tocHandle2 = group2.getTOC();
        TOCHandle tocHandle3 = group3.getTOC();
        tocHandle1.setStyleName("NewStyle");
        tocHandle2.setStyleName("Style2");
        tocHandle3.setStyleName("Style3");
        Regression_159499.assertEquals((String)"NewStyle", (String)tocHandle1.getStyleName());
        Regression_159499.assertEquals((String)"Style2", (String)tocHandle2.getStyleName());
        Regression_159499.assertEquals((String)"Style3", (String)tocHandle3.getStyleName());
        Regression_159499.assertEquals((String)"#FF0000", (String)tocHandle1.getColor().getStringValue());
        Regression_159499.assertEquals((Object)"\"Arial\"", (Object)tocHandle1.getFontFamily().getValue());
        Regression_159499.assertEquals((String)"#FFFF00", (String)tocHandle1.getBackgroundColor().getStringValue());
        Regression_159499.assertEquals((String)"#FF00FF", (String)tocHandle2.getColor().getStringValue());
        Regression_159499.assertEquals((Object)"cursive", (Object)tocHandle2.getFontFamily().getValue());
        Regression_159499.assertEquals((String)"#0000FF", (String)tocHandle2.getBackgroundColor().getStringValue());
        Regression_159499.assertEquals((String)"#FFA500", (String)tocHandle3.getColor().getStringValue());
        Regression_159499.assertEquals((Object)"fantasy", (Object)tocHandle3.getFontFamily().getValue());
        Regression_159499.assertEquals((String)"#808080", (String)tocHandle3.getBackgroundColor().getStringValue());
    }

    public void test_Regression_159499_Test5() throws DesignFileException, SemanticException {
        this.openDesign(REPORT);
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("label1");
        Regression_159499.assertNotNull((Object)labelHandle);
        SharedStyleHandle style = this.designHandle.findStyle("Style4");
        Regression_159499.assertNotNull((Object)style);
    }
}

