/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.regression;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.StyleException;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class Regression_161179
extends BaseTestCase {
    private static final String REPORT = "regression_161179.xml";
    private static final String REPORT1 = "regression_161179_1.xml";

    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/regression_161179.xml");
        this.copyGoldenToFile("input/regression_161179_1.xml");
    }

    public void tearDown() {
        this.removeResource();
    }

    public void test_regression_161179() throws SemanticException {
        DesignEngine engine = new DesignEngine(new DesignConfig());
        SessionHandle session = engine.newSessionHandle(ULocale.ENGLISH);
        ReportDesignHandle designHandle = session.createDesign();
        ElementFactory factory = designHandle.getElementFactory();
        TableHandle table = factory.newTableItem("table", 3, 1, 1, 1);
        designHandle.getBody().add((DesignElementHandle)table);
        RowHandle row = (RowHandle)table.getHeader().get(0);
        row.setStringProperty("borderTopStyle", "solid");
        row.setStringProperty("borderTopColor", "red");
        row.setStringProperty("borderTopWidth", "medium");
        Regression_161179.assertEquals((String)"solid", (String)row.getStringProperty("borderTopStyle"));
        Regression_161179.assertEquals((String)"red", (String)row.getStringProperty("borderTopColor"));
        Regression_161179.assertEquals((String)"medium", (String)row.getStringProperty("borderTopWidth"));
    }

    public void test_regression_161179_1() throws DesignFileException, StyleException {
        this.openDesign(REPORT);
        TableHandle table = (TableHandle)this.designHandle.findElement("table");
        RowHandle row = (RowHandle)table.getDetail().get(0);
        row.setStyleName("style");
        Regression_161179.assertEquals((String)"dotted", (String)row.getStringProperty("borderRightStyle"));
        Regression_161179.assertEquals((String)"thin", (String)row.getStringProperty("borderRightWidth"));
        Regression_161179.assertEquals((String)"black", (String)row.getStringProperty("borderRightColor"));
        RowHandle headerrow = (RowHandle)table.getHeader().get(0);
        CellHandle cell = (CellHandle)headerrow.getCells().get(0);
        Regression_161179.assertEquals((String)"none", (String)cell.getStringProperty("borderBottomStyle"));
        Regression_161179.assertEquals((String)"medium", (String)cell.getStringProperty("borderBottomWidth"));
        Regression_161179.assertEquals((String)"black", (String)cell.getStringProperty("borderBottomColor"));
    }

    public void test_regression_161179_2() throws DesignFileException, SemanticException {
        this.openDesign(REPORT1);
        this.libraryHandle = this.designHandle.getLibrary("LIB");
        Regression_161179.assertNotNull((Object)this.libraryHandle);
        TableHandle table = (TableHandle)this.libraryHandle.findElement("table");
        Regression_161179.assertNotNull((Object)table);
        TableHandle newtable = (TableHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)table, "newTable");
        this.designHandle.getBody().add((DesignElementHandle)newtable);
        RowHandle row = (RowHandle)newtable.getHeader().get(0);
        Regression_161179.assertEquals((String)"dashed", (String)row.getStringProperty("borderTopStyle"));
        Regression_161179.assertEquals((String)"thin", (String)row.getStringProperty("borderTopWidth"));
        Regression_161179.assertEquals((String)"blue", (String)row.getStringProperty("borderTopColor"));
        TableHandle table1 = this.designHandle.getElementFactory().newTableItem("table1", 3, 1, 1, 1);
        RowHandle detailrow = (RowHandle)table1.getDetail().get(0);
        this.designHandle.setThemeName("LIB.theme1");
        detailrow.setStyleName("style");
        Regression_161179.assertEquals((String)"double", (String)detailrow.getStringProperty("borderLeftStyle"));
        Regression_161179.assertEquals((String)"thick", (String)detailrow.getStringProperty("borderLeftWidth"));
        Regression_161179.assertEquals((String)"green", (String)detailrow.getStringProperty("borderLeftColor"));
    }
}

