/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.tests.data.engine.api;

import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import testutil.APITestCase;
import testutil.ConfigText;

public class MultiPass_FilterTest
extends APITestCase {
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(this, ConfigText.getString("Api.TestData.TableName"), ConfigText.getString("Api.TestData.TableSQL"), ConfigText.getString("Api.TestData.TestDataFileName"));
    }

    public void test_FilteWithTopN() throws Exception {
        String[] bindingNameFilter = new String[]{"FILTER_AMOUNT", "FILTER_COUNTRY", "FILTER_SALE_DATE"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.AMOUNT"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.SALE_DATE")};
        String[] bindingNameRow = new String[]{"ROW_0", "ROW_rowPosition", "ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow[0]"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_AMOUNT", 14, "3"))};
        this.createAndRunQuery(null, null, null, null, null, null, bindingNameFilter, bindingExprFilter, filters, bindingNameRow, bindingExprRow);
    }

    public void test_FilterWithBottomN() throws Exception {
        String[] bindingNameFilter = new String[]{"FILTER_AMOUNT", "FILTER_COUNTRY", "FILTER_SALE_DATE"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.AMOUNT"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.SALE_DATE")};
        String[] bindingNameRow = new String[]{"ROW_0", "ROW_rowPosition", "ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow[0]"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_AMOUNT", 15, "3"))};
        this.createAndRunQuery(null, null, null, null, null, null, bindingNameFilter, bindingExprFilter, filters, bindingNameRow, bindingExprRow);
    }

    public void test_FilterGroup() throws Exception {
        String[] bindingNameFilter = new String[]{"FILTER_AMOUNT"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.AMOUNT")};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ScriptExpression("row.FILTER_AMOUNT > 100"))};
        FilterDefinition filterDefn = new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.sum(row.ROW_AMOUNT)", 16, "40"));
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0", "GROUP_GROUP1"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        groupDefn[1].setKeyExpression("row.GROUP_GROUP1");
        groupDefn[0].addFilter((IFilterDefinition)filterDefn);
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, bindingNameFilter, bindingExprFilter, filters, bindingNameRow, bindingExprRow);
    }

    public void test_MultiPassFilterGroup() throws Exception {
        String[] bindingNameFilter = new String[]{"FILTER_AMOUNT"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.AMOUNT")};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ScriptExpression("row.FILTER_AMOUNT > 100"))};
        FilterDefinition filterDefn = new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.sum(row.ROW_AMOUNT)", 16, "40"));
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0", "GROUP_GROUP1"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        groupDefn[1].setKeyExpression("row.GROUP_GROUP1");
        groupDefn[0].addFilter((IFilterDefinition)filterDefn);
        filterDefn = new FilterDefinition((IBaseExpression)new ScriptExpression("Total.sum(row.ROW_AMOUNT,Total.NO_FILTER,2)<=400"));
        groupDefn[1].setKeyExpression("row.GROUP_GROUP1");
        groupDefn[1].addFilter((IFilterDefinition)filterDefn);
        ConditionalExpression ce = new ConditionalExpression("Total.sum(row.ROW_AMOUNT)", 15, "1");
        ce.setGroupName("group1");
        filterDefn = new FilterDefinition((IBaseExpression)ce);
        groupDefn[1].addFilter((IFilterDefinition)filterDefn);
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, bindingNameFilter, bindingExprFilter, filters, bindingNameRow, bindingExprRow);
    }

    public void test_NegativeValueFilterGroup() throws Exception {
        String sqlStatement = "select COUNTRY,AMOUNT, SALE_DATE from " + this.getTestTableName();
        ((OdaDataSetDesign)this.dataSet).setQueryText(sqlStatement);
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.COUNTRY"), new ScriptExpression("row.AMOUNT"), new ScriptExpression("row.SALE_DATE")};
        String[] names = new String[]{"COL_COUNTRY", "COL_AMOUNT", "COL_SALE_DATE"};
        QueryDefinition queryDefn = new QueryDefinition();
        queryDefn.setDataSetName(this.dataSet.getName());
        int i = 0;
        while (i < expressions.length) {
            queryDefn.addResultSetExpression(names[i], expressions[i]);
            ++i;
        }
        FilterDefinition filterDefn = new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.sum(row.Amount,null,1)", 17, "-10"));
        GroupDefinition groupDefn = new GroupDefinition();
        groupDefn.setKeyExpression("row.SALE_DATE");
        groupDefn.setInterval(2);
        groupDefn.setIntervalRange(2.0);
        groupDefn.addFilter((IFilterDefinition)filterDefn);
        try {
            queryDefn.addGroup(groupDefn);
            IPreparedQuery preparedQuery = this.dataEngine.prepare((IQueryDefinition)queryDefn);
            IQueryResults queryResults = preparedQuery.execute(null);
            queryResults.getResultIterator();
            MultiPass_FilterTest.fail((String)"should throw out exception here");
        }
        catch (DataException dataException) {}
    }

    public void test_InvalidValueFilterGroup() throws Exception {
        String sqlStatement = "select COUNTRY,AMOUNT, SALE_DATE from " + this.getTestTableName();
        ((OdaDataSetDesign)this.dataSet).setQueryText(sqlStatement);
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.COUNTRY"), new ScriptExpression("row.AMOUNT"), new ScriptExpression("row.SALE_DATE")};
        String[] names = new String[]{"COL_COUNTRY", "COL_AMOUNT", "COL_SALE_DATE"};
        QueryDefinition queryDefn = new QueryDefinition();
        queryDefn.setDataSetName(this.dataSet.getName());
        int i = 0;
        while (i < expressions.length) {
            queryDefn.addResultSetExpression(names[i], expressions[i]);
            ++i;
        }
        FilterDefinition filterDefn = new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.sum(row.Amount,null,1)", 17, "abc"));
        GroupDefinition groupDefn = new GroupDefinition();
        groupDefn.setKeyExpression("row.SALE_DATE");
        groupDefn.setInterval(2);
        groupDefn.setIntervalRange(2.0);
        groupDefn.addFilter((IFilterDefinition)filterDefn);
        try {
            queryDefn.addGroup(groupDefn);
            IPreparedQuery preparedQuery = this.dataEngine.prepare((IQueryDefinition)queryDefn);
            IQueryResults queryResults = preparedQuery.execute(null);
            queryResults.getResultIterator();
            MultiPass_FilterTest.fail((String)"should throw out exception here");
        }
        catch (DataException dataException) {}
    }
}

