/*
 * Decompiled with CFR 0.152.
 */
package testutil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import junit.framework.TestCase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;

public abstract class BaseTestCase
extends TestCase {
    protected PrintStream testOut;
    protected Context jsContext;
    protected Scriptable jsScope;
    private static final String OUTPUT_FOLDER = "output";
    private static final String INPUT_FOLDER = "input";
    private static final String GOLDEN_FOLDER = "golden";
    private static final String TEST_FOLDER = "src";
    private String classFolder;

    protected void setUp() throws Exception {
        super.setUp();
        this.openOutputFolder();
        this.openOutputFile();
        this.jsContext = Context.enter();
        this.jsScope = new ImporterTopLevel(this.jsContext);
        this.jsScope.put("_testCase", this.jsScope, (Object)this);
        this.jsContext.evaluateString(this.jsScope, "function testPrint(str) { _testCase.testPrint(str); }; function testPrintln(str) { _testCase.testPrintln(str); }; ", "BaseTestCase.setUp", 1, null);
    }

    protected void tearDown() throws Exception {
        Context.exit();
        this.closeOutputFile();
        super.tearDown();
    }

    protected File getInputFolder() {
        return new File(this.getBaseFolder(), INPUT_FOLDER);
    }

    private File getBaseFolder() {
        if (this.classFolder == null) {
            CodeSource source;
            String pathBase = null;
            ProtectionDomain domain = ((Object)((Object)this)).getClass().getProtectionDomain();
            if (domain != null && (source = domain.getCodeSource()) != null) {
                URL url = source.getLocation();
                pathBase = url.getPath();
                if (pathBase.endsWith("bin/")) {
                    pathBase = pathBase.substring(0, pathBase.length() - 4);
                }
                if (pathBase.endsWith("bin")) {
                    pathBase = pathBase.substring(0, pathBase.length() - 3);
                }
            }
            pathBase = String.valueOf(pathBase) + TEST_FOLDER + "/";
            this.classFolder = pathBase.substring(1);
        }
        String className = ((Object)((Object)this)).getClass().getName();
        int lastDotIndex = className.lastIndexOf(".");
        className = className.substring(0, lastDotIndex);
        className = String.valueOf(this.classFolder) + className.replace('.', '/');
        return new File(className);
    }

    protected InputStream getInputFolder(String dataFileName) {
        InputStream result = ((Object)((Object)this)).getClass().getResourceAsStream("input/" + dataFileName);
        return result;
    }

    private File getOutputFolder() {
        return new File(new File(System.getProperty("java.io.tmpdir")), OUTPUT_FOLDER);
    }

    private void openOutputFolder() {
        File outputFolder = this.getOutputFolder();
        if (!outputFolder.exists()) {
            outputFolder.mkdir();
        }
    }

    protected void openOutputFile() throws IOException {
        File outputFile = new File(this.getOutputFolder(), this.getOutputFileName());
        this.testOut = new PrintStream(new FileOutputStream(outputFile, false));
    }

    protected void closeOutputFile() throws IOException {
        if (this.testOut != null) {
            this.testOut.close();
            this.testOut = null;
        }
    }

    private String getOutputFileName() {
        String className = ((Object)((Object)this)).getClass().getName();
        int lastDotIdx = className.lastIndexOf(46);
        if (lastDotIdx >= 0) {
            className = className.substring(lastDotIdx + 1);
        }
        return String.valueOf(className) + "." + this.getName() + ".txt";
    }

    protected void checkOutputFile() throws IOException {
        if (this.testOut != null) {
            this.testOut.flush();
        }
        String name = this.getOutputFileName();
        this.checkOutputFile(name, name);
    }

    private void checkOutputFile(String goldenFileName, String outputFileName) throws IOException {
        InputStream golden = ((Object)((Object)this)).getClass().getResourceAsStream("golden/" + goldenFileName);
        File outputFile = new File(this.getOutputFolder(), outputFileName);
        BaseTestCase.assertTrue((boolean)this.compareTextFile(golden, outputFile));
    }

    private boolean compareTextFile(InputStream golden, File outputFile) throws IOException {
        boolean same = true;
        InputStreamReader readerA = new InputStreamReader(golden);
        FileReader readerB = new FileReader(outputFile);
        BufferedReader lineReaderA = new BufferedReader(readerA);
        BufferedReader lineReaderB = new BufferedReader(readerB);
        String strA = lineReaderA.readLine().trim();
        String strB = lineReaderB.readLine().trim();
        while (strA != null && strB != null) {
            same = strA.trim().equals(strB.trim());
            if (!same) break;
            strA = lineReaderA.readLine();
            strB = lineReaderB.readLine();
        }
        same = strA == null && strB == null;
        golden.close();
        readerA.close();
        readerB.close();
        lineReaderA.close();
        lineReaderB.close();
        return same;
    }

    public void testPrint(String str) {
        System.out.print(str);
        if (this.testOut != null) {
            this.testOut.print(str);
        }
    }

    public void testPrintln(String str) {
        System.out.println(str);
        if (this.testOut != null) {
            this.testOut.println(str);
        }
    }
}

