/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.integration.wtp.ui.internal.wizards;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.birt.integration.wtp.ui.internal.exception.BirtCoreException;
import org.eclipse.birt.integration.wtp.ui.internal.resource.BirtWTPMessages;
import org.eclipse.birt.integration.wtp.ui.internal.util.Logger;
import org.eclipse.birt.integration.wtp.ui.internal.util.WebArtifactUtil;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.ContextParamBean;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.FilterBean;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.FilterMappingBean;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.ListenerBean;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.ServletBean;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.ServletMappingBean;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.TagLibBean;
import org.eclipse.birt.integration.wtp.ui.internal.webapplication.WebAppBean;
import org.eclipse.birt.integration.wtp.ui.internal.wizards.IBirtWizardConstants;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.osgi.framework.Bundle;

public class BirtWizardUtil
implements IBirtWizardConstants {
    public static IConfigurationElement[] findConfigurationElementsByExtension(String extensionId) {
        if (extensionId == null) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionId);
        if (extensionPoint == null) {
            return null;
        }
        return extensionPoint.getConfigurationElements();
    }

    public static IConfigurationElement findConfigurationElementById(String extensionId, String id) {
        IConfigurationElement[] elements = BirtWizardUtil.findConfigurationElementsByExtension(extensionId);
        if (elements == null) {
            return null;
        }
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element != null && id.equals(element.getAttribute("id"))) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public static IFolder getFolder(IProject project, String dest) throws CoreException {
        IFolder folder;
        if (project == null) {
            return null;
        }
        if (dest == null || dest.length() <= 0) {
            dest = "";
        }
        if (!(folder = project.getFolder(dest)).exists()) {
            folder.create(true, true, null);
        }
        return folder;
    }

    public static void doImports(IProject project, String source, IPath destPath, IProgressMonitor monitor, IOverwriteQuery query) throws CoreException {
        IConfigurationElement configElement = BirtWizardUtil.findConfigurationElementById("org.eclipse.wst.common.ui.exampleProjectCreationWizard", "org.eclipse.birt.integration.wtp.ui.BirtExampleProjectCreationWizard");
        if (source == null && configElement != null) {
            IConfigurationElement[] projects = configElement.getChildren("projectsetup");
            IConfigurationElement[] imports = null;
            if (projects != null && projects.length > 0) {
                imports = projects[0].getChildren("import");
            }
            if (imports != null && imports.length > 0) {
                source = imports[0].getAttribute("src");
            }
        }
        if (source == null) {
            String message = BirtWTPMessages.BIRTErrors_miss_source;
            Logger.log(4, message);
            throw BirtCoreException.getException(message, null);
        }
        ZipFile zipFile = BirtWizardUtil.getZipFileFromPluginDir(source, BirtWizardUtil.getContributingPlugin(configElement));
        BirtWizardUtil.importFilesFromZip(zipFile, destPath, (IProgressMonitor)new SubProgressMonitor(monitor, 1), query);
    }

    private static String getContributingPlugin(IConfigurationElement configurationElement) {
        Object parent = configurationElement;
        while (parent != null) {
            if (parent instanceof IExtension) {
                return ((IExtension)parent).getNamespace();
            }
            parent = parent.getParent();
        }
        return null;
    }

    private static ZipFile getZipFileFromPluginDir(String pluginRelativePath, String symbolicName) throws CoreException {
        Bundle bundle;
        block3: {
            try {
                bundle = Platform.getBundle((String)symbolicName);
                if (bundle != null) break block3;
                return null;
            }
            catch (IOException e) {
                String message = String.valueOf(pluginRelativePath) + ": " + e.getMessage();
                Logger.logException(e);
                throw BirtCoreException.getException(message, e);
            }
        }
        URL starterURL = new URL(bundle.getEntry("/"), pluginRelativePath);
        return new ZipFile(FileLocator.toFileURL((URL)starterURL).getFile());
    }

    private static void importFilesFromZip(ZipFile srcZipFile, IPath destPath, IProgressMonitor monitor, IOverwriteQuery query) throws CoreException {
        try {
            ZipFileStructureProvider structureProvider = new ZipFileStructureProvider(srcZipFile);
            List list = BirtWizardUtil.prepareFileList(structureProvider, structureProvider.getRoot(), null);
            ImportOperation op = new ImportOperation(destPath, (Object)structureProvider.getRoot(), (IImportStructureProvider)structureProvider, query, list);
            op.run(monitor);
        }
        catch (Exception e) {
            String message = String.valueOf(srcZipFile.getName()) + ": " + e.getMessage();
            Logger.logException(e);
            throw BirtCoreException.getException(message, e);
        }
    }

    private static List prepareFileList(ZipFileStructureProvider structure, ZipEntry entry, List list) {
        List son;
        if (structure == null || entry == null) {
            return null;
        }
        if (list == null) {
            list = new ArrayList<ZipEntry>();
        }
        if ((son = structure.getChildren((Object)entry)) == null) {
            return list;
        }
        for (ZipEntry temp : son) {
            if (temp.isDirectory()) {
                BirtWizardUtil.prepareFileList(structure, temp, list);
                continue;
            }
            list.add(temp);
        }
        return list;
    }

    public static Map initConflictResources(Map map) {
        IConfigurationElement[] elements;
        if (map == null) {
            map = new HashMap();
        }
        if ((elements = BirtWizardUtil.findConfigurationElementsByExtension("org.eclipse.birt.integration.wtp.ui.birtResourcesDefinition")) == null || elements.length <= 0) {
            return map;
        }
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement[] folders;
            if ("conflict".equalsIgnoreCase(elements[i].getName()) && (folders = elements[i].getChildren("folder")) != null) {
                int j = 0;
                while (j < folders.length) {
                    String path = folders[j].getAttribute("path");
                    if (path != null) {
                        IConfigurationElement[] files = folders[j].getChildren("file");
                        ArrayList<String> fileList = new ArrayList<String>();
                        int k = 0;
                        while (k < files.length) {
                            String name = files[k].getAttribute("name");
                            if (name != null) {
                                fileList.add(name);
                            }
                            ++k;
                        }
                        map.put(path, fileList);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return map;
    }

    public static Map initWebapp(Map map) {
        IConfigurationElement[] elements;
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        if ((elements = BirtWizardUtil.findConfigurationElementsByExtension("org.eclipse.birt.integration.wtp.ui.birtResourcesDefinition")) == null || elements.length <= 0) {
            return map;
        }
        WebAppBean webAppBean = new WebAppBean();
        int i = 0;
        while (i < elements.length) {
            if ("webapp".equalsIgnoreCase(elements[i].getName())) {
                Object bean;
                String className;
                Object bean2;
                String description;
                String name;
                int j;
                Map<String, Object> son;
                String webappDesc = elements[i].getAttribute("description");
                if (webappDesc != null) {
                    webAppBean.setDescription(webappDesc);
                }
                IConfigurationElement[] contextParams = elements[i].getChildren("context-param");
                IConfigurationElement[] filters = elements[i].getChildren("filter");
                IConfigurationElement[] filterMappings = elements[i].getChildren("filter-mapping");
                IConfigurationElement[] listeners = elements[i].getChildren("listener");
                IConfigurationElement[] servlets = elements[i].getChildren("servlet");
                IConfigurationElement[] servletMappings = elements[i].getChildren("servlet-mapping");
                IConfigurationElement[] taglibs = elements[i].getChildren("taglib");
                if (contextParams != null) {
                    son = (HashMap)map.get("context-param");
                    if (son == null) {
                        son = new HashMap();
                    }
                    j = 0;
                    while (j < contextParams.length) {
                        name = contextParams[j].getAttribute("name");
                        String value = contextParams[j].getAttribute("value");
                        description = contextParams[j].getAttribute("description");
                        if (name != null && value != null) {
                            bean2 = new ContextParamBean(name, value);
                            ((ContextParamBean)bean2).setDescription(description);
                            son.put(name, bean2);
                        }
                        ++j;
                    }
                    map.put("context-param", son);
                }
                if (filters != null) {
                    son = (Map)map.get("filter");
                    if (son == null) {
                        son = new HashMap();
                    }
                    j = 0;
                    while (j < filters.length) {
                        name = filters[j].getAttribute("name");
                        className = filters[j].getAttribute("class");
                        description = filters[j].getAttribute("description");
                        if (name != null && className != null) {
                            bean2 = new FilterBean(name, className);
                            ((FilterBean)bean2).setDescription(description);
                            son.put(name, bean2);
                        }
                        ++j;
                    }
                    map.put("filter", son);
                }
                if (filterMappings != null) {
                    son = (Map)map.get("filter-mapping");
                    if (son == null) {
                        son = new HashMap();
                    }
                    j = 0;
                    while (j < filterMappings.length) {
                        name = filterMappings[j].getAttribute("name");
                        String servletName = filterMappings[j].getAttribute("servletName");
                        String uri = filterMappings[j].getAttribute("uri");
                        if (name != null) {
                            bean2 = new FilterMappingBean(name, servletName);
                            ((FilterMappingBean)bean2).setUri(uri);
                            son.put(WebArtifactUtil.getFilterMappingString(name, servletName, uri), bean2);
                        }
                        ++j;
                    }
                    map.put("filter-mapping", son);
                }
                if (listeners != null) {
                    son = (Map)map.get("listener");
                    if (son == null) {
                        son = new HashMap();
                    }
                    j = 0;
                    while (j < listeners.length) {
                        String className2 = listeners[j].getAttribute("class");
                        String description2 = listeners[j].getAttribute("description");
                        if (className2 != null) {
                            bean = new ListenerBean(className2);
                            ((ListenerBean)bean).setDescription(description2);
                            son.put("listener" + j, bean);
                        }
                        ++j;
                    }
                    map.put("listener", son);
                }
                if (servlets != null) {
                    son = (Map)map.get("servlet");
                    if (son == null) {
                        son = new HashMap();
                    }
                    j = 0;
                    while (j < servlets.length) {
                        name = servlets[j].getAttribute("name");
                        className = servlets[j].getAttribute("class");
                        description = servlets[j].getAttribute("description");
                        if (name != null && className != null) {
                            bean2 = new ServletBean(name, className);
                            ((ServletBean)bean2).setDescription(description);
                            son.put(name, bean2);
                        }
                        ++j;
                    }
                    map.put("servlet", son);
                }
                if (servletMappings != null) {
                    son = (Map)map.get("servlet-mapping");
                    if (son == null) {
                        son = new HashMap();
                    }
                    j = 0;
                    while (j < servletMappings.length) {
                        name = servletMappings[j].getAttribute("name");
                        String uri = servletMappings[j].getAttribute("uri");
                        if (name != null && uri != null) {
                            bean = new ServletMappingBean(name, uri);
                            son.put(uri, bean);
                        }
                        ++j;
                    }
                    map.put("servlet-mapping", son);
                }
                if (taglibs != null) {
                    son = (Map)map.get("taglib");
                    if (son == null) {
                        son = new HashMap();
                    }
                    j = 0;
                    while (j < taglibs.length) {
                        String uri = taglibs[j].getAttribute("uri");
                        String location = taglibs[j].getAttribute("location");
                        if (uri != null && location != null) {
                            bean = new TagLibBean(uri, location);
                            son.put(uri, bean);
                        }
                        ++j;
                    }
                    map.put("taglib", son);
                }
            }
            ++i;
        }
        map.put("webapp", webAppBean);
        return map;
    }

    public static String getDefaultResourceFolder() {
        String resourceFolder = "";
        try {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.birt.report.designer.ui");
            if (bundle == null) {
                return resourceFolder;
            }
            Class reportPluginClass = bundle.loadClass("org.eclipse.birt.report.designer.ui.ReportPlugin");
            if (reportPluginClass != null) {
                Method method = reportPluginClass.getMethod("getDefault", new Class[0]);
                Object instance = null;
                if (method != null) {
                    instance = method.invoke(null, new Object[0]);
                    method = reportPluginClass.getMethod("getResourcePreference", new Class[0]);
                }
                if (method != null && instance != null) {
                    resourceFolder = (String)method.invoke(instance, new Object[0]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (resourceFolder == null) {
            resourceFolder = "";
        }
        return resourceFolder;
    }

    public static String getConfigFolder(IDataModel dataModel) {
        if (dataModel == null) {
            return null;
        }
        IFacetProjectCreationDataModelProperties.FacetDataModelMap dataModelMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        if (dataModelMap == null) {
            return null;
        }
        IDataModel dataModel1 = dataModelMap.getFacetDataModel("jst.web");
        if (dataModel1 == null) {
            return null;
        }
        return dataModel1.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
    }

    public static IPath getWebContentPath(IProject project) {
        IPath path = null;
        if (project != null && J2EEProjectUtilities.isDynamicWebProject((IProject)project)) {
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            path = component.getRootFolder().getWorkspaceRelativePath();
        }
        return path;
    }

    public static File getFileFromPluginDir(String path, String pluginId) throws CoreException {
        Bundle bundle;
        block3: {
            try {
                bundle = Platform.getBundle((String)pluginId);
                if (bundle != null) break block3;
                return null;
            }
            catch (IOException e) {
                Logger.logException(e);
                throw BirtCoreException.getException(null, e);
            }
        }
        URL url = new URL(bundle.getEntry("/"), path);
        return new File(FileLocator.toFileURL((URL)url).getFile());
    }

    public static void processCheckFolder(Map properties, IProject project, String webContentFolder, IProgressMonitor monitor) {
        if (properties == null || project == null || webContentFolder == null) {
            return;
        }
        String[] folders = new String[]{"BIRT_RESOURCE_PATH", "BIRT_VIEWER_WORKING_FOLDER", "BIRT_VIEWER_DOCUMENT_FOLDER", "BIRT_VIEWER_IMAGE_DIR", "BIRT_VIEWER_SCRIPTLIB_DIR", "BIRT_VIEWER_LOG_DIR"};
        Map map = (Map)properties.get("context-param");
        if (map == null) {
            return;
        }
        int i = 0;
        while (i < folders.length) {
            String folder = WebArtifactUtil.getContextParamValue(map, folders[i]);
            BirtWizardUtil.checkFolder(project, webContentFolder, folder);
            ++i;
        }
    }

    private static void checkFolder(IProject project, String webContentFolder, String folderName) {
        if (folderName == null) {
            return;
        }
        try {
            File file = new File(folderName);
            if (file != null) {
                if (file.exists()) {
                    return;
                }
                if (file.isAbsolute()) {
                    file.mkdir();
                } else {
                    IWorkspace ws = ResourcesPlugin.getWorkspace();
                    IPath pjPath = project.getFullPath();
                    IPath configPath = pjPath.append(webContentFolder);
                    IPath path = configPath.append(folderName);
                    BirtWizardUtil.mkdirs(ws.getRoot().getFolder(path));
                }
            }
        }
        catch (Exception e) {
            Logger.logException(2, e);
        }
    }

    public static String readFile(String filename, String pluginId) throws CoreException {
        File file = BirtWizardUtil.getFileFromPluginDir(filename, pluginId);
        try {
            FileReader reader = new FileReader(file);
            StringBuffer sbuf = new StringBuffer();
            char[] cbuf = new char[512];
            int len = 0;
            while ((len = reader.read(cbuf)) != -1) {
                sbuf.append(cbuf, 0, len);
            }
            reader.close();
            return sbuf.toString();
        }
        catch (Exception e) {
            Logger.logException(e);
            throw BirtCoreException.getException(null, e);
        }
    }

    public static void writeFile(IFile iFile, byte[] data) throws CoreException {
        if (iFile == null || data == null) {
            return;
        }
        try {
            File file = iFile.getLocation().toFile();
            FileOutputStream out = new FileOutputStream(file, false);
            ((OutputStream)out).write(data);
            out.flush();
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            Logger.logException(e);
            throw BirtCoreException.getException(null, e);
        }
    }

    public static void mkdirs(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            if (folder.getParent() instanceof IFolder) {
                BirtWizardUtil.mkdirs((IFolder)folder.getParent());
            }
            folder.create(true, true, null);
        }
    }

    public static String[] getLogLevels() {
        return new String[]{BirtWTPMessages.BIRTConfiguration_loglevel_all, BirtWTPMessages.BIRTConfiguration_loglevel_severe, BirtWTPMessages.BIRTConfiguration_loglevel_warning, BirtWTPMessages.BIRTConfiguration_loglevel_info, BirtWTPMessages.BIRTConfiguration_loglevel_config, BirtWTPMessages.BIRTConfiguration_loglevel_fine, BirtWTPMessages.BIRTConfiguration_loglevel_finer, BirtWTPMessages.BIRTConfiguration_loglevel_finest, BirtWTPMessages.BIRTConfiguration_loglevel_off};
    }
}

