/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.integration.wtp.ui.project.facet;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.chart.integration.wtp.ui.internal.util.WebArtifactUtil;
import org.eclipse.birt.chart.integration.wtp.ui.internal.webapp.WebAppBean;
import org.eclipse.birt.chart.integration.wtp.ui.internal.wizards.BirtWizardUtil;
import org.eclipse.birt.chart.integration.wtp.ui.internal.wizards.SimpleImportOverwriteQuery;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.project.facet.J2EEFacetInstallDelegate;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class BirtFacetInstallDelegate
extends J2EEFacetInstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            IDataModel model = (IDataModel)config;
            IDataModel dataModel = (IDataModel)model.getProperty("FacetInstallDataModelProvider.MASTER_PROJECT_DM");
            IPath destPath = null;
            if (dataModel != null) {
                String dest = BirtWizardUtil.getConfigFolder(dataModel);
                IFolder folder = BirtWizardUtil.getFolder(project, dest);
                if (folder != null) {
                    destPath = folder.getFullPath();
                }
            } else {
                destPath = BirtWizardUtil.getWebContentPath(project);
            }
            BirtWizardUtil.doImports(project, null, destPath, monitor, new SimpleImportOverwriteQuery());
            HashMap properties = new HashMap();
            BirtWizardUtil.initWebapp(properties);
            WebArtifactUtil.initializeWebapp(properties, project);
            BirtWizardUtil.processCheckFolder(properties, project, destPath.toFile().getName(), monitor);
            this.processConfiguration(properties, project, monitor);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected void processConfiguration(Map properties, IProject project, IProgressMonitor monitor) throws CoreException {
        SimpleImportOverwriteQuery query = new SimpleImportOverwriteQuery();
        WebArtifactUtil.configureWebApp((WebAppBean)properties.get("webapp"), project, query, monitor);
        WebArtifactUtil.configureContextParam((Map)properties.get("context-param"), project, query, monitor);
        WebArtifactUtil.configureListener((Map)properties.get("listener"), project, query, monitor);
        WebArtifactUtil.configureServlet((Map)properties.get("servlet"), project, query, monitor);
        WebArtifactUtil.configureServletMapping((Map)properties.get("servlet-mapping"), project, query, monitor);
        WebArtifactUtil.configureTaglib((Map)properties.get("taglib"), project, query, monitor);
    }
}

