/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.internal.rcp.wizards;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Locale;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportEditorInput;
import org.eclipse.birt.report.designer.internal.ui.editors.wizards.NewReportPageSupport;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.wizards.INewLibraryCreationPage;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.command.LibraryChangeEvent;
import org.eclipse.birt.report.model.api.command.ResourceChangeEvent;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class WizardNewLibraryCreationPage
extends WizardPage
implements INewLibraryCreationPage {
    private static final String MSG_DUPLICATE_FILE_NAME = Messages.getString((String)"WizardNewReportCreationPage.msg.duplicate.fileName");
    private static final String MSG_EMPTY_FILE_LOCATION_DIRECTORY = Messages.getString((String)"WizardNewReportCreationPage.msg.empty.file.locationDirectory");
    private static final String MSG_EMPTY_FILE_NAME = Messages.getString((String)"WizardNewReportCreationPage.msg.empty.file.name");
    private static final String CREATING = Messages.getString((String)"NewReportWizard.text.Creating");
    private static final String OPENING_FILE_FOR_EDITING = Messages.getString((String)"NewReportWizard.text.OpenFileForEditing");
    private String fileExtension = "rptlibrary";
    private static final String TEMPLATE_FILE = "/templates/blank_library.rpttemplate";
    private Listener locationModifyListener = new Listener(){

        public void handleEvent(Event e) {
            WizardNewLibraryCreationPage.this.setPageComplete(WizardNewLibraryCreationPage.this.validatePage());
        }
    };
    NewReportPageSupport pageSupport = new NewReportPageSupport();
    private static final String NEW_REPORT_FILE_NAME_PREFIX = Messages.getString((String)"NewLibraryWizard.displayName.NewReportFileNamePrefix");

    public WizardNewLibraryCreationPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.setControl((Control)this.pageSupport.createComposite(parent));
        this.pageSupport.getFileNameField().addListener(24, this.locationModifyListener);
        this.pageSupport.getLocationPathField().addListener(24, this.locationModifyListener);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        UIUtil.bindHelp((Control)this.getControl(), (String)"org.eclipse.birt.cshelp.NewLibraryWizard_ID");
    }

    public void setVisible(boolean visible) {
        this.getControl().setVisible(visible);
        if (visible) {
            this.pageSupport.getFileNameField().setFocus();
        }
    }

    public boolean validatePage() {
        if (this.getFileName().equals("")) {
            this.setErrorMessage(null);
            this.setMessage(MSG_EMPTY_FILE_NAME);
            return false;
        }
        String location = this.getContainerFullPath().toOSString();
        if (location.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(MSG_EMPTY_FILE_LOCATION_DIRECTORY);
            return false;
        }
        IPath path = !Platform.getOS().equals("win32") ? (!this.getFileName().endsWith(".rptlibrary") ? this.getContainerFullPath().append(String.valueOf(this.getFileName()) + ".rptlibrary") : this.getContainerFullPath().append(this.getFileName())) : (!this.getFileName().toLowerCase().endsWith(".rptlibrary".toLowerCase()) ? this.getContainerFullPath().append(String.valueOf(this.getFileName()) + ".rptlibrary") : this.getContainerFullPath().append(this.getFileName()));
        if (path.lastSegment().equals("." + this.fileExtension)) {
            this.setErrorMessage(Messages.getString((String)"WizardNewReportCreationPage.Errors.nameEmpty"));
            return false;
        }
        if (path.toFile().exists()) {
            this.setErrorMessage(MSG_DUPLICATE_FILE_NAME);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void setContainerFullPath(IPath initPath) {
        this.pageSupport.setInitialFileLocation(initPath.toOSString());
    }

    public void setFileName(String initFileName) {
        this.pageSupport.setInitialFileName(this.getNewFileFullName(NEW_REPORT_FILE_NAME_PREFIX));
    }

    private String getNewFileFullName(String defaultName) {
        String path = this.getDefaultLocation();
        String name = String.valueOf(defaultName) + "." + this.fileExtension;
        int count = 0;
        File file = new File(path, name);
        while (file.exists()) {
            name = String.valueOf(defaultName) + "_" + ++count + "." + this.fileExtension;
            file = null;
            file = new File(path, name);
        }
        file = null;
        return name;
    }

    private String getDefaultLocation() {
        IPath defaultPath = Platform.getLocation();
        return defaultPath.toOSString();
    }

    public String getFileName() {
        return this.pageSupport.getFileName();
    }

    public IPath getContainerFullPath() {
        return this.pageSupport.getFileLocationFullPath();
    }

    public boolean performFinish() {
        String libraryFileName;
        final IPath locPath = this.getContainerFullPath();
        String fn = this.getFileName();
        final String fileName = !Platform.getOS().equals("win32") ? (!fn.endsWith("." + this.fileExtension) ? String.valueOf(fn) + "." + this.fileExtension : fn) : (!fn.toLowerCase(Locale.getDefault()).endsWith("." + this.fileExtension) ? String.valueOf(fn) + "." + this.fileExtension : fn);
        if (Platform.getBundle((String)"org.eclipse.birt.resources") == null) {
            return true;
        }
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"org.eclipse.birt.resources"), (IPath)new Path(TEMPLATE_FILE), null);
        if (url == null) {
            return true;
        }
        try {
            libraryFileName = FileLocator.resolve((URL)url).getPath();
        }
        catch (IOException iOException) {
            return false;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    WizardNewLibraryCreationPage.this.doFinish(locPath, fileName, libraryFileName, monitor);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            ExceptionUtil.handle((Throwable)realException);
            return false;
        }
        return true;
    }

    private void doFinish(IPath locationPath, String fileName, String sourceFileName, IProgressMonitor monitor) {
        monitor.beginTask(String.valueOf(CREATING) + fileName, 2);
        File container = null;
        try {
            container = new File(locationPath.toString());
            if (!container.exists()) {
                container.mkdirs();
            }
        }
        catch (Exception e) {
            ExceptionUtil.handle((Throwable)e);
        }
        if (container == null) {
            return;
        }
        final File file = new File(locationPath.toString(), fileName);
        try {
            String description;
            LibraryHandle handle = SessionHandleAdapter.getInstance().getSessionHandle().createLibraryFromTemplate(sourceFileName);
            if (ReportPlugin.getDefault().getEnableCommentPreference()) {
                handle.setStringProperty("comments", ReportPlugin.getDefault().getCommentPreference());
            }
            if (ReportPlugin.getDefault().getDefaultUnitPreference() != null) {
                handle.setStringProperty("units", ReportPlugin.getDefault().getDefaultUnitPreference());
            }
            if (this.inPredifinedTemplateFolder(sourceFileName) && (description = handle.getDescription()) != null && description.trim().length() > 0) {
                handle.setDescription(Messages.getString((String)description));
            }
            UIUtil.addCreateBy((ModuleHandle)handle);
            handle.saveAs(file.getAbsolutePath());
            handle.close();
        }
        catch (Exception exception) {}
        monitor.worked(1);
        monitor.setTaskName(OPENING_FILE_FOR_EDITING);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                try {
                    page.openEditor((IEditorInput)new ReportEditorInput(file), "org.eclipse.birt.report.designer.ui.editors.LibraryEditor", true);
                }
                catch (Exception e) {
                    ExceptionUtil.handle((Throwable)e);
                }
            }
        });
        monitor.worked(1);
        this.fireLibraryChanged(fileName);
    }

    private void fireLibraryChanged(String fileName) {
        SessionHandleAdapter.getInstance().getSessionHandle().fireResourceChange((ResourceChangeEvent)new LibraryChangeEvent(fileName));
    }

    protected boolean inPredifinedTemplateFolder(String sourceFileName) {
        String predifinedDir = UIUtil.getFragmentDirectory();
        File predifinedFile = new File(predifinedDir);
        File sourceFile = new File(sourceFileName);
        return sourceFile.getAbsolutePath().startsWith(predifinedFile.getAbsolutePath());
    }

    public void updatePerspective(IConfigurationElement configElement) {
    }
}

