/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatChangeListener;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FormatDateTimeDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

public class FormatDateTimeSection
extends Section {
    private int style;
    private final boolean showLocale;
    protected FormatDateTimeDescriptor format;
    IDescriptorProvider provider;

    public FormatDateTimeSection(Composite parent, int style, boolean isFormStyle) {
        this(parent, style, isFormStyle, true);
    }

    public FormatDateTimeSection(Composite parent, int style, boolean isFormStyle, boolean showLocale) {
        super(" ", parent, isFormStyle);
        this.style = style;
        this.showLocale = showLocale;
    }

    public void createSection() {
        this.getFormatControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    public FormatDateTimeDescriptor getFormatControl() {
        return this.format;
    }

    protected FormatDateTimeDescriptor getFormatControl(Composite parent) {
        if (this.format == null) {
            this.format = new FormatDateTimeDescriptor(this.style, this.isFormStyle, this.showLocale);
            this.format.setDescriptorProvider(this.provider);
            this.format.createControl(parent);
            this.format.getControl().setLayoutData((Object)new GridData(1808));
            this.format.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    FormatDateTimeSection.this.format = null;
                }
            });
        } else {
            this.checkParent(this.format.getControl(), parent);
        }
        return this.format;
    }

    public void layout() {
        GridData gd = (GridData)this.format.getControl().getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - this.placeholder;
    }

    public void addFormatChangeListener(IFormatChangeListener listener) {
        this.format.addFormatChangeListener(listener);
    }

    public void load() {
        if (this.format != null && !this.format.getControl().isDisposed()) {
            this.format.load();
        }
    }

    public IDescriptorProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IDescriptorProvider provider) {
        this.provider = provider;
        if (this.format != null) {
            this.format.setDescriptorProvider(provider);
        }
    }

    public void setInput(Object input) {
        assert (input != null);
        this.format.setInput(input);
    }

    public void setHidden(boolean isHidden) {
        if (this.format != null) {
            WidgetUtil.setExcludeGridData(this.format.getControl(), isHidden);
        }
    }

    public void setVisible(boolean isVisable) {
        if (this.format != null) {
            this.format.getControl().setVisible(isVisable);
        }
    }
}

