/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.SortOption;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.chart.reportitem.api.ChartItemUtil;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.SecurityUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.IBaseCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeElementFactory;
import org.eclipse.birt.data.engine.olap.api.query.ICubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeOperation;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeSortDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IMeasureDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ISubCubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.impl.DataModelAdapter;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionElementHandle;
import org.eclipse.birt.report.model.api.MemberValueHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.MultiViewsHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.util.CubeUtil;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartCubeQueryHelper {
    protected static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.reportitem/trace");
    protected final ExtendedItemHandle handle;
    protected final Chart cm;
    protected Map<String, IBinding> registeredBindings = new HashMap<String, IBinding>();
    protected Map<String, String> registeredQueries = new HashMap<String, String>();
    protected Map<String, ILevelDefinition> registeredLevels = new HashMap<String, ILevelDefinition>();
    protected Map<String, IMeasureDefinition> registeredMeasures = new HashMap<String, IMeasureDefinition>();
    protected Map<LevelHandle, ILevelDefinition> registeredLevelHandles = new HashMap<LevelHandle, ILevelDefinition>();
    protected String rowEdgeDimension;
    private boolean bSingleChart = false;
    private static ICubeElementFactory cubeFactory = null;
    protected final IModelAdapter modelAdapter;
    protected final ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();

    public ChartCubeQueryHelper(ExtendedItemHandle handle, Chart cm) throws BirtException {
        this.handle = handle;
        this.cm = cm;
        DataSessionContext dsc = new DataSessionContext(3, handle.getModuleHandle());
        this.modelAdapter = new DataModelAdapter(dsc);
    }

    public ChartCubeQueryHelper(ExtendedItemHandle handle, Chart cm, IModelAdapter modelAdapter) {
        this.handle = handle;
        this.cm = cm;
        this.modelAdapter = modelAdapter;
    }

    public static synchronized ICubeElementFactory getCubeElementFactory() throws BirtException {
        if (cubeFactory != null) {
            return cubeFactory;
        }
        try {
            Class<?> cls = Class.forName("org.eclipse.birt.data.engine.olap.impl.query.CubeElementFactory");
            cubeFactory = (ICubeElementFactory)SecurityUtil.newClassInstance(cls);
        }
        catch (Exception e) {
            throw new ChartException("org.eclipse.birt.chart.reportitem", 4, (Throwable)e);
        }
        return cubeFactory;
    }

    public IBaseCubeQueryDefinition createCubeQuery(IDataQueryDefinition parent) throws BirtException {
        return this.createCubeQuery(parent, null);
    }

    public IBaseCubeQueryDefinition createCubeQuery(IDataQueryDefinition parent, String[] expressions) throws BirtException {
        this.bSingleChart = parent == null;
        CubeHandle cubeHandle = this.getCubeHandle();
        ICubeQueryDefinition cubeQuery = null;
        if (cubeHandle == null) {
            cubeHandle = ChartCubeUtil.getBindingCube(this.handle);
            if (cubeHandle == null) {
                throw new ChartException("org.eclipse.birt.chart.reportitem", 17, Messages.getString("ChartCubeQueryHelper.Error.MustBindCube"));
            }
            if (parent instanceof ICubeQueryDefinition) {
                ISubCubeQueryDefinition subQuery = this.createSubCubeQuery();
                if (ChartCubeUtil.isPlotChart(this.handle)) {
                    this.addMinMaxBinding((ICubeQueryDefinition)parent);
                }
                if (subQuery != null) {
                    return subQuery;
                }
                Iterator bindings = this.handle.columnBindingsIterator();
                if (!bindings.hasNext()) {
                    return (ICubeQueryDefinition)parent;
                }
            }
        }
        cubeQuery = ChartCubeQueryHelper.getCubeElementFactory().createCubeQuery(cubeHandle.getQualifiedName());
        this.initBindings(cubeQuery, cubeHandle);
        List<SeriesDefinition> sdList = ChartCubeQueryHelper.getAllSeriesDefinitions(this.cm);
        ChartExpressionUtil.ExpressionSet exprSet = this.getExpressions(expressions, sdList);
        for (String expr : exprSet) {
            this.bindExpression(expr, cubeQuery, cubeHandle);
        }
        int i = 0;
        while (i < sdList.size()) {
            SeriesDefinition sd = sdList.get(i);
            this.addSorting(cubeQuery, cubeHandle, sd, i);
            ++i;
        }
        this.addCubeFilter(cubeQuery, cubeHandle);
        this.sortLevelDefinition(cubeQuery.getEdge(1), cubeHandle);
        this.sortLevelDefinition(cubeQuery.getEdge(2), cubeHandle);
        Collection<ILevelDefinition> levelsInOrder = this.getAllLevelsInHierarchyOrder(cubeHandle, cubeQuery);
        this.addAggregateOnToMeasures(levelsInOrder);
        return cubeQuery;
    }

    protected ChartExpressionUtil.ExpressionSet getExpressions(String[] expressions, List<SeriesDefinition> sdList) {
        ChartExpressionUtil.ExpressionSet exprSet = new ChartExpressionUtil.ExpressionSet();
        int i = 0;
        while (i < sdList.size()) {
            SeriesDefinition sd = sdList.get(i);
            EList<Query> queryList = sd.getDesignTimeSeries().getDataDefinition();
            int j = 0;
            while (j < queryList.size()) {
                Query query = (Query)queryList.get(j);
                exprSet.add(query.getDefinition());
                ++j;
            }
            exprSet.add(sd.getQuery().getDefinition());
            ++i;
        }
        if (expressions != null) {
            String[] stringArray = expressions;
            int n = expressions.length;
            int n2 = 0;
            while (n2 < n) {
                String expr = stringArray[n2];
                exprSet.add(expr);
                ++n2;
            }
        }
        return exprSet;
    }

    protected CubeHandle getCubeHandle() {
        return this.handle.getCube();
    }

    protected void addAggregateOnToMeasures(Collection<ILevelDefinition> levelsInOrder) throws DataException {
        Iterator<String> measureNames = this.registeredMeasures.keySet().iterator();
        while (measureNames.hasNext()) {
            IBinding binding = this.registeredBindings.get(measureNames.next());
            if (binding == null || !binding.getAggregatOns().isEmpty()) continue;
            for (ILevelDefinition level : levelsInOrder) {
                String dimensionName = level.getHierarchy().getDimension().getName();
                binding.addAggregateOn(ExpressionUtil.createJSDimensionExpression(dimensionName, level.getName()));
            }
        }
    }

    protected ISubCubeQueryDefinition createSubCubeQuery() throws BirtException {
        String queryName = "chart_subquery";
        AggregationCellHandle containerCell = ChartCubeUtil.getXtabContainerCell(this.handle);
        if (containerCell == null) {
            return null;
        }
        CrosstabReportItemHandle xtab = containerCell.getCrosstab();
        int columnLevelCount = ChartCubeUtil.getLevelCount(xtab, 1);
        int rowLevelCount = ChartCubeUtil.getLevelCount(xtab, 0);
        if (this.cm instanceof ChartWithAxes) {
            if (((ChartWithAxes)this.cm).isTransposed()) {
                if (columnLevelCount >= 1) {
                    ISubCubeQueryDefinition subCubeQuery = ChartCubeQueryHelper.getCubeElementFactory().createSubCubeQuery(queryName);
                    subCubeQuery.setStartingLevelOnColumn(ChartCubeUtil.createDimensionExpression(ChartCubeUtil.getLevel(xtab, 1, columnLevelCount - 1).getCubeLevel()));
                    if (rowLevelCount > 1) {
                        subCubeQuery.setStartingLevelOnRow(ChartCubeUtil.createDimensionExpression(ChartCubeUtil.getLevel(xtab, 0, rowLevelCount - 2).getCubeLevel()));
                    }
                    return subCubeQuery;
                }
                if (rowLevelCount > 1) {
                    ISubCubeQueryDefinition subCubeQuery = ChartCubeQueryHelper.getCubeElementFactory().createSubCubeQuery(queryName);
                    subCubeQuery.setStartingLevelOnRow(ChartCubeUtil.createDimensionExpression(ChartCubeUtil.getLevel(xtab, 0, rowLevelCount - 2).getCubeLevel()));
                    return subCubeQuery;
                }
            } else {
                if (rowLevelCount >= 1) {
                    ISubCubeQueryDefinition subCubeQuery = ChartCubeQueryHelper.getCubeElementFactory().createSubCubeQuery(queryName);
                    subCubeQuery.setStartingLevelOnRow(ChartCubeUtil.createDimensionExpression(ChartCubeUtil.getLevel(xtab, 0, rowLevelCount - 1).getCubeLevel()));
                    if (columnLevelCount > 1) {
                        subCubeQuery.setStartingLevelOnColumn(ChartCubeUtil.createDimensionExpression(ChartCubeUtil.getLevel(xtab, 1, columnLevelCount - 2).getCubeLevel()));
                    }
                    return subCubeQuery;
                }
                if (columnLevelCount > 1) {
                    ISubCubeQueryDefinition subCubeQuery = ChartCubeQueryHelper.getCubeElementFactory().createSubCubeQuery(queryName);
                    subCubeQuery.setStartingLevelOnColumn(ChartCubeUtil.createDimensionExpression(ChartCubeUtil.getLevel(xtab, 1, columnLevelCount - 2).getCubeLevel()));
                    return subCubeQuery;
                }
            }
        }
        return null;
    }

    private void addMinMaxBinding(ICubeQueryDefinition parent) throws BirtException {
        Axis xAxis = (Axis)((ChartWithAxes)this.cm).getAxes().get(0);
        SeriesDefinition sdValue = (SeriesDefinition)((ChartWithAxes)this.cm).getOrthogonalAxes(xAxis, true)[0].getSeriesDefinitions().get(0);
        Query queryValue = (Query)sdValue.getDesignTimeSeries().getDataDefinition().get(0);
        String bindingValue = this.exprCodec.getCubeBindingName(queryValue.getDefinition(), false);
        String maxBindingName = "chart__max" + bindingValue;
        String minBindingName = "chart__min" + bindingValue;
        Iterator<ComputedColumnHandle> bindings = ChartReportItemUtil.getAllColumnBindingsIterator(this.handle);
        while (bindings.hasNext()) {
            ComputedColumnHandle column = bindings.next();
            if (!column.getName().equals(bindingValue)) continue;
            Binding maxBinding = new Binding(maxBindingName);
            maxBinding.setExpression(new ScriptExpression(queryValue.getDefinition()));
            maxBinding.setAggrFunction("MAX");
            maxBinding.setExportable(false);
            Binding minBinding = new Binding(minBindingName);
            minBinding.setExpression(new ScriptExpression(queryValue.getDefinition()));
            minBinding.setAggrFunction("MIN");
            minBinding.setExportable(false);
            ICubeOperation op = ChartCubeQueryHelper.getCubeElementFactory().getCubeOperationFactory().createAddingNestAggregationsOperation(new IBinding[]{maxBinding, minBinding});
            parent.addCubeOperation(op);
            break;
        }
    }

    private void initBindings(ICubeQueryDefinition cubeQuery, CubeHandle cube) throws BirtException {
        Iterator<ComputedColumnHandle> bindings = ChartReportItemUtil.getAllColumnBindingsIterator(this.handle);
        while (bindings.hasNext()) {
            ComputedColumnHandle column = bindings.next();
            Binding binding = new Binding(column.getName());
            binding.setDataType(DataAdapterUtil.adaptModelDataType(column.getDataType()));
            binding.setAggrFunction(column.getAggregateFunction() == null ? null : DataAdapterUtil.adaptModelAggregationType(column.getAggregateFunction()));
            ChartItemUtil.loadExpression(this.exprCodec, column);
            binding.setExpression(ChartReportItemUtil.adaptExpression(this.exprCodec, this.modelAdapter, true));
            List lstAggOn = column.getAggregateOnList();
            if (column.getExpression() == null || !this.bSingleChart && !lstAggOn.isEmpty()) {
                this.addAggregateOn(binding, lstAggOn, cubeQuery, cube);
            }
            this.registeredBindings.put(binding.getBindingName(), binding);
            this.registeredQueries.put(binding.getBindingName(), this.exprCodec.encode());
        }
    }

    private void addAggregateOn(IBinding binding, List<String> lstAggOn, ICubeQueryDefinition cubeQuery, CubeHandle cube) throws BirtException {
        for (String aggOn : lstAggOn) {
            String[] levelNames = CubeUtil.splitLevelName(aggOn);
            String dimExpr = ExpressionUtil.createJSDimensionExpression(levelNames[0], levelNames[1]);
            binding.addAggregateOn(dimExpr);
        }
    }

    private void addSorting(ICubeQueryDefinition cubeQuery, CubeHandle cube, SeriesDefinition sd, int i) throws BirtException {
        if (sd.getSortKey() == null) {
            return;
        }
        String sortKey = sd.getSortKey().getDefinition();
        if (sd.isSetSorting() && sortKey != null && sortKey.length() > 0) {
            this.exprCodec.decode(sortKey);
            String sortKeyBinding = this.exprCodec.getCubeBindingName(true);
            if (this.registeredLevels.containsKey(sortKeyBinding)) {
                ICubeSortDefinition sortDef = ChartCubeQueryHelper.getCubeElementFactory().createCubeSortDefinition(ChartReportItemUtil.adaptExpression(this.exprCodec, this.modelAdapter, true), this.registeredLevels.get(sortKeyBinding), null, null, sd.getSorting() == SortOption.ASCENDING_LITERAL ? 0 : 1);
                if (sd.getSortLocale() != null) {
                    sortDef.setSortLocale(new ULocale(sd.getSortLocale()));
                }
                if (sd.isSetSortStrength()) {
                    sortDef.setSortStrength(sd.getSortStrength());
                }
                cubeQuery.addSort(sortDef);
            } else if (this.registeredMeasures.containsKey(sortKeyBinding)) {
                IMeasureDefinition mDef = this.registeredMeasures.get(sortKeyBinding);
                Query targetQuery = i > 0 ? sd.getQuery() : (Query)sd.getDesignTimeSeries().getDataDefinition().get(0);
                ChartExpressionUtil.ExpressionCodec exprCodecTarget = ChartModelHelper.instance().createExpressionCodec();
                exprCodecTarget.decode(targetQuery.getDefinition());
                String targetBindingName = exprCodecTarget.getCubeBindingName(true);
                IBinding measureBinding = this.registeredBindings.get(sortKeyBinding);
                Binding aggBinding = new Binding(String.valueOf(measureBinding.getBindingName()) + targetBindingName);
                aggBinding.setDataType(measureBinding.getDataType());
                aggBinding.setExpression(measureBinding.getExpression());
                ILevelDefinition level = this.registeredLevels.get(targetBindingName);
                aggBinding.addAggregateOn(ExpressionUtil.createJSDimensionExpression(level.getHierarchy().getDimension().getName(), level.getName()));
                aggBinding.setAggrFunction(mDef.getAggrFunction());
                aggBinding.setExportable(false);
                cubeQuery.addBinding(aggBinding);
                ICubeSortDefinition sortDef = ChartCubeQueryHelper.getCubeElementFactory().createCubeSortDefinition(ExpressionUtil.createJSDataExpression(aggBinding.getBindingName()), this.registeredLevels.get(targetBindingName), null, null, sd.getSorting() == SortOption.ASCENDING_LITERAL ? 0 : 1);
                if (sd.getSortLocale() != null) {
                    sortDef.setSortLocale(new ULocale(sd.getSortLocale()));
                }
                if (sd.isSetSortStrength()) {
                    sortDef.setSortStrength(sd.getSortStrength());
                }
                cubeQuery.addSort(sortDef);
            }
        }
    }

    protected void bindBinding(IBinding colBinding, ICubeQueryDefinition cubeQuery, CubeHandle cube) throws BirtException {
        String measure;
        if (colBinding == null) {
            return;
        }
        String bindingName = colBinding.getBindingName();
        String expr = this.registeredQueries.get(bindingName);
        if (!cubeQuery.getBindings().contains(colBinding)) {
            cubeQuery.addBinding(colBinding);
        }
        if ((measure = this.exprCodec.getMeasureName(expr)) != null) {
            if (this.registeredMeasures.containsKey(bindingName)) {
                return;
            }
            IMeasureDefinition mDef = cubeQuery.createMeasure(measure);
            String aggFun = DataAdapterUtil.adaptModelAggregationType(cube.getMeasure(measure).getFunction());
            mDef.setAggrFunction(aggFun);
            this.registeredMeasures.put(bindingName, mDef);
        } else if (this.exprCodec.isDimensionExpresion()) {
            this.registerDimensionLevel(cubeQuery, cube, bindingName);
        } else if (this.exprCodec.isCubeBinding(true)) {
            this.bindExpression(expr, cubeQuery, cube);
            return;
        }
    }

    protected void registerDimensionLevel(ICubeQueryDefinition cubeQuery, CubeHandle cube, String bindingName) {
        if (this.registeredLevels.containsKey(bindingName)) {
            return;
        }
        String[] levels = this.exprCodec.getLevelNames();
        String dimensionName = levels[0];
        int edgeType = this.getEdgeType(dimensionName);
        IEdgeDefinition edge = cubeQuery.getEdge(edgeType);
        IHierarchyDefinition hieDef = null;
        if (edge == null) {
            edge = cubeQuery.createEdge(edgeType);
            IDimensionDefinition dimDef = edge.createDimension(dimensionName);
            hieDef = dimDef.createHierarchy(cube.getDimension(dimDef.getName()).getDefaultHierarchy().getName());
        } else {
            hieDef = edge.getDimensions().get(0).getHierarchy().get(0);
        }
        ILevelDefinition levelDef = hieDef.createLevel(levels[1]);
        this.registeredLevels.put(bindingName, levelDef);
        LevelHandle levelHandle = this.handle.getModuleHandle().findLevel(String.valueOf(levelDef.getHierarchy().getDimension().getName()) + "/" + levelDef.getName());
        this.registeredLevelHandles.put(levelHandle, levelDef);
    }

    protected void bindExpression(String expression, ICubeQueryDefinition cubeQuery, CubeHandle cube) throws BirtException {
        if (expression == null) {
            return;
        }
        String expr = expression.trim();
        if (expr != null && expr.length() > 0) {
            this.exprCodec.decode(expression);
            String bindingName = null;
            IBinding colBinding = null;
            if (this.exprCodec.isCubeBinding(false)) {
                bindingName = this.exprCodec.getCubeBindingName(false);
                colBinding = this.registeredBindings.get(bindingName);
            } else {
                bindingName = ChartUtil.escapeSpecialCharacters(this.exprCodec.getExpression());
                colBinding = new Binding(bindingName);
                colBinding.setDataType(0);
                colBinding.setExpression(ChartReportItemUtil.adaptExpression(this.exprCodec, this.modelAdapter, true));
                cubeQuery.addBinding(colBinding);
                List<String> nameList = this.exprCodec.getCubeBindingNameList();
                if (nameList.size() == 0) {
                    return;
                }
                if (nameList.size() == 1) {
                    bindingName = nameList.get(0);
                    colBinding = this.registeredBindings.get(bindingName);
                } else {
                    for (String bn : nameList) {
                        this.bindBinding(this.registeredBindings.get(bn), cubeQuery, cube);
                    }
                    return;
                }
            }
            this.bindBinding(colBinding, cubeQuery, cube);
        }
    }

    protected List<FilterConditionElementHandle> getCubeFiltersFromHandle(ReportItemHandle itemHandle) {
        PropertyHandle propHandle = itemHandle.getPropertyHandle("cubeFilter");
        if (propHandle == null) {
            return Collections.emptyList();
        }
        return propHandle.getListValue();
    }

    private void addCubeFilter(ICubeQueryDefinition cubeQuery, CubeHandle cubeHandle) throws BirtException {
        CrosstabReportItemHandle crossTab;
        DesignElementHandle xtabHandle;
        ArrayList<ILevelDefinition> levels = new ArrayList<ILevelDefinition>();
        ArrayList<String> values = new ArrayList<String>();
        List<FilterConditionElementHandle> filters = null;
        if (this.handle.getContainer() instanceof MultiViewsHandle) {
            xtabHandle = this.handle.getContainer().getContainer();
            if (xtabHandle instanceof ExtendedItemHandle) {
                crossTab = (CrosstabReportItemHandle)((ExtendedItemHandle)xtabHandle).getReportItem();
                filters = this.getFiltersFromXtab(crossTab);
            }
        } else if (this.handle.getContainer() instanceof ExtendedItemHandle && this.handle.getCube() == null) {
            xtabHandle = (ExtendedItemHandle)this.handle.getContainer();
            String exName = ((ExtendedItemHandle)xtabHandle).getExtensionName();
            if ("AggregationCell".equals(exName) || "CrosstabCell".equals(exName)) {
                CrosstabCellHandle cell = (CrosstabCellHandle)((ExtendedItemHandle)xtabHandle).getReportItem();
                filters = this.getFiltersFromXtab(cell.getCrosstab());
                filters.addAll(this.getCubeFiltersFromHandle(this.handle));
            }
        } else if (ChartReportItemUtil.getReportItemReference(this.handle) != null) {
            ReportItemHandle rih = ChartReportItemUtil.getReportItemReference(this.handle);
            if (rih instanceof ExtendedItemHandle && ((ExtendedItemHandle)rih).getReportItem() instanceof CrosstabReportItemHandle) {
                crossTab = (CrosstabReportItemHandle)((ExtendedItemHandle)rih).getReportItem();
                filters = this.getFiltersFromXtab(crossTab);
            } else {
                filters = this.getCubeFiltersFromHandle(rih);
            }
        }
        if (filters == null) {
            filters = this.getCubeFiltersFromHandle(this.handle);
        }
        block0: for (FilterConditionElementHandle filterCon : filters) {
            ConditionalExpression filterCondExpr;
            levels.clear();
            values.clear();
            this.addMembers(levels, values, filterCon.getMember());
            ILevelDefinition[] qualifyLevels = null;
            Object[] qualifyValues = null;
            if (levels.size() > 0) {
                qualifyLevels = levels.toArray(new ILevelDefinition[levels.size()]);
                qualifyValues = values.toArray(new Object[values.size()]);
            }
            ChartItemUtil.loadExpression(this.exprCodec, filterCon);
            String filterQuery = this.exprCodec.encode();
            if (this.exprCodec.isCubeBinding(filterQuery, true)) {
                List<String> bindingNames = this.exprCodec.getCubeBindingNameList();
                for (String filterBindingName : bindingNames) {
                    if (filterBindingName == null || this.registeredLevels.containsKey(filterBindingName) || this.registeredMeasures.containsKey(filterBindingName)) continue;
                    String operator = filterCon.getOperator();
                    if ("bottom-n".equals(operator) || "bottom-percent".equals(operator) || "top-n".equals(operator) || "top-percent".equals(operator)) continue block0;
                    String newExpr = this.registeredQueries.get(filterBindingName);
                    if (newExpr == null) continue;
                    this.exprCodec.setBindingName(filterBindingName, true);
                    filterQuery = filterQuery.replace(this.exprCodec.encode(), newExpr);
                }
            }
            List<Expression> value1 = filterCon.getValue1ExpressionList().getListValue();
            if (ModuleUtil.isListFilterValue(filterCon)) {
                ArrayList<ScriptExpression> valueList = new ArrayList<ScriptExpression>(value1.size());
                for (Expression value : value1) {
                    valueList.add(this.modelAdapter.adaptExpression(value));
                }
                this.exprCodec.decode(filterQuery);
                filterCondExpr = new ConditionalExpression(ChartReportItemUtil.adaptExpression(this.exprCodec, this.modelAdapter, true), DataAdapterUtil.adaptModelFilterOperator(filterCon.getOperator()), valueList);
            } else {
                Object value2 = filterCon.getExpressionProperty("value2").getValue();
                this.exprCodec.decode(filterQuery);
                filterCondExpr = new ConditionalExpression(ChartReportItemUtil.adaptExpression(this.exprCodec, this.modelAdapter, true), DataAdapterUtil.adaptModelFilterOperator(filterCon.getOperator()), value1 == null ? null : this.modelAdapter.adaptExpression(value1.get(0)), value2 == null ? null : this.modelAdapter.adaptExpression((Expression)value2));
            }
            ILevelDefinition levelDefinition = null;
            if (filterCon.getMember() != null) {
                levelDefinition = this.registeredLevelHandles.get(filterCon.getMember().getLevel());
            }
            ICubeFilterDefinition filterDef = ChartCubeQueryHelper.getCubeElementFactory().creatCubeFilterDefinition(filterCondExpr, levelDefinition, qualifyLevels, qualifyValues);
            cubeQuery.addFilter(filterDef);
        }
    }

    private List<FilterConditionElementHandle> getFiltersFromXtab(CrosstabReportItemHandle crossTab) {
        DesignElementHandle elementHandle;
        ArrayList<FilterConditionElementHandle> list = new ArrayList<FilterConditionElementHandle>();
        if (crossTab == null) {
            return list;
        }
        if (crossTab.getCrosstabView(1) != null) {
            elementHandle = crossTab.getCrosstabView(1).getModelHandle();
            list.addAll(this.getLevelOnCrosstab((ExtendedItemHandle)elementHandle));
        }
        if (crossTab.getCrosstabView(0) != null) {
            elementHandle = crossTab.getCrosstabView(0).getModelHandle();
            list.addAll(this.getLevelOnCrosstab((ExtendedItemHandle)elementHandle));
        }
        int measureCount = crossTab.getMeasureCount();
        int i = 0;
        while (i < measureCount) {
            MeasureViewHandle measureView = crossTab.getMeasure(i);
            Iterator iter = measureView.filtersIterator();
            while (iter.hasNext()) {
                list.add((FilterConditionElementHandle)iter.next());
            }
            ++i;
        }
        return list;
    }

    private List<FilterConditionElementHandle> getLevelOnCrosstab(ExtendedItemHandle handle) {
        CrosstabViewHandle crossTabViewHandle = null;
        try {
            crossTabViewHandle = (CrosstabViewHandle)handle.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(e);
        }
        ArrayList<FilterConditionElementHandle> list = new ArrayList<FilterConditionElementHandle>();
        if (crossTabViewHandle == null) {
            return list;
        }
        int dimensionCount = crossTabViewHandle.getDimensionCount();
        int i = 0;
        while (i < dimensionCount) {
            DimensionViewHandle dimension = crossTabViewHandle.getDimension(i);
            int levelCount = dimension.getLevelCount();
            int j = 0;
            while (j < levelCount) {
                LevelViewHandle levelHandle = dimension.getLevel(j);
                Iterator iter = levelHandle.filtersIterator();
                while (iter.hasNext()) {
                    list.add((FilterConditionElementHandle)iter.next());
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    private void addMembers(List<ILevelDefinition> levels, List<String> values, MemberValueHandle member) {
        ILevelDefinition levelDef;
        if (member != null && (levelDef = this.registeredLevelHandles.get(member.getLevel())) != null) {
            levels.add(levelDef);
            values.add(member.getValue());
            if (member.getContentCount("memberValues") > 0) {
                this.addMembers(levels, values, (MemberValueHandle)member.getContent("memberValues", 0));
            }
        }
    }

    private Collection<ILevelDefinition> getAllLevelsInHierarchyOrder(CubeHandle cubeHandle, ICubeQueryDefinition cubeQuery) {
        Collection<ILevelDefinition> levelValues = this.registeredLevels.values();
        if (levelValues.size() > 1) {
            ArrayList<ILevelDefinition> levelList = new ArrayList<ILevelDefinition>(levelValues.size());
            for (ILevelDefinition level : levelValues) {
                levelList.add(level);
            }
            Collections.sort(levelList, this.getLevelComparator(cubeHandle, true));
            return levelList;
        }
        return levelValues;
    }

    protected int getEdgeType(String dimensionName) {
        if (this.rowEdgeDimension == null) {
            this.rowEdgeDimension = dimensionName;
            return 1;
        }
        return this.rowEdgeDimension.equals(dimensionName) ? 1 : 2;
    }

    private Comparator<ILevelDefinition> getLevelComparator(final CubeHandle cubeHandle, final boolean hasDiffEdges) {
        return new Comparator<ILevelDefinition>(){

            @Override
            public int compare(ILevelDefinition a, ILevelDefinition b) {
                HierarchyHandle hh;
                String dimB;
                int edgeB;
                String dimA = a.getHierarchy().getDimension().getName();
                int edgeA = ChartCubeQueryHelper.this.getEdgeType(dimA);
                if (hasDiffEdges && edgeA != (edgeB = ChartCubeQueryHelper.this.getEdgeType(dimB = b.getHierarchy().getDimension().getName()))) {
                    return edgeA == 2 ? 1 : -1;
                }
                dimB = b.getHierarchy().getDimension().getName();
                HierarchyHandle hb = hh = cubeHandle.getDimension(dimA).getDefaultHierarchy();
                if (!dimB.equals(dimA)) {
                    hb = cubeHandle.getDimension(dimB).getDefaultHierarchy();
                }
                return hh.getLevel(a.getName()).getIndex() - hb.getLevel(b.getName()).getIndex();
            }
        };
    }

    private void sortLevelDefinition(IEdgeDefinition edge, CubeHandle cubeHandle) {
        if (edge != null) {
            for (IDimensionDefinition dim : edge.getDimensions()) {
                IHierarchyDefinition hd = dim.getHierarchy().get(0);
                if (hd == null || hd.getLevels().size() <= 1) continue;
                Collections.sort(hd.getLevels(), this.getLevelComparator(cubeHandle, false));
            }
        }
    }

    static List<SeriesDefinition> getAllSeriesDefinitions(Chart chart) {
        ArrayList<SeriesDefinition> seriesList = new ArrayList<SeriesDefinition>();
        if (chart instanceof ChartWithAxes) {
            Axis xAxis = (Axis)((ChartWithAxes)chart).getAxes().get(0);
            seriesList.addAll((Collection<SeriesDefinition>)xAxis.getSeriesDefinitions());
            EList<Axis> axisList = xAxis.getAssociatedAxes();
            int i = 0;
            while (i < axisList.size()) {
                seriesList.addAll((Collection<SeriesDefinition>)((Axis)axisList.get(i)).getSeriesDefinitions());
                ++i;
            }
        } else if (chart instanceof ChartWithoutAxes) {
            SeriesDefinition sdBase = (SeriesDefinition)((ChartWithoutAxes)chart).getSeriesDefinitions().get(0);
            seriesList.add(sdBase);
            seriesList.addAll((Collection<SeriesDefinition>)sdBase.getSeriesDefinitions());
        }
        return seriesList;
    }
}

