/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.FilterUtil;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;

public final class QueryExecutionStrategyUtil {
    public static Strategy getQueryExecutionStrategy(DataEngineSession session, IQueryDefinition query, IBaseDataSetDesign dataSet) throws DataException {
        if (session.getEngineContext().getMode() == 4) {
            return Strategy.Complex;
        }
        if (query.getGroups() != null && query.getGroups().size() > 0) {
            if (session.getEngineContext().getMode() == 4) {
                return Strategy.Complex;
            }
            for (IGroupDefinition group : query.getGroups()) {
                if (group.getFilters().isEmpty() && group.getSorts().isEmpty() && !query.getQueryExecutionHints().doSortBeforeGrouping()) continue;
                return Strategy.Complex;
            }
        }
        if (query.getFilters() != null && query.getFilters().size() > 0) {
            return Strategy.Complex;
        }
        if (query.getSorts() != null && query.getSorts().size() > 0) {
            return Strategy.Complex;
        }
        if (query.getSubqueries() != null && query.getSubqueries().size() > 0) {
            return Strategy.Complex;
        }
        if (!query.usesDetails()) {
            return Strategy.Complex;
        }
        boolean hasAggregation = false;
        if (query.getBindings() != null) {
            for (IBinding binding : query.getBindings().values()) {
                if (binding.getAggrFunction() != null) {
                    hasAggregation = true;
                    IAggrFunction aggr = AggregationManager.getInstance().getAggregation(binding.getAggrFunction());
                    if (aggr != null && aggr.getNumberOfPasses() > 1) {
                        return Strategy.Complex;
                    }
                    ArrayList<IBaseExpression> exprs = new ArrayList<IBaseExpression>();
                    exprs.addAll(binding.getArguments());
                    if (binding.getExpression() != null) {
                        exprs.add(binding.getExpression());
                    }
                    int i = 0;
                    while (i < exprs.size()) {
                        Object expr = exprs.get(i);
                        if (!(expr instanceof IScriptExpression)) {
                            return Strategy.Complex;
                        }
                        IScriptExpression scriptExpr = (IScriptExpression)expr;
                        try {
                            List columnExprs = ExpressionUtil.extractColumnExpressions(scriptExpr.getText());
                            for (IColumnBinding temp : columnExprs) {
                                Object obj = query.getBindings().get(temp.getResultSetColumnName());
                                if (!(obj instanceof IBinding)) continue;
                                IBinding bindingObj = (IBinding)obj;
                                if (bindingObj.getAggrFunction() != null) {
                                    return Strategy.Complex;
                                }
                                IBaseExpression baseExpr = ((IBinding)obj).getExpression();
                                if (!(baseExpr instanceof IScriptExpression)) continue;
                                String cb = ExpressionUtil.getColumnName(((IScriptExpression)baseExpr).getText());
                                if (ScriptEvalUtil.compare(bindingObj.getBindingName(), cb) == 0) continue;
                                return Strategy.Complex;
                            }
                        }
                        catch (BirtException birtException) {
                            return Strategy.Complex;
                        }
                        ++i;
                    }
                }
                if (!ExpressionCompilerUtil.hasAggregationInExpr(binding.getExpression())) continue;
                return Strategy.Complex;
            }
        }
        if (dataSet != null) {
            if (dataSet.getFilters() != null && FilterUtil.hasMutipassFilters(dataSet.getFilters())) {
                return Strategy.Complex;
            }
            if (dataSet.needDistinctValue()) {
                return Strategy.Complex;
            }
            if (dataSet.getComputedColumns() != null) {
                List computedColumns = dataSet.getComputedColumns();
                int i = 0;
                while (i < computedColumns.size()) {
                    IComputedColumn computedColumn = (IComputedColumn)computedColumns.get(i);
                    if (computedColumn.getAggregateFunction() != null) {
                        return Strategy.Complex;
                    }
                    if (computedColumn.getExpression() instanceof IScriptExpression && ExpressionUtil.hasAggregation(((IScriptExpression)computedColumn.getExpression()).getText())) {
                        return Strategy.Complex;
                    }
                    ++i;
                }
            }
        }
        return hasAggregation ? Strategy.SimpleLookingFoward : Strategy.SimpleNoLookingFoward;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Strategy {
        SimpleLookingFoward,
        SimpleNoLookingFoward,
        Complex;

    }
}

