/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.script.ParameterAttribute;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentConstants;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentStreamSorter;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.content.impl.BookmarkContent;
import org.eclipse.birt.report.engine.internal.index.DocumentIndexWriter;
import org.eclipse.birt.report.engine.internal.util.BundleVersionUtil;
import org.eclipse.birt.report.engine.ir.EngineIRWriter;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.util.DocumentUtil;

public class ReportDocumentWriter
implements ReportDocumentConstants {
    private static Logger logger = Logger.getLogger(ReportDocumentWriter.class.getName());
    protected IReportEngine engine;
    protected IDocArchiveWriter archive;
    private String designName;
    private String extensions;
    private HashMap paramters = new HashMap();
    private HashMap globalVariables = new HashMap();
    private DocumentIndexWriter indexWriter;
    private int checkpoint = 0;
    private long pageCount = 0L;
    private static final int AUTO_LAYOUT_DESIGN = 0;
    private static final int FIXED_LAYOUT_DESIGN = 1;
    private int designType = 0;
    protected boolean finished = false;

    public ReportDocumentWriter(IReportEngine engine, IDocArchiveWriter archive) throws EngineException {
        this(engine, archive, null);
    }

    public ReportDocumentWriter(IReportEngine engine, IDocArchiveWriter archive, String[] extensions) throws EngineException {
        this.engine = engine;
        this.archive = archive;
        if (extensions != null && extensions.length > 0) {
            StringBuilder sb = new StringBuilder();
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                sb.append(ext);
                sb.append(";");
                ++n2;
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            this.extensions = sb.toString();
        }
        try {
            archive.initialize();
            this.saveCoreStreams();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed in initializing the archive", e);
        }
    }

    public IDocArchiveWriter getArchive() {
        return this.archive;
    }

    public void finish() {
        try {
            this.checkpoint = -1;
            this.saveCoreStreams();
            this.archive.setStreamSorter(new ReportDocumentStreamSorter());
            this.archive.flush();
            this.finished = true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed in flush the archive", e);
        }
    }

    public void close() {
        if (this.indexWriter != null) {
            try {
                this.indexWriter.close();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Failed to close the indexes", ex);
            }
            this.indexWriter = null;
        }
        if (!this.finished) {
            this.finish();
        }
        try {
            this.archive.finish();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed in close the archive", e);
        }
    }

    public String getName() {
        return this.archive.getName();
    }

    public void saveReportIR(Report reportIR) {
        block14: {
            RAOutputStream out = null;
            try {
                try {
                    out = this.archive.createRandomAccessStream("/design.ir");
                    new EngineIRWriter().write(out, reportIR);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Failed to save design IR!", ex);
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public ReportRunnable saveDesign(ReportRunnable runnable, ReportRunnable originalRunnable) throws EngineException {
        OutputStream out = null;
        ReportRunnable newRunnable = runnable;
        try {
            try {
                ReportDesignHandle design = runnable.getReport();
                if ("fixed layout".equals(design.getLayoutPreference())) {
                    this.designType = 1;
                }
                out = this.archive.createRandomAccessStream("/design");
                ReportDesignHandle newDesign = DocumentUtil.serialize(design, out);
                this.designName = design.getFileName();
                newRunnable = new ReportRunnable(this.engine, newDesign);
                newRunnable.setReportName(runnable.getReportName());
                newRunnable.cachedScripts = runnable.cachedScripts;
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed to save design!", ex);
                throw new EngineException("Error.FailedToSaveDesign", ex);
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            out = null;
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
        out = null;
        return newRunnable;
    }

    public void saveParamters(HashMap map) {
        this.paramters = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            ParameterAttribute valueObj = (ParameterAttribute)entry.getValue();
            Object value = valueObj.getValue();
            String display = valueObj.getDisplayText();
            this.paramters.put(key, new Object[]{value, display});
        }
    }

    public void savePersistentObjects(Map map) {
        this.globalVariables = new HashMap();
        this.globalVariables.putAll(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCoreStreams() throws Exception {
        Object lock = this.archive.lock("/core");
        try {
            Object object = lock;
            synchronized (object) {
                this.doSaveCoreStreams();
            }
        }
        finally {
            this.archive.unlock(lock);
        }
    }

    protected void doSaveCoreStreams() throws Exception {
        block18: {
            RAOutputStream out = null;
            DataOutputStream coreStream = null;
            try {
                try {
                    out = this.archive.createRandomAccessStream("/core");
                    coreStream = new DataOutputStream(new BufferedOutputStream(out));
                    IOUtil.writeString(coreStream, "reportdocument");
                    IOUtil.writeString(coreStream, "CORE_VERSION_2");
                    IOUtil.writeString(coreStream, "2.1.3-2.2RC0");
                    HashMap<String, String> properties = new HashMap<String, String>();
                    if (this.designType == 0) {
                        properties.put("page hint version", "3");
                    } else {
                        properties.put("page hint version", "4");
                    }
                    properties.put("BIRT ENGINE VERSION", "2.6.1");
                    properties.put("BIRT ENGINE BUILD NUMBER", this.getBuildNumber());
                    if (this.extensions != null) {
                        properties.put("BIRT_ENGINE_EXTENSIONS", this.extensions);
                    }
                    IOUtil.writeMap(coreStream, properties);
                    if (this.checkpoint != -1) {
                        ++this.checkpoint;
                    }
                    IOUtil.writeInt(coreStream, this.checkpoint);
                    IOUtil.writeLong(coreStream, this.pageCount);
                    IOUtil.writeString(coreStream, this.designName);
                    IOUtil.writeMap(coreStream, this.paramters);
                    IOUtil.writeMap(coreStream, this.globalVariables);
                    coreStream.flush();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Failed to save the core stream!", ex);
                    if (out != null) {
                        try {
                            out.close();
                            out = null;
                        }
                        catch (Exception exception) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                        out = null;
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.close();
                    out = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    private void writeMap(DataOutputStream stream, HashMap map) throws Exception {
        if (map == null) {
            map = new HashMap();
        }
        IOUtil.writeLong(stream, map.size());
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Long value = (Long)entry.getValue();
            IOUtil.writeString(stream, key);
            IOUtil.writeLong(stream, value);
        }
    }

    public void setPageCount(long pageCount) {
        this.pageCount = pageCount;
    }

    private String getBuildNumber() {
        return BundleVersionUtil.getBundleVersion("org.eclipse.birt.report.engine");
    }

    public void removeReportletDoucment() {
        if (this.archive.exists("/reportletDocument")) {
            this.archive.dropStream("/reportletDocument");
        }
    }

    public void saveReportletDocument(String bookmark, InstanceID iid) throws IOException {
        RAOutputStream out = this.archive.createOutputStream("/reportletDocument");
        try {
            IOUtil.writeInt(out, 0);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream s = new DataOutputStream(buffer);
            IOUtil.writeString(s, bookmark);
            IOUtil.writeString(s, iid == null ? null : iid.toUniqueString());
            out.writeInt(buffer.size());
            out.write(buffer.toByteArray());
        }
        finally {
            out.close();
        }
    }

    public void setBookmark(String bookmark, BookmarkContent content) {
        try {
            if (this.indexWriter == null) {
                this.indexWriter = new DocumentIndexWriter(this.archive);
            }
            if (this.indexWriter != null) {
                this.indexWriter.setBookmark(bookmark, content);
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Failed to save the bookmark", ex);
        }
    }

    public void setOffsetOfBookmark(String bookmark, long offset) {
        try {
            if (this.indexWriter == null) {
                this.indexWriter = new DocumentIndexWriter(this.archive);
            }
            if (this.indexWriter != null) {
                this.indexWriter.setOffsetOfBookmark(bookmark, offset);
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Failed to save the bookmark", ex);
        }
    }

    public void setOffsetOfInstance(String instanceId, long offset) {
        try {
            if (this.indexWriter == null) {
                this.indexWriter = new DocumentIndexWriter(this.archive);
            }
            if (this.indexWriter != null) {
                this.indexWriter.setOffsetOfInstance(instanceId, offset);
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Failed to save the bookmark", ex);
        }
    }
}

