/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.config.excel;

import java.util.Locale;
import org.eclipse.birt.report.engine.api.EXCELRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.emitter.config.AbstractConfigurableOptionObserver;
import org.eclipse.birt.report.engine.emitter.config.AbstractEmitterDescriptor;
import org.eclipse.birt.report.engine.emitter.config.ConfigurableOption;
import org.eclipse.birt.report.engine.emitter.config.IConfigurableOption;
import org.eclipse.birt.report.engine.emitter.config.IConfigurableOptionObserver;
import org.eclipse.birt.report.engine.emitter.config.IOptionValue;
import org.eclipse.birt.report.engine.emitter.config.excel.i18n.Messages;

public class ExcelEmitterDescriptor
extends AbstractEmitterDescriptor {
    protected IConfigurableOption[] options;
    protected Locale locale;

    public ExcelEmitterDescriptor() {
        this.initOptions();
    }

    public void setLocale(Locale locale) {
        if (this.locale != locale) {
            this.locale = locale;
            this.initOptions();
        }
    }

    private void initOptions() {
        ConfigurableOption wrappingText = this.initializeWrappingText();
        ConfigurableOption chartDpi = new ConfigurableOption("ChartDpi");
        chartDpi.setDisplayName(this.getMessage("OptionDisplayValue.ChartDpi"));
        chartDpi.setDataType(IConfigurableOption.DataType.INTEGER);
        chartDpi.setDisplayType(IConfigurableOption.DisplayType.TEXT);
        chartDpi.setDefaultValue(new Integer(192));
        chartDpi.setToolTip(this.getMessage("Tooltip.ChartDpi"));
        chartDpi.setDescription(this.getMessage("OptionDescription.ChartDpi"));
        ConfigurableOption hideGridlines = new ConfigurableOption("excelRenderOption.hideGridlines");
        hideGridlines.setDisplayName(this.getMessage("OptionDisplayValue.HideGridlines"));
        hideGridlines.setDataType(IConfigurableOption.DataType.BOOLEAN);
        hideGridlines.setDisplayType(IConfigurableOption.DisplayType.CHECKBOX);
        hideGridlines.setDefaultValue(Boolean.FALSE);
        hideGridlines.setToolTip(null);
        hideGridlines.setDescription(this.getMessage("OptionDescription.HideGridlines"));
        this.options = new IConfigurableOption[]{wrappingText, chartDpi};
    }

    protected String getMessage(String key) {
        return Messages.getString(key, this.locale);
    }

    protected ConfigurableOption initializeWrappingText() {
        ConfigurableOption wrappingText = new ConfigurableOption("excelRenderOption.wrappingText");
        wrappingText.setDisplayName(this.getMessage("OptionDisplayValue.WrappingText"));
        wrappingText.setDataType(IConfigurableOption.DataType.BOOLEAN);
        wrappingText.setDisplayType(IConfigurableOption.DisplayType.CHECKBOX);
        wrappingText.setDefaultValue(Boolean.TRUE);
        wrappingText.setToolTip(null);
        wrappingText.setDescription(this.getMessage("OptionDescription.WrappingText"));
        return wrappingText;
    }

    public IConfigurableOptionObserver createOptionObserver() {
        return new ExcelOptionObserver();
    }

    public String getDescription() {
        return this.getMessage("ExcelEmitter.Description");
    }

    public String getDisplayName() {
        return this.getMessage("ExcelEmitter.DisplayName");
    }

    public String getID() {
        return "org.eclipse.birt.report.engine.emitter.prototype.excel";
    }

    class ExcelOptionObserver
    extends AbstractConfigurableOptionObserver {
        ExcelOptionObserver() {
        }

        public IConfigurableOption[] getOptions() {
            return ExcelEmitterDescriptor.this.options;
        }

        public IRenderOption getPreferredRenderOption() {
            EXCELRenderOption renderOption = new EXCELRenderOption();
            renderOption.setEmitterID(ExcelEmitterDescriptor.this.getID());
            renderOption.setOutputFormat("xls");
            if (this.values != null && this.values.length > 0) {
                IOptionValue[] iOptionValueArray = this.values;
                int n = this.values.length;
                int n2 = 0;
                while (n2 < n) {
                    IOptionValue optionValue = iOptionValueArray[n2];
                    if (optionValue != null) {
                        renderOption.setOption(optionValue.getName(), optionValue.getValue());
                    }
                    ++n2;
                }
            }
            return renderOption;
        }
    }
}

