/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import com.ibm.icu.util.TimeZone;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.css.engine.value.DataFormatValue;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.excel.BookmarkDef;
import org.eclipse.birt.report.engine.emitter.excel.Data;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.emitter.excel.HyperlinkDef;
import org.eclipse.birt.report.engine.emitter.excel.layout.ColumnsInfo;
import org.eclipse.birt.report.engine.emitter.excel.layout.ContainerSizeInfo;
import org.eclipse.birt.report.engine.emitter.excel.layout.ExcelContext;
import org.eclipse.birt.report.engine.emitter.excel.layout.ExcelLayoutEngine;
import org.eclipse.birt.report.engine.emitter.excel.layout.LayoutUtil;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.MapDesign;
import org.eclipse.birt.report.engine.layout.pdf.util.HTML2Content;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.presentation.ContentEmitterVisitor;
import org.w3c.dom.css.CSSValue;

public class ExcelEmitter
extends ContentEmitterAdapter {
    protected static Logger logger = Logger.getLogger(ExcelEmitter.class.getName());
    protected IEmitterServices service = null;
    protected ExcelLayoutEngine engine;
    protected ExcelContext context;
    protected Set<String> bookmarkNames;

    public String getOutputFormat() {
        return "xls";
    }

    public void initialize(IEmitterServices service) throws EngineException {
        this.context = this.createContext();
        this.service = service;
        this.context.initialize(service);
        this.bookmarkNames = new HashSet<String>();
    }

    protected ExcelContext createContext() {
        return new ExcelContext();
    }

    public void start(IReportContent report) {
        this.context.setReport(report);
        IStyle style = report.getRoot().getComputedStyle();
        this.engine = this.createLayoutEngine(this.context, new ContentEmitterVisitor((IContentEmitter)this));
        this.engine.initalize(style);
    }

    protected ExcelLayoutEngine createLayoutEngine(ExcelContext context, ContentEmitterVisitor contentVisitor) {
        return new ExcelLayoutEngine(context, contentVisitor);
    }

    public void startPage(IPageContent page) throws BirtException {
        this.engine.startPage(page);
    }

    public void endPage(IPageContent page) throws BirtException {
        this.engine.endPage(page);
    }

    public void startTable(ITableContent table) {
        this.engine.startTable(table);
    }

    public void startRow(IRowContent row) {
        this.engine.addRow(row.getComputedStyle());
    }

    public void endRow(IRowContent row) {
        DimensionType height = row.getHeight();
        float rowHeight = (float)ExcelUtil.convertDimensionType(height, 0.0f, this.context.getDpi()) / 1000.0f;
        this.engine.endRow(rowHeight);
    }

    public void startCell(ICellContent cell) {
        IStyle style = cell.getComputedStyle();
        this.engine.addCell(cell, cell.getColumn(), cell.getColSpan(), cell.getRowSpan(), style);
    }

    public void endCell(ICellContent cell) {
        this.engine.endCell(cell);
    }

    public void endTable(ITableContent table) {
        this.engine.endTable((IContent)table);
    }

    public void startList(IListContent list) {
        ContainerSizeInfo size = this.engine.getCurrentContainer().getSizeInfo();
        ColumnsInfo table = LayoutUtil.createTable(list, size.getWidth(), this.context.getDpi());
        this.engine.addTable((IContainerContent)list, table, size);
        if (list.getChildren() == null) {
            HyperlinkDef link = this.parseHyperLink((IContent)list);
            BookmarkDef bookmark = this.getBookmark((IContent)list);
            float height = this.getContentHeight((IContent)list);
            this.engine.addData(null, list.getComputedStyle(), link, bookmark, height);
        }
    }

    public void startListBand(IListBandContent listBand) {
        this.engine.addCell(0, 1, 1, listBand.getComputedStyle());
    }

    public void endListBand(IListBandContent listBand) {
        this.engine.endListBandContainer();
    }

    public void endList(IListContent list) {
        this.engine.endTable((IContent)list);
    }

    public void startForeign(IForeignContent foreign) throws BirtException {
        if ("text/html".equalsIgnoreCase(foreign.getRawType())) {
            HTML2Content.html2Content((IForeignContent)foreign);
            HyperlinkDef link = this.parseHyperLink((IContent)foreign);
            this.engine.processForeign(foreign, link);
        }
    }

    public void startText(ITextContent text) {
        HyperlinkDef url = this.parseHyperLink((IContent)text);
        BookmarkDef bookmark = this.getBookmark((IContent)text);
        float height = this.getContentHeight((IContent)text);
        this.engine.addData(text.getText(), text.getComputedStyle(), url, bookmark, height);
    }

    public void startData(IDataContent data) {
        this.addDataContent(data);
    }

    protected Data addDataContent(IDataContent data) {
        float height = this.getContentHeight((IContent)data);
        HyperlinkDef url = this.parseHyperLink((IContent)data);
        BookmarkDef bookmark = this.getBookmark((IContent)data);
        Data excelData = null;
        Object generateBy = data.getGenerateBy();
        IStyle style = data.getComputedStyle();
        DataFormatValue dataformat = style.getDataFormat();
        MapDesign map = null;
        if (generateBy instanceof DataItemDesign) {
            DataItemDesign design = (DataItemDesign)generateBy;
            map = design.getMap();
        }
        if (map != null && map.getRuleCount() > 0 && data.getLabelText() != null) {
            excelData = this.engine.addData(data.getText(), style, url, bookmark, height);
        } else {
            String locale = null;
            int type = ExcelUtil.getType(data.getValue());
            if (type == 2) {
                if (dataformat != null) {
                    locale = dataformat.getStringLocale();
                }
                String text = data.getValue() == null ? null : data.getText();
                excelData = this.engine.addData(text, style, url, bookmark, locale, height);
            } else if (type == 1) {
                if (dataformat != null) {
                    locale = dataformat.getNumberLocale();
                }
                excelData = this.engine.addData(data.getValue(), style, url, bookmark, locale, height);
            } else {
                if (dataformat != null) {
                    locale = dataformat.getDateTimeLocale();
                }
                excelData = this.engine.addDateTime(data, style, url, bookmark, locale, height);
            }
        }
        return excelData;
    }

    private float getContentHeight(IContent content) {
        return (float)ExcelUtil.convertDimensionType(content.getHeight(), 0.0f, this.context.getDpi()) / 1000.0f;
    }

    public void startImage(IImageContent image) {
        if (this.context.isIgnoreImage()) {
            return;
        }
        IStyle style = image.getComputedStyle();
        HyperlinkDef url = this.parseHyperLink((IContent)image);
        BookmarkDef bookmark = this.getBookmark((IContent)image);
        this.engine.addImageData(image, style, url, bookmark);
    }

    public void startLabel(ILabelContent label) {
        Object design = label.getGenerateBy();
        ILabelContent container = label;
        while (design == null) {
            container = (IContent)container.getParent();
            design = container.getGenerateBy();
        }
        HyperlinkDef url = this.parseHyperLink((IContent)label);
        BookmarkDef bookmark = this.getBookmark((IContent)label);
        if (!"\n".equalsIgnoreCase(label.getText()) || !(container instanceof IForeignContent)) {
            float height = this.getContentHeight((IContent)label);
            this.engine.addData(label.getText(), label.getComputedStyle(), url, bookmark, height);
        }
    }

    public void startAutoText(IAutoTextContent autoText) {
        HyperlinkDef link = this.parseHyperLink((IContent)autoText);
        BookmarkDef bookmark = this.getBookmark((IContent)autoText);
        float height = this.getContentHeight((IContent)autoText);
        this.engine.addData(autoText.getText(), autoText.getComputedStyle(), link, bookmark, height);
    }

    public void end(IReportContent report) {
        this.engine.end(report);
        this.engine.endWriter();
    }

    public HyperlinkDef parseHyperLink(IContent content) {
        HyperlinkDef hyperlink = null;
        IHyperlinkAction linkAction = content.getHyperlinkAction();
        if (linkAction != null) {
            String tooltip = linkAction.getTooltip();
            String bookmark = linkAction.getBookmark();
            IReportRunnable reportRunnable = this.service.getReportRunnable();
            IReportContext reportContext = this.service.getReportContext();
            IHTMLActionHandler actionHandler = (IHTMLActionHandler)this.service.getOption("actionHandler");
            switch (linkAction.getType()) {
                case 2: {
                    hyperlink = new HyperlinkDef(bookmark, 2, tooltip);
                    break;
                }
                case 1: {
                    String url = EmitterUtil.getHyperlinkUrl((IHyperlinkAction)linkAction, (IReportRunnable)reportRunnable, (IHTMLActionHandler)actionHandler, (IReportContext)reportContext);
                    hyperlink = new HyperlinkDef(url, 1, tooltip);
                    break;
                }
                case 3: {
                    String url = EmitterUtil.getHyperlinkUrl((IHyperlinkAction)linkAction, (IReportRunnable)reportRunnable, (IHTMLActionHandler)actionHandler, (IReportContext)reportContext);
                    hyperlink = new HyperlinkDef(url, 3, tooltip);
                }
            }
        }
        if (hyperlink != null) {
            Color color = PropertyUtil.getColor((CSSValue)content.getStyle().getProperty(26));
            hyperlink.setColor(color);
        }
        return hyperlink;
    }

    protected BookmarkDef getBookmark(IContent content) {
        String bookmarkName = content.getBookmark();
        if (bookmarkName == null) {
            return null;
        }
        if (this.bookmarkNames.contains(bookmarkName)) {
            return null;
        }
        BookmarkDef bookmark = new BookmarkDef(bookmarkName);
        if (!ExcelUtil.isValidBookmarkName(bookmarkName)) {
            bookmark.setGeneratedName(this.engine.getGenerateBookmark(bookmarkName));
        }
        this.bookmarkNames.add(bookmarkName);
        return bookmark;
    }

    public TimeZone getTimeZone() {
        IReportContext reportContext;
        if (this.service != null && (reportContext = this.service.getReportContext()) != null) {
            return reportContext.getTimeZone();
        }
        return TimeZone.getDefault();
    }

    public void endContainer(IContainerContent container) {
        this.engine.removeContainerStyle();
    }

    public void startContainer(IContainerContent container) {
        this.engine.addContainerStyle(container.getComputedStyle());
    }
}

