/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs.expression;

import java.text.MessageFormat;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionCellEditorProvider;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.IExpressionCellEditorProvider;
import org.eclipse.birt.report.designer.internal.ui.expressions.ExpressionContextFactoryImpl;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionBuilder;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionContextFactory;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ExpressionCellEditor
extends CellEditor {
    private Control contents;
    protected Button button;
    private FocusListener buttonFocusListener;
    private IExpressionCellEditorProvider provider;
    protected Menu menu;
    private ModifyListener modifyListener;
    protected Text editor;
    private IExpressionContextFactory contextFactory;
    private Object contextObject;
    private SelectionAdapter listener;

    public ExpressionCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected Button createButton(Composite parent) {
        Button result = new Button(parent, 1024);
        result.setText("...");
        return result;
    }

    protected Control createContents(Composite cell) {
        this.editor = new Text(cell, this.getStyle());
        this.editor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ExpressionCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.editor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ExpressionCellEditor.this.fireApplyEditorValue();
                ExpressionCellEditor.this.deactivate();
            }
        });
        this.editor.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.editor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ExpressionCellEditor.this.focusLost();
            }
        });
        this.editor.addModifyListener(this.getModifyListener());
        this.setValueValid(true);
        return this.editor;
    }

    protected ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ExpressionCellEditor.this.editOccured(e);
                }
            };
        }
        return this.modifyListener;
    }

    protected void editOccured(ModifyEvent e) {
        String value = this.editor.getText();
        if (value == null) {
            value = "";
        }
        String typedValue = value;
        boolean oldValidState = this.isValueValid();
        boolean newValidState = this.isCorrect(typedValue);
        if (!newValidState) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), value));
        }
        this.valueChanged(oldValidState, newValidState);
    }

    protected Control createControl(Composite parent) {
        Font font = parent.getFont();
        Color bg = parent.getBackground();
        Composite editorArea = new Composite(parent, this.getStyle());
        editorArea.setFont(font);
        editorArea.setBackground(bg);
        editorArea.setLayout((Layout)new DialogCellLayout());
        this.contents = this.createContents(editorArea);
        this.button = this.createButton(editorArea);
        this.button.setFont(font);
        this.menu = new Menu((Decorations)parent.getShell(), 8);
        this.button.addListener(4, new Listener(){

            public void handleEvent(Event e) {
                if (!ExpressionCellEditor.this.button.isEnabled() || e.button != 1) {
                    return;
                }
                ExpressionCellEditor.this.showMenu();
            }
        });
        this.button.addListener(2, new Listener(){

            public void handleEvent(Event e) {
                if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001) {
                    ExpressionCellEditor.this.showMenu();
                }
            }
        });
        this.setExpressionCellEditorProvider(new ExpressionCellEditorProvider(false));
        this.button.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    ExpressionCellEditor.this.fireCancelEditor();
                }
            }
        });
        this.button.addFocusListener(this.getButtonFocusListener());
        this.setValueValid(true);
        return editorArea;
    }

    public void deactivate() {
        if (this.button != null && !this.button.isDisposed()) {
            this.button.removeFocusListener(this.getButtonFocusListener());
        }
        super.deactivate();
    }

    protected Object doGetValue() {
        if (this.getExpression() == null || this.getExpression().trim().length() == 0) {
            this.button.setData("exprType", null);
            return null;
        }
        return new Expression((Object)this.getExpression(), this.getExpressionType());
    }

    protected void doSetFocus() {
        this.button.setFocus();
        this.button.addFocusListener(this.getButtonFocusListener());
    }

    private FocusListener getButtonFocusListener() {
        if (this.buttonFocusListener == null) {
            this.buttonFocusListener = new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    ExpressionCellEditor.this.focusLost();
                }
            };
        }
        return this.buttonFocusListener;
    }

    protected void focusLost() {
        if (this.button != null && !this.button.isFocusControl() && Display.getCurrent().getCursorControl() != this.button) {
            super.focusLost();
        }
    }

    protected void doSetValue(Object value) {
        if (this.editor != null) {
            this.editor.removeModifyListener(this.getModifyListener());
            if (value instanceof Expression) {
                this.editor.setText(DEUtil.resolveNull((String)((Expression)value).getStringExpression()));
                this.button.setData("exprType", (Object)((Expression)value).getType());
            } else if (value instanceof ExpressionHandle) {
                this.editor.setText(DEUtil.resolveNull((String)((ExpressionHandle)value).getStringExpression()));
                this.button.setData("exprType", (Object)((ExpressionHandle)value).getType());
            } else {
                this.editor.setText(value == null ? "" : value.toString());
                this.button.setData("exprType", (Object)UIUtil.getDefaultScriptType());
            }
            this.refresh();
            this.editor.addModifyListener(this.getModifyListener());
        }
    }

    protected void setExpressionType(String exprType) {
        this.button.setData("exprType", (Object)exprType);
        this.refresh();
    }

    protected String getExpressionType() {
        String type = (String)this.button.getData("exprType");
        if (type == null) {
            type = UIUtil.getDefaultScriptType();
            this.setExpressionType(type);
        }
        return type;
    }

    protected void setExpressionCellEditorProvider(IExpressionCellEditorProvider provider) {
        if (provider != null && provider != this.provider) {
            this.provider = provider;
            provider.setInput(this);
            int i = 0;
            while (i < this.menu.getItemCount()) {
                this.menu.getItem(i).dispose();
                --i;
                ++i;
            }
            String[] types = this.provider.getExpressionTypes();
            this.listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Widget widget = e.widget;
                    if (widget instanceof MenuItem) {
                        String exprType = (String)widget.getData();
                        ExpressionCellEditor.this.provider.handleSelectionEvent(exprType);
                    } else if (widget instanceof Button) {
                        ExpressionCellEditor.this.provider.handleSelectionEvent(ExpressionCellEditor.this.getExpressionType());
                    }
                }
            };
            int i2 = 0;
            while (i2 < types.length) {
                MenuItem item = new MenuItem(this.menu, 32);
                item.setText(this.provider.getText(types[i2]));
                item.setData((Object)types[i2]);
                item.addSelectionListener((SelectionListener)this.listener);
                ++i2;
            }
            if (this.menu.getItemCount() <= 1) {
                this.menu = null;
                this.button.addSelectionListener((SelectionListener)this.listener);
            }
            this.refresh();
        }
    }

    public void refresh() {
        if (!this.button.isDisposed()) {
            this.button.setToolTipText(this.provider.getTooltipText(this.getExpressionType()));
        }
    }

    public void setExpressionInput(IExpressionProvider provider, Object contextObject) {
        this.contextFactory = new ExpressionContextFactoryImpl(contextObject, provider);
        this.contextObject = contextObject;
    }

    protected void openExpressionBuilder(IExpressionBuilder builder, String expressionType) {
        builder.setExpression(this.editor.getText());
        builder.setExpressionContext(this.contextFactory.getContext(expressionType, this.contextObject));
        if (builder.open() == 0) {
            Object result = builder.getExpression();
            String newExpression = result == null ? "" : result.toString();
            this.editor.setText(newExpression);
            this.button.setData("exprType", (Object)expressionType);
            this.markDirty();
            this.refresh();
        }
        this.editor.setFocus();
    }

    public String getExpression() {
        return this.editor.getText();
    }

    public void notifyExpressionChangeEvent(String oldExpr, String newExpr) {
        if (oldExpr != null) {
            boolean newValidState = this.isCorrect(newExpr);
            if (newValidState) {
                this.markDirty();
            } else {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), newExpr.toString()));
            }
            this.fireApplyEditorValue();
        }
    }

    private void showMenu() {
        if (this.menu != null) {
            Rectangle size = this.button.getBounds();
            this.menu.setLocation(this.button.toDisplay(new Point(0, size.height - 1)));
            int i = 0;
            while (i < this.menu.getItemCount()) {
                MenuItem item = this.menu.getItem(i);
                if (item.getData().equals(this.getExpressionType())) {
                    item.setSelection(true);
                } else {
                    item.setSelection(false);
                }
                ++i;
            }
            this.menu.setVisible(true);
        }
    }

    private class DialogCellLayout
    extends Layout {
        private DialogCellLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point size = ExpressionCellEditor.this.button.computeSize(-1, -1, force);
            if (ExpressionCellEditor.this.contents != null) {
                ExpressionCellEditor.this.contents.setBounds(0, 0, bounds.width - size.x, bounds.height);
            }
            ExpressionCellEditor.this.button.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point contentsSize = ExpressionCellEditor.this.contents.computeSize(-1, -1, force);
            Point buttonSize = ExpressionCellEditor.this.button.computeSize(-1, -1, force);
            Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
            return result;
        }
    }
}

