/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.views.data.DataSetItemModel;
import org.eclipse.birt.report.designer.data.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormPage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButton;
import org.eclipse.birt.report.designer.internal.ui.dnd.InsertInLayoutUtil;
import org.eclipse.birt.report.designer.internal.ui.expressions.ExpressionContextFactoryImpl;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionContextFactory;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionConverter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider.FilterHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider.SortingHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.elements.structures.TOC;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IPredefinedStyle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class GroupDialog
extends BaseDialog
implements Listener {
    private static final String GROUP_DLG_GROUP_FILTER_SORTING = Messages.getString((String)"GroupDialog.Label.FilterSorting");
    private static final String GROUP_DLG_GROUP_RANGE_LABEL = Messages.getString((String)"GroupDialog.Label.Range");
    private static final String GROUP_DLG_GROUP_INTERVAL_LABEL = Messages.getString((String)"GroupDialog.Label.Interval");
    private static final String GROUP_DLG_GROUP_KEY_LABEL = Messages.getString((String)"GroupDialog.Label.GroupOn");
    private static final String GROUP_DLG_GROUP_NAME_LABEL = Messages.getString((String)"GroupDialog.Label.Name");
    private static final String TAB_SORTING = Messages.getString((String)"GroupDialog.Tab.Sorting");
    private static final String TAB_FILTER = Messages.getString((String)"GroupDialog.Tab.Filter");
    private static final String GROUP_DLG_INTERVAL_BASE_LABEL = Messages.getString((String)"GroupDialog.Label.IntervalBase");
    private static final String GROUP_DLG_AREA_MSG = Messages.getString((String)"GroupDialog.Dialog.GroupDetail");
    public static final String GROUP_DLG_TITLE_NEW = Messages.getString((String)"GroupDialog.Title.New");
    public static final String GROUP_DLG_TITLE_EDIT = Messages.getString((String)"GroupDialog.Title.Edit");
    public static final String GROUP_DLG_HIDE_DETAIL = Messages.getString((String)"GroupDialog.buttion.HideDetail");
    private List columnList;
    private GroupHandle inputGroup;
    private Text nameEditor;
    private Combo keyChooser;
    private Combo intervalType;
    private Combo tocStyleType;
    private Text intervalRange;
    private Button ascending;
    private Button descending;
    private Button intervalBaseButton;
    private Text intervalBaseText;
    private Button hideDetail;
    private Text tocEditor;
    private Text bookmarkEditor;
    private static final IChoice[] intervalChoicesAll = DEUtil.getMetaDataDictionary().getChoiceSet("interval").getChoices();
    private static final String SORT_GROUP_TITLE = DEUtil.getPropertyDefn((String)"TableGroup", (String)"sortDirection").getDisplayName();
    private static final IChoice[] pagebreakBeforeChoicesAll = DEUtil.getMetaDataDictionary().getChoiceSet("pageBreakBefore").getChoices();
    private static final IChoice[] pagebreakAfterChoicesAll = DEUtil.getMetaDataDictionary().getChoiceSet("pageBreakAfter").getChoices();
    private static final IChoice[] pagebreakInsideChoicesAll = DEUtil.getMetaDataDictionary().getChoiceSet("pageBreakInside").getChoices();
    private String[] sytleChoicesAll;
    private static final IChoice[] intervalChoicesString = GroupDialog.getIntervalChoicesString();
    private static final IChoice[] intervalChoicesDate = GroupDialog.getIntervalChoicesDate();
    private static final IChoice[] intervalChoicesNumeric = GroupDialog.getIntervalChoicesNumeric();
    private static IChoice[] intervalChoices = intervalChoicesAll;
    private String previoiusKeyExpression = "";
    private Button repeatHeaderButton;
    private Combo pagebreakAfterCombo;
    private Combo pagebreakBeforeCombo;
    private Combo pagebreakInsideCombo;
    private Group sortingGroup;
    NumberFormat format = NumberFormat.getNumberInstance(SessionHandleAdapter.getInstance().getSessionHandle().getULocale().toLocale());

    public GroupDialog(Shell parentShell, String title) {
        super(parentShell, title);
        this.sytleChoicesAll = this.getAllStyleChoices();
    }

    private String[] getAllStyleChoices() {
        String[] styles = ChoiceSetFactory.getStyles();
        styles = GroupDialog.filterPreStyles(styles);
        return styles;
    }

    private static String[] filterPreStyles(String[] items) {
        List preStyles = DesignEngine.getMetaDataDictionary().getPredefinedStyles();
        ArrayList<String> preStyleNames = new ArrayList<String>();
        int i = 0;
        while (i < preStyles.size()) {
            preStyleNames.add(((IPredefinedStyle)preStyles.get(i)).getName());
            ++i;
        }
        ArrayList<String> sytleNames = new ArrayList<String>();
        int i2 = 0;
        while (i2 < items.length) {
            if (preStyleNames.indexOf(items[i2]) == -1) {
                sytleNames.add(items[i2]);
            }
            ++i2;
        }
        return sytleNames.toArray(new String[0]);
    }

    protected Control createDialogArea(Composite parent) {
        if (this.sytleChoicesAll == null) {
            this.sytleChoicesAll = this.getAllStyleChoices();
        }
        ScrolledComposite scrollContent = new ScrolledComposite((Composite)super.createDialogArea(parent), 768);
        scrollContent.setAlwaysShowScrollBars(false);
        scrollContent.setExpandHorizontal(true);
        scrollContent.setMinWidth(600);
        scrollContent.setLayout((Layout)new FillLayout());
        scrollContent.setLayoutData((Object)new GridData(1808));
        GroupDialog.applyDialogFont((Control)scrollContent);
        Composite topComposite = new Composite((Composite)scrollContent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        topComposite.setLayout((Layout)layout);
        this.createTitleArea(topComposite);
        Composite composite = new Composite(topComposite, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(2, true));
        this.createFieldArea(composite);
        this.createGroupArea(composite);
        this.createBookmarkArea(topComposite);
        this.createTOCArea(topComposite);
        this.createFilterSortingArea(topComposite);
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.GroupDialog_ID");
        Point size = topComposite.computeSize(-1, -1);
        topComposite.setSize(size.x, size.y);
        scrollContent.setContent((Control)topComposite);
        return scrollContent;
    }

    private void createBookmarkArea(Composite parent) {
        Composite bookmakrComposite = new Composite(parent, 0);
        bookmakrComposite.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(768);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        bookmakrComposite.setLayoutData((Object)gd);
        bookmakrComposite.setLayout((Layout)layout);
        new Label(bookmakrComposite, 0).setText(Messages.getString((String)"GroupDialog.Label.Bookmark"));
        this.bookmarkEditor = new Text(bookmakrComposite, 2052);
        gd = new GridData();
        gd.widthHint = 180;
        this.bookmarkEditor.setLayoutData((Object)gd);
        ExpressionButtonUtil.createExpressionButton(bookmakrComposite, (Control)this.bookmarkEditor, new ExpressionProvider((DesignElementHandle)this.inputGroup), this.inputGroup);
    }

    private void createTOCArea(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString((String)"GroupDialog.Dialog.TOCGroup"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        new Label((Composite)group, 0).setText(Messages.getString((String)"GroupDialog.Dialog.TOC"));
        Composite tocArea = new Composite((Composite)group, 0);
        tocArea.setLayoutData((Object)new GridData(768));
        tocArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        this.tocEditor = new Text(tocArea, 2052);
        GridData gd = new GridData();
        gd.widthHint = 200;
        this.tocEditor.setLayoutData((Object)gd);
        this.tocEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GroupDialog.this.tocStyleType == null) {
                    return;
                }
                if (GroupDialog.this.tocEditor.getText().trim().equals("")) {
                    GroupDialog.this.tocStyleType.setEnabled(false);
                } else {
                    GroupDialog.this.tocStyleType.setEnabled(true);
                }
            }
        });
        ExpressionButtonUtil.createExpressionButton(tocArea, (Control)this.tocEditor, new ExpressionProvider((DesignElementHandle)this.inputGroup), this.inputGroup);
        new Label((Composite)group, 0).setText(Messages.getString((String)"GroupDialog.Dialog.TOCStyle"));
        this.tocStyleType = new Combo((Composite)group, 12);
        gd = new GridData();
        gd.widthHint = 200;
        this.tocStyleType.setLayoutData((Object)gd);
        this.tocStyleType.setVisibleItemCount(30);
        this.tocStyleType.setItems(this.sytleChoicesAll);
    }

    private void createTitleArea(Composite parent) {
        int heightMargins = 3;
        int widthMargins = 8;
        final Composite titleArea = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = heightMargins;
        layout.marginWidth = widthMargins;
        titleArea.setLayout((Layout)layout);
        Display display = parent.getDisplay();
        Color background = JFaceColors.getBannerBackground((Display)display);
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 20 + heightMargins * 2;
        titleArea.setLayoutData((Object)layoutData);
        titleArea.setBackground(background);
        titleArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(titleArea.getDisplay().getSystemColor(18));
                Rectangle bounds = titleArea.getClientArea();
                bounds.height -= 2;
                --bounds.width;
                e.gc.drawRectangle(bounds);
            }
        });
        Label label = new Label(titleArea, 0);
        label.setBackground(background);
        label.setFont(FontManager.getFont((String)label.getFont().toString(), (int)10, (int)1));
        label.setText(GROUP_DLG_AREA_MSG);
    }

    private void createFieldArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        composite.setLayoutData((Object)gd);
        new Label(composite, 0).setText(GROUP_DLG_GROUP_NAME_LABEL);
        this.nameEditor = new Text(composite, 2052);
        this.nameEditor.setLayoutData((Object)new GridData(768));
        new Label(composite, 0).setText(GROUP_DLG_GROUP_KEY_LABEL);
        Composite keyArea = new Composite(composite, 0);
        keyArea.setLayoutData((Object)new GridData(768));
        keyArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        this.keyChooser = new Combo(keyArea, 4);
        this.keyChooser.setLayoutData((Object)new GridData(768));
        this.keyChooser.setVisibleItemCount(30);
        this.keyChooser.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!GroupDialog.this.keyChooser.getText().trim().equals("")) {
                    GroupDialog.this.resetInterval();
                }
            }
        });
        this.keyChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String value;
                IExpressionConverter converter;
                if (GroupDialog.this.keyChooser.getSelectionIndex() != -1 && (converter = ExpressionButtonUtil.getCurrentExpressionConverter((Control)GroupDialog.this.keyChooser)) != null && (value = ExpressionUtility.getExpression(GroupDialog.this.columnList.get(GroupDialog.this.keyChooser.getSelectionIndex()), converter)) != null) {
                    GroupDialog.this.tocEditor.setText(value);
                    GroupDialog.this.tocEditor.setData("exprType", (Object)ExpressionButtonUtil.getExpression((Control)GroupDialog.this.keyChooser).getType());
                    ExpressionButton button = ExpressionButtonUtil.getExpressionButton((Control)GroupDialog.this.tocEditor);
                    if (button != null) {
                        button.refresh();
                    }
                }
            }
        });
        this.keyChooser.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String key = UIUtil.convertToModelString(GroupDialog.this.keyChooser.getText(), true);
                if (key != null) {
                    String tocExp = null;
                    IExpressionConverter converter = ExpressionButtonUtil.getCurrentExpressionConverter((Control)GroupDialog.this.keyChooser, false);
                    if (converter != null) {
                        if (GroupDialog.this.keyChooser.indexOf(key) != -1) {
                            tocExp = ExpressionUtility.getExpression(GroupDialog.this.columnList.get(GroupDialog.this.keyChooser.indexOf(key)), converter);
                        } else {
                            int i = 0;
                            while (i < GroupDialog.this.columnList.size()) {
                                if (key.equals(ExpressionUtility.getExpression(GroupDialog.this.columnList.get(i), converter))) {
                                    tocExp = key;
                                    break;
                                }
                                ++i;
                            }
                        }
                    }
                    if (!GroupDialog.this.tocEditor.getText().equals(tocExp)) {
                        if (tocExp == null) {
                            GroupDialog.this.tocEditor.setText("");
                        } else {
                            GroupDialog.this.tocEditor.setText(tocExp);
                        }
                    }
                    GroupDialog.this.tocEditor.setData("exprType", (Object)ExpressionButtonUtil.getExpression((Control)GroupDialog.this.keyChooser).getType());
                    ExpressionButton button = ExpressionButtonUtil.getExpressionButton((Control)GroupDialog.this.tocEditor);
                    if (button != null) {
                        button.refresh();
                    }
                }
            }
        });
        ExpressionButtonUtil.ExpressionHelper helper = new ExpressionButtonUtil.ExpressionHelper(){

            public String getExpression() {
                return GroupDialog.this.getKeyExpression(GroupDialog.this.keyChooser, GroupDialog.this.keyChooser.getText());
            }

            public void setExpression(String expression) {
                GroupDialog.this.setKeyExpression(GroupDialog.this.keyChooser, expression);
            }

            public IExpressionProvider getExpressionProvider() {
                return new ExpressionProvider((DesignElementHandle)GroupDialog.this.inputGroup);
            }

            public IExpressionContextFactory getExpressionContextFactory() {
                return new ExpressionContextFactoryImpl(this.getContextObject(), this.getExpressionProvider());
            }
        };
        ExpressionButtonUtil.createExpressionButton(keyArea, (Control)this.keyChooser, null, this.inputGroup, null, false, 8, helper);
        Composite intervalArea = new Composite(composite, 0);
        intervalArea.setLayoutData((Object)new GridData(768));
        intervalArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        Composite intervalTypeArea = new Composite(intervalArea, 0);
        intervalTypeArea.setLayoutData((Object)new GridData(768));
        intervalTypeArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(1, false));
        Composite intervalRangeArea = new Composite(intervalArea, 0);
        intervalRangeArea.setLayoutData((Object)new GridData(256));
        intervalRangeArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(1, false));
        new Label(intervalTypeArea, 0).setText(GROUP_DLG_GROUP_INTERVAL_LABEL);
        new Label(intervalRangeArea, 0).setText(GROUP_DLG_GROUP_RANGE_LABEL);
        this.intervalType = new Combo(intervalTypeArea, 12);
        this.intervalType.setLayoutData((Object)new GridData(768));
        this.intervalType.setVisibleItemCount(30);
        int i = 0;
        while (i < intervalChoices.length) {
            this.intervalType.add(intervalChoices[i].getDisplayName());
            ++i;
        }
        this.intervalType.setData((Object)intervalChoices);
        this.intervalType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupDialog.this.intervalRange.setEnabled(GroupDialog.this.intervalType.getSelectionIndex() != 0);
                GroupDialog.this.intervalBaseButton.setEnabled(GroupDialog.this.intervalType.getSelectionIndex() != 0 && GroupDialog.this.getColumnType() != String.class);
                GroupDialog.this.intervalBaseText.setEnabled(GroupDialog.this.intervalBaseButton.getEnabled() && GroupDialog.this.intervalBaseButton.getSelection());
            }
        });
        this.intervalRange = new Text(intervalRangeArea, 2052);
        this.intervalRange.setLayoutData((Object)new GridData(256));
        this.intervalRange.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                if (event.text.length() <= 0) {
                    return;
                }
                int beginIndex = Math.min(event.start, event.end);
                int endIndex = Math.max(event.start, event.end);
                String inputtedText = GroupDialog.this.intervalRange.getText();
                String newString = inputtedText.substring(0, beginIndex);
                newString = String.valueOf(newString) + event.text;
                newString = String.valueOf(newString) + inputtedText.substring(endIndex);
                event.doit = false;
                try {
                    double value = GroupDialog.this.format.parse(newString).doubleValue();
                    if (value >= 0.0) {
                        event.doit = true;
                    }
                }
                catch (Exception exception) {
                    event.doit = false;
                    return;
                }
            }
        });
        this.intervalBaseButton = new Button(composite, 32);
        this.intervalBaseButton.setText(GROUP_DLG_INTERVAL_BASE_LABEL);
        this.intervalBaseButton.setLayoutData((Object)new GridData(768));
        this.intervalBaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupDialog.this.intervalBaseText.setEnabled(GroupDialog.this.intervalBaseButton.getSelection());
            }
        });
        this.intervalBaseText = new Text(composite, 2052);
        this.intervalBaseText.setLayoutData((Object)new GridData(768));
        this.hideDetail = new Button(composite, 32);
        this.hideDetail.setLayoutData((Object)new GridData(768));
        this.hideDetail.setText(GROUP_DLG_HIDE_DETAIL);
    }

    private void createGroupArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData(770);
        layoutData.verticalSpan = 2;
        composite.setLayoutData((Object)layoutData);
        composite.setLayout((Layout)new GridLayout());
        this.sortingGroup = new Group(composite, 0);
        this.sortingGroup.setText(SORT_GROUP_TITLE);
        this.sortingGroup.setLayoutData((Object)new GridData(768));
        this.sortingGroup.setLayout((Layout)new FillLayout(512));
        Composite sortingGroupComposite = new Composite((Composite)this.sortingGroup, 0);
        sortingGroupComposite.setLayout((Layout)new GridLayout());
        this.ascending = new Button(sortingGroupComposite, 16);
        this.ascending.setText(Messages.getString((String)"GroupDialog.Button.Ascending"));
        this.descending = new Button(sortingGroupComposite, 16);
        this.descending.setText(Messages.getString((String)"GroupDialog.Button.Descending"));
        Group pagebreakGroup = new Group(composite, 0);
        pagebreakGroup.setText(Messages.getString((String)"GroupDialog.PageBreak"));
        pagebreakGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        pagebreakGroup.setLayout((Layout)layout);
        new Label((Composite)pagebreakGroup, 0).setText(Messages.getString((String)"GroupDialog.PageBreakBefore"));
        this.pagebreakBeforeCombo = new Combo((Composite)pagebreakGroup, 12);
        int i = 0;
        while (i < pagebreakBeforeChoicesAll.length) {
            this.pagebreakBeforeCombo.add(pagebreakBeforeChoicesAll[i].getDisplayName());
            ++i;
        }
        this.pagebreakBeforeCombo.setLayoutData((Object)new GridData(768));
        this.pagebreakBeforeCombo.setVisibleItemCount(30);
        WidgetUtil.createGridPlaceholder((Composite)pagebreakGroup, 1, true);
        this.pagebreakBeforeCombo.setData((Object)pagebreakBeforeChoicesAll);
        new Label((Composite)pagebreakGroup, 0).setText(Messages.getString((String)"GroupDialog.PageBreakAfter"));
        this.pagebreakAfterCombo = new Combo((Composite)pagebreakGroup, 12);
        i = 0;
        while (i < pagebreakAfterChoicesAll.length) {
            this.pagebreakAfterCombo.add(pagebreakAfterChoicesAll[i].getDisplayName());
            ++i;
        }
        this.pagebreakAfterCombo.setVisibleItemCount(30);
        this.pagebreakAfterCombo.setData((Object)pagebreakAfterChoicesAll);
        this.pagebreakAfterCombo.setLayoutData((Object)new GridData(768));
        WidgetUtil.createGridPlaceholder((Composite)pagebreakGroup, 1, true);
        new Label((Composite)pagebreakGroup, 0).setText(Messages.getString((String)"GroupDialog.PageBreakInside"));
        this.pagebreakInsideCombo = new Combo((Composite)pagebreakGroup, 12);
        i = 0;
        while (i < pagebreakInsideChoicesAll.length) {
            this.pagebreakInsideCombo.add(pagebreakInsideChoicesAll[i].getDisplayName());
            ++i;
        }
        this.pagebreakInsideCombo.setVisibleItemCount(30);
        this.pagebreakInsideCombo.setData((Object)pagebreakInsideChoicesAll);
        this.pagebreakInsideCombo.setLayoutData((Object)new GridData(768));
        WidgetUtil.createGridPlaceholder((Composite)pagebreakGroup, 1, true);
        this.repeatHeaderButton = new Button((Composite)pagebreakGroup, 32);
        this.repeatHeaderButton.setText(Messages.getString((String)"GroupDialog.RepeatHeader"));
        GridData data = new GridData();
        data.horizontalSpan = 3;
        this.repeatHeaderButton.setLayoutData((Object)data);
        PropertyHandle propertyHandle = this.inputGroup.getPropertyHandle("sort");
        if (propertyHandle.iterator().hasNext()) {
            this.ascending.setEnabled(false);
            this.descending.setEnabled(false);
        }
    }

    private void createFilterSortingArea(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(GROUP_DLG_GROUP_FILTER_SORTING);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).minSize(500, 250).create());
        ArrayList<GroupHandle> list = new ArrayList<GroupHandle>(1);
        list.add(this.inputGroup);
        TabFolder tab = new TabFolder((Composite)group, 128);
        tab.setLayoutData((Object)new GridData(1808));
        TabItem filterItem = new TabItem(tab, 0);
        FormPage filterPage = new FormPage((Composite)tab, 4, new FilterHandleProvider(){

            public int[] getColumnWidths() {
                return new int[]{200, 100, 100, 100};
            }
        }, true);
        filterPage.setInput(list);
        filterItem.setText(TAB_FILTER);
        filterItem.setControl((Control)filterPage);
        this.checkReadOnlyControl("filter", (Control)filterPage);
        TabItem sortItem = new TabItem(tab, 0);
        FormPage sortPage = new FormPage((Composite)tab, 4, new SortingHandleProvider(){

            public int[] getColumnWidths() {
                return new int[]{200, 100, 100, 100};
            }
        }, true);
        sortPage.setInput(list);
        sortItem.setText(TAB_SORTING);
        sortItem.setControl((Control)sortPage);
        this.checkReadOnlyControl("sort", (Control)sortPage);
    }

    private boolean checkReadOnlyControl(String property, Control control) {
        PropertyHandle handle = this.inputGroup.getPropertyHandle(property);
        if (handle != null && handle.isReadOnly()) {
            if (control instanceof Text) {
                ((Text)control).setEditable(false);
            } else if (control instanceof Combo) {
                ((Combo)control).setEnabled(false);
            } else if (control instanceof Button) {
                ((Button)control).setEnabled(false);
            } else if (control instanceof Composite) {
                this.disableControl((Composite)control);
            }
            return handle.isReadOnly();
        }
        return false;
    }

    private void disableControl(Composite container) {
        Control[] children = container.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Composite) {
                this.disableControl((Composite)children[i]);
            } else if (!(children[i] instanceof Label)) {
                children[i].setEnabled(false);
            }
            ++i;
        }
        container.setEnabled(false);
    }

    protected boolean initDialog() {
        if (this.inputGroup.getName() != null) {
            this.nameEditor.setText(this.inputGroup.getName());
            this.checkReadOnlyControl("groupName", (Control)this.nameEditor);
        }
        ExpressionButtonUtil.initExpressionButtonControl((Control)this.bookmarkEditor, this.inputGroup, "bookmark");
        this.checkReadOnlyControl("bookmark", (Control)this.bookmarkEditor);
        this.refreshColumnList();
        this.setKeyExpression(this.inputGroup.getExpressionProperty("keyExpr"));
        if (this.checkReadOnlyControl("keyExpr", (Control)this.keyChooser)) {
            ((ExpressionButton)this.keyChooser.getData("exprButton")).setEnabled(false);
        } else {
            ((ExpressionButton)this.keyChooser.getData("exprButton")).setEnabled(true);
        }
        PropertyHandle property = this.inputGroup.getPropertyHandle("intervalRange");
        String range = property == null ? null : property.getDisplayValue();
        this.intervalRange.setText(range == null ? "" : range);
        this.checkReadOnlyControl("intervalRange", (Control)this.intervalRange);
        int index = this.getIntervalTypeIndex(this.inputGroup.getInterval());
        this.intervalType.select(index);
        this.checkReadOnlyControl("interval", (Control)this.intervalType);
        if (index == 0) {
            this.intervalRange.setEnabled(false);
            this.intervalBaseButton.setEnabled(false);
            this.intervalBaseText.setEnabled(false);
        } else {
            this.intervalRange.setEnabled(true);
            if (this.getColumnType() == String.class) {
                this.intervalBaseButton.setEnabled(false);
                this.intervalBaseText.setEnabled(false);
            } else {
                this.intervalBaseButton.setEnabled(true);
                this.intervalBaseButton.setSelection(this.inputGroup.getIntervalBase() != null);
                this.intervalBaseText.setEnabled(this.intervalBaseButton.getSelection());
                if (this.inputGroup.getIntervalBase() != null) {
                    this.intervalBaseText.setText(this.inputGroup.getIntervalBase());
                }
            }
        }
        this.checkReadOnlyControl("intervalBase", (Control)this.intervalBaseButton);
        this.checkReadOnlyControl("intervalBase", (Control)this.intervalBaseText);
        if ("asc".equals(this.inputGroup.getSortDirection())) {
            this.ascending.setSelection(true);
        } else {
            this.descending.setSelection(true);
        }
        this.checkReadOnlyControl("sortDirection", (Control)this.ascending);
        this.checkReadOnlyControl("sortDirection", (Control)this.descending);
        ArrayList<GroupHandle> list = new ArrayList<GroupHandle>(1);
        list.add(this.inputGroup);
        ExpressionButtonUtil.initExpressionButtonControl((Control)this.tocEditor, this.inputGroup.getTOC(), "expressionValue");
        if (this.inputGroup.getTOC() != null) {
            index = this.getTocStyleIndex(this.inputGroup.getTOC().getStyleName());
            if (index >= 0 && index < this.tocStyleType.getItemCount()) {
                this.tocStyleType.select(index);
            } else if (this.inputGroup.getTOC().getStyleName() != null) {
                this.tocStyleType.setText(this.inputGroup.getTOC().getStyleName());
            }
            if (this.tocStyleType.getText() == null || this.tocStyleType.getText().trim().length() == 0) {
                this.tocStyleType.setEnabled(false);
            }
        }
        if (this.checkReadOnlyControl("toc", (Control)this.tocEditor)) {
            ((ExpressionButton)this.tocEditor.getData("exprButton")).setEnabled(false);
            this.tocStyleType.setEnabled(false);
        } else {
            ((ExpressionButton)this.tocEditor.getData("exprButton")).setEnabled(true);
        }
        index = this.getPagebreakBeforeIndex(this.inputGroup.getPageBreakBefore());
        if (index < 0 || index >= this.pagebreakBeforeCombo.getItemCount()) {
            this.pagebreakBeforeCombo.setText(this.inputGroup.getPageBreakBefore());
        } else {
            this.pagebreakBeforeCombo.select(index);
        }
        this.checkReadOnlyControl("pageBreakBefore", (Control)this.pagebreakBeforeCombo);
        index = this.getPagebreakAfterIndex(this.inputGroup.getPageBreakAfter());
        if (index < 0 || index >= this.pagebreakAfterCombo.getItemCount()) {
            this.pagebreakAfterCombo.setText(this.inputGroup.getPageBreakAfter());
        } else {
            this.pagebreakAfterCombo.select(index);
        }
        this.checkReadOnlyControl("pageBreakAfter", (Control)this.pagebreakAfterCombo);
        String pagebreakInside = this.getPageBreakInsideLocalValue();
        index = pagebreakInside == null ? this.getPagebreakInsideIndex("avoid") : this.getPagebreakInsideIndex(this.inputGroup.getPageBreakInside());
        if (index < 0 || index >= this.pagebreakInsideCombo.getItemCount()) {
            this.pagebreakInsideCombo.setText(this.inputGroup.getPageBreakInside());
        } else {
            this.pagebreakInsideCombo.select(index);
        }
        this.checkReadOnlyControl("pageBreakAfter", (Control)this.pagebreakInsideCombo);
        if (this.inputGroup.repeatHeader()) {
            this.repeatHeaderButton.setSelection(true);
        }
        this.checkReadOnlyControl("repeatHeader", (Control)this.repeatHeaderButton);
        this.hideDetail.setSelection(this.inputGroup.hideDetail());
        this.checkReadOnlyControl("hideDetail", (Control)this.hideDetail);
        return true;
    }

    private String getPageBreakInsideLocalValue() {
        ArrayList<GroupHandle> modelList = new ArrayList<GroupHandle>();
        modelList.add(this.inputGroup);
        String pagebreakInside = DEUtil.getGroupElementHandle(modelList).getLocalStringProperty("pageBreakInside");
        return pagebreakInside;
    }

    private void refreshColumnList() {
        String selected = this.keyChooser.getText();
        this.keyChooser.removeAll();
        this.columnList = DEUtil.getVisiableColumnBindingsList((DesignElementHandle)this.inputGroup);
        this.columnList = DataUtil.getValidGroupKeyBindings(this.columnList);
        Iterator itor = this.columnList.iterator();
        while (itor.hasNext()) {
            this.keyChooser.add(((ComputedColumnHandle)itor.next()).getName());
        }
        int newIndex = this.keyChooser.indexOf(selected);
        if (newIndex != -1) {
            this.keyChooser.select(newIndex);
        } else {
            this.keyChooser.setText(selected);
        }
    }

    private int getPagebreakAfterIndex(String pageBreakAfter) {
        int index = 0;
        int i = 0;
        while (i < pagebreakAfterChoicesAll.length) {
            if (pagebreakAfterChoicesAll[i].getName().equals(pageBreakAfter)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    private int getPagebreakInsideIndex(String pageBreakInside) {
        int index = 0;
        int i = 0;
        while (i < pagebreakInsideChoicesAll.length) {
            if (pagebreakInsideChoicesAll[i].getName().equals(pageBreakInside)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    private int getPagebreakBeforeIndex(String pageBreakBefore) {
        int index = 0;
        int i = 0;
        while (i < pagebreakBeforeChoicesAll.length) {
            if (pagebreakBeforeChoicesAll[i].getName().equals(pageBreakBefore)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    private int getTocStyleIndex(String style) {
        int index = -1;
        if (style == null || style.trim().length() == 0) {
            return 0;
        }
        int i = 0;
        while (i < this.sytleChoicesAll.length) {
            if (this.sytleChoicesAll[i].equals(style)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public void setInput(Object input) {
        assert (input instanceof GroupHandle);
        if (this.inputGroup != null) {
            this.inputGroup.removeListener((Listener)this);
        }
        this.inputGroup = (GroupHandle)input;
        this.inputGroup.addListener((Listener)this);
    }

    protected void okPressed() {
        try {
            String choice;
            block42: {
                int index;
                this.inputGroup.setName(this.nameEditor.getText());
                String bookmark = this.bookmarkEditor.getText();
                if (bookmark != null && !bookmark.equals("")) {
                    ExpressionButtonUtil.saveExpressionButtonControl((Control)this.bookmarkEditor, this.inputGroup, "bookmark");
                } else {
                    this.inputGroup.setBookmark(null);
                }
                String tocText = this.tocEditor.getText();
                if (tocText != null && !tocText.equals("")) {
                    if (this.inputGroup.getTOC() != null) {
                        ExpressionButtonUtil.saveExpressionButtonControl((Control)this.tocEditor, this.inputGroup.getTOC(), "expressionValue");
                    } else {
                        TOC toc = StructureFactory.createTOC();
                        ExpressionButtonUtil.saveExpressionButtonControl((Control)this.tocEditor, toc, "expressionValue");
                        this.inputGroup.addTOC(toc);
                    }
                } else {
                    this.inputGroup.setTocExpression(null);
                }
                if (this.inputGroup.getTOC() != null) {
                    int index2 = this.tocStyleType.getSelectionIndex();
                    if (index2 == 0) {
                        this.inputGroup.getTOC().setStyleName(null);
                    } else {
                        this.inputGroup.getTOC().setStyleName(this.tocStyleType.getText());
                    }
                }
                if ((index = this.keyChooser.getSelectionIndex()) == -1 && UIUtil.convertToModelString(this.keyChooser.getText(), true) != null) {
                    String groupKey = UIUtil.convertToModelString(this.keyChooser.getText(), true);
                    if (this.keyChooser.indexOf(groupKey) != -1) {
                        index = this.keyChooser.indexOf(groupKey);
                    } else {
                        int i = 0;
                        while (i < this.columnList.size()) {
                            if (groupKey.equals(DEUtil.getExpression(this.columnList.get(i)))) {
                                index = i;
                                break;
                            }
                            ++i;
                        }
                    }
                }
                Expression oldKeyExpr = (Expression)this.inputGroup.getExpressionProperty("keyExpr").getValue();
                Expression newKeyExpr = new Expression((Object)this.getKeyExpression(this.keyChooser, this.keyChooser.getText()), (String)this.keyChooser.getData("exprType"));
                this.inputGroup.setExpressionProperty("keyExpr", newKeyExpr);
                if (newKeyExpr.getStringExpression() != null && newKeyExpr.getStringExpression().trim().length() != 0 && !newKeyExpr.equals((Object)oldKeyExpr) && index != -1) {
                    SlotHandle slotHandle = null;
                    if (this.inputGroup instanceof ListGroupHandle) {
                        slotHandle = this.inputGroup.getHeader();
                    } else if (this.inputGroup instanceof TableGroupHandle && this.inputGroup.getHeader().getCount() != 0) {
                        RowHandle rowHandle = (RowHandle)this.inputGroup.getHeader().get(0);
                        CellHandle cellHandle = (CellHandle)rowHandle.getCells().get(0);
                        slotHandle = cellHandle.getContent();
                    }
                    if (slotHandle != null && slotHandle.getContents().size() == 0) {
                        DataItemHandle dataItemHandle = this.inputGroup.getElementFactory().newDataItem(null);
                        ComputedColumnHandle columnHandle = (ComputedColumnHandle)this.columnList.get(index);
                        dataItemHandle.setResultSetColumn(columnHandle.getName());
                        ColumnHintHandle hintHandle = GroupDialog.findColumnHintHandle(columnHandle);
                        StyleHandle styleHandle = dataItemHandle.getPrivateStyle();
                        if (hintHandle != null) {
                            InsertInLayoutUtil.formatDataHandleDataType(columnHandle.getDataType(), hintHandle.getValueFormat(), styleHandle);
                        }
                        slotHandle.add((DesignElementHandle)dataItemHandle);
                    }
                }
                if (!intervalChoices[index = this.intervalType.getSelectionIndex()].getName().equals(this.inputGroup.getInterval())) {
                    this.inputGroup.setInterval(intervalChoices[index].getName());
                }
                if (index != 0) {
                    try {
                        if (this.intervalRange.getText().trim().length() > 0) {
                            this.inputGroup.setIntervalRange(this.format.parse(this.intervalRange.getText()).doubleValue());
                            break block42;
                        }
                        this.inputGroup.setIntervalRange(null);
                    }
                    catch (ParseException e) {
                        ExceptionHandler.handle(e);
                    }
                } else {
                    this.inputGroup.setProperty("intervalRange", null);
                }
            }
            if (this.intervalBaseText.getEnabled()) {
                this.inputGroup.setIntervalBase(UIUtil.convertToModelString(this.intervalBaseText.getText(), false));
            } else {
                this.inputGroup.setIntervalBase(null);
            }
            if (this.inputGroup.hideDetail() != this.hideDetail.getSelection()) {
                this.inputGroup.setHideDetail(this.hideDetail.getSelection());
            }
            if (this.ascending.getSelection()) {
                if (!"asc".equals(this.inputGroup.getSortDirection())) {
                    this.inputGroup.setSortDirection("asc");
                }
            } else if (!"desc".equals(this.inputGroup.getSortDirection())) {
                this.inputGroup.setSortDirection("desc");
            }
            if (!(choice = pagebreakBeforeChoicesAll[this.pagebreakBeforeCombo.getSelectionIndex()].getName()).equals(this.inputGroup.getPageBreakBefore())) {
                this.inputGroup.setPageBreakBefore(choice);
            }
            if (!(choice = pagebreakAfterChoicesAll[this.pagebreakAfterCombo.getSelectionIndex()].getName()).equals(this.inputGroup.getPageBreakAfter())) {
                this.inputGroup.setPageBreakAfter(choice);
            }
            choice = pagebreakInsideChoicesAll[this.pagebreakInsideCombo.getSelectionIndex()].getName();
            if (this.getPageBreakInsideLocalValue() != null) {
                if (!choice.equals(this.inputGroup.getPageBreakInside())) {
                    this.inputGroup.setPageBreakInside(choice);
                }
            } else if (!choice.equals("avoid")) {
                this.inputGroup.setPageBreakInside(choice);
            }
            if (this.inputGroup.repeatHeader() != this.repeatHeaderButton.getSelection()) {
                this.inputGroup.setRepeatHeader(this.repeatHeaderButton.getSelection());
            }
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            return;
        }
        this.setResult(this.inputGroup);
        super.okPressed();
    }

    private static ColumnHintHandle findColumnHintHandle(ComputedColumnHandle column) {
        if (!(column.getElementHandle() instanceof ReportItemHandle)) {
            return null;
        }
        DataSetHandle dataset = ((ReportItemHandle)column.getElementHandle()).getDataSet();
        if (dataset == null) {
            return null;
        }
        for (ColumnHintHandle element : dataset.getPropertyHandle("columnHints")) {
            if (!element.getColumnName().equals(column.getColumnName()) && !column.getColumnName().equals(element.getAlias())) continue;
            return element;
        }
        return null;
    }

    private int getIntervalTypeIndex(String interval) {
        int index = 0;
        int i = 0;
        while (i < intervalChoices.length) {
            if (intervalChoices[i].getName().equals(interval)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    private void setKeyExpression(ExpressionHandle key) {
        this.keyChooser.setData("exprType", (Object)(key == null || key.getType() == null ? UIUtil.getDefaultScriptType() : key.getType()));
        Object button = this.keyChooser.getData("exprButton");
        if (button instanceof ExpressionButton) {
            ((ExpressionButton)button).refresh();
        }
        if (key == null) {
            this.keyChooser.setText("");
            return;
        }
        this.keyChooser.deselectAll();
        String keyValue = StringUtil.trimString((String)key.getStringExpression());
        if (StringUtil.isBlank((String)keyValue)) {
            this.keyChooser.setText("");
            return;
        }
        int i = 0;
        while (i < this.columnList.size()) {
            if (keyValue.equals(ExpressionUtility.getExpression(this.columnList.get(i), ExpressionButtonUtil.getCurrentExpressionConverter((Control)this.keyChooser, false)))) {
                this.keyChooser.select(i);
                return;
            }
            ++i;
        }
        this.keyChooser.setText(keyValue);
    }

    private void resetInterval() {
        String currentKeyExpression = this.keyChooser.getText();
        if (this.previoiusKeyExpression.equals(currentKeyExpression)) {
            return;
        }
        intervalChoices = ExpressionUtility.isColumnExpression(currentKeyExpression) ? this.getSubIntervalChoice() : intervalChoicesAll;
        this.resetIntervalType(intervalChoices);
        this.previoiusKeyExpression = currentKeyExpression;
    }

    private IChoice[] getSubIntervalChoice() {
        Class columnType = this.getColumnType();
        if (columnType == null) {
            return intervalChoicesAll;
        }
        if (String.class.isAssignableFrom(columnType)) {
            return intervalChoicesString;
        }
        if (Date.class.isAssignableFrom(columnType)) {
            return intervalChoicesDate;
        }
        if (Number.class.isAssignableFrom(columnType)) {
            return intervalChoicesNumeric;
        }
        return intervalChoicesAll;
    }

    private static IChoice[] getIntervalChoicesString() {
        String[] str = new String[]{"none", "prefix"};
        return GroupDialog.getIntervalChoiceArray(str);
    }

    private static IChoice[] getIntervalChoicesDate() {
        String[] str = new String[]{"none", "year", "quarter", "month", "week", "day", "hour", "minute", "second"};
        return GroupDialog.getIntervalChoiceArray(str);
    }

    private static IChoice[] getIntervalChoicesNumeric() {
        String[] str = new String[]{"none", "interval"};
        return GroupDialog.getIntervalChoiceArray(str);
    }

    private static IChoice[] getIntervalChoiceArray(String[] str) {
        ArrayList<IChoice> choiceList = new ArrayList<IChoice>();
        int i = 0;
        while (i < intervalChoicesAll.length) {
            int j = 0;
            while (j < str.length) {
                if (intervalChoicesAll[i].getName().equals(str[j])) {
                    choiceList.add(intervalChoicesAll[i]);
                    break;
                }
                ++j;
            }
            ++i;
        }
        IChoice[] choice = new IChoice[choiceList.size()];
        return choiceList.toArray(choice);
    }

    private Class getColumnType() {
        int i = 0;
        while (i < this.columnList.size()) {
            Object dataSetItemModel = this.columnList.get(i);
            if (dataSetItemModel instanceof DataSetItemModel && ((DataSetItemModel)dataSetItemModel).getDataSetColumnName().equals(this.keyChooser.getText())) {
                return DataType.getClass((int)((DataSetItemModel)dataSetItemModel).getDataType());
            }
            ++i;
        }
        return null;
    }

    private void resetIntervalType(IChoice[] choice) {
        this.intervalType.removeAll();
        int i = 0;
        while (i < choice.length) {
            this.intervalType.add(choice[i].getDisplayName());
            ++i;
        }
        this.intervalType.setData((Object)choice);
        this.intervalType.select(0);
        this.intervalType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupDialog.this.intervalRange.setEnabled(GroupDialog.this.intervalType.getSelectionIndex() != 0);
                GroupDialog.this.intervalBaseButton.setEnabled(GroupDialog.this.intervalType.getSelectionIndex() != 0 && GroupDialog.this.getColumnType() != String.class);
                GroupDialog.this.intervalBaseText.setEnabled(GroupDialog.this.intervalBaseButton.getEnabled() && GroupDialog.this.intervalBaseButton.getSelection());
            }
        });
        this.enableIntervalRangeAndBase(false);
    }

    private void enableIntervalRangeAndBase(boolean bool) {
        this.intervalRange.setEnabled(bool);
        this.intervalBaseButton.setEnabled(bool);
        this.intervalBaseText.setEnabled(bool);
    }

    private String getKeyExpression(Combo chooser, String key) {
        for (ComputedColumnHandle cachedColumn : this.columnList) {
            if (!cachedColumn.getName().equals(key)) continue;
            IExpressionConverter converter = ExpressionButtonUtil.getCurrentExpressionConverter((Control)chooser);
            return ExpressionUtility.getExpression(cachedColumn, converter);
        }
        return key;
    }

    private void setKeyExpression(Combo chooser, String key) {
        chooser.deselectAll();
        key = StringUtil.trimString((String)key);
        if (StringUtil.isBlank((String)key)) {
            chooser.setText("");
            return;
        }
        IExpressionConverter converter = ExpressionButtonUtil.getCurrentExpressionConverter((Control)chooser);
        int i = 0;
        while (i < this.columnList.size()) {
            if (key.equals(ExpressionUtility.getExpression(this.columnList.get(i), converter))) {
                chooser.setText(((ComputedColumnHandle)this.columnList.get(i)).getName());
                return;
            }
            ++i;
        }
        chooser.setText(key);
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        PropertyHandle propertyHandle = this.inputGroup.getPropertyHandle("sort");
        if (propertyHandle.iterator().hasNext()) {
            this.ascending.setEnabled(false);
            this.descending.setEnabled(false);
        } else {
            this.ascending.setEnabled(true);
            this.descending.setEnabled(true);
        }
    }

    public boolean close() {
        this.inputGroup.removeListener((Listener)this);
        return super.close();
    }
}

