/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.DataEngineThreadLocal;
import org.eclipse.birt.data.engine.api.IDataScriptEngine;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.PropertySecurity;
import org.mozilla.javascript.Scriptable;

public class DataEngineContext {
    public static final int MODE_GENERATION = 1;
    public static final int MODE_PRESENTATION = 2;
    public static final int DIRECT_PRESENTATION = 3;
    public static final int MODE_UPDATE = 4;
    public static final int CACHE_USE_DEFAULT = 1;
    public static final int CACHE_USE_DISABLE = 2;
    public static final int CACHE_USE_ALWAYS = 3;
    public static final int CACHE_MODE_IN_MEMORY = 1;
    public static final int CACHE_MODE_IN_DISK = 2;
    private int mode;
    private int generationOption;
    private Scriptable scope;
    private IDocArchiveReader reader;
    private IDocArchiveWriter writer;
    private ULocale currentLocale;
    private int cacheOption;
    private int cacheCount;
    private String tmpDir = PropertySecurity.getSystemProperty("java.io.tmpdir");
    private ClassLoader classLoader;
    public static final int VERSION_INFO_STREAM = 11;
    public static final int DATASET_DATA_STREAM = 21;
    public static final int DATASET_META_STREAM = 22;
    public static final int DATASET_DATA_LEN_STREAM = 23;
    public static final int EXPR_VALUE_STREAM = 31;
    public static final int EXPR_META_STREAM = 32;
    public static final int EXPR_ROWLEN_STREAM = 33;
    public static final int GROUP_INFO_STREAM = 41;
    public static final int SUBQUERY_INFO_STREAM = 42;
    public static final int QUERY_DEFN_STREAM = 43;
    public static final int ORIGINAL_QUERY_DEFN_STREAM = 44;
    public static final int ROW_INDEX_STREAM = 51;
    public static final int QUERYID_INFO_STREAM = 61;
    public static final int SUBQUERY_PARENTINDEX_STREAM = 71;
    public static final int META_STREAM = 99;
    public static final int META_INDEX_STREAM = 100;
    public static final int NAMING_RELATION_STREAM = 101;
    public static final int PLS_GROUPLEVEL_STREAM = 102;
    public static final int AGGR_INDEX_STREAM = 103;
    public static final int AGGR_VALUE_STREAM = 104;
    public static final int COMBINED_AGGR_INDEX_STREAM = 105;
    public static final int COMBINED_AGGR_VALUE_STREAM = 106;
    public static final int META_SECURITY_STREAM = 109;
    @Deprecated
    public static final int ROW_SECURITY_STREAM = 110;
    public static final int ACL_COLLECTION_STREAM = 111;
    public static final int CUBE_META_SECURITY_STREAM = 112;
    public static final int DIMENSION_META_SECURITY_STREAM = 114;
    @Deprecated
    public static final int ROW_SECURITY_STREAM_INDEX = 115;
    public static final String QUERY_STARTING_ID = "/dataEngine/queryStartingID";
    public static final int PROGRESSIVE_VIEWING_GROUP_STREAM = 120;
    private static Logger logger = Logger.getLogger(DataEngineContext.class.getName());
    private ScriptContext scriptContext;
    private TimeZone currentTimeZone;

    public static DataEngineContext newInstance(int mode, Scriptable scope, IDocArchiveReader reader, IDocArchiveWriter writer, ClassLoader classLoader) throws BirtException {
        return new DataEngineContext(mode, scope, reader, writer, classLoader, null);
    }

    public static DataEngineContext newInstance(int mode, Scriptable scope, IDocArchiveReader reader, IDocArchiveWriter writer) throws BirtException {
        ScriptContext context = new ScriptContext().newContext((Object)scope);
        DataEngineContext result = DataEngineContext.newInstance(mode, context, reader, writer, null);
        return result;
    }

    public static DataEngineContext newInstance(int mode, ScriptContext context, IDocArchiveReader reader, IDocArchiveWriter writer, ClassLoader classLoader) throws BirtException {
        IDataScriptEngine dse = (IDataScriptEngine)context.getScriptEngine("javascript");
        DataEngineContext result = new DataEngineContext(mode, dse.getJSScope(context), reader, writer, classLoader, context);
        return result;
    }

    private DataEngineContext(int mode, Scriptable scope, IDocArchiveReader reader, IDocArchiveWriter writer, ClassLoader classLoader, ScriptContext context) throws BirtException {
        Object[] params = new Object[]{mode, scope, reader, writer, classLoader};
        logger.entering(DataEngineContext.class.getName(), "DataEngineContext", params);
        if (mode != 1 && mode != 2 && mode != 3 && mode != 4) {
            throw new DataException("data.engine.InvalidMode");
        }
        if (writer == null && mode == 1) {
            throw new DataException("data.engine.InvalidArchive");
        }
        if (reader == null && mode == 2) {
            throw new DataException("data.engine.InvalidArchive");
        }
        if (reader == null && mode == 4) {
            throw new DataException("data.engine.InvalidArchive");
        }
        this.classLoader = classLoader;
        this.mode = mode;
        this.scope = scope;
        this.reader = reader;
        this.writer = writer;
        this.cacheOption = 1;
        this.scriptContext = context;
        this.currentLocale = ULocale.getDefault();
        this.currentTimeZone = TimeZone.getDefault();
        logger.exiting(DataEngineContext.class.getName(), "DataEngineContext");
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public Scriptable getJavaScriptScope() {
        return this.scope;
    }

    public int getCacheOption() {
        return this.cacheOption;
    }

    public int getCacheCount() {
        return this.cacheCount;
    }

    public void setCacheOption(int option, int cacheCount) throws BirtException {
        if (this.mode != 3) {
            throw new DataException("data.engine.cacheFunctionWrongMode");
        }
        this.cacheOption = option;
        this.cacheCount = cacheCount;
    }

    public RAOutputStream getOutputStream(String streamID, String subStreamID, int streamType) throws DataException {
        assert (this.writer != null);
        String relativePath = DataEngineContext.getPath(streamID, subStreamID, streamType);
        try {
            RAOutputStream outputStream = this.writer.openRandomAccessStream(relativePath);
            if (outputStream == null) {
                throw new DataException("data.engine.GetSaveStreamError");
            }
            return outputStream;
        }
        catch (IOException e) {
            throw new DataException("data.engine.GetSaveStreamError", e);
        }
    }

    public boolean hasOutStream(String streamID, String subStreamID, int streamType) {
        String relativePath = DataEngineContext.getPath(streamID, subStreamID, streamType);
        if (this.writer != null) {
            return this.writer.exists(relativePath);
        }
        return false;
    }

    public boolean hasInStream(String streamID, String subStreamID, int streamType) {
        String relativePath = DataEngineContext.getPath(streamID, subStreamID, streamType);
        if (this.reader != null) {
            return this.reader.exists(relativePath);
        }
        return this.writer != null && this.writer.exists(relativePath);
    }

    public void dropStream(String streamID, String subStreamID, int streamType) {
        String relativePath = DataEngineContext.getPath(streamID, subStreamID, streamType);
        this.dropStream(relativePath);
    }

    public void dropStream(String streamPath) {
        if (this.writer != null) {
            try {
                if (!this.writer.exists(streamPath)) {
                    return;
                }
                RAOutputStream stream = this.writer.createRandomAccessStream(streamPath);
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public RAInputStream getInputStream(String streamID, String subStreamID, int streamType) throws DataException {
        String relativePath = DataEngineContext.getPath(streamID, subStreamID, streamType);
        try {
            RAInputStream inputStream = null;
            if (this.reader != null) {
                inputStream = this.reader.getStream(relativePath);
            } else if (this.writer != null && this.writer.exists(relativePath)) {
                inputStream = this.writer.getInputStream(relativePath);
            }
            if (inputStream == null) {
                throw new DataException("data.engine.GetLoadStreamError");
            }
            return inputStream;
        }
        catch (IOException e) {
            throw new DataException("data.engine.GetLoadStreamError", e);
        }
    }

    public void setLocale(Locale locale) {
        this.currentLocale = ULocale.forLocale((Locale)locale);
        DataException.setLocale(this.currentLocale);
    }

    public void setTimeZone(TimeZone zone) {
        this.currentTimeZone = zone;
    }

    public TimeZone getTimeZone() {
        return this.currentTimeZone;
    }

    public ULocale getLocale() {
        return this.currentLocale;
    }

    public String getTmpdir() {
        if (!this.tmpDir.endsWith(File.separator)) {
            return String.valueOf(this.tmpDir) + File.separator;
        }
        return this.tmpDir;
    }

    public void setTmpdir(String tmpdir) {
        this.tmpDir = tmpdir;
        DataEngineThreadLocal.getInstance().getPathManager().setTempPath(this.getTmpdir());
    }

    public void setDataEngineOption(int option) {
        this.generationOption = option;
    }

    public int getDataEngineOption() {
        return this.generationOption;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public IDocArchiveReader getDocReader() {
        return this.reader;
    }

    public IDocArchiveWriter getDocWriter() {
        return this.writer;
    }

    public void setDocReader(IDocArchiveReader reader) {
        this.reader = reader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static String getPath(String streamID, String subStreamID, int streamType) {
        String relativePath = null;
        switch (streamType) {
            case 11: {
                return "/DataEngine/VesionInfo";
            }
            case 101: {
                return "/DataEngine/NamingRelation";
            }
            case 21: {
                relativePath = "DataSetData";
                break;
            }
            case 22: {
                relativePath = "ResultClass";
                break;
            }
            case 23: {
                relativePath = "DataSetLens";
                break;
            }
            case 31: {
                relativePath = "ExprValue";
                break;
            }
            case 33: {
                relativePath = "ExprRowLen";
                break;
            }
            case 32: {
                relativePath = "ExprMetaInfo";
                break;
            }
            case 41: {
                relativePath = "GroupInfo";
                break;
            }
            case 42: {
                relativePath = "SubQueryInfo";
                break;
            }
            case 43: {
                relativePath = "QueryDefn";
                break;
            }
            case 44: {
                relativePath = "OriginalQueryDefn";
                break;
            }
            case 51: {
                relativePath = "RowIndex";
                break;
            }
            case 61: {
                relativePath = "QueryIDInfo";
                break;
            }
            case 71: {
                relativePath = "ParentIndex";
                break;
            }
            case 99: {
                relativePath = "Meta";
                break;
            }
            case 100: {
                relativePath = "MetaIndex";
                break;
            }
            case 102: {
                relativePath = "PlsGroupLevel";
                break;
            }
            case 103: {
                relativePath = "AggrIndex";
                break;
            }
            case 104: {
                relativePath = "AggrValue";
                break;
            }
            case 105: {
                relativePath = "CombinedAggrIndex";
                break;
            }
            case 106: {
                relativePath = "CombinedAggrValue";
                break;
            }
            case 109: {
                relativePath = "MetaSecurity";
                break;
            }
            case 110: {
                relativePath = "RowSecurity";
                break;
            }
            case 115: {
                relativePath = "RowSecurityIndex";
                break;
            }
            case 112: {
                relativePath = "CubeMetaSecurity";
                break;
            }
            case 111: {
                relativePath = "ACLCollection";
                break;
            }
            case 114: {
                relativePath = "DimensionSecurity";
                break;
            }
            case 120: {
                relativePath = "ProgressiveViewingGroupInfo";
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        String streamRoot = "/" + streamID + "/";
        if (subStreamID != null) {
            streamRoot = String.valueOf(streamRoot) + subStreamID + "/";
        }
        return String.valueOf(streamRoot) + relativePath;
    }

    public ScriptContext getScriptContext() {
        if (this.scriptContext == null) {
            this.scriptContext = new ScriptContext();
        }
        return this.scriptContext;
    }
}

