/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInfo;

public class GroupInfoUtil {
    public static List[] getGroupInfo(List[] groups, int[] indexArray) throws DataException {
        HashMap<GroupInfo, Integer> deleteNumMap = new HashMap<GroupInfo, Integer>();
        if (groups == null || groups.length == 0 || indexArray == null) {
            return groups;
        }
        List endLevelList = groups[groups.length - 1];
        if (endLevelList.size() == 0) {
            return groups;
        }
        if (GroupInfoUtil.validateGroupLevel(endLevelList, indexArray)) {
            int firstChild = -1;
            int count = 0;
            int startCount = 0;
            GroupInfo baseInfo = (GroupInfo)endLevelList.get(0);
            int i = 1;
            while (i < endLevelList.size()) {
                count = 0;
                GroupInfo info = (GroupInfo)endLevelList.get(i);
                firstChild = info.firstChild;
                while (startCount < indexArray.length) {
                    if (indexArray[startCount] >= firstChild || indexArray[startCount] < baseInfo.firstChild) break;
                    ++startCount;
                    ++count;
                }
                if (count < firstChild - baseInfo.firstChild) {
                    deleteNumMap.put(info, firstChild - baseInfo.firstChild - count);
                }
                baseInfo = info;
                ++i;
            }
        } else {
            throw new DataException("data.engine.document.invalidIndexArray");
        }
        return GroupInfoUtil.cleanUnUsedGroupInstance(GroupInfoUtil.doRefactorOnGroupInfo(groups, deleteNumMap));
    }

    private static List[] doRefactorOnGroupInfo(List[] groups, Map deletedNumMap) throws DataException {
        int deleteNum;
        GroupInfo info;
        List endLevelList = groups[groups.length - 1];
        int i = 1;
        while (i < endLevelList.size()) {
            info = (GroupInfo)endLevelList.get(i);
            if (deletedNumMap.get(info) != null && (deleteNum = ((Integer)deletedNumMap.get(info)).intValue()) > 0 && GroupInfoUtil.refactorOnGroup(groups, i, deleteNum, groups.length - 1)) {
                deletedNumMap.remove(info);
            }
            ++i;
        }
        i = 1;
        while (i < endLevelList.size()) {
            info = (GroupInfo)endLevelList.get(i);
            if (deletedNumMap.get(info) != null && (deleteNum = ((Integer)deletedNumMap.get(info)).intValue()) > 0) {
                GroupInfoUtil.resetStatus(groups, i, deleteNum, groups.length - 1);
            }
            ++i;
        }
        return groups;
    }

    private static boolean refactorOnGroup(List[] groups, int groupIndex, int deletedNum, int level) throws DataException {
        List levelList = groups[level];
        int index = groupIndex;
        GroupInfo groupInfo = (GroupInfo)levelList.get(groupIndex);
        GroupInfo baseInfo = (GroupInfo)levelList.get(groupIndex - 1);
        if (groupInfo.firstChild > 0 && baseInfo.firstChild >= 0 && groupInfo.firstChild - baseInfo.firstChild > deletedNum) {
            while (index < levelList.size() && groupInfo.firstChild > 0) {
                groupInfo = (GroupInfo)levelList.get(index);
                groupInfo.firstChild -= deletedNum;
                ++index;
            }
            return true;
        }
        if (groupInfo.firstChild > 0 && baseInfo.firstChild >= 0 && groupInfo.firstChild - baseInfo.firstChild == deletedNum) {
            return false;
        }
        throw new DataException("data.engine.document.invalidGroupItem");
    }

    private static void resetStatus(List[] groups, int groupIndex, int deletedNum, int level) {
        List levelList = groups[level];
        GroupInfo deletedGroup = (GroupInfo)levelList.get(groupIndex);
        int index = groupIndex + 1;
        while (index < levelList.size()) {
            GroupInfo groupInfo = (GroupInfo)levelList.get(index);
            if (groupInfo.firstChild > 0 && groupInfo.firstChild > deletedGroup.firstChild) {
                groupInfo.firstChild -= deletedNum;
            }
            ++index;
        }
        deletedGroup.firstChild = -2;
    }

    private static boolean validateGroupLevel(List endLevelList, int[] indexArray) {
        assert (endLevelList != null);
        int index = 0;
        int i = 0;
        while (i < indexArray.length) {
            if ((index = GroupInfoUtil.findGroup(i, index, indexArray, endLevelList)) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static int findGroup(int arrayIndex, int startIndex, int[] indexArray, List endLevelList) {
        int i = startIndex;
        while (i < endLevelList.size()) {
            GroupInfo info = (GroupInfo)endLevelList.get(i);
            int start = info.firstChild;
            int end = -1;
            if (i + 1 < endLevelList.size()) {
                end = ((GroupInfo)endLevelList.get((int)(i + 1))).firstChild - 1;
            }
            if ((end == -1 || indexArray[arrayIndex] <= end) && indexArray[arrayIndex] >= start) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static List[] cleanUnUsedGroupInstance(List[] groups) {
        List[] savedList = groups;
        groups = new List[groups.length];
        int i = 0;
        while (i < groups.length) {
            groups[i] = new ArrayList();
            ++i;
        }
        GroupInfoUtil.copy(savedList, groups);
        int last = groups.length - 1;
        List lastGroup = groups[last];
        int i2 = 0;
        while (i2 < lastGroup.size()) {
            if (((GroupInfo)lastGroup.get((int)i2)).firstChild == -2) {
                return GroupInfoUtil.cleanUnUsedGroupInstance(GroupInfoUtil.removeWholeGroup(groups, last, i2));
            }
            ++i2;
        }
        return groups;
    }

    private static void copy(List[] sourceLists, List[] destLists) {
        int i = 0;
        while (i < sourceLists.length) {
            destLists[i].clear();
            int j = 0;
            while (j < sourceLists[i].size()) {
                destLists[i].add(sourceLists[i].get(j));
                ++j;
            }
            ++i;
        }
    }

    private static List[] removeWholeGroup(List[] groups, int groupLevelIndex, int groupInstanceIndex) {
        List lastGroup = groups[groupLevelIndex];
        int parent = ((GroupInfo)lastGroup.get((int)groupInstanceIndex)).parent;
        boolean shouldRemoveParent = GroupInfoUtil.manipulateParentGroup(groups, groupLevelIndex, groupInstanceIndex);
        if (groupLevelIndex < groups.length - 1 && groupInstanceIndex < lastGroup.size() - 1) {
            int start = ((GroupInfo)groups[groupLevelIndex].get((int)(groupInstanceIndex + 1))).firstChild;
            List childGroup = groups[groupLevelIndex + 1];
            int j = start;
            while (j < childGroup.size()) {
                --((GroupInfo)childGroup.get((int)j)).parent;
                ++j;
            }
        }
        lastGroup.remove(groupInstanceIndex);
        if (shouldRemoveParent) {
            return GroupInfoUtil.removeWholeGroup(groups, groupLevelIndex - 1, parent);
        }
        return groups;
    }

    private static boolean manipulateParentGroup(List[] groups, int groupLevelIndex, int groupInstanceIndex) {
        boolean shouldRemoveParent = false;
        int parent = ((GroupInfo)groups[groupLevelIndex].get((int)groupInstanceIndex)).parent;
        if (groupLevelIndex > 0) {
            List parentGroup = groups[groupLevelIndex - 1];
            int j = parent + 1;
            while (j < parentGroup.size()) {
                --((GroupInfo)parentGroup.get((int)j)).firstChild;
                ++j;
            }
            if (GroupInfoUtil.isWholeGroupEliminate(groupInstanceIndex, parent, groups[groupLevelIndex])) {
                shouldRemoveParent = true;
            }
        }
        return shouldRemoveParent;
    }

    private static boolean isWholeGroupEliminate(int currentIndex, int parent, List groups) {
        if (currentIndex - 1 >= 0 && ((GroupInfo)groups.get((int)(currentIndex - 1))).parent == parent) {
            return false;
        }
        return currentIndex + 1 >= groups.size() || ((GroupInfo)groups.get((int)(currentIndex + 1))).parent != parent;
    }
}

