/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.btree.BTree;
import org.eclipse.birt.core.btree.BTreeCursor;
import org.eclipse.birt.core.btree.BTreeFile;
import org.eclipse.birt.core.btree.BTreeOption;
import org.eclipse.birt.core.btree.BTreeSerializer;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.SizeOfUtil;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;
import org.eclipse.birt.data.engine.impl.index.ArchiveInputFile;
import org.eclipse.birt.data.engine.impl.index.ArchiveOutputFile;
import org.eclipse.birt.data.engine.impl.index.BTreeSerializerUtil;
import org.eclipse.birt.data.engine.impl.index.IDataSetIndex;
import org.eclipse.birt.data.engine.impl.index.IIndexSerializer;
import org.eclipse.birt.data.engine.impl.index.IntegerSerializer;
import org.eclipse.birt.data.engine.impl.index.JavaSerializer;
import org.eclipse.birt.data.engine.impl.index.KeyRowID;
import org.eclipse.birt.data.engine.olap.data.util.DataType;
import org.eclipse.birt.data.engine.olap.data.util.DiskSortedStack;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTreeIndex
implements IIndexSerializer,
IDataSetIndex {
    private BTree<Object, Integer> btree = null;
    private DiskSortedStack sortedKeyRowID = null;
    private BTreeSerializer serializer = null;
    private Class keyDataType = null;
    private long memoryBufferSize = 0L;
    private final int BTREE_CACHE_SIZE = 200;
    private ArchiveInputFile inputFile = null;

    public BTreeIndex(long memoryBufferSize, String indexName, StreamManager manager, Class keyDataType) throws DataException {
        this.serializer = BTreeSerializerUtil.createSerializer(keyDataType);
        try {
            this.btree = BTreeIndex.createBTree(new ArchiveOutputFile(manager.getDocWriter(), manager.getOutStreamName(indexName)), 200, this.serializer);
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
        this.keyDataType = keyDataType;
        this.memoryBufferSize = memoryBufferSize;
    }

    public BTreeIndex(String indexName, IDocArchiveReader reader, Class keyDataType, ClassLoader classLoader) throws DataException {
        this.serializer = BTreeSerializerUtil.createSerializer(keyDataType);
        if (this.serializer instanceof JavaSerializer) {
            ((JavaSerializer)this.serializer).setClassLoader(classLoader);
        }
        try {
            this.inputFile = new ArchiveInputFile(reader, indexName);
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
        this.keyDataType = keyDataType;
    }

    private static BTree<Object, Integer> createBTree(ArchiveOutputFile file, int cacheSize, BTreeSerializer serializer) throws DataException {
        BTreeOption option = new BTreeOption();
        option.setKeySerializer(serializer);
        option.setCacheSize(cacheSize);
        option.setHasValue(true);
        option.setAllowDuplicate(true);
        option.setAllowNullKey(true);
        option.setReadOnly(false);
        option.setValueSerializer((BTreeSerializer)new IntegerSerializer());
        option.setFile((BTreeFile)file);
        try {
            return new BTree(option);
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    private static BTree<Object, Integer> createBTree(ArchiveInputFile file, int cacheSize, BTreeSerializer serializer) throws DataException {
        BTreeOption option = new BTreeOption();
        option.setKeySerializer(serializer);
        option.setCacheSize(cacheSize);
        option.setHasValue(true);
        option.setAllowDuplicate(true);
        option.setAllowNullKey(true);
        option.setReadOnly(true);
        option.setValueSerializer((BTreeSerializer)new IntegerSerializer());
        option.setFile((BTreeFile)file);
        try {
            return new BTree(option);
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void close() throws DataException {
        try {
            if (this.sortedKeyRowID != null) {
                this.insertToBTree();
            }
            if (this.btree != null) {
                this.btree.close();
            }
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    private static boolean equals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    private void insertToBTree() throws DataException {
        try {
            ArrayList<Integer> rowIDList = new ArrayList<Integer>();
            KeyRowID keyRowID = (KeyRowID)this.sortedKeyRowID.pop();
            boolean isFirst = true;
            Object lastKey = null;
            while (keyRowID != null) {
                if (isFirst) {
                    lastKey = keyRowID.key;
                    rowIDList.add(keyRowID.rowID);
                    isFirst = false;
                } else if (BTreeIndex.equals(lastKey, keyRowID.key)) {
                    rowIDList.add(keyRowID.rowID);
                } else {
                    this.btree.insert(lastKey, (Object[])rowIDList.toArray(new Integer[0]));
                    lastKey = keyRowID.key;
                    rowIDList.clear();
                    rowIDList.add(keyRowID.rowID);
                }
                keyRowID = (KeyRowID)this.sortedKeyRowID.pop();
            }
            if (rowIDList.size() > 0) {
                this.btree.insert(lastKey, (Object[])rowIDList.toArray(new Integer[0]));
            }
            this.sortedKeyRowID.close();
            this.sortedKeyRowID = null;
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public Object put(Object o1, Object o2) throws DataException {
        if (this.sortedKeyRowID == null) {
            int cacheSize = 10000;
            if (this.memoryBufferSize != 0L) {
                cacheSize = (int)(this.memoryBufferSize / (long)(SizeOfUtil.sizeOf(DataType.getDataType(this.keyDataType)) + 16 + 4));
                this.sortedKeyRowID = new DiskSortedStack(cacheSize, false, false, KeyRowID.getCreator());
            } else {
                this.sortedKeyRowID = new DiskSortedStack(cacheSize, false, false, KeyRowID.getCreator());
                this.sortedKeyRowID.setUseMemoryOnly(true);
            }
        }
        try {
            this.sortedKeyRowID.push(new KeyRowID(o1, (Integer)o2));
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Integer> getKeyIndex(Object key, int filterType) throws DataException {
        List candidate;
        BTreeIndex bTreeIndex = this;
        synchronized (bTreeIndex) {
            if (this.btree == null) {
                this.btree = BTreeIndex.createBTree(this.inputFile, 200, this.serializer);
            }
        }
        if (this.sortedKeyRowID != null) {
            this.insertToBTree();
            try {
                this.sortedKeyRowID.close();
            }
            catch (IOException e) {
                throw new DataException(e.getLocalizedMessage(), e);
            }
            this.sortedKeyRowID = null;
        }
        if (filterType != 1 && filterType != 22 && filterType != 5 && filterType != 6 && filterType != 4 && filterType != 3 && filterType != 7) {
            throw new UnsupportedOperationException();
        }
        if (filterType == 1) {
            return this.getKeyIndex(key);
        }
        if (filterType == 22) {
            candidate = (List)key;
            HashSet<Integer> result = new HashSet<Integer>();
            for (Object eachKey : candidate) {
                result.addAll(this.getKeyIndex(eachKey));
            }
            return result;
        }
        if (filterType == 5) {
            return this.getGreater(key, true);
        }
        if (filterType == 6) {
            return this.getGreater(key, false);
        }
        if (filterType == 4) {
            return this.getLess(key, true);
        }
        if (filterType == 3) {
            return this.getLess(key, false);
        }
        if (filterType == 7) {
            candidate = (List)key;
            return this.getBetween(candidate.get(0), candidate.get(1));
        }
        return new HashSet<Integer>();
    }

    private Set<Integer> getBetween(Object key1, Object key2) throws DataException {
        Object max;
        Object min;
        if (ScriptEvalUtil.compare(key1, key2) <= 0) {
            min = key1;
            max = key2;
        } else {
            min = key2;
            max = key1;
        }
        try {
            min = DataTypeUtil.convert((Object)min, (Class)this.keyDataType);
            max = DataTypeUtil.convert((Object)max, (Class)this.keyDataType);
        }
        catch (BirtException e1) {
            throw DataException.wrap(e1);
        }
        BTreeCursor bCursor = this.btree.createCursor();
        HashSet<Integer> result = new HashSet<Integer>();
        try {
            if (!bCursor.first()) {
                return result;
            }
            if (ScriptEvalUtil.compare(bCursor.getKey(), min) <= 0) {
                bCursor.moveTo(min);
                if (((Comparable)bCursor.getKey()).compareTo(max) > 0) {
                    return result;
                }
                if (((Comparable)bCursor.getKey()).compareTo(min) >= 0) {
                    result.addAll(bCursor.getValues());
                }
            } else {
                bCursor.beforeFirst();
            }
            while (bCursor.next()) {
                if (((Comparable)bCursor.getKey()).compareTo(max) > 0) {
                    return result;
                }
                result.addAll(bCursor.getValues());
            }
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
        return result;
    }

    private Set<Integer> getGreater(Object key, boolean includeKey) throws DataException {
        try {
            key = DataTypeUtil.convert((Object)key, (Class)this.keyDataType);
        }
        catch (BirtException e1) {
            throw DataException.wrap(e1);
        }
        BTreeCursor bCursor = this.btree.createCursor();
        HashSet<Integer> result = new HashSet<Integer>();
        try {
            if (!bCursor.first()) {
                return result;
            }
            if (((Comparable)bCursor.getKey()).compareTo(key) > 0) {
                bCursor.beforeFirst();
            } else {
                bCursor.moveTo(key);
                int cr = ((Comparable)bCursor.getKey()).compareTo(key);
                if (includeKey && cr == 0 || cr > 0) {
                    result.addAll(bCursor.getValues());
                }
            }
            while (bCursor.next()) {
                result.addAll(bCursor.getValues());
            }
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
        return result;
    }

    private Set<Integer> getLess(Object key, boolean includeKey) throws DataException {
        try {
            key = DataTypeUtil.convert((Object)key, (Class)this.keyDataType);
        }
        catch (BirtException e1) {
            throw DataException.wrap(e1);
        }
        BTreeCursor bCursor = this.btree.createCursor();
        HashSet<Integer> result = new HashSet<Integer>();
        try {
            while (bCursor.next()) {
                int cr = ((Comparable)bCursor.getKey()).compareTo(key);
                if (cr < 0 || cr == 0 && includeKey) {
                    result.addAll(bCursor.getValues());
                    continue;
                }
                return result;
            }
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
        return result;
    }

    private Set<Integer> getKeyIndex(Object key) throws DataException {
        HashSet<Integer> set = new HashSet<Integer>();
        Collection rowID = null;
        try {
            key = DataTypeUtil.convert((Object)key, (Class)this.keyDataType);
        }
        catch (BirtException e1) {
            throw DataException.wrap(e1);
        }
        try {
            rowID = this.btree.getValues(key);
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
        if (rowID != null) {
            set.addAll(rowID);
        }
        return set;
    }

    @Override
    public boolean supportFilter(int filterType) throws DataException {
        return filterType == 1 || filterType == 22 || filterType == 5 || filterType == 6 || filterType == 4 || filterType == 3 || filterType == 7;
    }

    @Override
    public Object[] getAllKeyValues() throws DataException {
        if (this.btree == null) {
            this.btree = BTreeIndex.createBTree(this.inputFile, 200, this.serializer);
        }
        BTreeCursor bCursor = this.btree.createCursor();
        ArrayList<Object> key = new ArrayList<Object>();
        try {
            while (bCursor.next()) {
                key.add(bCursor.getKey());
            }
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
        return key.toArray();
    }

    @Override
    public Set<Integer> getAllKeyRows() throws DataException {
        if (this.btree == null) {
            this.btree = BTreeIndex.createBTree(this.inputFile, 200, this.serializer);
        }
        BTreeCursor bCursor = this.btree.createCursor();
        ArrayList<Integer> keyRow = new ArrayList<Integer>();
        try {
            while (bCursor.next()) {
                keyRow.add((Integer)bCursor.getValue());
            }
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
        HashSet<Integer> set = new HashSet<Integer>();
        set.addAll(keyRow);
        return set;
    }
}

