/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IDataScriptEngine;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.IShutdownListener;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.FileSecurity;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.BindingColumnsEvalUtil;
import org.eclipse.birt.data.engine.impl.ColumnBindingMetaData;
import org.eclipse.birt.data.engine.impl.IServiceForResultSet;
import org.eclipse.birt.data.engine.impl.ISubQueryExecutor;
import org.eclipse.birt.data.engine.impl.LogUtil;
import org.eclipse.birt.data.engine.impl.PreparedSubquery;
import org.eclipse.birt.data.engine.impl.QueryResults;
import org.eclipse.birt.data.engine.impl.QuerySharingUtil;
import org.eclipse.birt.data.engine.impl.ResultSetCacheUtil;
import org.eclipse.birt.data.engine.impl.RowIDUtil;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.impl.document.IDInfo;
import org.eclipse.birt.data.engine.impl.document.IRDSave;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultIterator
implements IResultIterator {
    protected RDSaveHelper rdSaveHelper;
    private Scriptable scope;
    protected org.eclipse.birt.data.engine.odi.IResultIterator odiResult;
    private IServiceForResultSet resultService;
    private GroupUtil groupUtil;
    protected RowIDUtil rowIDUtil;
    protected Map boundColumnValueMap = new HashMap();
    protected Map lastBoundColumnValueMap = null;
    private BindingColumnsEvalUtil bindingColumnsEvalUtil;
    private boolean isFirstNext = true;
    private OutputStream metaOutputStream = null;
    private DataOutputStream rowOutputStream = null;
    private static Logger logger = Logger.getLogger(ResultIterator.class.getName());
    private List columnList = null;
    private int rawIdStartingValue = 0;
    private IShutdownListener listener;
    private boolean distinctValue;
    private StopSign stopSign = null;

    ResultIterator(IServiceForResultSet rService, org.eclipse.birt.data.engine.odi.IResultIterator odiResult, Scriptable scope, int rawIdStartingValue) throws DataException {
        Object[] params = new Object[]{rService, odiResult, scope};
        logger.entering(ResultIterator.class.getName(), "ResultIterator", params);
        assert (rService != null && rService.getQueryResults() != null && odiResult != null && scope != null);
        this.resultService = rService;
        this.odiResult = odiResult;
        this.scope = scope;
        this.rawIdStartingValue = rawIdStartingValue;
        if (rService.getSession().getEngineContext().getMode() == 1 || rService.getSession().getEngineContext().getMode() == 3) {
            this.validateManualBindingExpressions(this.resultService.getQueryDefn().getBindings());
        }
        if (this.needCache() && !this.isEmpty()) {
            try {
                this.createCacheOutputStream();
                this.saveMetaData();
                IOUtil.writeInt((OutputStream)this.rowOutputStream, (int)this.odiResult.getRowCount());
            }
            catch (IOException iOException) {
                throw new DataException("data.engine.CreateCacheTempError");
            }
        }
        this.start();
        this.prepareBindingColumnsEvalUtil();
        this.prepareCurrentRow();
        this.distinctValue = this.resultService.getQueryDefn().getDistinctValue();
        this.addEngineShutdownListener();
        this.stopSign = this.resultService.getSession().getStopSign();
        logger.exiting(ResultIterator.class.getName(), "ResultIterator");
    }

    private static Map copy(Map map) {
        HashMap newMap = new HashMap();
        for (Object key : map.keySet()) {
            newMap.put(key, map.get(key));
        }
        return newMap;
    }

    private void addEngineShutdownListener() {
        this.listener = new IShutdownListener(){

            public void dataEngineShutdown() {
                try {
                    ResultIterator.this.close();
                }
                catch (BirtException birtException) {}
            }
        };
        this.resultService.getSession().getEngine().addShutdownListener(this.listener);
    }

    public void setRdSaveHelper(RDSaveHelper rdSaveHelper) throws DataException {
        this.rdSaveHelper = rdSaveHelper;
        this.prepareBindingColumnsEvalUtil();
        this.prepareCurrentRow();
    }

    private void createCacheOutputStream() throws FileNotFoundException, DataException {
        File tmpDir = new File(this.resultService.getSession().getTempDir());
        if (!FileSecurity.fileExist(tmpDir) || !FileSecurity.fileIsDirectory(tmpDir)) {
            FileSecurity.fileMakeDirs(tmpDir);
        }
        String id = this.resultService.getQueryResults().getID();
        int currentParentQueryRowId = 0;
        if (this.resultService != null && this.resultService.getQueryDefn() instanceof ISubqueryDefinition) {
            PreparedSubquery.SubQueryExecutor executor;
            QueryResults results;
            if (this.resultService.getQueryResults() instanceof QueryResults && (results = (QueryResults)this.resultService.getQueryResults()).getQueryService().getQueryExecutor() instanceof ISubQueryExecutor && (executor = (PreparedSubquery.SubQueryExecutor)results.getQueryService().getQueryExecutor()).getParentIterator() != null) {
                currentParentQueryRowId = executor.getParentIterator().getCurrentResultIndex();
            }
            id = QuerySharingUtil.getSubQueryID(id, this.resultService.getQueryDefn().getName(), currentParentQueryRowId);
        }
        this.metaOutputStream = new BufferedOutputStream(FileSecurity.createFileOutputStream(ResultSetCacheUtil.getMetaFile(this.resultService.getSession().getTempDir(), id)), 1024);
        this.rowOutputStream = new DataOutputStream(new BufferedOutputStream(FileSecurity.createFileOutputStream(ResultSetCacheUtil.getDataFile(this.resultService.getSession().getTempDir(), id)), 1024));
        File file = ResultSetCacheUtil.getDataFile(this.resultService.getSession().getTempDir(), id);
        FileSecurity.fileDeleteOnExit(file);
        file = ResultSetCacheUtil.getMetaFile(this.resultService.getSession().getTempDir(), id);
        FileSecurity.fileDeleteOnExit(file);
    }

    private void closeCacheOutputStream() throws DataException {
        try {
            if (this.rowOutputStream != null) {
                IOUtil.writeInt((OutputStream)this.rowOutputStream, (int)-1);
                this.rowOutputStream.close();
                this.rowOutputStream = null;
            }
        }
        catch (IOException iOException) {
            throw new DataException("data.engine.CloseCacheTempError");
        }
    }

    private boolean needCache() {
        if (this.resultService == null || this.resultService.getQueryDefn() == null) {
            return false;
        }
        return this.resultService.getQueryDefn().cacheQueryResults();
    }

    private void saveMetaData() throws DataException, IOException {
        ArrayList<IBinding> metaMap = new ArrayList<IBinding>();
        ResultIterator.populateDataSetRowMapping(metaMap, this.odiResult.getResultClass());
        ((ResultClass)this.odiResult.getResultClass()).doSave(this.metaOutputStream, metaMap, 0);
        if (this.metaOutputStream != null) {
            this.metaOutputStream.close();
            this.metaOutputStream = null;
        }
    }

    private static void populateDataSetRowMapping(List<IBinding> metaMap, IResultClass rsClass) throws DataException {
        int i = 0;
        while (i < rsClass.getFieldCount()) {
            Binding binding = new Binding(rsClass.getFieldName(i + 1));
            binding.setExpression(new org.eclipse.birt.data.engine.api.querydefn.ScriptExpression(ExpressionUtil.createJSDataSetRowExpression((String)rsClass.getFieldName(i + 1))));
            metaMap.add(binding);
            ++i;
        }
    }

    private void validateManualBindingExpressions(Map exprs) throws DataException {
        Set validDataSetColumnNames = this.populateValidDataSetColumnNameSet();
        for (Map.Entry entry : exprs.entrySet()) {
            IBaseExpression expr = ((IBinding)entry.getValue()).getExpression();
            List usedDataSetExprs = ExpressionCompilerUtil.extractDataSetColumnExpression(expr);
            int j = 0;
            while (j < usedDataSetExprs.size()) {
                if (!validDataSetColumnNames.contains(usedDataSetExprs.get(j)) && !usedDataSetExprs.get(j).equals("_rowPosition")) {
                    throw new DataException("data.engine.ColumnBindingReferToInexistColumn", new Object[]{entry.getKey(), usedDataSetExprs.get(j)});
                }
                ++j;
            }
        }
    }

    private Set populateValidDataSetColumnNameSet() throws DataException {
        HashSet<String> validDataSetColumnNames = new HashSet<String>();
        int i = 1;
        while (i <= this.odiResult.getResultClass().getFieldCount()) {
            validDataSetColumnNames.add(this.odiResult.getResultClass().getFieldName(i));
            validDataSetColumnNames.add(this.odiResult.getResultClass().getFieldAlias(i));
            ++i;
        }
        return validDataSetColumnNames;
    }

    @Override
    public Scriptable getScope() {
        return this.scope;
    }

    private void start() throws DataException {
        this.getRdSaveHelper().doSaveStart();
    }

    private void checkStarted() throws DataException {
        if (this.odiResult == null) {
            DataException e = new DataException("data.engine.ResultClosed");
            logger.logp(Level.FINE, ResultIterator.class.getName(), "checkStarted", "ResultIterator has been closed.", (Throwable)((Object)e));
            throw e;
        }
    }

    @Override
    public IQueryResults getQueryResults() {
        return this.resultService.getQueryResults();
    }

    @Override
    public boolean next() throws BirtException {
        if (this.distinctValue) {
            boolean hasNext = this.nextRow();
            while (hasNext) {
                if (this.lastBoundColumnValueMap == null) {
                    this.lastBoundColumnValueMap = ResultIterator.copy(this.boundColumnValueMap);
                    return true;
                }
                if (!ResultIterator.equal(this.lastBoundColumnValueMap, this.boundColumnValueMap)) {
                    this.lastBoundColumnValueMap = ResultIterator.copy(this.boundColumnValueMap);
                    return true;
                }
                hasNext = this.nextRow();
            }
            return false;
        }
        return this.nextRow();
    }

    private static boolean equal(Map map1, Map map2) {
        for (Map.Entry entry : map1.entrySet()) {
            if ("_$$_dte_inner_row_id_$$_".equals(entry.getKey())) continue;
            if (map2.get(entry.getKey()) == null && entry.getValue() != null) {
                return false;
            }
            if (map2.get(entry.getKey()) != null && entry.getValue() == null) {
                return false;
            }
            if (map2.get(entry.getKey()) == null && entry.getValue() == null || map2.get(entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean nextRow() throws BirtException {
        this.checkStarted();
        if (this.isEmpty()) {
            return false;
        }
        if (this.isFirstNext) {
            this.isFirstNext = false;
            return this.odiResult.getCurrentResult() != null;
        }
        if (this.hasNextRow()) {
            this.prepareCurrentRow();
            return true;
        }
        return false;
    }

    private void clear() {
        this.boundColumnValueMap.clear();
    }

    private void saveCurrentRow() throws IOException, BirtException {
        if (this.columnList == null) {
            this.columnList = new ArrayList();
            for (Object key : this.boundColumnValueMap.keySet()) {
                this.columnList.add(key);
            }
            IOUtil.writeInt((OutputStream)this.rowOutputStream, (int)this.columnList.size());
            int i = 0;
            while (i < this.columnList.size()) {
                IOUtil.writeObject((DataOutputStream)this.rowOutputStream, this.columnList.get(i));
                ++i;
            }
        }
        IOUtil.writeInt((OutputStream)this.rowOutputStream, (int)this.getRowIndex());
        IOUtil.writeInt((OutputStream)this.rowOutputStream, (int)this.getStartingGroupLevel());
        IOUtil.writeInt((OutputStream)this.rowOutputStream, (int)this.getEndingGroupLevel());
        int i = 0;
        while (i < this.columnList.size()) {
            IOUtil.writeObject((DataOutputStream)this.rowOutputStream, (Object)this.getValue((String)this.columnList.get(i)));
            ++i;
        }
    }

    protected boolean hasNextRow() throws DataException {
        return this.odiResult.next();
    }

    @Override
    public boolean isEmpty() throws DataException {
        return this.odiResult.getRowCount() == 0;
    }

    @Override
    public int getRowId() throws BirtException {
        this.checkStarted();
        if (this.rowIDUtil == null) {
            this.rowIDUtil = new RowIDUtil();
        }
        if (this.rowIDUtil.getMode(this.odiResult) == 1) {
            return this.odiResult.getCurrentResultIndex() + this.rawIdStartingValue;
        }
        IResultObject ob = this.odiResult.getCurrentResult();
        if (ob == null) {
            return -1;
        }
        return (Integer)ob.getFieldValue(this.rowIDUtil.getRowIdPos());
    }

    int getRawIdStartingValue() {
        return this.rawIdStartingValue;
    }

    @Override
    public int getRowIndex() throws BirtException {
        this.checkStarted();
        return this.odiResult.getCurrentResultIndex();
    }

    @Override
    public void moveTo(int rowIndex) throws BirtException {
        this.checkStarted();
        if (this.isFirstNext) {
            this.next();
        }
        int currRowIndex = this.odiResult.getCurrentResultIndex();
        if (rowIndex < 0 || rowIndex >= this.odiResult.getRowCount() && this.odiResult.getRowCount() != -1) {
            throw new DataException("data.engine.invalidRowIndex", rowIndex);
        }
        if (rowIndex < currRowIndex) {
            throw new DataException("data.engine.backwardSeekError");
        }
        if (rowIndex == currRowIndex) {
            return;
        }
        int gapRows = rowIndex - currRowIndex;
        int i = 0;
        while (i < gapRows) {
            this.next();
            ++i;
        }
    }

    private RDSaveHelper getRdSaveHelper() throws DataException {
        if (this.rdSaveHelper == null) {
            IDInfo id = null;
            id = this.resultService.getQueryDefn() instanceof ISubqueryDefinition ? new IDInfo(null, this.resultService.getQueryDefn().getName()) : new IDInfo(this.resultService.getQueryResults().getID());
            this.rdSaveHelper = new RDSaveHelper(this.resultService.getSession().getEngineContext(), this.resultService.getQueryDefn(), this.odiResult, id);
        }
        return this.rdSaveHelper;
    }

    @Override
    public Object getValue(String exprName) throws BirtException {
        Object exprValue;
        this.checkStarted();
        logger.logp(Level.FINER, ResultIterator.class.getName(), "getValue", "get of value binding column: " + LogUtil.toString(exprName));
        if (!this.boundColumnValueMap.containsKey(exprName)) {
            if (this.bindingColumnsEvalUtil.isValidBindingName(exprName)) {
                this.prepareBindingColumn(exprName);
            } else {
                throw new DataException("data.engine.InvalidBoundColumnName", exprName);
            }
        }
        if ((exprValue = this.boundColumnValueMap.get(exprName)) instanceof BirtException) {
            throw (BirtException)((Object)exprValue);
        }
        return exprValue;
    }

    private Object prepareBindingColumn(String exprName) throws DataException {
        assert (this.bindingColumnsEvalUtil != null);
        Object value = this.bindingColumnsEvalUtil.evaluateValue(exprName);
        this.boundColumnValueMap.put(exprName, value);
        return value;
    }

    private void prepareCurrentRow() throws DataException {
        this.clear();
        this.rdSaveHelper.doSaveBasic();
        if (this.needCache() && !this.isEmpty()) {
            this.bindingColumnsEvalUtil.getColumnsValue(this.boundColumnValueMap, true);
            try {
                this.saveCurrentRow();
            }
            catch (IOException e) {
                try {
                    this.metaOutputStream.close();
                    this.rowOutputStream.close();
                }
                catch (IOException iOException) {}
                throw new DataException("data.engine.WriteCacheTempError", e);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
        this.bindingColumnsEvalUtil.getColumnsValue(this.boundColumnValueMap, false);
    }

    protected void prepareBindingColumnsEvalUtil() throws DataException {
        this.bindingColumnsEvalUtil = new BindingColumnsEvalUtil(this.odiResult, this.scope, this.resultService.getSession().getEngineContext().getScriptContext(), this.getRdSaveHelper(), this.resultService.getAllBindingExprs(), this.resultService.getAllAutoBindingExprs());
    }

    @Override
    public Boolean getBoolean(String name) throws BirtException {
        return DataTypeUtil.toBoolean((Object)this.getValue(name));
    }

    @Override
    public Integer getInteger(String name) throws BirtException {
        return DataTypeUtil.toInteger((Object)this.getValue(name));
    }

    @Override
    public Double getDouble(String name) throws BirtException {
        return DataTypeUtil.toDouble((Object)this.getValue(name));
    }

    @Override
    public String getString(String name) throws BirtException {
        return DataTypeUtil.toString((Object)this.getValue(name));
    }

    @Override
    public BigDecimal getBigDecimal(String name) throws BirtException {
        return DataTypeUtil.toBigDecimal((Object)this.getValue(name));
    }

    @Override
    public Date getDate(String name) throws BirtException {
        return DataTypeUtil.toDate((Object)this.getValue(name));
    }

    @Override
    public Blob getBlob(String name) throws BirtException {
        return DataTypeUtil.toBlob((Object)this.getValue(name));
    }

    @Override
    public byte[] getBytes(String name) throws BirtException {
        return DataTypeUtil.toBytes((Object)this.getValue(name));
    }

    @Override
    public void skipToEnd(int groupLevel) throws BirtException {
        this.checkStarted();
        this.goThroughGapRows(groupLevel);
        logger.logp(Level.FINER, ResultIterator.class.getName(), "skipToEnd", "skipping rows to the last row in the current group");
    }

    protected void goThroughGapRows(int groupLevel) throws DataException, BirtException {
        while (groupLevel < this.odiResult.getEndingGroupLevel() && this.odiResult.getEndingGroupLevel() != 0 && this.next()) {
        }
    }

    @Override
    public int getStartingGroupLevel() throws DataException {
        return this.odiResult.getStartingGroupLevel();
    }

    @Override
    public int getEndingGroupLevel() throws DataException {
        return this.odiResult.getEndingGroupLevel();
    }

    @Override
    public IResultIterator getSecondaryIterator(ScriptContext context, String subQueryName) throws DataException {
        try {
            Scriptable scope = null;
            if (context != null) {
                scope = ((IDataScriptEngine)context.getScriptEngine("javascript")).getJSScope(context);
            }
            return this.getSecondaryIterator(subQueryName, scope);
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    @Override
    public IResultIterator getSecondaryIterator(String subQueryName, Scriptable subScope) throws DataException {
        IResultIterator resultIt;
        this.checkStarted();
        IQueryResults results = this.resultService.execSubquery(this.odiResult, subQueryName, subScope);
        if (this.needCache() && results instanceof QueryResults) {
            ((QueryResults)results).setID(this.resultService.getQueryResults().getID());
        }
        logger.logp(Level.FINER, ResultIterator.class.getName(), "getSecondaryIterator", "Returns the secondary result specified by a SubQuery");
        try {
            resultIt = results.getResultIterator();
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
        if (resultIt instanceof ResultIterator) {
            this.getRdSaveHelper().processForSubQuery(this.getQueryResults().getID(), (ResultIterator)resultIt, subQueryName);
        }
        return resultIt;
    }

    @Override
    public IResultMetaData getResultMetaData() throws DataException {
        try {
            ColumnBindingMetaData columnBindingMetaData = new ColumnBindingMetaData(this.resultService.getQueryDefn(), this.odiResult == null ? null : this.odiResult.getResultClass());
            return columnBindingMetaData;
        }
        finally {
            logger.logp(Level.FINEST, ResultIterator.class.getName(), "getResultMetaData", "Returns the result metadata");
        }
    }

    @Override
    public void close() throws BirtException {
        if (this.odiResult == null) {
            return;
        }
        this.resultService.getSession().getEngine().removeListener(this.listener);
        if (!this.stopSign.isStopped()) {
            if (this.getRdSaveHelper().needsSaveToDoc()) {
                while (this.next()) {
                }
                this.getRdSaveHelper().doSaveFinish();
            }
            if (this.needCache() && !this.isEmpty()) {
                while (this.next()) {
                }
                this.closeCacheOutputStream();
            }
        }
        if (this.odiResult != null) {
            this.odiResult.close();
        }
        this.odiResult = null;
        this.resultService = null;
        logger.logp(Level.FINER, ResultIterator.class.getName(), "close", "a ResultIterator is closed");
    }

    public org.eclipse.birt.data.engine.odi.IResultIterator getOdiResult() {
        return this.odiResult;
    }

    @Override
    public boolean findGroup(Object[] groupKeyValues) throws BirtException {
        if (this.groupUtil == null) {
            this.groupUtil = new GroupUtil(this.resultService.getQueryDefn(), this);
        }
        return this.groupUtil.findGroup(groupKeyValues);
    }

    @Override
    public boolean isBeforeFirst() throws BirtException {
        return !this.isEmpty() && this.isFirstNext;
    }

    @Override
    public boolean isFirst() throws BirtException {
        return !this.isEmpty() && this.getRowIndex() == 0;
    }

    private class GroupUtil {
        private IBaseQueryDefinition queryDefn;
        private ResultIterator resultIterator;

        private GroupUtil(IBaseQueryDefinition queryDefn, ResultIterator resultIterator2) {
            this.queryDefn = queryDefn;
            this.resultIterator = resultIterator2;
        }

        public boolean findGroup(Object[] groupKeyValues) throws BirtException {
            org.eclipse.birt.data.engine.odi.IResultIterator odiResult = this.resultIterator.getOdiResult();
            List groups = this.queryDefn.getGroups();
            if (groupKeyValues.length > groups.size()) {
                throw new DataException("data.engine.incorrectGroupKeyValues");
            }
            GroupDefinition group = null;
            String[] columnNames = new String[groupKeyValues.length];
            int i = 0;
            while (i < columnNames.length) {
                group = (GroupDefinition)groups.get(i);
                columnNames[i] = this.getGroupKeyExpression(group);
                ++i;
            }
            odiResult.first(0);
            if (odiResult.getCurrentResult() == null) {
                return false;
            }
            block1: do {
                i = 0;
                while (i < columnNames.length) {
                    if (!this.groupKeyValuesEqual(odiResult, groupKeyValues, columnNames, i)) {
                        this.resultIterator.skipToEnd(i + 1);
                        continue block1;
                    }
                    if (i == columnNames.length - 1) {
                        return true;
                    }
                    ++i;
                }
            } while (odiResult.next());
            return false;
        }

        private boolean groupKeyValuesEqual(org.eclipse.birt.data.engine.odi.IResultIterator odiResult, Object[] groupKeyValues, String[] columnExprs, int i) throws BirtException {
            Object fieldValue = null;
            fieldValue = ScriptEvalUtil.evalExpr(new org.eclipse.birt.data.engine.api.querydefn.ScriptExpression(columnExprs[i]), ResultIterator.this.resultService.getSession().getEngineContext().getScriptContext().newContext((Object)ResultIterator.this.scope), ScriptExpression.defaultID, 0);
            boolean retValue = false;
            if (fieldValue == groupKeyValues[i]) {
                retValue = true;
            } else if (fieldValue != null && groupKeyValues[i] != null) {
                if (fieldValue.getClass().equals(groupKeyValues[i].getClass())) {
                    retValue = this.equal(fieldValue, groupKeyValues[i]);
                } else {
                    Object convertedOb = DataTypeUtil.convert((Object)groupKeyValues[i], fieldValue.getClass());
                    retValue = this.equal(fieldValue, convertedOb);
                }
            }
            return retValue;
        }

        private boolean equal(Object value1, Object value2) {
            if (value1 instanceof Date && value2 instanceof Date) {
                return ((Date)value1).getTime() == ((Date)value2).getTime();
            }
            return value1.equals(value2);
        }

        private String getGroupKeyExpression(GroupDefinition group) {
            String columnName = group.getKeyColumn() != null ? ExpressionUtil.createJSRowExpression((String)group.getKeyColumn()) : group.getKeyExpression();
            return columnName;
        }
    }

    class RDSaveHelper {
        private DataEngineContext context;
        private IBaseQueryDefinition queryDefn;
        private org.eclipse.birt.data.engine.odi.IResultIterator odiResult;
        private IDInfo idInfo;
        private IRDSave rdSave;
        private boolean isBasicSaved;

        RDSaveHelper(DataEngineContext context, IBaseQueryDefinition queryDefn, org.eclipse.birt.data.engine.odi.IResultIterator odiResult, IDInfo idInfo) {
            this.context = context;
            this.queryDefn = queryDefn;
            this.odiResult = odiResult;
            this.idInfo = idInfo;
        }

        void doSaveExpr(Map valueMap) throws DataException {
            this.doSave(valueMap, false);
        }

        void doSaveFinish() throws DataException {
            this.doSave(null, true);
        }

        void doSaveStart() throws DataException {
            if (!this.needsSaveToDoc()) {
                return;
            }
            this.getRdSave().saveStart();
        }

        private void doSave(Map valueMap, boolean finish) throws DataException {
            if (!this.needsSaveToDoc()) {
                return;
            }
            this.doSaveBasic();
            if (!finish) {
                this.rdSave.saveExprValue(this.odiResult.getCurrentResultIndex(), valueMap);
            } else {
                this.rdSave.saveFinish(this.odiResult.getRowCount() - 1);
            }
        }

        private void doSaveBasic() throws DataException {
            if (!this.needsSaveToDoc()) {
                return;
            }
            if (!this.isBasicSaved) {
                this.isBasicSaved = true;
                this.getRdSave().saveResultIterator(this.odiResult, this.idInfo.getGroupLevel(), this.idInfo.getSubQueryInfo());
            }
        }

        private IRDSave getRdSave() throws DataException {
            if (this.rdSave == null) {
                this.rdSave = RDUtil.newSave(this.context, this.queryDefn, this.odiResult.getRowCount(), new QueryResultInfo(this.idInfo.getQueryResultID(), this.idInfo.getsubQueryName(), this.idInfo.getsubQueryIndex()));
            }
            return this.rdSave;
        }

        public boolean needsSaveToDoc() {
            if (((BaseQueryDefinition)this.queryDefn).isTempQuery()) {
                return false;
            }
            if (this.odiResult == null) {
                return false;
            }
            if (this.context == null || this.context.getMode() == 3 || this.context.getMode() == 2) {
                return false;
            }
            return this.context.getDocWriter() != null;
        }

        private void processForSubQuery(String parentQueryID, ResultIterator resultIt, String subQueryName) throws DataException {
            if (!this.needsSaveToDoc()) {
                return;
            }
            QueryResults results = (QueryResults)resultIt.getQueryResults();
            results.setID(this.idInfo.buildSubQueryID(parentQueryID));
            if (((ISubqueryDefinition)resultIt.resultService.getQueryDefn()).applyOnGroup()) {
                resultIt.setRdSaveHelper(new RDSaveHelper(resultIt.resultService.getSession().getEngineContext(), resultIt.resultService.getQueryDefn(), resultIt.odiResult, new IDInfo(resultIt.getQueryResults().getID(), subQueryName, results.getGroupLevel(), this.odiResult.getCurrentGroupIndex(results.getGroupLevel()), this.odiResult.getGroupStartAndEndIndex(results.getGroupLevel()))));
            } else {
                resultIt.setRdSaveHelper(new RDSaveHelper(resultIt.resultService.getSession().getEngineContext(), resultIt.resultService.getQueryDefn(), resultIt.odiResult, new IDInfo(resultIt.getQueryResults().getID(), subQueryName, 1, this.odiResult.getCurrentResultIndex(), IDInfo.getSpecialSubQueryInfo(this.odiResult.getRowCount()))));
            }
        }

        public boolean isSummaryQuery() {
            return this.queryDefn instanceof IQueryDefinition ? ((IQueryDefinition)this.queryDefn).isSummaryQuery() : false;
        }
    }
}

