/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.index;

import java.io.IOException;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.btree.BTreeFile;

class ArchiveInputFile
implements BTreeFile {
    IDocArchiveReader archive;
    String name;
    RAInputStream input;

    ArchiveInputFile(IDocArchiveReader archive, String name) throws IOException {
        this.archive = archive;
        this.name = name;
        this.input = archive.getInputStream(name);
    }

    public int allocBlock() throws IOException {
        throw new IOException("read only stream");
    }

    public int getTotalBlock() throws IOException {
        return (int)((this.input.length() + 4096L - 1L) / 4096L);
    }

    public Object lock() throws IOException {
        return this.archive.lock(this.name);
    }

    public void readBlock(int blockId, byte[] bytes) throws IOException {
        this.input.seek((long)(blockId * 4096));
        this.input.read(bytes);
    }

    public void unlock(Object lock) throws IOException {
        this.archive.unlock(lock);
    }

    public void writeBlock(int blockId, byte[] bytes) throws IOException {
        throw new IOException("read only stream");
    }

    public void close() {
    }
}

