/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v2;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.impl.AbstractContent;
import org.eclipse.birt.report.engine.content.impl.AutoTextContent;
import org.eclipse.birt.report.engine.content.impl.CellContent;
import org.eclipse.birt.report.engine.content.impl.ContainerContent;
import org.eclipse.birt.report.engine.content.impl.DataContent;
import org.eclipse.birt.report.engine.content.impl.ForeignContent;
import org.eclipse.birt.report.engine.content.impl.ImageContent;
import org.eclipse.birt.report.engine.content.impl.LabelContent;
import org.eclipse.birt.report.engine.content.impl.ListBandContent;
import org.eclipse.birt.report.engine.content.impl.ListContent;
import org.eclipse.birt.report.engine.content.impl.PageContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.content.impl.RowContent;
import org.eclipse.birt.report.engine.content.impl.TableBandContent;
import org.eclipse.birt.report.engine.content.impl.TableContent;
import org.eclipse.birt.report.engine.content.impl.TextContent;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.v2.ContentTreeCache;

public class ReportContentReaderV2 {
    protected static Logger logger = Logger.getLogger(ReportContentReaderV2.class.getName());
    protected ReportContent reportContent;
    protected IReportDocument document;
    protected RAInputStream stream;
    protected long offset;
    protected ClassLoader loader;
    protected ContentTreeCache contentCache = new ContentTreeCache();

    public ReportContentReaderV2(ReportContent reportContent, IReportDocument document, ClassLoader loader) {
        this.reportContent = reportContent;
        this.loader = loader;
        this.document = document;
    }

    public void open(String name) throws IOException {
        IDocArchiveReader reader = this.document.getArchive();
        this.stream = reader.getStream(name);
    }

    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Failed to close the reader", ex);
            }
        }
    }

    protected IContent readContent(DataInputStream oi) throws IOException {
        AbstractContent object = null;
        int contentType = IOUtil.readInt((InputStream)oi);
        switch (contentType) {
            case 1: {
                CellContent cellContent;
                object = cellContent = (CellContent)this.reportContent.createCellContent();
                break;
            }
            case 2: {
                ContainerContent containerContent = (ContainerContent)this.reportContent.createContainerContent();
                containerContent.readContent(oi, this.loader);
                object = containerContent;
                break;
            }
            case 3: {
                DataContent dataContent = (DataContent)this.reportContent.createDataContent();
                dataContent.readContent(oi, this.loader);
                object = dataContent;
                break;
            }
            case 4: {
                ForeignContent foreignContent = (ForeignContent)this.reportContent.createForeignContent();
                foreignContent.readContent(oi, this.loader);
                object = foreignContent;
                break;
            }
            case 5: {
                ImageContent imageContent = (ImageContent)this.reportContent.createImageContent();
                imageContent.readContent(oi, this.loader);
                object = imageContent;
                break;
            }
            case 6: {
                LabelContent labelContent = (LabelContent)this.reportContent.createLabelContent();
                labelContent.readContent(oi, this.loader);
                object = labelContent;
                break;
            }
            case 7: {
                PageContent pageContent = (PageContent)this.reportContent.createPageContent();
                pageContent.readContent(oi, this.loader);
                object = pageContent;
                break;
            }
            case 8: {
                RowContent rowContent = (RowContent)this.reportContent.createRowContent();
                rowContent.readContent(oi, this.loader);
                object = rowContent;
                break;
            }
            case 9: {
                TableBandContent tableBandContent = (TableBandContent)this.reportContent.createTableBandContent();
                tableBandContent.readContent(oi, this.loader);
                object = tableBandContent;
                break;
            }
            case 10: {
                TableContent tableContent = (TableContent)this.reportContent.createTableContent();
                tableContent.readContent(oi, this.loader);
                object = tableContent;
                break;
            }
            case 11: {
                TextContent textContent = (TextContent)this.reportContent.createTextContent();
                textContent.readContent(oi, this.loader);
                object = textContent;
                break;
            }
            case 12: {
                AutoTextContent autoText = (AutoTextContent)this.reportContent.createAutoTextContent();
                autoText.readContent(oi, this.loader);
                object = autoText;
                break;
            }
            case 13: {
                ListContent list = (ListContent)this.reportContent.createListContent();
                list.readContent(oi, this.loader);
                object = list;
                break;
            }
            case 14: {
                ListBandContent listBand = (ListBandContent)this.reportContent.createListBandContent();
                listBand.readContent(oi, this.loader);
                object = listBand;
            }
        }
        return object;
    }

    public IContent readContent() throws IOException {
        if (this.offset >= this.stream.length()) {
            return null;
        }
        ContentTreeCache.TreeEntry entry = this.contentCache.getEntry(this.offset);
        if (entry != null) {
            this.stream.seek(this.offset + 8L);
            int size = this.stream.readInt();
            this.offset = this.offset + 12L + (long)size;
            return (IContent)entry.value;
        }
        this.stream.seek(this.offset);
        long parentOffset = this.stream.readLong();
        int size = this.stream.readInt();
        byte[] buffer = new byte[size];
        this.stream.readFully(buffer, 0, size);
        DataInputStream oi = new DataInputStream(new ByteArrayInputStream(buffer));
        IContent content = this.readContent(oi);
        DocumentExtension docExt = new DocumentExtension(this.offset);
        content.setExtension(0, entry);
        if (parentOffset != -1L) {
            IContent parent = this.loadContent(parentOffset);
            content.setParent(parent);
        }
        this.offset = this.offset + 12L + (long)size;
        this.contentCache.addEntry(new ContentTreeCache.TreeEntry(docExt.getIndex(), parentOffset, this.offset, content));
        return content;
    }

    private IContent loadContent(long offset) throws IOException {
        ContentTreeCache.TreeEntry entry = this.contentCache.getEntry(offset);
        if (entry != null) {
            return (IContent)entry.value;
        }
        this.stream.seek(offset);
        long parentOffset = this.stream.readLong();
        int size = this.stream.readInt();
        byte[] buffer = new byte[size];
        this.stream.readFully(buffer, 0, size);
        DataInputStream oi = new DataInputStream(new ByteArrayInputStream(buffer));
        IContent content = this.readContent(oi);
        DocumentExtension docExt = new DocumentExtension(offset);
        content.setExtension(0, docExt);
        IContent parent = null;
        if (parentOffset != -1L) {
            parent = this.loadContent(parentOffset);
        }
        content.setParent(parent);
        offset = offset + 12L + (long)size;
        this.contentCache.addEntry(new ContentTreeCache.TreeEntry(docExt.getIndex(), parentOffset, offset, content));
        return content;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }
}

