/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.identity.gravatar;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Locale;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.mylyn.internal.commons.identity.gravatar.IGravatarConstants;
import org.eclipse.mylyn.internal.commons.identity.gravatar.IGravatarHashProvider;

public abstract class GravatarUtils {
    private static String digest(String value) {
        String hashed = null;
        try {
            byte[] input = value.getBytes("CP1252");
            byte[] digested = MessageDigest.getInstance("MD5").digest(input);
            hashed = new BigInteger(1, digested).toString(16);
            int padding = 32 - hashed.length();
            if (padding > 0) {
                char[] zeros = new char[padding];
                Arrays.fill(zeros, '0');
                hashed = String.valueOf(new String(zeros)) + hashed;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            hashed = null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            hashed = null;
        }
        return hashed;
    }

    public String getAdaptedHash(Object element) {
        String potentialHash;
        if (element == null) {
            return null;
        }
        String hash = null;
        IGravatarHashProvider provider = null;
        if (element instanceof IGravatarHashProvider) {
            provider = (IGravatarHashProvider)element;
        } else if (element instanceof IAdaptable) {
            provider = (IGravatarHashProvider)((IAdaptable)element).getAdapter(IGravatarHashProvider.class);
        }
        hash = provider != null ? provider.getGravatarHash() : (GravatarUtils.isValidHash(potentialHash = element.toString()) ? potentialHash : GravatarUtils.getHash(potentialHash));
        return hash;
    }

    public static boolean isValidHash(String hash) {
        return hash != null && hash.length() == 32 && IGravatarConstants.HASH_PATTERN.matcher(hash).matches();
    }

    public static String getHash(String email) {
        String hash = null;
        if (email != null && (email = email.trim().toLowerCase(Locale.US)).length() > 0) {
            hash = GravatarUtils.digest(email);
        }
        return hash;
    }

    public static boolean isValidEmail(String alias) {
        return alias != null && alias.contains("@");
    }
}

