/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.providers;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dnd.InsertInLayoutUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.AddStyleAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.AddThemeStyleAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.ApplyLayoutPreferenceAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.DeleteGroupAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.EditGroupAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertGroupActionFactory;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertGroupHeaderFooterAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.ResetImageOriginalSizeAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.DataEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.DummyEditpart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.GridEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ImageEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.LabelEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ListBandEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ListEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.MultipleEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.providers.ISchematicMenuListener;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedElementUIPoint;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtensionPointManager;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.EditpartExtensionManager;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.PaletteEntryExtension;
import org.eclipse.birt.report.designer.internal.ui.util.CategorizedElementSorter;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractViewAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.CopyAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.CutAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.DeleteAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.ExportToLibraryAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.ExtendElementAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.PasteAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.RefreshModuleHandleAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.actions.GeneralInsertMenuAction;
import org.eclipse.birt.report.designer.ui.actions.InsertAggregationAction;
import org.eclipse.birt.report.designer.ui.actions.InsertPasteColumnAction;
import org.eclipse.birt.report.designer.ui.actions.MenuUpdateAction;
import org.eclipse.birt.report.designer.ui.actions.NoneAction;
import org.eclipse.birt.report.designer.ui.extensions.IMenuBuilder;
import org.eclipse.birt.report.designer.ui.extensions.IReportItemViewProvider;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.views.ProviderFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.AbstractThemeHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TemplateReportItemHandle;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.ActionFactory;

public class SchematicContextMenuProvider
extends ContextMenuProvider {
    private static final String INSERT_ROW_MENU_ITEM_TEXT = Messages.getString((String)"SchematicContextMenuProvider.Menu.insertRow");
    private static final String EDIT_GROUP_MENU_ITEM_TEXT = Messages.getString((String)"SchematicContextMenuProvider.Menu.EditGroup");
    private static final String INSERT_GROUP_HEADER_FOOTER_ITEM_TEXT = Messages.getString((String)"SchematicContextMenuProvider.Menu.InsertGroupHeaderFooter");
    private static final String DELETE_GROUP_MENU_ITEM_TEXT = Messages.getString((String)"SchematicContextMenuProvider.Menu.DeleteGroup");
    private static final String STYLE_MENU_ITEM_TEXT = Messages.getString((String)"SchematicContextMenuProvider.Menu.Style");
    private static final String APPLY_STYLE_MENU_ITEM_TEXT = Messages.getString((String)"SchematicContextMenuProvider.Menu.Style.Apply");
    private static final String THEME_MENU_ITEM_TEXT = Messages.getString((String)"SchematicContextMenuProvider.Menu.Theme");
    private static final String APPLY_THEME_MENU_ITEM_TEXT = Messages.getString((String)"SchematicContextMenuProvider.Menu.Theme.Apply");
    private static final String INSERT_MENU_ITEM_TEXT = Messages.getString((String)"SchematicContextMenuProvider.Menu.Insert");
    private static final String ELEMENT_MENU_ITEM_TEXT = Messages.getString((String)"SchematicContextMenuProvider.Menu.insertElement");
    private static final String EDIT_STYLE_MENU_ITEM_TEXT = Messages.getString((String)"SchematicContextMenuProvider.Menu.EditStyle");
    private static final String DELETE_STYLE_MENU_ITEM_TEXT = Messages.getString((String)"SchematicContextMenuProvider.Menu.DeleteStyle");
    private static final String NEW_STYLE_MENU_ITEM_TEXT = Messages.getString((String)"SchematicContextMenuProvider.Menu.NewStyle");
    private static final String LAYOUT_PREF_MENU_TEXT = Messages.getString((String)"SchematicContextMenuProvider.Menu.Layout");
    private IMenuListener proxy;
    private final ActionRegistry actionRegistry;

    public SchematicContextMenuProvider(EditPartViewer viewer, ActionRegistry actionRegistry) {
        super(viewer);
        this.actionRegistry = actionRegistry;
    }

    public ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    protected IAction getAction(String actionID) {
        IAction action = this.getActionRegistry().getAction((Object)actionID);
        if (action instanceof UpdateAction) {
            ((UpdateAction)action).update();
        }
        return action;
    }

    protected ISelection getSelection() {
        return this.getViewer().getSelection();
    }

    protected List getSelectedObjects() {
        if (!(this.getSelection() instanceof IStructuredSelection)) {
            return Collections.EMPTY_LIST;
        }
        return ((IStructuredSelection)this.getSelection()).toList();
    }

    public void buildContextMenu(IMenuManager menuManager) {
        Separator separator;
        MenuManager insertMenu;
        if (this.proxy != null) {
            this.proxy.menuAboutToShow(menuManager);
            this.proxy = null;
            return;
        }
        GEFActionConstants.addStandardActionGroups((IMenuManager)menuManager);
        Object firstSelectedElement = this.getFirstElement();
        Object selectedElements = this.getSelectedElement();
        Object multiSelection = this.getMultiSelectedElement();
        boolean isExtended = false;
        if (firstSelectedElement instanceof IAdaptable && ((IAdaptable)firstSelectedElement).getAdapter(DesignElementHandle.class) instanceof ExtendedItemHandle) {
            isExtended = true;
        }
        if (selectedElements instanceof ReportDesignHandle) {
            this.createLayoutPrefMenu((ReportDesignHandle)selectedElements, menuManager, "org.eclipse.gef.group.view", ((ReportDesignHandle)selectedElements).getLayoutPreference());
        }
        if (this.isMutilSelection(multiSelection)) {
            AbstractViewAction action;
            menuManager.appendToGroup("org.eclipse.gef.group.undo", this.getAction(ActionFactory.UNDO.getId()));
            menuManager.appendToGroup("org.eclipse.gef.group.undo", this.getAction(ActionFactory.REDO.getId()));
            menuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)new CutAction(selectedElements));
            menuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)new CopyAction(selectedElements));
            menuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)new PasteAction(selectedElements));
            menuManager.appendToGroup("org.eclipse.gef.group.copy", this.getAction(ActionFactory.DELETE.getId()));
            if (this.isRootElementHandleClass(multiSelection)) {
                action = new RefreshModuleHandleAction(selectedElements);
                menuManager.add((IAction)action);
                this.createInsertElementMenu(menuManager, "org.eclipse.gef.group.edit");
                this.createThemeMenu(selectedElements, menuManager, "org.eclipse.gef.group.rest");
                action = new ExportToLibraryAction(selectedElements);
                menuManager.add((IAction)action);
            }
            if (this.isListHandleCalss(multiSelection)) {
                action = this.getAction("org.eclipse.birt.report.designer.ui.actions.CreatePlaceHolderAction");
                menuManager.appendToGroup("org.eclipse.gef.group.edit", (IAction)action);
            }
            this.createStyleMenu(menuManager, "org.eclipse.gef.group.rest");
            if (Policy.TRACING_MENU_SHOW) {
                System.out.println("Menu(for Editor) >> Shows for multi-selcetion.");
            }
        } else if (firstSelectedElement instanceof DesignElementHandle || isExtended) {
            menuManager.appendToGroup("org.eclipse.gef.group.undo", this.getAction(ActionFactory.UNDO.getId()));
            menuManager.appendToGroup("org.eclipse.gef.group.undo", this.getAction(ActionFactory.REDO.getId()));
            menuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)new CutAction(selectedElements));
            menuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)new CopyAction(selectedElements));
            menuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)new PasteAction(selectedElements));
            this.createStyleMenu(menuManager, "org.eclipse.gef.group.rest");
            if (((IStructuredSelection)this.getSelection()).size() == 1) {
                Object[] objs;
                IAction action;
                Object element = ((IStructuredSelection)this.getSelection()).getFirstElement();
                if (element instanceof LabelEditPart || element instanceof ImageEditPart) {
                    if (element instanceof DataEditPart) {
                        action = this.getAction("org.eclipse.birt.report.designer.ui.actions.ChangeDataColumnAction");
                        menuManager.appendToGroup("org.eclipse.gef.group.edit", action);
                    }
                    action = this.getAction("org.eclipse.gef.direct_edit");
                    action.setAccelerator(0x100000B);
                    if (element instanceof DataEditPart) {
                        action.setText(Messages.getString((String)"SchematicContextMenuProvider.ActionText.editData"));
                    } else {
                        action.setText(Messages.getString((String)"SchematicContextMenuProvider.ActionText.editLabel"));
                    }
                    menuManager.appendToGroup("org.eclipse.gef.group.edit", action);
                    if (element instanceof ImageEditPart) {
                        this.createImageMenu((ImageHandle)((ImageEditPart)element).getModel(), menuManager, "org.eclipse.gef.group.edit");
                    }
                }
                if (firstSelectedElement instanceof ReportItemHandle) {
                    action = this.getAction("org.eclipse.birt.report.designer.ui.actions.CreatePlaceHolderAction");
                    menuManager.appendToGroup("org.eclipse.gef.group.edit", action);
                }
                if (firstSelectedElement instanceof TemplateReportItemHandle) {
                    action = this.getAction("org.eclipse.birt.report.designer.internal.ui.views.actions.RevertToReportItemAction");
                    menuManager.appendToGroup("org.eclipse.gef.group.edit", action);
                }
                if ((objs = ElementAdapterManager.getAdapters(firstSelectedElement, IReportItemViewProvider.class)) != null && objs.length == 1) {
                    IAction action2 = this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.CreateChartAction");
                    menuManager.appendToGroup("org.eclipse.gef.group.view", action2);
                }
            }
            if (firstSelectedElement instanceof RowHandle) {
                if (this.getRowHandles().size() != 0) {
                    insertMenu = new MenuManager(INSERT_MENU_ITEM_TEXT);
                    MenuManager rowMenu = new MenuManager(INSERT_ROW_MENU_ITEM_TEXT);
                    rowMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertRowAboveAction"));
                    rowMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertRowBelowAction"));
                    RowHandle row = (RowHandle)this.getRowHandles().get(0);
                    if (!(row.getContainer() instanceof GridHandle)) {
                        insertMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.IncludeHeaderAction"));
                        insertMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.IncludeDetailAction"));
                        insertMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.IncludeFooterAction"));
                    }
                    insertMenu.add((IContributionItem)rowMenu);
                    menuManager.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)insertMenu);
                }
                menuManager.appendToGroup("org.eclipse.gef.group.copy", this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.DeleteRowAction"));
                menuManager.appendToGroup("org.eclipse.gef.group.edit", this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.Merge"));
                menuManager.appendToGroup("org.eclipse.gef.group.edit", this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.SplitAction"));
            } else if (firstSelectedElement instanceof ColumnHandle) {
                menuManager.appendToGroup("org.eclipse.gef.group.edit", (IAction)new InsertPasteColumnAction(selectedElements));
                if (this.getColumnHandles().size() != 0) {
                    MenuManager subMenu = new MenuManager(INSERT_MENU_ITEM_TEXT);
                    subMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertColumnRightAction"));
                    subMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertColumnLeftAction"));
                    menuManager.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)subMenu);
                }
                menuManager.appendToGroup("org.eclipse.gef.group.copy", this.getAction("DeleteGroupAction.DeleteColumnAction"));
                menuManager.appendToGroup("org.eclipse.gef.group.edit", this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.Merge"));
                menuManager.appendToGroup("org.eclipse.gef.group.edit", this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.SplitAction"));
            } else if (firstSelectedElement instanceof CellHandle) {
                this.createInsertElementMenu(menuManager, "org.eclipse.gef.group.edit");
                menuManager.appendToGroup("org.eclipse.gef.group.edit", this.getAction("org.eclipse.birt.report.designer.ui.command.copyCellContentsContextAction"));
                menuManager.appendToGroup("org.eclipse.gef.group.edit", this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.Merge"));
                menuManager.appendToGroup("org.eclipse.gef.group.edit", this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.SplitAction"));
                menuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)new DeleteAction(selectedElements));
            } else {
                menuManager.appendToGroup("org.eclipse.gef.group.copy", this.getAction(ActionFactory.DELETE.getId()));
            }
            menuManager.appendToGroup("org.eclipse.gef.group.edit", this.getAction("org.eclipse.birt.report.designer.ui.actions.ExportElementToLibraryAction"));
            if (Policy.TRACING_MENU_SHOW) {
                System.out.println("Menu(for Editor) >> Shows for " + ((DesignElementHandle)firstSelectedElement).getDefn().getDisplayName());
            }
        } else if (firstSelectedElement instanceof SlotHandle) {
            menuManager.appendToGroup("org.eclipse.gef.group.undo", this.getAction(ActionFactory.UNDO.getId()));
            menuManager.appendToGroup("org.eclipse.gef.group.undo", this.getAction(ActionFactory.REDO.getId()));
            menuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)new CutAction(selectedElements));
            menuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)new CopyAction(selectedElements));
            menuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)new PasteAction(selectedElements));
            menuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)new DeleteAction(selectedElements));
            this.createInsertElementMenu(menuManager, "org.eclipse.gef.group.edit");
            if (Policy.TRACING_MENU_SHOW) {
                System.out.println("Menu(for Editor) >> Shows for the slot " + ((SlotHandle)firstSelectedElement).getSlotID() + " of " + ((SlotHandle)firstSelectedElement).getElementHandle().getDefn().getDisplayName());
            }
        }
        if (!this.getTableEditParts().isEmpty() || !this.getTableMultipleEditParts().isEmpty()) {
            if (firstSelectedElement instanceof TableHandle) {
                insertMenu = new MenuManager(Messages.getString((String)"TableBandProvider.action.text.row"));
                insertMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.IncludeHeaderAction"));
                insertMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.IncludeDetailAction"));
                insertMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.IncludeFooterAction"));
                menuManager.appendToGroup("group.add", (IContributionItem)insertMenu);
            }
            this.createInsertGroupMenu(menuManager, "group.add");
            if (this.getTableEditParts().size() == 1 || this.getTableMultipleEditParts().size() == 1) {
                this.createDeleteGroupMenus(menuManager, "group.add");
                this.createEditGroupMenu(menuManager, "group.add");
                this.createInsertGroupHeaderFooter(menuManager, "group.add");
                separator = new Separator("org.eclipse.birt.report.designer.action.editBinding");
                menuManager.add((IContributionItem)separator);
                menuManager.appendToGroup("org.eclipse.birt.report.designer.action.editBinding", this.getAction("org.eclipse.birt.report.designer.action.editBinding"));
            }
        }
        if (!this.getListEditParts().isEmpty()) {
            this.createInsertGroupMenu(menuManager, "group.add");
            if (this.getListEditParts().size() == 1) {
                this.createDeleteGroupMenus(menuManager, "group.add");
                this.createEditGroupMenu(menuManager, "group.add");
                separator = new Separator("org.eclipse.birt.report.designer.action.editBinding");
                menuManager.add((IContributionItem)separator);
                menuManager.appendToGroup("org.eclipse.birt.report.designer.action.editBinding", this.getAction("org.eclipse.birt.report.designer.action.editBinding"));
            }
        }
        if (this.getElements().size() == 1 || this.isMutilSelection(multiSelection)) {
            Object[] menuAdapters;
            if (firstSelectedElement instanceof DesignElementHandle) {
                String elementName = ((DesignElementHandle)firstSelectedElement).getDefn().getName();
                IMenuBuilder menuBuilder = ExtensionPointManager.getInstance().getMenuBuilder(elementName);
                if (menuBuilder != null) {
                    menuBuilder.buildMenu(menuManager, this.getElements());
                }
            }
            if ((menuAdapters = ElementAdapterManager.getAdapters(firstSelectedElement, IMenuListener.class)) != null && menuAdapters.length > 0) {
                int i = 0;
                while (i < menuAdapters.length) {
                    if (menuAdapters[i] instanceof ISchematicMenuListener) {
                        ((ISchematicMenuListener)menuAdapters[i]).setActionRegistry(this.getActionRegistry());
                    }
                    ((IMenuListener)menuAdapters[i]).menuAboutToShow(menuManager);
                    ++i;
                }
            }
        }
    }

    private boolean isListHandleCalss(Object multiSelection) {
        return multiSelection == ListHandle.class;
    }

    private boolean isMutilSelection(Object multiSelection) {
        return multiSelection != null && (multiSelection == Object.class || multiSelection == DesignElementHandle.class || this.isRootElementHandleClass(multiSelection) || multiSelection == ReportItemHandle.class);
    }

    private boolean isRootElementHandleClass(Object obj) {
        return obj == ReportDesignHandle.class || obj == LibraryHandle.class;
    }

    private void createInsertGroupMenu(IMenuManager menuManager, String group_name) {
        DesignElementHandle container;
        RowHandle row;
        if ((this.getFirstElement() instanceof CellHandle || this.getFirstElement() instanceof RowHandle) && !((row = this.getFirstElement() instanceof CellHandle ? (RowHandle)((CellHandle)this.getFirstElement()).getContainer() : (RowHandle)this.getFirstElement()).getContainer() instanceof TableGroupHandle)) {
            int slotID = row.getContainerSlotHandle().getSlotID();
            menuManager.appendToGroup(group_name, (IAction)InsertGroupActionFactory.createInsertGroupAction(slotID, this.getSelectedObjects()));
            return;
        }
        if (this.getFirstElement() instanceof SlotHandle && !((container = ((SlotHandle)this.getFirstElement()).getElementHandle()) instanceof ListGroupHandle)) {
            int slotID = ((SlotHandle)this.getFirstElement()).getSlotID();
            menuManager.appendToGroup(group_name, (IAction)InsertGroupActionFactory.createInsertGroupAction(slotID, this.getSelectedObjects()));
            return;
        }
        MenuManager subMenu = new MenuManager(Messages.getString((String)"InsertGroupAction.actionMsg.group"));
        Action[] actions = InsertGroupActionFactory.getInsertGroupActions(this.getSelectedObjects());
        int i = 0;
        while (i < actions.length) {
            subMenu.add((IAction)actions[i]);
            ++i;
        }
        menuManager.appendToGroup(group_name, (IContributionItem)subMenu);
    }

    private void createInsertElementMenu(IMenuManager menuManager, String group_name) {
        MenuManager subMenu = new MenuManager(ELEMENT_MENU_ITEM_TEXT);
        IAction action = this.getAction("Insert Label");
        action.setText(GeneralInsertMenuAction.INSERT_LABEL_DISPLAY_TEXT);
        subMenu.add(action);
        action = this.getAction("Insert Text");
        action.setText(GeneralInsertMenuAction.INSERT_TEXT_DISPLAY_TEXT);
        subMenu.add(action);
        action = this.getAction("Insert Dynamic Text");
        action.setText(GeneralInsertMenuAction.INSERT_DYNAMIC_TEXT_DISPLAY_TEXT);
        subMenu.add(action);
        action = this.getAction("Insert Data");
        action.setText(GeneralInsertMenuAction.INSERT_DATA_DISPLAY_TEXT);
        subMenu.add(action);
        action = this.getAction("Insert Image");
        action.setText(GeneralInsertMenuAction.INSERT_IMAGE_DISPLAY_TEXT);
        subMenu.add(action);
        action = this.getAction("Insert Grid");
        action.setText(GeneralInsertMenuAction.INSERT_GRID_DISPLAY_TEXT);
        subMenu.add(action);
        action = this.getAction("Insert List");
        action.setText(GeneralInsertMenuAction.INSERT_LIST_DISPLAY_TEXT);
        subMenu.add(action);
        action = this.getAction("Insert Table");
        action.setText(GeneralInsertMenuAction.INSERT_TABLE_DISPLAY_TEXT);
        subMenu.add(action);
        CategorizedElementSorter<IAction> elementSorter = new CategorizedElementSorter<IAction>();
        List<ExtendedElementUIPoint> points = ExtensionPointManager.getInstance().getExtendedElementPoints();
        for (ExtendedElementUIPoint point : points) {
            IElementDefn extension = DEUtil.getMetaDataDictionary().getExtension(point.getExtensionName());
            action = this.getAction(point.getExtensionName());
            if (action == null) continue;
            String menuLabel = (String)point.getAttribute("menuLabel");
            action.setText(menuLabel == null ? extension.getDisplayName() : menuLabel);
            String category = (String)point.getAttribute("category");
            elementSorter.addElement(category, action);
        }
        PaletteEntryExtension[] entries = EditpartExtensionManager.getPaletteEntries();
        int i = 0;
        while (i < entries.length) {
            action = this.getAction(entries[i].getItemName());
            if (action != null) {
                action.setText(entries[i].getMenuLabel());
                String category = entries[i].getCategory();
                elementSorter.addElement(category, action);
            }
            ++i;
        }
        List actions = elementSorter.getSortedElements();
        Collections.sort(actions, new Comparator<IAction>(){

            @Override
            public int compare(IAction o1, IAction o2) {
                return Collator.getInstance().compare(o1.getText(), o2.getText());
            }
        });
        Iterator itr = actions.iterator();
        while (itr.hasNext()) {
            subMenu.add((IAction)itr.next());
        }
        subMenu.add((IContributionItem)new Separator());
        action = this.getAction("InsertAggregationAction");
        action.setText(InsertAggregationAction.TEXT);
        subMenu.add(action);
        menuManager.appendToGroup(group_name, (IContributionItem)subMenu);
    }

    private void createStyleMenu(IMenuManager menuManager, String group_name) {
        MenuManager menu = new MenuManager(STYLE_MENU_ITEM_TEXT);
        this.populateAddStyleAction(menu);
        menu.add((IContributionItem)new Separator());
        MenuManager subMenu = new MenuManager(EDIT_STYLE_MENU_ITEM_TEXT);
        subMenu.add((IAction)NoneAction.getInstance());
        subMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SchematicContextMenuProvider.this.updateDynamicItems("edit style menu", manager);
            }
        });
        menu.add((IContributionItem)subMenu);
        subMenu = new MenuManager(APPLY_STYLE_MENU_ITEM_TEXT);
        subMenu.add((IAction)NoneAction.getInstance());
        subMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SchematicContextMenuProvider.this.updateDynamicItems("apply style menu", manager);
            }
        });
        menu.add((IContributionItem)subMenu);
        subMenu = new MenuManager(DELETE_STYLE_MENU_ITEM_TEXT);
        subMenu.add((IAction)NoneAction.getInstance());
        subMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SchematicContextMenuProvider.this.updateDynamicItems("delete style menu", manager);
            }
        });
        menu.add((IContributionItem)subMenu);
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.views.actions.ImportCSSStyleAction"));
        menuManager.appendToGroup(group_name, (IContributionItem)menu);
        menuManager.appendToGroup(group_name, this.getAction("org.eclipse.birt.report.designer.internal.ui.views.actions.CopyFormatAction"));
        menuManager.appendToGroup(group_name, this.getAction("org.eclipse.birt.report.designer.internal.ui.views.actions.PasteFormatAction"));
    }

    private void populateAddStyleAction(MenuManager menu) {
        ModuleHandle module = SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (module instanceof ReportDesignHandle) {
            menu.add(this.getAction("AddStyleAction"));
        } else if (module instanceof LibraryHandle) {
            LibraryHandle libraryHandle = (LibraryHandle)module;
            MenuManager subMenu = new MenuManager(NEW_STYLE_MENU_ITEM_TEXT);
            SlotHandle themeSlot = libraryHandle.getThemes();
            for (Object obj : themeSlot.getContents()) {
                if (!(obj instanceof AbstractThemeHandle)) continue;
                subMenu.add((IAction)new AddThemeStyleAction((AbstractThemeHandle)obj, (AddStyleAction)this.getAction("AddStyleAction")));
            }
            menu.add((IContributionItem)subMenu);
        }
    }

    private void createLayoutPrefMenu(ReportDesignHandle handle, IMenuManager menuManager, String group_name, String layout) {
        MenuManager menu = new MenuManager(LAYOUT_PREF_MENU_TEXT, ReportPlatformUIImages.getImageDescriptor("LayoutPreference"), null);
        menu.add((IAction)new ApplyLayoutPreferenceAction(handle, "auto layout"));
        menu.add((IAction)new ApplyLayoutPreferenceAction(handle, "fixed layout"));
        menuManager.appendToGroup(group_name, (IContributionItem)menu);
    }

    private void createImageMenu(ImageHandle imageHandle, IMenuManager menuManager, String group_name) {
        MenuManager menu = new MenuManager(Messages.getString((String)"SchematicContextMenuProvider.label.ResetSize"));
        ResetImageOriginalSizeAction action = new ResetImageOriginalSizeAction(imageHandle, Messages.getString((String)"SchematicContextMenuProvider.label.RestToOrginalPixels"), 0);
        if (action.isEnabled()) {
            menu.add((IAction)action);
        }
        if ((action = new ResetImageOriginalSizeAction(imageHandle, Messages.getString((String)"SchematicContextMenuProvider.label.ResetToImageDPI"), 1)).isEnabled()) {
            menu.add((IAction)action);
        }
        if ((action = new ResetImageOriginalSizeAction(imageHandle, Messages.getString((String)"SchematicContextMenuProvider.label.ResetToReportDPI"), 2)).isEnabled()) {
            menu.add((IAction)action);
        }
        if ((action = new ResetImageOriginalSizeAction(imageHandle, Messages.getString((String)"SchematicContextMenuProvider.label.ResetToScreenDPI"), 3)).isEnabled()) {
            menu.add((IAction)action);
        }
        menuManager.appendToGroup(group_name, (IContributionItem)menu);
    }

    private void createThemeMenu(Object selectedObject, IMenuManager menuManager, String group_name) {
        MenuManager menu = new MenuManager(THEME_MENU_ITEM_TEXT);
        if (selectedObject instanceof LibraryHandle) {
            SlotHandle obj = ((LibraryHandle)selectedObject).getThemes();
            menu.add((IAction)new ExtendElementAction(ProviderFactory.createProvider(obj), "org.eclipse.birt.report.designer.internal.ui.action.NewReportItemThemeAction", (Object)obj, Messages.getString((String)"ThemesNodeProvider.action.New"), "Theme"));
        }
        MenuManager subMenu = new MenuManager(APPLY_THEME_MENU_ITEM_TEXT);
        subMenu.add((IAction)NoneAction.getInstance());
        subMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SchematicContextMenuProvider.this.updateDynamicItems("apply theme menu", manager);
            }
        });
        menu.add((IContributionItem)subMenu);
        menu.add((IContributionItem)new Separator());
        menuManager.appendToGroup(group_name, (IContributionItem)menu);
    }

    private void updateDynamicItems(String actionId, IMenuManager menu) {
        IAction action = this.getAction(actionId);
        if (action != null && action instanceof MenuUpdateAction) {
            ((MenuUpdateAction)action).updateMenu((MenuManager)menu);
        }
    }

    private void createEditGroupMenu(IMenuManager menuManager, String group_name) {
        DesignElementHandle container;
        if (this.getFirstElement() instanceof RowHandle && (container = ((RowHandle)this.getFirstElement()).getContainer()) instanceof TableGroupHandle) {
            EditGroupAction action = new EditGroupAction(null, (GroupHandle)((TableGroupHandle)container));
            action.setText(EDIT_GROUP_MENU_ITEM_TEXT);
            menuManager.appendToGroup(group_name, (IAction)action);
            return;
        }
        if (this.getFirstElement() instanceof SlotHandle && (container = ((SlotHandle)this.getFirstElement()).getElementHandle()) instanceof ListGroupHandle) {
            EditGroupAction action = new EditGroupAction(null, (GroupHandle)((ListGroupHandle)container));
            action.setText(EDIT_GROUP_MENU_ITEM_TEXT);
            menuManager.appendToGroup(group_name, (IAction)action);
            return;
        }
        MenuManager subMenu = new MenuManager(EDIT_GROUP_MENU_ITEM_TEXT);
        ListingHandle parentHandle = null;
        if (!this.getTableEditParts().isEmpty()) {
            parentHandle = (ListingHandle)((TableEditPart)this.getTableEditParts().get(0)).getModel();
        } else if (!this.getTableMultipleEditParts().isEmpty()) {
            parentHandle = (ListingHandle)((ReportElementEditPart)((Object)this.getTableMultipleEditParts().get(0))).getModel();
        } else if (!this.getListEditParts().isEmpty()) {
            parentHandle = (ListingHandle)((ListEditPart)((Object)this.getListEditParts().get(0))).getModel();
        } else {
            return;
        }
        SlotHandle handle = parentHandle.getGroups();
        for (GroupHandle groupHandle : handle) {
            subMenu.add((IAction)new EditGroupAction(null, groupHandle));
        }
        menuManager.appendToGroup(group_name, (IContributionItem)subMenu);
    }

    protected List getElements() {
        return InsertInLayoutUtil.editPart2Model(this.getSelection()).toList();
    }

    protected Object getSelectedElement() {
        Object[] array = this.getElements().toArray();
        if (array.length == 1) {
            return array[0];
        }
        return array;
    }

    protected Object getFirstElement() {
        Object[] array = this.getElements().toArray();
        if (array.length > 0) {
            return array[0];
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private Object getMultiSelectedElement() {
        block2: {
            list = this.getElements();
            baseHandle = list.get(0);
            if (baseHandle == null) break block2;
            base = baseHandle.getClass();
            i = 1;
            while (i < list.size()) {
                block3: {
                    obj = list.get(i);
                    if (!base.isInstance(obj)) ** GOTO lbl11
                    break block3;
lbl-1000:
                    // 1 sources

                    {
                        base = base.getSuperclass();
lbl11:
                        // 2 sources

                        ** while (!base.isInstance(obj))
                    }
                }
                ++i;
            }
            return base;
        }
        return null;
    }

    public List getRowHandles() {
        List list = this.getSelectedObjects();
        if (list.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> rowHandles = new ArrayList<Object>();
        int i = 0;
        while (i < list.size()) {
            Object obj = list.get(i);
            if (obj instanceof DummyEditpart && ((DummyEditpart)((Object)obj)).getModel() instanceof RowHandle) {
                rowHandles.add(((DummyEditpart)((Object)obj)).getModel());
            }
            ++i;
        }
        return rowHandles;
    }

    public List getColumnHandles() {
        List list = this.getSelectedObjects();
        if (list.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> columnHandles = new ArrayList<Object>();
        int i = 0;
        while (i < list.size()) {
            Object obj = list.get(i);
            if (obj instanceof DummyEditpart && ((DummyEditpart)((Object)obj)).getModel() instanceof ColumnHandle) {
                columnHandles.add(((DummyEditpart)((Object)obj)).getModel());
            }
            ++i;
        }
        return columnHandles;
    }

    private List getTableMultipleEditParts() {
        ArrayList tableParts = new ArrayList();
        for (Object obj : this.getSelectedObjects()) {
            if (obj instanceof DummyEditpart) continue;
            if (obj instanceof MultipleEditPart && ((MultipleEditPart)((Object)obj)).getModel() instanceof TableHandle) {
                if (tableParts.contains(obj)) continue;
                tableParts.add(obj);
                continue;
            }
            return Collections.EMPTY_LIST;
        }
        return tableParts;
    }

    protected List getTableEditParts() {
        ArrayList tableParts = new ArrayList();
        for (Object obj : this.getSelectedObjects()) {
            if (obj instanceof DummyEditpart) continue;
            if (obj instanceof TableEditPart) {
                if (obj instanceof GridEditPart) {
                    return Collections.EMPTY_LIST;
                }
                if (tableParts.contains(obj)) continue;
                tableParts.add(obj);
                continue;
            }
            if (obj instanceof TableCellEditPart) {
                TableEditPart parent2 = (TableEditPart)((TableCellEditPart)obj).getParent();
                TableEditPart parent = parent2;
                if (parent instanceof GridEditPart) {
                    return Collections.EMPTY_LIST;
                }
                if (tableParts.contains(parent)) continue;
                tableParts.add(parent);
                continue;
            }
            return Collections.EMPTY_LIST;
        }
        return tableParts;
    }

    protected List getListEditParts() {
        ArrayList listParts = new ArrayList();
        for (Object obj : this.getSelectedObjects()) {
            if (obj instanceof ListEditPart) {
                if (listParts.contains(obj)) continue;
                listParts.add(obj);
                continue;
            }
            if (obj instanceof ListBandEditPart) {
                ListEditPart parent2 = (ListEditPart)((ListBandEditPart)((Object)obj)).getParent();
                ListEditPart parent = parent2;
                if (listParts.contains((Object)parent)) continue;
                listParts.add(parent);
                continue;
            }
            return Collections.EMPTY_LIST;
        }
        return listParts;
    }

    private void createDeleteGroupMenus(IMenuManager menuManager, String group_name) {
        DesignElementHandle container;
        ReportElementEditPart editPart = null;
        if (this.getFirstElement() instanceof RowHandle && (container = ((RowHandle)this.getFirstElement()).getContainer()) instanceof TableGroupHandle) {
            editPart = this.getTableEditPart();
            DeleteGroupAction action = new DeleteGroupAction(editPart, (GroupHandle)((TableGroupHandle)container));
            action.setText(DELETE_GROUP_MENU_ITEM_TEXT);
            menuManager.appendToGroup(group_name, (IAction)action);
            return;
        }
        if (this.getFirstElement() instanceof SlotHandle && (container = ((SlotHandle)this.getFirstElement()).getElementHandle()) instanceof ListGroupHandle) {
            editPart = this.getListEditPart();
            DeleteGroupAction action = new DeleteGroupAction(editPart, (GroupHandle)((ListGroupHandle)container));
            action.setText(DELETE_GROUP_MENU_ITEM_TEXT);
            menuManager.appendToGroup(group_name, (IAction)action);
            return;
        }
        MenuManager subMenu = new MenuManager(DELETE_GROUP_MENU_ITEM_TEXT);
        ListingHandle parentHandle = null;
        if (!this.getTableEditParts().isEmpty()) {
            parentHandle = (ListingHandle)((TableEditPart)this.getTableEditParts().get(0)).getModel();
            editPart = (TableEditPart)this.getTableEditParts().get(0);
        } else if (!this.getTableMultipleEditParts().isEmpty()) {
            parentHandle = (ListingHandle)((ReportElementEditPart)((Object)this.getTableMultipleEditParts().get(0))).getModel();
            editPart = (ReportElementEditPart)((Object)this.getTableMultipleEditParts().get(0));
        } else if (!this.getListEditParts().isEmpty()) {
            parentHandle = (ListingHandle)((ListEditPart)((Object)this.getListEditParts().get(0))).getModel();
            editPart = (ListEditPart)((Object)this.getListEditParts().get(0));
        } else {
            return;
        }
        SlotHandle handle = parentHandle.getGroups();
        for (GroupHandle groupHandle : handle) {
            subMenu.add((IAction)new DeleteGroupAction(editPart, groupHandle));
        }
        menuManager.appendToGroup(group_name, (IContributionItem)subMenu);
    }

    protected TableEditPart getTableEditPart() {
        List list = this.getSelectedObjects();
        if (list.isEmpty()) {
            return null;
        }
        TableEditPart part = null;
        int i = 0;
        while (i < list.size()) {
            Object obj = list.get(i);
            if (obj instanceof TableEditPart) {
                part = (TableEditPart)obj;
            } else if (obj instanceof TableCellEditPart) {
                part = (TableEditPart)((TableCellEditPart)obj).getParent();
            }
            ++i;
        }
        return part;
    }

    protected ListEditPart getListEditPart() {
        List list = this.getSelectedObjects();
        if (list.isEmpty()) {
            return null;
        }
        ListEditPart part = null;
        int i = 0;
        while (i < list.size()) {
            Object obj = list.get(i);
            if (obj instanceof ListEditPart) {
                part = (ListEditPart)((Object)obj);
            } else if (obj instanceof ListBandEditPart) {
                part = (ListEditPart)((ListBandEditPart)((Object)obj)).getParent();
            }
            ++i;
        }
        return part;
    }

    private void createInsertGroupHeaderFooter(IMenuManager menuManager, String group_name) {
        DesignElementHandle container;
        MenuManager subMenu = new MenuManager(INSERT_GROUP_HEADER_FOOTER_ITEM_TEXT);
        if (this.getFirstElement() instanceof RowHandle && (container = ((RowHandle)this.getFirstElement()).getContainer()) instanceof TableGroupHandle) {
            TableGroupHandle groupHandle = (TableGroupHandle)container;
            subMenu.add((IAction)new InsertGroupHeaderFooterAction((GroupHandle)groupHandle, 1));
            subMenu.add((IAction)new InsertGroupHeaderFooterAction((GroupHandle)groupHandle, 2));
            menuManager.appendToGroup(group_name, (IContributionItem)subMenu);
            return;
        }
        if (this.getFirstElement() instanceof SlotHandle) {
            return;
        }
        ListingHandle parentHandle = null;
        if (!this.getTableEditParts().isEmpty()) {
            parentHandle = (ListingHandle)((TableEditPart)this.getTableEditParts().get(0)).getModel();
        } else if (!this.getTableMultipleEditParts().isEmpty()) {
            parentHandle = (ListingHandle)((ReportElementEditPart)((Object)this.getTableMultipleEditParts().get(0))).getModel();
        } else {
            return;
        }
        SlotHandle handle = parentHandle.getGroups();
        for (GroupHandle groupHandle : handle) {
            MenuManager groupMenu = new MenuManager(DEUtil.getEscapedMenuItemText((String)groupHandle.getDisplayLabel()));
            groupMenu.add((IAction)new InsertGroupHeaderFooterAction(groupHandle, 1));
            groupMenu.add((IAction)new InsertGroupHeaderFooterAction(groupHandle, 2));
            subMenu.add((IContributionItem)groupMenu);
        }
        menuManager.appendToGroup(group_name, (IContributionItem)subMenu);
    }

    public IMenuListener getProxy() {
        return this.proxy;
    }

    public void setProxy(IMenuListener proxy) {
        this.proxy = proxy;
    }
}

