/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButton;
import org.eclipse.birt.report.designer.internal.ui.dialogs.parameters.IHyperlinkParameter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.parameters.IHyperlinkParameterProvider;
import org.eclipse.birt.report.designer.internal.ui.dialogs.parameters.IReportHyperlinkParameter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.parameters.ReportHyperlinkParameter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.HyperlinkParameterBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.ProjectFileDialog;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.ui.widget.ComboBoxCellEditor;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.engine.api.EmitterInfo;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.api.ReportEngine;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.model.api.AbstractScalarParameterHandle;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ParamBinding;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperlinkBuilder
extends BaseDialog {
    private static final String TITLE = Messages.getString((String)"HyperlinkBuilder.DialogTitle");
    private static final String LABEL_SELECT_TYPE = Messages.getString((String)"HyperlinkBuilder.Label.SelectType");
    private static final String LABEL_LOCATION = Messages.getString((String)"HyperlinkBuilder.Label.Location");
    private static final String LABEL_TARGET = Messages.getString((String)"HyperlinkBuilder.Label.Target");
    private static final String LABEL_TOOLTIP = Messages.getString((String)"HyperlinkBuilder.Label.Tooltip");
    private static final String LABEL_BOOKMARK = Messages.getString((String)"HyperlinkBuilder.Label.Bookmark");
    private static final String LABEL_LINKED_EXPRESSION = Messages.getString((String)"HyperlinkBuilder.Label.LinkedExpression");
    private static final String LABEL_REPORT_PARAMETER = Messages.getString((String)"HyperlinkBuilder.Label.Parameters");
    private static final String RADIO_NONE = Messages.getString((String)"HyperlinkBuilder.Radio.None");
    private static final String RADIO_URI = Messages.getString((String)"HyperlinkBuilder.Radio.Uri");
    private static final String RADIO_BOOKMARK = Messages.getString((String)"HyperlinkBuilder.Radio.Bookmark");
    private static final String RADIO_DRILLTHROUGH = Messages.getString((String)"HyperlinkBuilder.Radio.DrillThrough");
    private static final String COLUMN_PARAMETER = Messages.getString((String)"HyperlinkBuilder.Column.Parameters");
    private static final String COLUMN_VALUE = Messages.getString((String)"HyperlinkBuilder.Column.Values");
    private static final String COLUMN_REQUIRED = Messages.getString((String)"HyperlinkBuilder.ParameterRequired");
    private static final String COLUMN_DATA_TYPE = Messages.getString((String)"HyperlinkBuilder.Column.DataType");
    private static final Image IMAGE_OPEN_FILE = ReportPlatformUIImages.getImage("Open file");
    private static final Image REQUIRED_ICON = ReportPlatformUIImages.getImage("Default");
    private static final Image ERROR_ICON = ReportPlatformUIImages.getImage("IMG_OBJS_ERROR_TSK");
    private static final String ERROR_MSG_REPORT_REQUIRED = Messages.getString((String)"HyperlinkBuilder.ErrorMessage.ReportReqired");
    private static final String ERROR_MSG_INVALID_REPORT = Messages.getString((String)"HyperlinkBuilder.ErrorMessage.InvalidReport");
    private static final String TOOLTIP_BROWSE_FILE = Messages.getString((String)"HyperlinkBuilder.BrowseForFile");
    private static final String[] STEPS = new String[]{"", Messages.getString((String)"HyperlinkBuilder.Step.1"), Messages.getString((String)"HyperlinkBuilder.Step.2"), Messages.getString((String)"HyperlinkBuilder.Step.3"), Messages.getString((String)"HyperlinkBuilder.Step.4"), Messages.getString((String)"HyperlinkBuilder.Step.5"), Messages.getString((String)"HyperlinkBuilder.Step.6")};
    private static final String REQUIED_MARK = "*";
    private static final IChoiceSet CHOICESET_TARGET = DEUtil.getMetaDataDictionary().getChoiceSet("targetNames");
    private ActionHandle inputHandle;
    private Composite displayArea;
    private String selectedType;
    private Button noneRadio;
    private Button uriRadio;
    private Button bookmarkRadio;
    private Button drillRadio;
    private Combo bookmarkChooser;
    private Combo targetChooser;
    private Text bookmarkEditor;
    private Text locationEditor;
    private CLabel messageLine;
    private Label toolTip;
    private TableViewer paramBindingTable;
    private ComboBoxCellEditor parameterChooser;
    private ArrayList<ParamBinding> paramBindingList = new ArrayList();
    private List<String> typeFilterList = new ArrayList<String>(2);
    private boolean bTargetEnabled = true;
    private boolean bTooltipEnabled = true;
    private ExpressionProvider provider;
    private Object targetReportHandle;
    private ArrayList<IHyperlinkParameter> paramList = new ArrayList();
    private HashMap<String, String> paramTypes = new HashMap();
    private IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList list = (ArrayList)inputElement;
            ArrayList elementsList = (ArrayList)list.clone();
            return elementsList.toArray();
        }
    };
    private ITableLabelProvider labelProvider = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            ParamBinding parameterBinding;
            boolean isRequired;
            if (columnIndex == 1 && (isRequired = HyperlinkBuilder.this.isParameterRequired((parameterBinding = (ParamBinding)element).getParamName()))) {
                return REQUIRED_ICON;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = null;
            ParamBinding parameterBinding = (ParamBinding)element;
            if (columnIndex == 0) {
                text = parameterBinding.getParamName();
            } else {
                if (columnIndex == 2) {
                    String name = parameterBinding.getParamName();
                    Object object = HyperlinkBuilder.this.getParameter(name);
                    if (object instanceof AbstractScalarParameterHandle) {
                        return HyperlinkBuilder.this.getDisplayDataType(((AbstractScalarParameterHandle)object).getDataType());
                    }
                    return "";
                }
                if (columnIndex == 3) {
                    text = parameterBinding.getExpression();
                }
            }
            if (text == null) {
                text = "";
            }
            return text;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    private Button reportDesignButton;
    private Button reportDocumentButton;
    private Text documentEditor;
    private Button targetBookmarkButton;
    private Button tocButton;
    private Button sameFrameButton;
    private Button newWindowButton;
    private Button wholePageButton;
    private Button parentFrameButton;
    private String[] supportedFormats;
    private Combo anchorChooser;
    private Combo targetFormatsChooser;
    private Button checkButton;
    private Group targetGroup;
    private boolean showBookMark = true;
    private boolean isIDE = false;
    private boolean isRelativeToProjectRoot = false;
    private Text tooltipText;
    private ScrolledComposite scrollContent;
    private Composite paramButtonContainer;
    private Button addParamButton;
    private Button editParamButton;
    private Button removeParamButton;
    private Button removeAllParamButton;

    public HyperlinkBuilder(Shell parentShell) {
        this(parentShell, false);
    }

    protected Object getParameter(String paramName) {
        if (this.paramList != null) {
            int i = 0;
            while (i < this.paramList.size()) {
                IHyperlinkParameter parameter = this.paramList.get(i);
                if (parameter.getName().equals(paramName) && parameter instanceof ReportHyperlinkParameter) {
                    return ((ReportHyperlinkParameter)parameter).getParameterHandle();
                }
                ++i;
            }
        }
        return null;
    }

    public HyperlinkBuilder() {
        this(UIUtil.getDefaultShell(), false);
    }

    public HyperlinkBuilder(Shell parentShell, boolean isIDE) {
        this(parentShell, isIDE, false);
    }

    public HyperlinkBuilder(Shell parentShell, boolean isIDE, boolean isRelativeToProjectRoot) {
        super(parentShell, TITLE);
        this.isIDE = isIDE;
        this.isRelativeToProjectRoot = isRelativeToProjectRoot;
    }

    public HyperlinkBuilder(boolean isIDE) {
        this(UIUtil.getDefaultShell(), isIDE);
    }

    public void showBookMark(boolean showBookMark) {
        this.showBookMark = showBookMark;
    }

    protected Control createDialogArea(Composite parent) {
        int height;
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createSelectionArea(composite);
        new Label(composite, 258).setLayoutData((Object)new GridData(768));
        this.scrollContent = new ScrolledComposite(composite, 768);
        this.scrollContent.setLayoutData((Object)new GridData(1808));
        this.scrollContent.setExpandHorizontal(true);
        this.scrollContent.setExpandVertical(true);
        this.scrollContent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                HyperlinkBuilder.this.computeSize();
            }
        });
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        int n = height = shell.getBounds().height < 710 ? shell.getBounds().height - 200 : 510;
        if (!this.bTargetEnabled) {
            height -= 70;
        }
        if (!this.bTooltipEnabled) {
            height -= 50;
        }
        GridData gd = new GridData(1808);
        gd.minimumWidth = 600;
        gd.minimumHeight = height;
        this.scrollContent.setLayoutData((Object)gd);
        this.displayArea = new Composite((Composite)this.scrollContent, 0);
        this.displayArea.setLayout((Layout)new GridLayout(3, false));
        this.displayArea.setLayoutData((Object)new GridData(1808));
        this.scrollContent.setContent((Control)this.displayArea);
        new Label(composite, 258).setLayoutData((Object)new GridData(768));
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.HyperlinkBuilder_ID");
        return composite;
    }

    protected void computeSize() {
        Point size = this.displayArea.computeSize(-1, -1);
        this.scrollContent.setMinSize(size.x, size.y + 10);
        this.scrollContent.layout();
    }

    private void createSelectionArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(2, false));
        new Label(composite, 0).setText(LABEL_SELECT_TYPE);
        if (!this.typeFilterList.contains("none")) {
            this.noneRadio = new Button(composite, 16);
            this.noneRadio.setText(RADIO_NONE);
            this.addRadioListener(this.noneRadio, "none");
        }
        if (!this.typeFilterList.contains("hyperlink")) {
            UIUtil.createBlankLabel(composite);
            this.uriRadio = new Button(composite, 16);
            this.uriRadio.setText(RADIO_URI);
            this.addRadioListener(this.uriRadio, "hyperlink");
        }
        if (!(SessionHandleAdapter.getInstance().getReportDesignHandle() instanceof LibraryHandle) && !this.typeFilterList.contains("bookmark-link") && this.showBookMark) {
            UIUtil.createBlankLabel(composite);
            this.bookmarkRadio = new Button(composite, 16);
            this.bookmarkRadio.setText(RADIO_BOOKMARK);
            this.addRadioListener(this.bookmarkRadio, "bookmark-link");
        }
        if (!this.typeFilterList.contains("drill-through")) {
            UIUtil.createBlankLabel(composite);
            this.drillRadio = new Button(composite, 16);
            this.drillRadio.setText(RADIO_DRILLTHROUGH);
            this.addRadioListener(this.drillRadio, "drill-through");
        }
    }

    public void addHyperlinkTypeFilter(String disabledType) {
        this.typeFilterList.add(disabledType);
    }

    public void setTargetEnabled(boolean bEnabled) {
        this.bTargetEnabled = bEnabled;
    }

    public void setTooltipEnabled(boolean bEnabled) {
        this.bTooltipEnabled = bEnabled;
    }

    private void switchTo(String type) {
        this.selectedType = type;
        this.clearArea();
        this.closeTargetReport();
        this.displayArea.setLayout((Layout)new GridLayout(3, false));
        if ("hyperlink".equals(type)) {
            this.switchToURI();
        } else if ("bookmark-link".equals(type) && this.showBookMark) {
            this.switchToBookmark();
        } else if ("drill-through".equals(type)) {
            this.switchToDrillthrough();
        }
        this.initDisplayArea();
        this.displayArea.layout();
        this.computeSize();
    }

    private void switchToURI() {
        new Label(this.displayArea, 0);
        new Label(this.displayArea, 0).setText(Messages.getString((String)"HyperlinkBuilder.Label.Location.hint"));
        new Label(this.displayArea, 0);
        new Label(this.displayArea, 0).setText(REQUIED_MARK + LABEL_LOCATION);
        this.locationEditor = new Text(this.displayArea, 2052);
        this.locationEditor.setLayoutData((Object)new GridData(768));
        this.locationEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HyperlinkBuilder.this.updateButtons();
            }
        });
        Composite buttonArea = new Composite(this.displayArea, 0);
        buttonArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        buttonArea.setLayoutData((Object)new GridData());
        this.createBrowerButton(buttonArea, this.locationEditor, true, false);
        this.createComplexExpressionButton(buttonArea, this.locationEditor);
        this.createTargetBar();
        this.createTooltipBar();
        this.locationEditor.forceFocus();
    }

    private void createTooltipBar() {
        if (this.bTooltipEnabled) {
            new Label(this.displayArea, 0).setText(LABEL_TOOLTIP);
            this.tooltipText = new Text(this.displayArea, 2048);
            this.tooltipText.setLayoutData((Object)new GridData(768));
            UIUtil.createBlankLabel(this.displayArea);
        }
    }

    private void switchToBookmark() {
        this.createBookmarkBar(true);
        this.createTooltipBar();
    }

    private void switchToDrillthrough() {
        this.displayArea.setLayout((Layout)new GridLayout());
        Composite container = new Composite(this.displayArea, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        this.messageLine = new CLabel(container, 0);
        this.messageLine.setLayoutData((Object)new GridData(768));
        this.createDrillthroughSelectTargetReport(container);
        this.createDrillthroughSelectTargetAnchor(container);
        this.createDrillthroughCreateLinkExpression(container);
        if (this.bTargetEnabled) {
            this.createDrillthroughSelectShowTarget(container);
        }
        this.createDrillthroughSelectFormat(container);
        if (this.bTooltipEnabled) {
            this.createDrillthroughTooltip(container);
        }
        container.setSize(container.computeSize(-1, -1));
    }

    private void createDrillthroughTooltip(Composite container) {
        Group formatsGroup = new Group(container, 0);
        formatsGroup.setLayoutData((Object)new GridData(768));
        formatsGroup.setText(String.valueOf(STEPS[6]) + Messages.getString((String)"HyperlinkBuilder.DrillThrough.Tooltip"));
        formatsGroup.setLayout((Layout)new GridLayout(2, false));
        this.toolTip = new Label((Composite)formatsGroup, 0);
        this.toolTip.setText(LABEL_TOOLTIP);
        this.tooltipText = new Text((Composite)formatsGroup, 2048);
        this.tooltipText.setLayoutData((Object)new GridData(768));
    }

    private void createDrillthroughSelectTargetReport(Composite container) {
        this.targetGroup = new Group(container, 0);
        this.targetGroup.setLayoutData((Object)new GridData(1808));
        this.targetGroup.setText(String.valueOf(STEPS[1]) + Messages.getString((String)"HyperlinkBuilder.DrillThrough.SelectTargetReport"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.targetGroup.setLayout((Layout)layout);
        this.reportDesignButton = new Button((Composite)this.targetGroup, 16);
        this.reportDesignButton.setText(Messages.getString((String)"HyperlinkBuilder.ReportDesignButton"));
        this.reportDesignButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HyperlinkBuilder.this.initTargetReport(HyperlinkBuilder.this.locationEditor.getText());
                HyperlinkBuilder.this.selectRadio((Composite)HyperlinkBuilder.this.targetGroup, HyperlinkBuilder.this.reportDesignButton);
                HyperlinkBuilder.this.initParamterBindings(false);
                HyperlinkBuilder.this.deSelectAnchor();
                HyperlinkBuilder.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.locationEditor = new Text((Composite)this.targetGroup, 2052);
        this.locationEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String target = HyperlinkBuilder.this.locationEditor.getText();
                HyperlinkBuilder.this.handleTargetReportChange(target);
            }
        });
        this.locationEditor.setLayoutData((Object)new GridData(768));
        this.createBrowerButton((Composite)this.targetGroup, this.locationEditor, false, true);
        this.reportDocumentButton = new Button((Composite)this.targetGroup, 16);
        this.reportDocumentButton.setText(Messages.getString((String)"HyperlinkBuilder.ReportDocumentButton"));
        this.reportDocumentButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HyperlinkBuilder.this.initTargetReport(HyperlinkBuilder.this.documentEditor.getText());
                HyperlinkBuilder.this.selectRadio((Composite)HyperlinkBuilder.this.targetGroup, HyperlinkBuilder.this.reportDocumentButton);
                HyperlinkBuilder.this.initParamterBindings(false);
                HyperlinkBuilder.this.deSelectAnchor();
                HyperlinkBuilder.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.documentEditor = new Text((Composite)this.targetGroup, 2052);
        this.documentEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String target = HyperlinkBuilder.this.documentEditor.getText();
                HyperlinkBuilder.this.handleTargetReportChange(target);
            }
        });
        this.documentEditor.setLayoutData((Object)new GridData(768));
        this.createBrowerButton((Composite)this.targetGroup, this.documentEditor, false, true, new String[]{"*.rptdocument"});
        this.createBindingTable((Composite)this.targetGroup);
    }

    private void createDrillthroughSelectTargetAnchor(Composite container) {
        Group group = new Group(container, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setText(String.valueOf(STEPS[2]) + Messages.getString((String)"HyperlinkBuilder.DrillThrough.SelectTargetAnchor"));
        group.setLayout((Layout)new GridLayout());
        this.targetBookmarkButton = new Button((Composite)group, 16);
        this.targetBookmarkButton.setText(Messages.getString((String)"HyperlinkBuilder.DrillThroughTargetBookmark"));
        this.targetBookmarkButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HyperlinkBuilder.this.initAnchorChooser(HyperlinkBuilder.this.targetReportHandle, false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.tocButton = new Button((Composite)group, 16);
        this.tocButton.setText(Messages.getString((String)"HyperlinkBuilder.DrillThroughTargetToc"));
        this.tocButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HyperlinkBuilder.this.initAnchorChooser(HyperlinkBuilder.this.targetReportHandle, true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.anchorChooser = new Combo((Composite)group, 2056);
        this.anchorChooser.setLayoutData((Object)new GridData(768));
        this.anchorChooser.setVisibleItemCount(30);
        this.anchorChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HyperlinkBuilder.this.anchorChooser.getData() instanceof List) {
                    List value = (List)HyperlinkBuilder.this.anchorChooser.getData();
                    HyperlinkBuilder.this.bookmarkEditor.setText((String)value.get(HyperlinkBuilder.this.anchorChooser.getSelectionIndex()));
                } else {
                    HyperlinkBuilder.this.bookmarkEditor.setText(HyperlinkBuilder.this.anchorChooser.getText());
                }
                HyperlinkBuilder.this.updateButtons();
            }
        });
    }

    private void createDrillthroughCreateLinkExpression(Composite container) {
        Group group = new Group(container, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setText(String.valueOf(STEPS[3]) + Messages.getString((String)"HyperlinkBuilder.DrillThrough.CreateLinkExpr"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        new Label((Composite)group, 0).setText(Messages.getString((String)"HyperlinkBuilder.DrillThroughLinkExpression"));
        this.bookmarkEditor = new Text((Composite)group, 2056);
        this.bookmarkEditor.setLayoutData((Object)new GridData(768));
        this.createExpressionButton((Composite)group, this.bookmarkEditor);
    }

    private void createDrillthroughSelectShowTarget(Composite container) {
        Group group = new Group(container, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setText(String.valueOf(STEPS[4]) + Messages.getString((String)"HyperlinkBuilder.DrillThrough.ShowTargetReport"));
        group.setLayout((Layout)new GridLayout(2, false));
        this.newWindowButton = new Button((Composite)group, 16);
        this.newWindowButton.setText(Messages.getString((String)"HyperlinkBuilder.DrillThroughNewWindow"));
        this.parentFrameButton = new Button((Composite)group, 16);
        this.parentFrameButton.setText(Messages.getString((String)"HyperlinkBuilder.DrillThroughParentFrame"));
        this.sameFrameButton = new Button((Composite)group, 16);
        this.sameFrameButton.setText(Messages.getString((String)"HyperlinkBuilder.DrillThroughSameFrame"));
        this.wholePageButton = new Button((Composite)group, 16);
        this.wholePageButton.setText(Messages.getString((String)"HyperlinkBuilder.DrillThroughWholePage"));
    }

    private void createDrillthroughSelectFormat(Composite container) {
        ReportEngine engine = new ReportEngine(new EngineConfig());
        this.supportedFormats = new String[0];
        EmitterInfo[] emitters = engine.getEmitterInfo();
        if (emitters != null && emitters.length > 0) {
            ArrayList<String> temp = new ArrayList<String>();
            int i = 0;
            while (i < emitters.length) {
                EmitterInfo info = emitters[i];
                if (!info.isHidden().booleanValue()) {
                    temp.add(info.getFormat());
                }
                ++i;
            }
            this.supportedFormats = temp.toArray(new String[temp.size()]);
        }
        Group formatsGroup = new Group(container, 0);
        formatsGroup.setLayoutData((Object)new GridData(768));
        formatsGroup.setText(String.valueOf(this.bTargetEnabled ? STEPS[5] : STEPS[4]) + Messages.getString((String)"HyperlinkBuilder.DrillThrough.SelectFormat"));
        formatsGroup.setLayout((Layout)new GridLayout(2, false));
        this.checkButton = new Button((Composite)formatsGroup, 32);
        this.checkButton.setText(Messages.getString((String)"HyperlinkBuilder.TargetReportFormat"));
        this.checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HyperlinkBuilder.this.targetFormatsChooser.setEnabled(((Button)e.widget).getSelection());
                if (!((Button)e.widget).getSelection() && HyperlinkBuilder.this.targetFormatsChooser.getSelectionIndex() != -1) {
                    HyperlinkBuilder.this.targetFormatsChooser.deselect(HyperlinkBuilder.this.targetFormatsChooser.getSelectionIndex());
                }
            }
        });
        this.targetFormatsChooser = new Combo((Composite)formatsGroup, 2056);
        this.targetFormatsChooser.setLayoutData((Object)new GridData(768));
        this.targetFormatsChooser.setVisibleItemCount(30);
        this.targetFormatsChooser.setItems(this.supportedFormats);
        this.targetFormatsChooser.setEnabled(false);
        this.targetFormatsChooser.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (HyperlinkBuilder.this.tocButton.getSelection() && HyperlinkBuilder.this.targetReportHandle instanceof IReportDocument) {
                    HyperlinkBuilder.this.initAnchorChooser(HyperlinkBuilder.this.targetReportHandle, true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createBindingTable(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(LABEL_REPORT_PARAMETER);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.paramBindingTable = new TableViewer(parent, 67588);
        Table table = this.paramBindingTable.getTable();
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.minimumHeight = 120;
        table.setLayoutData((Object)gd);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn parameterColumn = new TableColumn(table, 16384);
        parameterColumn.setText(COLUMN_PARAMETER);
        parameterColumn.setResizable(true);
        parameterColumn.setWidth(140);
        parameterColumn = new TableColumn(table, 0x1000000);
        parameterColumn.setText(COLUMN_REQUIRED);
        parameterColumn.setResizable(true);
        parameterColumn.setWidth(70);
        TableColumn dataTypeColumn = new TableColumn(table, 16384);
        dataTypeColumn.setText(COLUMN_DATA_TYPE);
        dataTypeColumn.setResizable(true);
        dataTypeColumn.setWidth(70);
        TableColumn valueColumn = new TableColumn(table, 16384);
        valueColumn.setText(COLUMN_VALUE);
        valueColumn.setResizable(true);
        valueColumn.setWidth(150);
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    HyperlinkBuilder.this.deleteRow();
                }
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                HyperlinkBuilder.this.editRow();
            }
        });
        this.paramBindingTable.setColumnProperties(new String[]{COLUMN_PARAMETER, COLUMN_REQUIRED, COLUMN_DATA_TYPE, COLUMN_VALUE});
        this.parameterChooser = new ComboBoxCellEditor((Composite)table, new String[0], 0);
        this.paramBindingTable.setContentProvider((IContentProvider)this.contentProvider);
        this.paramBindingTable.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.paramBindingTable.setInput(this.paramBindingList);
        this.paramBindingTable.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HyperlinkBuilder.this.updateParamBindingButtons();
            }
        });
        this.paramButtonContainer = new Composite(parent, 0);
        this.paramButtonContainer.setLayoutData((Object)new GridData(1040));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.paramButtonContainer.setLayout((Layout)layout);
        this.addParamButton = new Button(this.paramButtonContainer, 8);
        this.addParamButton.setText(Messages.getString((String)"HyperlinkBuilder.Button.AddParam"));
        gd = new GridData(768);
        gd.verticalAlignment = 0x1000008;
        gd.grabExcessVerticalSpace = true;
        this.addParamButton.setLayoutData((Object)gd);
        this.addParamButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HyperlinkParameterBuilder builder = new HyperlinkParameterBuilder(Messages.getString((String)"HyperlinkBuilder.ParamterBuilder.Add.Title"));
                builder.setHyperlinkBuilder(HyperlinkBuilder.this);
                builder.setActionHandle(HyperlinkBuilder.this.inputHandle);
                ArrayList avaliableList = HyperlinkBuilder.this.getAvailableParamList(null);
                builder.setItems(avaliableList.toArray(new String[0]));
                if (builder.open() == 0) {
                    HyperlinkBuilder.this.paramBindingList.add((ParamBinding)builder.getResult());
                    HyperlinkBuilder.this.refreshParamBindingTable();
                    HyperlinkBuilder.this.paramBindingTable.getTable().select(HyperlinkBuilder.this.paramBindingTable.getTable().getItemCount() - 1);
                    HyperlinkBuilder.this.updateParamBindingButtons();
                    HyperlinkBuilder.this.validateTables();
                }
            }
        });
        this.editParamButton = new Button(this.paramButtonContainer, 8);
        this.editParamButton.setText(Messages.getString((String)"HyperlinkBuilder.Button.EditParam"));
        gd = new GridData(768);
        this.editParamButton.setLayoutData((Object)gd);
        this.editParamButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HyperlinkBuilder.this.editRow();
                HyperlinkBuilder.this.updateParamBindingButtons();
                HyperlinkBuilder.this.validateTables();
            }
        });
        this.removeParamButton = new Button(this.paramButtonContainer, 8);
        this.removeParamButton.setText(Messages.getString((String)"HyperlinkBuilder.Button.RemoveParam"));
        gd = new GridData(768);
        this.removeParamButton.setLayoutData((Object)gd);
        this.removeParamButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HyperlinkBuilder.this.deleteRow();
                HyperlinkBuilder.this.updateParamBindingButtons();
                HyperlinkBuilder.this.validateTables();
            }
        });
        this.removeAllParamButton = new Button(this.paramButtonContainer, 8);
        this.removeAllParamButton.setText(Messages.getString((String)"HyperlinkBuilder.Button.RemoveAllParam"));
        gd = new GridData(768);
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 1;
        this.removeAllParamButton.setLayoutData((Object)gd);
        this.removeAllParamButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HyperlinkBuilder.this.paramBindingList.clear();
                HyperlinkBuilder.this.refreshParamBindingTable();
                HyperlinkBuilder.this.validateTables();
            }
        });
    }

    private void clearArea() {
        Control[] controls = this.displayArea.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].dispose();
            ++i;
        }
    }

    private void createExpressionButton(Composite parent, Text text) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                HyperlinkBuilder.this.updateButtons();
            }
        };
        ExpressionButtonUtil.createExpressionButton(parent, (Control)text, (IExpressionProvider)this.getExpressionProvider(), (Object)this.inputHandle.getElementHandle(), listener);
    }

    private void createComplexExpressionButton(Composite parent, Text text) {
        ExpressionButtonUtil.createExpressionButton(parent, (Control)text, this.getExpressionProvider(), this.inputHandle.getElementHandle(), true, 8);
    }

    protected void configureExpressionBuilder(ExpressionBuilder builder) {
        builder.setExpressionProvier(this.getExpressionProvider());
    }

    protected ExpressionProvider getExpressionProvider() {
        if (this.provider == null) {
            return new ExpressionProvider(this.inputHandle.getElementHandle());
        }
        return this.provider;
    }

    public void setExpressionProvider(ExpressionProvider provider) {
        this.provider = provider;
    }

    private Button createBrowerButton(Composite parent, Text text, boolean needQuote, boolean needFilter) {
        List<String> extensionList = ReportPlugin.getDefault().getReportExtensionNameList();
        String[] extensionNames = new String[extensionList.size()];
        int i = 0;
        while (i < extensionNames.length) {
            extensionNames[i] = "*." + extensionList.get(i);
            ++i;
        }
        return this.createBrowerButton(parent, text, needQuote, needFilter, extensionNames);
    }

    private Button createBrowerButton(Composite parent, final Text text, final boolean needQuote, final boolean needFilter, final String[] fileExt) {
        Button button = new Button(parent, 8);
        GridData gd = new GridData();
        if (!Platform.getOS().equals("macosx")) {
            gd.widthHint = 20;
            gd.heightHint = 20;
        }
        button.setLayoutData((Object)gd);
        button.setImage(IMAGE_OPEN_FILE);
        button.setToolTipText(TOOLTIP_BROWSE_FILE);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object dialog;
                boolean projectMode = false;
                String filename = null;
                if (!HyperlinkBuilder.this.isIDE || HyperlinkBuilder.this.getProjectFolder() == null) {
                    dialog = new FileDialog(UIUtil.getDefaultShell());
                    if (needFilter) {
                        dialog.setFilterExtensions(fileExt);
                    }
                    filename = dialog.open();
                } else {
                    projectMode = true;
                    dialog = needFilter ? new ProjectFileDialog(HyperlinkBuilder.this.getProjectFolder(), fileExt) : new ProjectFileDialog(HyperlinkBuilder.this.getProjectFolder());
                    if (dialog.open() == 0) {
                        filename = dialog.getPath();
                    }
                }
                try {
                    if (filename != null) {
                        File file = new File(filename);
                        if (!file.isFile() || !file.exists()) {
                            ExceptionHandler.openErrorMessageBox(Messages.getString((String)"HyperlinkBuilder.FileNameError.Title"), Messages.getString((String)"HyperlinkBuilder.FileNameError.Message"));
                            return;
                        }
                        filename = file.toURL().toString();
                        if (needFilter && !HyperlinkBuilder.this.checkExtensions(fileExt, filename)) {
                            ExceptionHandler.openErrorMessageBox(Messages.getString((String)"HyperlinkBuilder.FileNameError.Title"), Messages.getString((String)"HyperlinkBuilder.FileNameError.Message"));
                            return;
                        }
                        if (projectMode && HyperlinkBuilder.this.isRelativeToProjectRoot) {
                            filename = URIUtil.getRelativePath((String)HyperlinkBuilder.this.getProjectFolder(), (String)filename);
                            if (!filename.startsWith("/")) {
                                filename = "/" + filename;
                            }
                        } else {
                            filename = URIUtil.getRelativePath((String)HyperlinkBuilder.this.getBasePath(), (String)filename);
                        }
                        filename = new Path(filename).toString();
                        if (text.getData("exprButton") != null) {
                            text.setData("exprType", (Object)"constant");
                            ((ExpressionButton)text.getData("exprButton")).refresh();
                        } else if (needQuote) {
                            filename = "\"" + filename + "\"";
                        }
                        text.setText(filename);
                        text.setFocus();
                    }
                    HyperlinkBuilder.this.updateButtons();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle(ex);
                }
            }
        });
        return button;
    }

    private void createTargetBar() {
        if (this.bTargetEnabled) {
            new Label(this.displayArea, 0).setText(LABEL_TARGET);
            this.targetChooser = new Combo(this.displayArea, 2056);
            this.targetChooser.setLayoutData((Object)new GridData(768));
            this.targetChooser.setVisibleItemCount(30);
            this.targetChooser.setItems(ChoiceSetFactory.getDisplayNamefromChoiceSet(CHOICESET_TARGET));
            UIUtil.createBlankLabel(this.displayArea);
        }
    }

    private void createBookmarkBar(boolean isRequired) {
        String label = isRequired ? REQUIED_MARK + LABEL_BOOKMARK : LABEL_BOOKMARK;
        new Label(this.displayArea, 0).setText(label);
        this.bookmarkChooser = new Combo(this.displayArea, 2056);
        GridData gd = new GridData(768);
        this.bookmarkChooser.setLayoutData((Object)gd);
        this.bookmarkChooser.setVisibleItemCount(30);
        this.bookmarkChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Expression expr = (Expression)HyperlinkBuilder.this.bookmarkChooser.getData(HyperlinkBuilder.this.bookmarkChooser.getText());
                HyperlinkBuilder.this.bookmarkEditor.setText(expr.getStringExpression());
                HyperlinkBuilder.this.bookmarkEditor.setData("exprType", (Object)expr.getType());
                ExpressionButton exprButton = ExpressionButtonUtil.getExpressionButton((Control)HyperlinkBuilder.this.bookmarkEditor);
                if (exprButton != null) {
                    exprButton.refresh();
                }
                HyperlinkBuilder.this.updateButtons();
            }
        });
        new Label(this.displayArea, 0);
        new Label(this.displayArea, 0).setText(LABEL_LINKED_EXPRESSION);
        this.bookmarkEditor = new Text(this.displayArea, 2056);
        this.bookmarkEditor.setLayoutData((Object)new GridData(768));
        this.createExpressionButton(this.displayArea, this.bookmarkEditor);
    }

    public void setURI(String expr, String exprType) throws SemanticException {
        Expression expression = new Expression((Object)expr, exprType);
        this.inputHandle.setExpressionProperty("uri", expression);
    }

    public ExpressionHandle getURI() {
        return this.inputHandle.getExpressionProperty("uri");
    }

    protected void okPressed() {
        try {
            this.inputHandle.setToolTip(null);
            this.setURI(null, null);
            this.inputHandle.setTargetBookmark(null);
            this.inputHandle.setTargetBookmarkType(null);
            this.inputHandle.setTargetWindow(null);
            this.inputHandle.setTargetFileType(null);
            this.inputHandle.setReportName(null);
            this.inputHandle.setFormatType(null);
            this.inputHandle.getMember("paramBindings").setValue(null);
            if ("hyperlink".equals(this.selectedType)) {
                this.setURI(this.locationEditor.getText(), (String)this.locationEditor.getData("exprType"));
                if (this.bTargetEnabled) {
                    this.inputHandle.setTargetWindow(ChoiceSetFactory.getValueFromChoiceSet(this.targetChooser.getText(), CHOICESET_TARGET));
                }
                this.saveTooltip();
            } else if ("bookmark-link".equals(this.selectedType) && this.showBookMark) {
                ExpressionButtonUtil.saveExpressionButtonControl((Control)this.bookmarkEditor, this.inputHandle, "targetBookmark");
                this.saveTooltip();
            } else if ("drill-through".equals(this.selectedType)) {
                Iterator<ParamBinding> iter;
                if (this.reportDesignButton.getSelection()) {
                    this.inputHandle.setTargetFileType("report-design");
                    this.inputHandle.setReportName(this.locationEditor.getText());
                    iter = this.paramBindingList.iterator();
                    while (iter.hasNext()) {
                        this.inputHandle.addParamBinding(iter.next());
                    }
                } else if (this.reportDocumentButton.getSelection()) {
                    this.inputHandle.setTargetFileType("report-document");
                    this.inputHandle.setReportName(this.documentEditor.getText());
                    iter = this.paramBindingList.iterator();
                    while (iter.hasNext()) {
                        this.inputHandle.addParamBinding(iter.next());
                    }
                }
                if (!StringUtil.isBlank((String)this.bookmarkEditor.getText()) && !this.bookmarkEditor.getText().equals("---")) {
                    ExpressionButtonUtil.saveExpressionButtonControl((Control)this.bookmarkEditor, this.inputHandle, "targetBookmark");
                }
                if (this.targetBookmarkButton.getSelection()) {
                    this.inputHandle.setTargetBookmarkType("bookmark");
                } else if (this.tocButton.getSelection()) {
                    this.inputHandle.setTargetBookmarkType("toc");
                }
                if (this.bTargetEnabled) {
                    if (this.sameFrameButton.getSelection()) {
                        this.inputHandle.setTargetWindow("_self");
                    } else if (this.newWindowButton.getSelection()) {
                        this.inputHandle.setTargetWindow("_blank");
                    } else if (this.wholePageButton.getSelection()) {
                        this.inputHandle.setTargetWindow("_top");
                    } else if (this.parentFrameButton.getSelection()) {
                        this.inputHandle.setTargetWindow("_parent");
                    }
                }
                int index = this.targetFormatsChooser.getSelectionIndex();
                if (this.checkButton.getSelection() && index != -1) {
                    this.inputHandle.setFormatType(this.targetFormatsChooser.getItem(index));
                } else {
                    this.inputHandle.setFormatType(null);
                }
                this.saveTooltip();
            }
            this.inputHandle.setLinkType(this.selectedType);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
        this.setResult(this.inputHandle);
        super.okPressed();
    }

    private void saveTooltip() throws SemanticException {
        if (this.bTooltipEnabled) {
            if (this.tooltipText.getText().trim().length() == 0) {
                this.inputHandle.setToolTip(null);
            } else {
                this.inputHandle.setToolTip(this.tooltipText.getText().trim());
            }
        }
    }

    public boolean close() {
        this.closeTargetReport();
        return super.close();
    }

    public void setInput(ActionHandle input) {
        this.inputHandle = input;
    }

    @Override
    protected boolean initDialog() {
        this.switchTo(this.inputHandle.getLinkType());
        if ("hyperlink".equals(this.selectedType)) {
            this.uriRadio.setSelection(true);
        } else if ("bookmark-link".equals(this.selectedType) && this.showBookMark) {
            this.bookmarkRadio.setSelection(true);
        } else if ("drill-through".equals(this.selectedType)) {
            this.drillRadio.setSelection(true);
        } else {
            this.noneRadio.setSelection(true);
        }
        this.getShell().addListener(11, new Listener(){

            public void handleEvent(Event event) {
                GridData gd = (GridData)HyperlinkBuilder.this.scrollContent.getLayoutData();
                if (gd.horizontalAlignment != 4 || gd.verticalAlignment != 4) {
                    HyperlinkBuilder.this.scrollContent.setLayoutData((Object)new GridData(1808));
                }
                HyperlinkBuilder.this.scrollContent.layout(false, true);
                HyperlinkBuilder.this.displayArea.layout(false, true);
            }
        });
        return super.initDialog();
    }

    private void initDisplayArea() {
        if ("hyperlink".equals(this.selectedType)) {
            ExpressionHandle uri = this.getURI();
            this.locationEditor.setText(uri == null || uri.getExpression() == null ? "" : (String)uri.getExpression());
            this.locationEditor.setData("exprType", (Object)(uri == null || uri.getType() == null ? "constant" : uri.getType()));
            ExpressionButton button = (ExpressionButton)this.locationEditor.getData("exprButton");
            if (button != null) {
                button.refresh();
            }
            if (this.bTargetEnabled) {
                if (this.inputHandle.getTargetWindow() != null) {
                    this.targetChooser.setText(ChoiceSetFactory.getDisplayNameFromChoiceSet(this.inputHandle.getTargetWindow(), CHOICESET_TARGET));
                } else {
                    this.targetChooser.select(0);
                }
            }
            this.loadTooltip();
        } else if ("bookmark-link".equals(this.selectedType) && this.showBookMark) {
            if (this.inputHandle.getTargetBookmark() != null) {
                ExpressionButtonUtil.initExpressionButtonControl((Control)this.bookmarkEditor, this.inputHandle, "targetBookmark");
            }
            this.initBookmarkList(SessionHandleAdapter.getInstance().getReportDesignHandle());
            this.loadTooltip();
        } else if ("drill-through".equals(this.selectedType)) {
            if ("report-document".equals(this.inputHandle.getTargetFileType())) {
                this.reportDocumentButton.setSelection(true);
                if (this.inputHandle.getReportName() != null) {
                    this.documentEditor.setText(this.inputHandle.getReportName());
                }
                this.selectRadio((Composite)this.targetGroup, this.reportDocumentButton);
            } else {
                this.reportDesignButton.setSelection(true);
                this.selectRadio((Composite)this.targetGroup, this.reportDesignButton);
                if (this.inputHandle.getReportName() != null) {
                    this.locationEditor.setText(this.inputHandle.getReportName());
                }
            }
            if (this.inputHandle.getReportName() != null) {
                this.initTargetReport(this.inputHandle.getReportName());
            }
            if (this.reportDocumentButton.getSelection()) {
                this.handleTargetReportChange(this.documentEditor.getText());
            } else if (this.reportDesignButton.getSelection()) {
                this.initTargetReport(this.locationEditor.getText());
            }
            this.initParamterBindings(true);
            if ("bookmark".equals(this.inputHandle.getTargetBookmarkType())) {
                this.targetBookmarkButton.setSelection(true);
                this.initAnchorChooser(this.targetReportHandle, false);
            } else if ("toc".equals(this.inputHandle.getTargetBookmarkType())) {
                this.tocButton.setSelection(true);
                this.initAnchorChooser(this.targetReportHandle, true);
            }
            if (this.inputHandle.getTargetBookmark() != null) {
                ExpressionButtonUtil.initExpressionButtonControl((Control)this.bookmarkEditor, this.inputHandle, "targetBookmark");
            } else {
                this.bookmarkEditor.setText("---");
            }
            if (this.bTargetEnabled) {
                if ("_blank".equals(this.inputHandle.getTargetWindow())) {
                    this.newWindowButton.setSelection(true);
                } else if ("_self".equals(this.inputHandle.getTargetWindow())) {
                    this.sameFrameButton.setSelection(true);
                } else if ("_top".equals(this.inputHandle.getTargetWindow())) {
                    this.wholePageButton.setSelection(true);
                } else if ("_parent".equals(this.inputHandle.getTargetWindow())) {
                    this.parentFrameButton.setSelection(true);
                } else {
                    this.newWindowButton.setSelection(true);
                }
            }
            if (this.inputHandle.getFormatType() != null) {
                int index = 0;
                while (index < this.supportedFormats.length) {
                    if (this.supportedFormats[index].equals(this.inputHandle.getFormatType())) {
                        this.checkButton.setSelection(true);
                        this.targetFormatsChooser.setEnabled(true);
                        this.targetFormatsChooser.select(index);
                        break;
                    }
                    ++index;
                }
            }
            this.loadTooltip();
        }
        this.updateButtons();
    }

    private void loadTooltip() {
        if (this.bTooltipEnabled && this.inputHandle.getToolTip() != null) {
            this.tooltipText.setText(this.inputHandle.getToolTip());
        }
    }

    private void initParamterBindings(boolean first) {
        if (this.targetReportHandle != null) {
            this.paramList.clear();
            this.paramTypes.clear();
            String errorMessage = null;
            String newFilename = null;
            if (this.reportDesignButton.getSelection()) {
                newFilename = this.locationEditor.getText();
            } else if (this.reportDocumentButton.getSelection()) {
                newFilename = this.documentEditor.getText();
            }
            if (newFilename == null || newFilename.length() == 0) {
                errorMessage = ERROR_MSG_REPORT_REQUIRED;
            } else {
                ReportDesignHandle tmpReportDesign = null;
                if (this.targetReportHandle instanceof IReportDocument) {
                    tmpReportDesign = ((IReportDocument)this.targetReportHandle).getReportDesign();
                } else if (this.targetReportHandle instanceof ReportDesignHandle) {
                    tmpReportDesign = (ReportDesignHandle)this.targetReportHandle;
                }
                if (tmpReportDesign != null && (this.targetReportHandle instanceof ReportDesignHandle || this.targetReportHandle instanceof IReportDocument)) {
                    Map<String, List<IHyperlinkParameter>> hparams = this.getHyperlinkParameters(tmpReportDesign, null);
                    for (Map.Entry<String, List<IHyperlinkParameter>> ent : hparams.entrySet()) {
                        ent.getKey();
                        List<IHyperlinkParameter> hps = ent.getValue();
                        if (hps == null) continue;
                        for (IHyperlinkParameter hp : hps) {
                            if (hp instanceof ReportHyperlinkParameter && this.targetReportHandle instanceof IReportDocument) continue;
                            this.paramList.add(hp);
                            this.paramTypes.put(hp.getName(), hp.getDataType());
                        }
                    }
                }
            }
            if (errorMessage != null) {
                this.messageLine.setText(errorMessage);
                this.messageLine.setImage(ERROR_ICON);
            } else {
                this.messageLine.setText("");
                this.messageLine.setImage(null);
            }
            this.updateButtons();
        }
        if (first) {
            this.paramBindingList.clear();
            Iterator iter = this.inputHandle.paramBindingsIterator();
            while (iter.hasNext()) {
                ParamBindingHandle handle = (ParamBindingHandle)iter.next();
                this.paramBindingList.add((ParamBinding)handle.getStructure());
            }
        }
        this.paramBindingTable.getTable().setEnabled(this.messageLine.getText().length() == 0);
        this.refreshParamBindingTable();
        this.enableParamButtons(this.paramBindingTable.getTable().getEnabled());
    }

    private void enableParamButtons(boolean enabled) {
        this.paramButtonContainer.setEnabled(enabled);
        if (!enabled) {
            Control[] children = this.paramButtonContainer.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].setEnabled(false);
                ++i;
            }
        } else {
            this.updateParamBindingButtons();
        }
    }

    private Map<String, List<IHyperlinkParameter>> getHyperlinkParameters(ReportDesignHandle design, String format) {
        LinkedHashMap<String, List<IHyperlinkParameter>> result = new LinkedHashMap<String, List<IHyperlinkParameter>>();
        Object[] adapters = ElementAdapterManager.getAdapters(design, IHyperlinkParameterProvider.class);
        if (adapters != null) {
            Object[] objectArray = adapters;
            int n = adapters.length;
            int n2 = 0;
            while (n2 < n) {
                String[] categories;
                Object adapt = objectArray[n2];
                IHyperlinkParameterProvider paramProvider = (IHyperlinkParameterProvider)adapt;
                if (paramProvider != null && (categories = paramProvider.getCategories()) != null) {
                    String[] stringArray = categories;
                    int n3 = categories.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String cat = stringArray[n4];
                        IHyperlinkParameter[] params = paramProvider.getParameters(cat, format);
                        if (params != null) {
                            ArrayList<IHyperlinkParameter> buk = (ArrayList<IHyperlinkParameter>)result.get(cat);
                            if (buk == null) {
                                buk = new ArrayList<IHyperlinkParameter>();
                                result.put(cat, buk);
                            }
                            IHyperlinkParameter[] iHyperlinkParameterArray = params;
                            int n5 = params.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IHyperlinkParameter pm = iHyperlinkParameterArray[n6];
                                buk.add(pm);
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    private List<Object> getAllBookMarkExpressions(ReportDesignHandle reportDesignHandle) {
        ReportDesign reportDesign = (ReportDesign)reportDesignHandle.getModule();
        return reportDesign.collectPropValues(reportDesignHandle.getBody().getSlotID(), "bookmark");
    }

    private void initBookmarkList(Object handle) {
        this.bookmarkChooser.removeAll();
        if (handle != null && handle instanceof ReportDesignHandle) {
            List<Object> expressions = this.getAllBookMarkExpressions((ReportDesignHandle)handle);
            for (Object obj : expressions) {
                Expression expr = (Expression)obj;
                this.bookmarkChooser.add(expr.getStringExpression());
                this.bookmarkChooser.setData(expr.getStringExpression(), (Object)expr);
            }
            this.bookmarkChooser.setText(this.bookmarkEditor.getText());
        }
        this.bookmarkChooser.setEnabled(this.bookmarkChooser.getItemCount() > 0);
    }

    private void initAnchorChooser(Object handle, boolean isToc) {
        this.anchorChooser.removeAll();
        if (handle instanceof ReportDesignHandle) {
            ArrayList chooserItems = new ArrayList();
            if (isToc) {
                chooserItems.addAll(((ReportDesignHandle)handle).getAllTocs());
            } else {
                chooserItems.addAll(((ReportDesignHandle)handle).getAllBookmarks());
            }
            ArrayList<String> displayItems = new ArrayList<String>();
            displayItems.add(0, "---");
            int i = 0;
            while (i < chooserItems.size()) {
                displayItems.add(DEUtil.resolveNull((String)((String)chooserItems.get(i))));
                ++i;
            }
            this.anchorChooser.setItems(displayItems.toArray(new String[0]));
        } else if (handle instanceof IReportDocument) {
            if (isToc) {
                String format = "html";
                if (this.targetFormatsChooser.getSelectionIndex() != -1) {
                    format = this.supportedFormats[this.targetFormatsChooser.getSelectionIndex()];
                }
                ITOCTree tocTree = ((IReportDocument)handle).getTOCTree(format, SessionHandleAdapter.getInstance().getSessionHandle().getULocale());
                TOCNode rootTocNode = tocTree.getRoot();
                List<String> chooserItems = this.getAllTocDisplayString(rootTocNode);
                chooserItems.add(0, "---");
                this.anchorChooser.setItems(chooserItems.toArray(new String[0]));
            } else {
                this.anchorChooser.setItems(this.getDocumentBookmarks((IReportDocument)handle));
            }
        }
        this.bookmarkEditor.setText("");
        String bookmark = this.inputHandle.getTargetBookmark();
        String[] chooserValues = this.anchorChooser.getItems();
        if (bookmark != null && chooserValues != null) {
            int i = 0;
            while (i < chooserValues.length) {
                if (bookmark.equals(chooserValues[i])) {
                    this.anchorChooser.select(i);
                    this.bookmarkEditor.setText(this.anchorChooser.getText());
                    break;
                }
                ++i;
            }
        }
        this.anchorChooser.setEnabled(this.anchorChooser.getItemCount() > 0);
    }

    private String[] getDocumentBookmarks(IReportDocument rdoc) {
        List bookmarks = rdoc.getBookmarks();
        String[] bookmarkArray = new String[bookmarks.size() + 1];
        bookmarkArray[0] = "---";
        int i = 1;
        Iterator iter = bookmarks.iterator();
        while (iter.hasNext()) {
            bookmarkArray[i] = "\"" + iter.next() + "\"";
            ++i;
        }
        return bookmarkArray;
    }

    private List<String> getAllTocDisplayString(TOCNode parent) {
        ArrayList<String> tocList = new ArrayList<String>();
        if (parent.getParent() != null) {
            tocList.add("\"" + parent.getDisplayString() + "\"");
        }
        List childToc = parent.getChildren();
        for (TOCNode node : childToc) {
            tocList.addAll(this.getAllTocDisplayString(node));
        }
        return tocList;
    }

    private void addRadioListener(Button radio, final String type) {
        radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HyperlinkBuilder.this.selectedType != type) {
                    HyperlinkBuilder.this.switchTo(type);
                }
            }
        });
    }

    private void updateButtons() {
        boolean okEnable = true;
        if ("hyperlink".equals(this.selectedType)) {
            okEnable = !StringUtil.isBlank((String)this.locationEditor.getText());
        } else if ("bookmark-link".equals(this.selectedType) && this.showBookMark) {
            okEnable = !StringUtil.isBlank((String)this.bookmarkEditor.getText());
        } else if ("drill-through".equals(this.selectedType)) {
            okEnable = (!StringUtil.isBlank((String)this.locationEditor.getText()) || !StringUtil.isBlank((String)this.documentEditor.getText())) && this.messageLine.getText().length() == 0;
        }
        this.getOkButton().setEnabled(okEnable);
    }

    private void validateTables() {
        int i = 0;
        while (i < this.paramBindingList.size()) {
            int j = i + 1;
            while (j < this.paramBindingList.size()) {
                if (this.paramBindingList.get(i).getParamName().equals(this.paramBindingList.get(j).getParamName())) {
                    String errorMessage = Messages.getString((String)"HyperlinkBuilder.DrillThrough.ErrorMsg.DuplicateParameterName");
                    this.messageLine.setText(errorMessage);
                    this.messageLine.setImage(ERROR_ICON);
                    this.getOkButton().setEnabled(false);
                    return;
                }
                ++j;
            }
            ++i;
        }
        this.messageLine.setText("");
        this.messageLine.setImage(null);
        this.updateButtons();
    }

    private ArrayList<String> getAvailableParamList(String selectedParameter) {
        ArrayList<String> avaliableList = new ArrayList<String>();
        for (IHyperlinkParameter parameter : this.paramList) {
            avaliableList.add(parameter.getName());
        }
        for (ParamBinding paramBinding : this.paramBindingList) {
            if (paramBinding.getParamName().equals(selectedParameter)) continue;
            avaliableList.remove(paramBinding.getParamName());
        }
        return avaliableList;
    }

    private void deleteRow() {
        ParamBinding paramBinding = this.getSelectedBinding();
        if (paramBinding != null) {
            int index = this.paramBindingTable.getTable().getSelectionIndex();
            this.paramBindingList.remove(paramBinding);
            this.refreshParamBindingTable();
            if (this.paramBindingTable.getTable().getItemCount() <= index) {
                --index;
            }
            if (index >= 0) {
                this.paramBindingTable.getTable().select(index);
            }
        }
    }

    private void editRow() {
        ParamBinding paramBinding = this.getSelectedBinding();
        if (paramBinding == null) {
            return;
        }
        HyperlinkParameterBuilder builder = new HyperlinkParameterBuilder(Messages.getString((String)"HyperlinkBuilder.ParamterBuilder.Edit.Title"));
        builder.setHyperlinkBuilder(this);
        builder.setActionHandle(this.inputHandle);
        builder.setParamBinding(paramBinding);
        if (builder.open() == 0) {
            this.refreshParamBindingTable();
            this.validateTables();
        }
    }

    private ParamBinding getSelectedBinding() {
        IStructuredSelection selection = (IStructuredSelection)this.paramBindingTable.getSelection();
        if (selection.size() == 1) {
            return (ParamBinding)selection.getFirstElement();
        }
        return null;
    }

    private void closeTargetReport() {
        if (this.targetReportHandle instanceof ReportDesignHandle) {
            ((ReportDesignHandle)this.targetReportHandle).close();
        } else if (this.targetReportHandle instanceof IReportDocument) {
            ((IReportDocument)this.targetReportHandle).close();
        }
        this.targetReportHandle = null;
    }

    private void initTargetReport(String newFilename) {
        this.closeTargetReport();
        this.targetReportHandle = null;
        String errorMessage = null;
        if (newFilename.endsWith(".rptdocument")) {
            ReportEngine engine = new ReportEngine(new EngineConfig());
            try {
                this.targetReportHandle = engine.openReportDocument(this.resolvePath(newFilename));
            }
            catch (EngineException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                errorMessage = e.getMessage();
            }
        } else {
            try {
                this.targetReportHandle = SessionHandleAdapter.getInstance().getSessionHandle().openDesign(newFilename);
            }
            catch (DesignFileException designFileException) {
                try {
                    this.targetReportHandle = SessionHandleAdapter.getInstance().getSessionHandle().openDesign(this.resolvePath(newFilename));
                }
                catch (DesignFileException designFileException2) {
                    errorMessage = ERROR_MSG_INVALID_REPORT;
                }
            }
        }
        if (errorMessage != null) {
            this.messageLine.setText(errorMessage);
            this.messageLine.setImage(ERROR_ICON);
        } else {
            this.messageLine.setText("");
            this.messageLine.setImage(null);
        }
    }

    private String resolvePath(String file_path) {
        String rootPath = null;
        rootPath = file_path.startsWith("/") ? this.getProjectFolder() : this.getBasePath();
        return URIUtil.resolveAbsolutePath((String)rootPath, (String)file_path);
    }

    private String getBasePath() {
        String baseFile = SessionHandleAdapter.getInstance().getReportDesignHandle().getFileName();
        return new File(baseFile).getParent();
    }

    public void setInputString(String input, DesignElementHandle handle) throws DesignFileException {
        this.setInput(ModuleUtil.deserializeAction((String)input, (DesignElementHandle)handle));
    }

    public String getResultString() throws IOException {
        return ModuleUtil.serializeAction((ActionHandle)((ActionHandle)this.getResult()));
    }

    private void selectRadio(Composite container, Button radio) {
        if (!radio.getSelection()) {
            return;
        }
        Control[] children = container.getChildren();
        boolean isChoiceChild = false;
        int i = 0;
        while (i < children.length) {
            if (!(children[i] instanceof Label)) {
                if ((children[i].getStyle() & 0x10) != 0) {
                    isChoiceChild = children[i] == radio;
                } else if (!isChoiceChild) {
                    children[i].setEnabled(false);
                } else {
                    children[i].setEnabled(true);
                }
            }
            ++i;
        }
    }

    private void deSelectAnchor() {
        this.targetBookmarkButton.setSelection(false);
        this.tocButton.setSelection(false);
        this.anchorChooser.removeAll();
        this.bookmarkEditor.setText("");
    }

    protected boolean isParameterRequired(String paramName) {
        if (paramName == null) {
            return false;
        }
        if (this.paramList != null) {
            for (IHyperlinkParameter obj : this.paramList) {
                ParameterHandle paramHandle;
                if (!(obj instanceof IReportHyperlinkParameter) || !obj.getName().equals(paramName) || !((paramHandle = ((IReportHyperlinkParameter)obj).getParameterHandle()) instanceof AbstractScalarParameterHandle)) continue;
                return ((AbstractScalarParameterHandle)paramHandle).isRequired();
            }
        }
        return false;
    }

    private boolean checkExtensions(String[] fileExt, String fileName) {
        int i = 0;
        while (i < fileExt.length) {
            String ext = fileExt[i].substring(fileExt[i].lastIndexOf(46));
            if (fileName.toLowerCase().endsWith(ext.toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String getProjectFolder() {
        return UIUtil.getProjectFolder();
    }

    protected String getDisplayDataType(ParamBinding binding) {
        String name = binding.getParamName();
        String dataType = this.paramTypes.get(name);
        if (dataType == null) {
            return "";
        }
        return this.getDisplayDataType(dataType);
    }

    protected String getDisplayDataType(String dataType) {
        IChoiceSet DATA_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getElement("ScalarParameter").getProperty("dataType").getAllowedChoices();
        IChoice choice = DATA_TYPE_CHOICE_SET.findChoice(dataType);
        if (choice == null) {
            return "";
        }
        return choice.getDisplayName();
    }

    protected Expression getParamBindingExpression(ParamBinding param) {
        List expressions = param.getExpressionList();
        if (expressions == null || expressions.isEmpty()) {
            return null;
        }
        return (Expression)expressions.get(0);
    }

    private void handleTargetReportChange(String target) {
        this.closeTargetReport();
        this.initTargetReport(target);
        this.initParamterBindings(false);
        this.updateButtons();
        this.deSelectAnchor();
    }

    protected String getTargetReportFile() {
        if (this.targetReportHandle instanceof IReportDocument) {
            return ((IReportDocument)this.targetReportHandle).getReportDesign().getFileName();
        }
        if (this.targetReportHandle instanceof ReportDesignHandle) {
            return ((ReportDesignHandle)this.targetReportHandle).getFileName();
        }
        return null;
    }

    private void refreshParamBindingTable() {
        this.paramBindingTable.refresh();
        this.updateParamBindingButtons();
    }

    protected void updateParamBindingButtons() {
        this.editParamButton.setEnabled(this.getSelectedBinding() != null);
        this.removeParamButton.setEnabled(this.getSelectedBinding() != null);
        this.removeAllParamButton.setEnabled(this.paramBindingTable.getTable().getItemCount() > 0);
        this.addParamButton.setEnabled(this.getAvailableParamList(null).size() > 0);
    }
}

