/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelper;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelperProvider;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.dialogs.HyperlinkBuilder;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.model.api.AbstractScalarParameterHandle;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.elements.structures.ParamBinding;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class HyperlinkParameterBuilder
extends BaseDialog {
    public static final String HYPERLINK_PARAMETER = "HyperlinkParameter";
    public static final String TARGET_REPORT = "TargetReport";
    public static final String PARAMETER_HANDLE = "ParameterHandle";
    public static final String PARAMETER_VALUE = "ParameterValue";
    private String[] items;
    private Combo paramChooser;
    private HyperlinkBuilder hyperlinkBuilder;
    private Composite valueControl;
    private Label valueLabel;
    private Composite container;
    private ParamBinding paramBinding;
    private ActionHandle handle;
    private Text text;
    private IDialogHelper valueEditor;
    private Text typeValue;
    private Text requiredValue;

    public void setHyperlinkBuilder(HyperlinkBuilder hyperlinkBuilder) {
        this.hyperlinkBuilder = hyperlinkBuilder;
    }

    protected HyperlinkParameterBuilder(String title) {
        super(title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.container = new Composite(composite, 0);
        GridData gd = new GridData(1808);
        gd.minimumHeight = 80;
        this.container.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 10;
        this.container.setLayout((Layout)layout);
        new Label(this.container, 0).setText(Messages.getString((String)"HyperlinkParameterBuilder.Label.Parameter"));
        this.paramChooser = new Combo(this.container, 2048);
        gd = new GridData(768);
        gd.widthHint = 250;
        this.paramChooser.setLayoutData((Object)gd);
        this.paramChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HyperlinkParameterBuilder.this.updateValueControl();
            }
        });
        this.paramChooser.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HyperlinkParameterBuilder.this.updateValueControl();
                HyperlinkParameterBuilder.this.checkOkButton();
            }
        });
        Label requiredLabel = new Label(this.container, 0);
        requiredLabel.setText(Messages.getString((String)"HyperlinkParameterBuilder.Lable.Required"));
        this.requiredValue = new Text(this.container, 2056);
        gd = new GridData(768);
        this.requiredValue.setLayoutData((Object)gd);
        Label typeLabel = new Label(this.container, 0);
        typeLabel.setText(Messages.getString((String)"HyperlinkParameterBuilder.Label.DataType"));
        this.typeValue = new Text(this.container, 2056);
        gd = new GridData(768);
        this.typeValue.setLayoutData((Object)gd);
        this.valueLabel = new Label(this.container, 0);
        this.valueLabel.setText(Messages.getString((String)"HyperlinkParameterBuilder.Label.Value"));
        gd = new GridData();
        gd.exclude = true;
        this.valueLabel.setLayoutData((Object)gd);
        this.valueLabel.setVisible(false);
        this.populateComboBoxItems();
        return composite;
    }

    protected void updateValueControl() {
        if (this.hyperlinkBuilder != null) {
            Object object = this.hyperlinkBuilder.getParameter(this.paramChooser.getText());
            if (this.valueControl != null && !this.valueControl.isDisposed()) {
                this.valueControl.dispose();
            }
            if (object instanceof ScalarParameterHandle || object == null) {
                GridData gd = (GridData)this.valueLabel.getLayoutData();
                gd.exclude = false;
                this.valueLabel.setLayoutData((Object)gd);
                this.valueLabel.setVisible(true);
                this.valueControl = new Composite(this.container, 0);
                gd = new GridData(768);
                this.valueControl.setLayoutData((Object)gd);
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                layout.numColumns = 2;
                this.valueControl.setLayout((Layout)layout);
                this.text = new Text(this.valueControl, 2048);
                this.text.setLayoutData((Object)new GridData(768));
                this.text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        HyperlinkParameterBuilder.this.checkOkButton();
                    }
                });
                ExpressionButtonUtil.createExpressionButton(this.valueControl, (Control)this.text, this.hyperlinkBuilder.getExpressionProvider(), this.handle == null ? null : this.handle.getElementHandle());
                if (this.paramBinding != null) {
                    ExpressionButtonUtil.initExpressionButtonControl((Control)this.text, this.hyperlinkBuilder.getParamBindingExpression(this.paramBinding));
                    this.text.setFocus();
                }
                if (object instanceof ScalarParameterHandle) {
                    this.typeValue.setText(this.hyperlinkBuilder.getDisplayDataType(((ScalarParameterHandle)object).getDataType()));
                    this.requiredValue.setText(((ScalarParameterHandle)object).isRequired() ? Messages.getString((String)"HyperlinkParameterBuilder.Required.Choice.Yes") : Messages.getString((String)"HyperlinkParameterBuilder.Required.Choice.No"));
                } else {
                    this.typeValue.setText("");
                    this.requiredValue.setText("");
                }
            } else {
                if (object instanceof AbstractScalarParameterHandle) {
                    this.typeValue.setText(this.hyperlinkBuilder.getDisplayDataType(((AbstractScalarParameterHandle)object).getDataType()));
                    this.requiredValue.setText(((AbstractScalarParameterHandle)object).isRequired() ? Messages.getString((String)"HyperlinkParameterBuilder.Required.Choice.Yes") : Messages.getString((String)"HyperlinkParameterBuilder.Required.Choice.No"));
                }
                this.valueEditor = this.createValueEditor(this.container, object);
                if (this.valueEditor == null) {
                    GridData gd = (GridData)this.valueLabel.getLayoutData();
                    gd.exclude = true;
                    this.valueLabel.setLayoutData((Object)gd);
                    this.valueLabel.setVisible(false);
                } else {
                    GridData gd = (GridData)this.valueLabel.getLayoutData();
                    gd.exclude = false;
                    this.valueLabel.setLayoutData((Object)gd);
                    this.valueLabel.setVisible(true);
                    this.valueEditor.getControl().setLayoutData((Object)new GridData(768));
                    this.valueEditor.addListener(24, new Listener(){

                        public void handleEvent(Event event) {
                            HyperlinkParameterBuilder.this.checkOkButton();
                        }
                    });
                    this.valueEditor.setProperty(PARAMETER_HANDLE, object);
                    this.valueEditor.setProperty(TARGET_REPORT, this.hyperlinkBuilder.getTargetReportFile());
                    this.valueEditor.setProperty(PARAMETER_VALUE, this.paramBinding == null ? null : this.hyperlinkBuilder.getParamBindingExpression(this.paramBinding));
                    this.valueEditor.update(true);
                    this.valueControl = (Composite)this.valueEditor.getControl();
                    if (this.paramBinding != null) {
                        this.valueEditor.getControl().setFocus();
                    }
                }
            }
            this.container.layout();
        }
    }

    private IDialogHelper createValueEditor(Composite parent, Object parameter) {
        Object[] helperProviders = ElementAdapterManager.getAdapters(parameter, IDialogHelperProvider.class);
        if (helperProviders != null) {
            int i = 0;
            while (i < helperProviders.length) {
                IDialogHelper helper;
                IDialogHelperProvider helperProvider = (IDialogHelperProvider)helperProviders[i];
                if (helperProvider != null && (helper = helperProvider.createHelper((Object)this, HYPERLINK_PARAMETER)) != null) {
                    helper.createContent(parent);
                    return helper;
                }
                ++i;
            }
        }
        return null;
    }

    protected void okPressed() {
        if (this.paramBinding != null) {
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            if (this.text != null && !this.text.isDisposed()) {
                expressions.add(ExpressionButtonUtil.getExpression((Control)this.text));
                this.paramBinding.setExpression(expressions);
            } else if (this.valueEditor != null && !this.valueEditor.getControl().isDisposed()) {
                this.valueEditor.update(false);
                expressions.add((Expression)this.valueEditor.getProperty(PARAMETER_VALUE));
                this.paramBinding.setExpression(expressions);
            }
        } else {
            ParamBinding paramBinding = StructureFactory.createParamBinding();
            paramBinding.setParamName(this.paramChooser.getText());
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            if (this.text != null && !this.text.isDisposed()) {
                expressions.add(ExpressionButtonUtil.getExpression((Control)this.text));
                paramBinding.setExpression(expressions);
            } else if (this.valueEditor != null && !this.valueEditor.getControl().isDisposed()) {
                this.valueEditor.update(false);
                expressions.add((Expression)this.valueEditor.getProperty(PARAMETER_VALUE));
                paramBinding.setExpression(expressions);
            }
            this.setResult(paramBinding);
        }
        super.okPressed();
    }

    public void setParamBinding(ParamBinding paramBinding) {
        this.paramBinding = paramBinding;
        if (paramBinding != null) {
            this.items = new String[]{paramBinding.getParamName()};
        }
    }

    public void setItems(String[] items) {
        this.items = items;
    }

    private void populateComboBoxItems() {
        if (this.paramChooser != null && this.items != null) {
            this.paramChooser.removeAll();
            int i = 0;
            while (i < this.items.length) {
                this.paramChooser.add(this.items[i], i);
                ++i;
            }
            if (this.items.length > 0) {
                this.paramChooser.select(0);
                this.updateValueControl();
            }
            if (this.paramBinding != null) {
                this.paramChooser.setEnabled(false);
            }
        }
    }

    public void setActionHandle(ActionHandle handle) {
        this.handle = handle;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.checkOkButton();
        return control;
    }

    private void checkOkButton() {
        if (this.hyperlinkBuilder == null || this.getOkButton() == null) {
            return;
        }
        Object object = this.hyperlinkBuilder.getParameter(this.paramChooser.getText());
        if (object instanceof AbstractScalarParameterHandle) {
            if (((AbstractScalarParameterHandle)object).isRequired()) {
                if (this.text != null && !this.text.isDisposed()) {
                    this.getOkButton().setEnabled(this.text.getText().trim().length() != 0);
                } else if (this.valueEditor != null && !this.valueEditor.getControl().isDisposed()) {
                    Expression expression = (Expression)this.valueEditor.getProperty(PARAMETER_VALUE);
                    if (expression == null) {
                        this.getOkButton().setEnabled(false);
                    } else if (expression.getStringExpression() == null || expression.getStringExpression().trim().length() == 0) {
                        this.getOkButton().setEnabled(false);
                    } else {
                        this.getOkButton().setEnabled(true);
                    }
                }
            } else {
                this.getOkButton().setEnabled(true);
            }
        } else {
            this.getOkButton().setEnabled(true);
        }
    }
}

