/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.notifications;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.notifications.Environment;
import org.eclipse.mylyn.internal.tasks.core.notifications.FeedEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedReader {
    private final Environment environment;
    private final List<FeedEntry> entries;

    public FeedReader(Environment environment) {
        this.environment = environment;
        this.entries = new ArrayList<FeedEntry>();
    }

    public IStatus parse(InputStream in, IProgressMonitor monitor) {
        SyndFeedInput input = new SyndFeedInput();
        try {
            SyndFeed feed = input.build((Reader)new XmlReader(in));
            for (SyndEntry syndEntry : feed.getEntries()) {
                FeedEntry entry = new FeedEntry(syndEntry);
                if (!this.environment.matches(entry, monitor)) continue;
                this.entries.add(entry);
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.mylyn.tasks.core", 4, "Failed to parse RSS feed", (Throwable)e);
        }
    }

    public List<FeedEntry> getEntries() {
        return this.entries;
    }
}

