/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.io.File;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;

public class JarEntryFile
extends PlatformObject
implements IStorage {
    private ZipFile fZipFile;
    private String fEntryName;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public JarEntryFile(ZipFile zipFile, String entryName) {
        this.fZipFile = zipFile;
        this.fEntryName = entryName;
    }

    public InputStream getContents() throws CoreException {
        try {
            ZipEntry zipEntry = this.fZipFile.getEntry(this.fEntryName);
            return this.fZipFile.getInputStream(zipEntry);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.ui", 4, e.getMessage(), (Throwable)e));
        }
    }

    public IPath getFullPath() {
        return new Path(this.fEntryName);
    }

    public String getName() {
        return this.getFullPath().lastSegment();
    }

    public boolean isReadOnly() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.zip.ZipFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this.fZipFile;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.io.File");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz2)) {
            return new File(this.fZipFile.getName());
        }
        return super.getAdapter(adapter);
    }

    public String toString() {
        return "JarEntryFile[" + this.fZipFile.getName() + "::" + this.fEntryName + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JarEntryFile)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }
}

