/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.extension.render;

import java.util.LinkedList;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.withaxes.AxisSubUnit;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints3D;
import org.eclipse.birt.chart.computation.withaxes.StackedSeriesLookup;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.Line3DRenderEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.OvalRenderEvent;
import org.eclipse.birt.chart.event.Polygon3DRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.Text3DRenderEvent;
import org.eclipse.birt.chart.event.WrappedInstruction;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.AreaSeries;
import org.eclipse.birt.chart.model.type.DifferenceSeries;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.render.AxesRenderer;
import org.eclipse.birt.chart.render.CurveRenderer;
import org.eclipse.birt.chart.render.DeferredCache;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.script.AbstractScriptHandler;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.FillUtil;
import org.eclipse.emf.common.util.EList;

public class Line
extends AxesRenderer {
    protected static final ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine.extension/render");
    protected DeferredCache subDeferredCache;

    protected double computeStackPosition(AxisSubUnit au, double dValue, Axis ax) {
        if (ax.isPercent()) {
            dValue = au.valuePercentage(dValue);
        }
        return au.stackValue(dValue);
    }

    public void renderSeries(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        int iThisSeriesIndex;
        boolean bShowAsTape;
        LineSeries ls;
        double dSeriesThickness;
        try {
            this.validateDataSetCount(isrh);
        }
        catch (ChartException vex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)vex);
        }
        boolean bRendering3D = this.isDimension3D();
        if (bRendering3D && this.subDeferredCache == null) {
            this.dc = this.subDeferredCache = this.dc.deriveNewDeferredCache();
        }
        SeriesRenderingHints srh = null;
        SeriesRenderingHints3D srh3d = null;
        if (bRendering3D) {
            srh3d = (SeriesRenderingHints3D)isrh;
        } else {
            srh = (SeriesRenderingHints)isrh;
        }
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        logger.log(1, Messages.getString("info.render.series", new Object[]{this.getClass().getName(), this.iSeriesIndex + 1, this.iSeriesCount}, this.getRunTimeContext().getULocale()));
        Bounds boClientArea = isrh.getClientAreaBounds(true);
        double d = dSeriesThickness = bRendering3D ? 0.0 : srh.getSeriesThickness();
        if (cwa.getDimension() == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL) {
            boClientArea.delta(-dSeriesThickness, dSeriesThickness, 0.0, 0.0);
        }
        if (!(ls = (LineSeries)this.getSeries()).isVisible()) {
            this.restoreClipping(ipr);
            return;
        }
        ChartDimension cd = cwa.getDimension();
        AbstractScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        DataPointHints[] dpha = isrh.getDataPoints();
        this.validateNullDatapoint(dpha);
        double fX = 0.0;
        double fY = 0.0;
        double fZ = 0.0;
        double fWidth = 0.0;
        double fWidthZ = 0.0;
        double fHeight = 0.0;
        Location lo = null;
        Location3D lo3d = null;
        boolean isAreaSeries = this.getSeries() instanceof AreaSeries && !(this.getSeries() instanceof DifferenceSeries);
        boolean bl = bShowAsTape = cd.getValue() == 2 || isAreaSeries && cd.getValue() == 1;
        if (bShowAsTape) {
            bShowAsTape = this.validateShowAsTape();
        }
        Axis ax = this.getAxis();
        StackedSeriesLookup ssl = null;
        if (!bRendering3D) {
            ssl = srh.getStackedSeriesLookup();
        }
        LineAttributes lia = ls.getLineAttributes();
        double[] faX = new double[dpha.length];
        double[] faY = new double[dpha.length];
        double[] faZ = new double[dpha.length];
        SeriesDefinition sd = this.getSeriesDefinition();
        EList<Fill> elPalette = sd.getSeriesPalette().getEntries();
        if (elPalette.isEmpty()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.empty.palette", new Object[]{ls}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        boolean bPaletteByCategory = this.isPaletteByCategory();
        if (bPaletteByCategory && ls.eContainer() instanceof SeriesDefinition) {
            sd = (SeriesDefinition)ls.eContainer();
        }
        if ((iThisSeriesIndex = sd.getRunTimeSeries().indexOf(ls)) < 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.missing.series.for.palette.index", new Object[]{ls, sd}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        Marker m = null;
        if (ls.getMarkers().size() > 0) {
            m = (Marker)ls.getMarkers().get(iThisSeriesIndex % ls.getMarkers().size());
        }
        Fill fPaletteEntry = null;
        if (!bPaletteByCategory) {
            fPaletteEntry = FillUtil.getPaletteFill(elPalette, iThisSeriesIndex);
        } else if (this.iSeriesIndex > 0) {
            fPaletteEntry = FillUtil.getPaletteFill(elPalette, this.iSeriesIndex - 1);
        }
        this.updateTranslucency(fPaletteEntry, ls);
        double dTapeWidth = -1.0;
        double dUnitSpacingZ = 0.0;
        int i = 0;
        while (i < dpha.length) {
            double dEnd;
            double dValue;
            AxisSubUnit au;
            if (bRendering3D) {
                lo3d = dpha[i].getLocation3D();
                if (ChartUtil.mathEqual(dTapeWidth, -1.0)) {
                    double dUnitSpacing = !cwa.isSetUnitSpacing() ? 50.0 : cwa.getUnitSpacing();
                    dTapeWidth = dpha[i].getSize2D().getHeight() * (100.0 - dUnitSpacing) / 100.0;
                    dUnitSpacingZ = dpha[i].getSize2D().getHeight() * dUnitSpacing / 200.0;
                }
            } else {
                lo = dpha[i].getLocation();
            }
            if (cwa.isTransposed()) {
                if (srh.isCategoryScale()) {
                    fHeight = dpha[i].getSize();
                }
                faY[i] = fY = lo.getY() + fHeight / 2.0;
                if (ls.isStacked() || ax.isPercent()) {
                    au = ssl.getUnit(ls, i);
                    dValue = Line.isNaN(dpha[i].getOrthogonalValue()) ? 0.0 : (Double)dpha[i].getOrthogonalValue();
                    dEnd = this.computeStackPosition(au, dValue, ax);
                    try {
                        faX[i] = Math.floor(srh.getLocationOnOrthogonal(new Double(dEnd)));
                        dpha[i].setStackOrthogonalValue(new Double(dEnd));
                        if (faX[i] < srh.getPlotBaseLocation()) {
                            faX[i] = srh.getPlotBaseLocation();
                        }
                        au.setLastPosition(dValue, faX[i], 0.0);
                    }
                    catch (Exception ex) {
                        throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)ex);
                    }
                } else {
                    faX[i] = lo.getX();
                }
            } else {
                if (bRendering3D) {
                    fWidth = dpha[i].getSize2D().getWidth();
                    fWidthZ = dpha[i].getSize2D().getHeight();
                    fX = lo3d.getX() + fWidth / 2.0;
                    fZ = lo3d.getZ() + fWidthZ - dUnitSpacingZ;
                    faX[i] = fX;
                    faZ[i] = fZ;
                } else {
                    if (srh.isCategoryScale()) {
                        fWidth = dpha[i].getSize();
                    }
                    faX[i] = fX = lo.getX() + fWidth / 2.0;
                }
                if (ls.isStacked() || ax.isPercent()) {
                    if (bRendering3D) {
                        throw new ChartException("org.eclipse.birt.chart.engine.extension", 15, "exception.no.stack.percent.3D.chart", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                    }
                    au = ssl.getUnit(ls, i);
                    dValue = Line.isNaN(dpha[i].getOrthogonalValue()) ? 0.0 : ((Number)dpha[i].getOrthogonalValue()).doubleValue();
                    dEnd = this.computeStackPosition(au, dValue, ax);
                    try {
                        faY[i] = Math.floor(srh.getLocationOnOrthogonal(new Double(dEnd)));
                        dpha[i].setStackOrthogonalValue(new Double(dEnd));
                        au.setLastPosition(dValue, faY[i], 0.0);
                    }
                    catch (Exception ex) {
                        throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)ex);
                    }
                } else {
                    faY[i] = bRendering3D ? lo3d.getY() : lo.getY();
                }
                if (bRendering3D) {
                    double plotBaseLocation = srh3d.getPlotBaseLocation();
                    if (faY[i] < plotBaseLocation) {
                        faY[i] = plotBaseLocation;
                    }
                    if (faY[i] > plotBaseLocation + srh3d.getPlotHeight()) {
                        faY[i] = plotBaseLocation + srh3d.getPlotHeight();
                    }
                }
            }
            ++i;
        }
        if (!bRendering3D) {
            this.handleOutsideDataPoints(ipr, srh, faX, faY, bShowAsTape);
        }
        if (bRendering3D) {
            this.addComparsionPolygon(ipr, goFactory.createLocation3Ds(faX, faY, faZ), dpha);
        }
        if (ls.isCurve()) {
            this.renderAsCurve(ipr, ls.getLineAttributes(), bRendering3D ? srh3d : srh, bRendering3D ? goFactory.createLocation3Ds(faX, faY, faZ) : goFactory.createLocations(faX, faY), bShowAsTape, dTapeWidth, fPaletteEntry, ls.isPaletteLineColor());
            this.renderShadowAsCurve(ipr, lia, bRendering3D ? srh3d : srh, bRendering3D ? goFactory.createLocation3Ds(faX, faY, faZ) : goFactory.createLocations(faX, faY), bShowAsTape, dTapeWidth);
            if (m != null) {
                i = 0;
                while (i < dpha.length) {
                    if (!dpha[i].isOutside()) {
                        fPaletteEntry = bPaletteByCategory ? FillUtil.getPaletteFill(elPalette, i) : FillUtil.getPaletteFill(elPalette, iThisSeriesIndex);
                        this.updateTranslucency(fPaletteEntry, ls);
                        ScriptHandler.callFunction(sh, "beforeDrawElement", dpha[i], fPaletteEntry);
                        ScriptHandler.callFunction(sh, "beforeDrawDataPoint", dpha[i], fPaletteEntry, this.getRunTimeContext().getScriptContext());
                        this.getRunTimeContext().notifyStructureChange("beforeDrawElement", dpha[i]);
                        this.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", dpha[i]);
                        this.renderMarker(ls, ipr, m, bRendering3D ? goFactory.createLocation3D(faX[i], faY[i], faZ[i]) : goFactory.createLocation(faX[i], faY[i]), ls.getLineAttributes(), fPaletteEntry, dpha[i], null, true, true);
                        ScriptHandler.callFunction(sh, "afterDrawElement", dpha[i], fPaletteEntry);
                        ScriptHandler.callFunction(sh, "afterDrawDataPoint", dpha[i], fPaletteEntry, this.getRunTimeContext().getScriptContext());
                        this.getRunTimeContext().notifyStructureChange("afterDrawElement", dpha[i]);
                        this.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", dpha[i]);
                    }
                    ++i;
                }
            }
        } else {
            this.renderShadow(ipr, p, lia, bRendering3D ? goFactory.createLocation3Ds(faX, faY, faZ) : goFactory.createLocations(faX, faY), bShowAsTape, dpha);
            this.renderDataPoints(ipr, p, bRendering3D ? srh3d : srh, dpha, lia, bRendering3D ? goFactory.createLocation3Ds(faX, faY, faZ) : goFactory.createLocations(faX, faY), bShowAsTape, dTapeWidth, fPaletteEntry, ls.isPaletteLineColor());
            if (m != null) {
                i = 0;
                while (i < dpha.length) {
                    fPaletteEntry = bPaletteByCategory ? FillUtil.getPaletteFill(elPalette, i) : FillUtil.getPaletteFill(elPalette, iThisSeriesIndex);
                    this.updateTranslucency(fPaletteEntry, ls);
                    ScriptHandler.callFunction(sh, "beforeDrawElement", dpha[i], fPaletteEntry);
                    ScriptHandler.callFunction(sh, "beforeDrawDataPoint", dpha[i], fPaletteEntry, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawElement", dpha[i]);
                    this.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", dpha[i]);
                    this.renderMarker(ls, ipr, m, bRendering3D ? goFactory.createLocation3D(faX[i], faY[i], faZ[i]) : goFactory.createLocation(faX[i], faY[i]), ls.getLineAttributes(), fPaletteEntry, dpha[i], null, true, true);
                    ScriptHandler.callFunction(sh, "afterDrawElement", dpha[i], fPaletteEntry);
                    ScriptHandler.callFunction(sh, "afterDrawDataPoint", dpha[i], fPaletteEntry, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawElement", dpha[i]);
                    this.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", dpha[i]);
                    ++i;
                }
            }
        }
        Label laDataPoint = null;
        Position pDataPoint = null;
        Location loDataPoint = null;
        Location3D loDataPoint3d = null;
        try {
            if (bRendering3D) {
                laDataPoint = srh3d.getLabelAttributes(ls);
                if (laDataPoint.isVisible()) {
                    pDataPoint = srh3d.getLabelPosition(ls);
                    loDataPoint3d = goFactory.createLocation3D(0.0, 0.0, 0.0);
                }
            } else {
                laDataPoint = srh.getLabelAttributes(ls);
                if (laDataPoint.isVisible()) {
                    pDataPoint = srh.getLabelPosition(ls);
                    loDataPoint = goFactory.createLocation(0.0, 0.0);
                }
            }
        }
        catch (Exception ex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)ex);
        }
        if (laDataPoint.isVisible()) {
            double dSize = m == null ? 0 : m.getSize();
            int i2 = 0;
            while (i2 < dpha.length) {
                if (!Line.isNaN(dpha[i2].getOrthogonalValue()) && !dpha[i2].isOutside()) {
                    laDataPoint = bRendering3D ? srh3d.getLabelAttributes(ls) : srh.getLabelAttributes(ls);
                    laDataPoint.getCaption().setValue(dpha[i2].getDisplayValue());
                    ScriptHandler.callFunction(sh, "beforeDrawDataPointLabel", dpha[i2], laDataPoint, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawDataPointLabel", laDataPoint);
                    if (laDataPoint.isVisible()) {
                        if (bRendering3D) {
                            switch (pDataPoint.getValue()) {
                                case 0: {
                                    loDataPoint3d.set(faX[i2], faY[i2] + dSize + (double)p.getVerticalSpacing(), faZ[i2] + 1.0);
                                    break;
                                }
                                case 1: {
                                    loDataPoint3d.set(faX[i2], faY[i2] - dSize - (double)p.getVerticalSpacing(), faZ[i2] + 1.0);
                                    break;
                                }
                                case 2: {
                                    loDataPoint3d.set(faX[i2] - dSize - (double)p.getHorizontalSpacing(), faY[i2], faZ[i2] + 1.0);
                                    break;
                                }
                                case 3: {
                                    loDataPoint3d.set(faX[i2] + dSize + (double)p.getHorizontalSpacing(), faY[i2], faZ[i2] + 1.0);
                                    break;
                                }
                                default: {
                                    throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.illegal.datapoint.position.line", new Object[]{pDataPoint.getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                                }
                            }
                            Text3DRenderEvent tre3d = ((EventObjectCache)((Object)ipr)).getEventObject(WrappedStructureSource.createSeriesDataPoint(ls, dpha[i2]), Text3DRenderEvent.class);
                            tre3d.setAction(2);
                            tre3d.setLabel(laDataPoint);
                            tre3d.setTextPosition(Methods.getLabelPosition(pDataPoint));
                            tre3d.setLocation3D(loDataPoint3d);
                            this.getDeferredCache().addLabel(tre3d);
                        } else {
                            switch (pDataPoint.getValue()) {
                                case 0: {
                                    loDataPoint.set(faX[i2], faY[i2] - dSize - (double)p.getVerticalSpacing());
                                    break;
                                }
                                case 1: {
                                    loDataPoint.set(faX[i2], faY[i2] + dSize + (double)p.getVerticalSpacing());
                                    break;
                                }
                                case 2: {
                                    loDataPoint.set(faX[i2] - dSize - (double)p.getHorizontalSpacing(), faY[i2]);
                                    break;
                                }
                                case 3: {
                                    loDataPoint.set(faX[i2] + dSize + (double)p.getHorizontalSpacing(), faY[i2]);
                                    break;
                                }
                                default: {
                                    throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.illegal.datapoint.position.line", new Object[]{pDataPoint.getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                                }
                            }
                            this.renderLabel(WrappedStructureSource.createSeriesDataPoint(ls, dpha[i2]), 2, laDataPoint, pDataPoint, loDataPoint, null);
                        }
                    }
                    ScriptHandler.callFunction(sh, "afterDrawDataPointLabel", dpha[i2], laDataPoint, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawDataPointLabel", laDataPoint);
                }
                ++i2;
            }
        }
        if (!bRendering3D && this.getSeries().getCurveFitting() != null) {
            Location[] larray = new Location[faX.length];
            int i3 = 0;
            while (i3 < larray.length) {
                larray[i3] = goFactory.createLocation(faX[i3], faY[i3]);
                ++i3;
            }
            larray = Line.filterNull(larray, isrh.getDataPoints());
            this.renderFittingCurve(ipr, larray, this.getSeries().getCurveFitting(), false, true);
        }
        if (!bRendering3D) {
            this.restoreClipping(ipr);
        }
    }

    protected boolean validateShowAsTape() {
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        LineSeries ls = (LineSeries)this.getSeries();
        if (!ls.isStacked()) {
            if (this.getSeriesCount() > 2 && !this.isDimension3D()) {
                return false;
            }
        } else {
            Axis[] axaOrthogonal = cwa.getOrthogonalAxes(cwa.getBaseAxes()[0], true);
            if (axaOrthogonal.length > 1) {
                return false;
            }
            if (this.getSeriesCount() > 2 && !this.isDimension3D()) {
                return false;
            }
        }
        return true;
    }

    public void renderLegendGraphic(IPrimitiveRenderer ipr, Legend lg, Fill fPaletteEntry, Bounds bo) throws ChartException {
        double height;
        double width;
        int markerSize;
        int iThisSeriesIndex;
        if (bo.getWidth() == 0.0 && bo.getHeight() == 0.0) {
            return;
        }
        ClientArea ca = lg.getClientArea();
        LineAttributes lia = ca.getOutline();
        LineSeries ls = (LineSeries)this.getSeries();
        if (fPaletteEntry == null) {
            fPaletteEntry = goFactory.RED();
        }
        RectangleRenderEvent rre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createLegend(lg), RectangleRenderEvent.class);
        rre.setBackground(ca.getBackground());
        rre.setOutline(lia);
        rre.setBounds(bo);
        ipr.fillRectangle(rre);
        LineAttributes liaMarker = ls.getLineAttributes();
        if (liaMarker.isVisible()) {
            LineRenderEvent lre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createLegend(lg), LineRenderEvent.class);
            if (ls.isPaletteLineColor()) {
                liaMarker = goFactory.copyOf(liaMarker);
                liaMarker.setColor(FillUtil.getColor(fPaletteEntry));
            }
            lre.setLineAttributes(liaMarker);
            lre.setStart(goFactory.createLocation(bo.getLeft() + 1.0, bo.getTop() + bo.getHeight() / 2.0));
            lre.setEnd(goFactory.createLocation(bo.getLeft() + bo.getWidth() - 1.0, bo.getTop() + bo.getHeight() / 2.0));
            ipr.drawLine(lre);
        }
        SeriesDefinition sd = this.getSeriesDefinition();
        boolean bPaletteByCategory = this.isPaletteByCategory();
        if (bPaletteByCategory && ls.eContainer() instanceof SeriesDefinition) {
            sd = (SeriesDefinition)ls.eContainer();
        }
        if ((iThisSeriesIndex = sd.getRunTimeSeries().indexOf(ls)) < 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.missing.series.for.palette.index", new Object[]{ls, sd}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        Marker m = null;
        if (ls.getMarkers().size() > 0) {
            m = (Marker)ls.getMarkers().get(iThisSeriesIndex % ls.getMarkers().size());
        }
        if ((markerSize = (int)((((width = bo.getWidth() / this.getDeviceScale()) > (height = bo.getHeight() / this.getDeviceScale()) ? height : width) - 2.0) / 2.0)) <= 0) {
            markerSize = 1;
        }
        if (m != null) {
            DataPointHints dph = this.createDummyDataPointHintsForLegendItem();
            this.renderMarker(lg, ipr, m, goFactory.createLocation(bo.getLeft() + bo.getWidth() / 2.0, bo.getTop() + bo.getHeight() / 2.0), ls.getLineAttributes(), fPaletteEntry, dph, markerSize, false, false);
        }
    }

    protected void renderAsCurve(IPrimitiveRenderer ipr, LineAttributes lia, ISeriesRenderingHints srh, Location[] loa, boolean bShowAsTape, double tapeWidth, Fill paletteEntry, boolean usePaletteLineColor) throws ChartException {
        DataPointHints[] dpha = srh.getDataPoints();
        boolean bStacked = this.getSeries().isStacked() || this.getAxis().isPercent();
        LineSeries ls = (LineSeries)this.getSeries();
        DataPointsSeeker dpSeeker = DataPointsSeeker.create(dpha, ls, bStacked);
        LinkedList<Location> list = new LinkedList<Location>();
        while (dpSeeker.next()) {
            list.add(loa[dpSeeker.getIndex()]);
        }
        Location[] newLoa = this.isDimension3D() ? (Location[])list.toArray(new Location3D[list.size()]) : list.toArray(new Location[list.size()]);
        CurveRenderer cr = new CurveRenderer((ChartWithAxes)this.getModel(), this, lia, newLoa, bShowAsTape, tapeWidth, true, !this.isDimension3D(), paletteEntry, usePaletteLineColor, ((LineSeries)this.getSeries()).isConnectMissingValue());
        cr.draw(ipr);
    }

    protected void renderShadowAsCurve(IPrimitiveRenderer ipr, LineAttributes lia, ISeriesRenderingHints srh, Location[] loa, boolean bShowAsTape, double tapeWidth) throws ChartException {
        ColorDefinition cLineShadow = ((LineSeries)this.getSeries()).getShadowColor();
        if (!bShowAsTape && cLineShadow != null && cLineShadow.getTransparency() != goFactory.TRANSPARENT().getTransparency() && lia.isVisible()) {
            Location positionDelta = ((ChartWithAxes)this.getModel()).isTransposed() ? goFactory.createLocation(-2.0 * this.getDeviceScale(), 0.0) : goFactory.createLocation(0.0, 2.0 * this.getDeviceScale());
            double[] shX = new double[loa.length];
            double[] shY = new double[loa.length];
            int i = 0;
            while (i < loa.length) {
                shX[i] = loa[i].getX() + positionDelta.getX();
                shY[i] = loa[i].getY() + positionDelta.getY();
                ++i;
            }
            LineAttributes liaShadow = goFactory.copyOf(lia);
            liaShadow.setColor(cLineShadow);
            this.renderAsCurve(ipr, liaShadow, srh, goFactory.createLocations(shX, shY), bShowAsTape, tapeWidth, liaShadow.getColor(), false);
        }
    }

    protected void renderDataPoints(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints srh, DataPointHints[] dpha, LineAttributes lia, Location[] loa, boolean bShowAsTape, double dTapeWidth, Fill paletteEntry, boolean usePaletteLineColor) throws ChartException {
        if (!lia.isVisible()) {
            return;
        }
        DataPointsRenderer.Context context = new DataPointsRenderer.Context(this, ipr, srh, dpha, paletteEntry);
        DataPointsRenderer dpRenderer = this.isDimension3D() ? new LineDataPointsRenderer3D(context, loa, dTapeWidth) : new LineDataPointsRenderer2D(context, loa);
        dpRenderer.render();
    }

    protected void renderShadow(IPrimitiveRenderer ipr, Plot p, LineAttributes lia, Location[] loa, boolean bShowAsTape, DataPointHints[] dpha) throws ChartException {
        ColorDefinition cLineShadow = ((LineSeries)this.getSeries()).getShadowColor();
        if (!bShowAsTape && cLineShadow != null && cLineShadow.getTransparency() != goFactory.TRANSPARENT().getTransparency() && lia.isVisible()) {
            DataPointsRenderer.Context context = new DataPointsRenderer.Context(this, ipr, null, dpha, null);
            LineDataPointsRenderer2DShadow dpRenderer = new LineDataPointsRenderer2DShadow(context, loa);
            dpRenderer.render();
        }
    }

    protected int getPreviousNonNullIndex(int currentIndex, DataPointHints[] dpha) {
        int i = currentIndex - 1;
        while (i >= 0) {
            if (dpha[i].getOrthogonalValue() != null && !Line.isNaN(dpha[i].getOrthogonalValue())) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public void compute(Bounds bo, Plot p, ISeriesRenderingHints isrh) throws ChartException {
    }

    protected static Location3D[] createLocation3DArray(int iSize) {
        Location3D[] loa3d = new Location3D[iSize];
        int i = 0;
        while (i < iSize) {
            loa3d[i] = goFactory.createLocation3D(0.0, 0.0, 0.0);
            ++i;
        }
        return loa3d;
    }

    protected static Location[] createLocationArray(int iSize) {
        Location[] loa = new Location[iSize];
        int i = 0;
        while (i < iSize) {
            loa[i] = goFactory.createLocation(0.0, 0.0);
            ++i;
        }
        return loa;
    }

    protected void flushClipping() throws ChartException {
        this.getDeferredCacheManager().flushOptions(35);
    }

    private void addComparsionPolygon(IPrimitiveRenderer ipr, Location3D[] loa3d, DataPointHints[] dpha) throws ChartException {
        Location3D[] l3d = Line.createLocation3DArray(4);
        double x0 = loa3d[0].getX();
        double x1 = loa3d[loa3d.length - 1].getX();
        double minY = loa3d[0].getY();
        double maxY = loa3d[0].getY();
        double maxZ = loa3d[0].getZ();
        int i = 0;
        while (i < loa3d.length) {
            if (minY > loa3d[i].getY()) {
                minY = loa3d[i].getY();
            }
            if (maxY < loa3d[i].getY()) {
                maxY = loa3d[i].getY();
            }
            if (maxZ < loa3d[i].getZ()) {
                maxZ = loa3d[i].getZ();
            }
            ++i;
        }
        l3d[0].set(x0, maxY, maxZ);
        l3d[1].set(x1, maxY, maxZ);
        l3d[2].set(x1, minY, maxZ);
        l3d[3].set(x0, minY, maxZ);
        StructureSource sourceObj = WrappedStructureSource.createSeriesDataPoint(this.getSeries(), dpha[0]);
        Polygon3DRenderEvent pre3d = ((EventObjectCache)((Object)ipr)).getEventObject(sourceObj, Polygon3DRenderEvent.class);
        pre3d.setEnable(false);
        pre3d.setDoubleSided(true);
        pre3d.setOutline(null);
        pre3d.setPoints3D(l3d);
        pre3d.setSourceObject(sourceObj);
        Object event = this.dc.getParentDeferredCache().addPlane(pre3d, 2);
        if (event instanceof WrappedInstruction) {
            ((WrappedInstruction)event).setSubDeferredCache(this.dc);
        }
        pre3d.setDoubleSided(false);
        pre3d.setEnable(true);
    }

    protected static abstract class DataPointsRenderer {
        protected final Context context;
        protected final ChartWithAxes cwa;
        protected final DeferredCache dc;
        protected final LineSeries ls;
        protected final LineAttributes lia;
        protected final EventObjectCache eventObjCache;

        protected DataPointsRenderer(Context context) throws ChartException {
            this.context = context;
            this.dc = context.line.getDeferredCache();
            this.ls = (LineSeries)context.line.getSeries();
            this.cwa = (ChartWithAxes)context.line.getModel();
            if (this.ls.isPaletteLineColor()) {
                this.lia = this.ls.getLineAttributes().copyInstance();
                this.lia.setColor(FillUtil.getColor(context.paletteEntry));
            } else {
                this.lia = this.ls.getLineAttributes();
            }
            this.eventObjCache = (EventObjectCache)((Object)context.ipr);
        }

        public void render() throws ChartException {
            DataPointsSeeker seeker = DataPointsSeeker.create(this.context.dpha, this.ls, this.context.bStacked);
            if (seeker.next()) {
                this.beforeLoop(seeker);
                while (seeker.next()) {
                    this.processDataPoint(seeker);
                }
                this.afterLoop(seeker);
            }
        }

        protected StructureSource createDataPointSource(int index) {
            return WrappedStructureSource.createSeriesDataPoint(this.ls, this.context.dpha[index]);
        }

        protected StructureSource createSeriesSource() {
            return StructureSource.createSeries(this.ls);
        }

        protected void addInteractivity(DataPointHints dph, PrimitiveRenderEvent event) throws ChartException {
            this.context.line.addInteractivity(this.context.ipr, dph, event);
        }

        protected abstract void beforeLoop(DataPointsSeeker var1) throws ChartException;

        protected abstract void processDataPoint(DataPointsSeeker var1) throws ChartException;

        protected abstract void afterLoop(DataPointsSeeker var1) throws ChartException;

        public static class Context {
            protected final Line line;
            protected final IPrimitiveRenderer ipr;
            protected final ISeriesRenderingHints isrh;
            protected final DataPointHints[] dpha;
            protected final Fill paletteEntry;
            protected final boolean bStacked;

            public Context(Line line, IPrimitiveRenderer ipr, ISeriesRenderingHints isrh, DataPointHints[] dpha, Fill paletteEntry) {
                this.line = line;
                this.ipr = ipr;
                this.isrh = isrh;
                this.dpha = dpha;
                this.paletteEntry = paletteEntry;
                this.bStacked = line.getSeries().isStacked() || line.getAxis().isPercent();
            }
        }
    }

    protected static class DataPointsSeeker {
        protected final DataPointHints[] dpha;
        protected final int iSize;
        protected int index;

        protected DataPointsSeeker(DataPointHints[] dpha) {
            this.dpha = dpha;
            this.iSize = dpha != null ? dpha.length : 0;
            this.reset();
        }

        public void reset() {
            this.index = -1;
        }

        public boolean next() {
            if (this.index + 1 < this.iSize) {
                ++this.index;
                return true;
            }
            return false;
        }

        public int getIndex() {
            return this.index;
        }

        public int getPrevIndex() {
            return this.index - 1;
        }

        public boolean isSingle() {
            return false;
        }

        public DataPointHints getDataPointHints(int index) {
            return this.dpha[index];
        }

        public DataPointHints getDataPointHints() {
            return this.dpha[this.index];
        }

        public int size() {
            return this.iSize;
        }

        protected boolean isNull(int index) {
            return Line.isNaN(this.dpha[index].getOrthogonalValue());
        }

        public boolean isNull() {
            return this.isNull(this.index);
        }

        public static DataPointsSeeker create(DataPointHints[] dpha, LineSeries ls, boolean bStacked) {
            if (ls instanceof AreaSeries) {
                if (bStacked) {
                    return new DataPointsSeeker(dpha);
                }
                if (ls.isConnectMissingValue()) {
                    return new DataPointsSeekerConnectNull(dpha);
                }
                return new DataPointsSeekerTrimmed(dpha);
            }
            if (ls.isConnectMissingValue()) {
                return new DataPointsSeekerConnectNull(dpha);
            }
            return new DataPointsSeekerSkipNullDS(dpha);
        }
    }

    protected static class DataPointsSeekerConnectNull
    extends DataPointsSeeker {
        private int idPrevNonNull;

        DataPointsSeekerConnectNull(DataPointHints[] dpha) {
            super(dpha);
        }

        public void reset() {
            this.index = -1;
            this.idPrevNonNull = -1;
        }

        public boolean next() {
            int newIndex = this.index + 1;
            while (newIndex < this.dpha.length) {
                if (!this.isNull(newIndex)) {
                    this.idPrevNonNull = this.index;
                    this.index = newIndex;
                    return true;
                }
                ++newIndex;
            }
            return false;
        }

        public int getPrevIndex() {
            return this.idPrevNonNull;
        }

        public boolean isNull() {
            return false;
        }
    }

    protected static class DataPointsSeekerSkipNullDS
    extends DataPointsSeeker {
        private boolean bNextIsNull;
        private boolean bIsNull;
        private boolean bPrevIsNull;

        DataPointsSeekerSkipNullDS(DataPointHints[] dpha) {
            super(dpha);
        }

        public void reset() {
            this.index = -2;
            this.bNextIsNull = true;
            this.bIsNull = true;
        }

        public boolean next() {
            boolean bIsNull = this.bIsNull;
            boolean bNextIsNull = this.bNextIsNull;
            int newIndex = this.index + 1;
            while (newIndex < this.dpha.length) {
                boolean bPrevIsNull = bIsNull;
                bIsNull = bNextIsNull;
                boolean bl = bNextIsNull = newIndex + 1 < this.dpha.length ? this.isNull(newIndex + 1) : true;
                if (!bIsNull) {
                    this.bPrevIsNull = bPrevIsNull;
                    this.bIsNull = bIsNull;
                    this.bNextIsNull = bNextIsNull;
                    this.index = newIndex;
                    return true;
                }
                ++newIndex;
            }
            return false;
        }

        public int getPrevIndex() {
            return this.bPrevIsNull ? -1 : this.index - 1;
        }

        public boolean isSingle() {
            return !this.bIsNull && this.bNextIsNull && this.bPrevIsNull;
        }

        public boolean isNull() {
            return false;
        }
    }

    protected static class DataPointsSeekerTrimmed
    extends DataPointsSeeker {
        protected final int findex = this.initFirstIndex();
        protected final int lindex = this.initLastIndex(this.findex);

        protected DataPointsSeekerTrimmed(DataPointHints[] dpha) {
            super(dpha);
            this.index = this.findex - 1;
        }

        public boolean next() {
            if (this.index + 1 <= this.lindex) {
                ++this.index;
                return true;
            }
            return false;
        }

        protected int initFirstIndex() {
            int i = 0;
            while (i < this.iSize) {
                if (!this.isNull(i)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        protected int initLastIndex(int findex) {
            if (findex >= 0) {
                int i = this.iSize - 1;
                while (i > -1) {
                    if (!this.isNull(i)) {
                        return i;
                    }
                    --i;
                }
            }
            return -2;
        }

        public void reset() {
            this.index = -1;
        }
    }

    protected static class LineDataPointsRenderer2D
    extends DataPointsRenderer {
        protected final Location[] loa;
        protected final LineRenderEvent lre;
        protected final Bounds boSingle = Line.access$2().createBounds(0.0, 0.0, 0.0, 0.0);

        protected LineDataPointsRenderer2D(DataPointsRenderer.Context context, Location[] loa) throws ChartException {
            super(context);
            this.loa = loa;
            this.lre = this.eventObjCache.getEventObject(this.createSeriesSource(), LineRenderEvent.class);
            this.lre.setLineAttributes(this.lia);
        }

        protected void drawSinglePoint(DataPointsSeeker seeker) throws ChartException {
            if (seeker.isSingle()) {
                int index = seeker.getIndex();
                double iSize = (double)this.lia.getThickness() * 2.0;
                OvalRenderEvent ore = this.eventObjCache.getEventObject(this.createDataPointSource(index), OvalRenderEvent.class);
                this.boSingle.set(this.loa[index].getX() - iSize / 2.0, this.loa[index].getY() - iSize / 2.0, iSize, iSize);
                ore.setBounds(this.boSingle);
                ore.setOutline(this.lia);
                this.context.ipr.drawOval(ore);
                this.addInteractivity(seeker.getDataPointHints(), ore);
            }
        }

        protected void afterLoop(DataPointsSeeker seeker) throws ChartException {
        }

        protected void beforeLoop(DataPointsSeeker seeker) throws ChartException {
            this.drawSinglePoint(seeker);
        }

        protected void processDataPoint(DataPointsSeeker seeker) throws ChartException {
            this.drawSinglePoint(seeker);
            int pindex = seeker.getPrevIndex();
            if (pindex > -1) {
                int index = seeker.getIndex();
                DataPointHints dph = seeker.getDataPointHints();
                this.lre.setStart(this.loa[pindex]);
                this.lre.setEnd(this.loa[index]);
                this.addInteractivity(dph, this.lre);
                this.dc.addLine(this.lre);
            }
        }
    }

    protected static class LineDataPointsRenderer2DShadow
    extends LineDataPointsRenderer2D {
        private final LineAttributes liaShadow;
        private static final double deltaY = 3.0;
        private final Location loStart = Line.access$2().createLocation(0.0, 0.0);
        private final Location loEnd = Line.access$2().createLocation(0.0, 0.0);

        protected LineDataPointsRenderer2DShadow(DataPointsRenderer.Context context, Location[] loa) throws ChartException {
            super(context, loa);
            ColorDefinition cLineShadow = this.ls.getShadowColor();
            this.liaShadow = this.lia.copyInstance();
            this.liaShadow.setColor(cLineShadow);
            this.lre.setLineAttributes(this.liaShadow);
            this.lre.setStart(this.loStart);
            this.lre.setEnd(this.loEnd);
        }

        protected void drawSinglePoint(DataPointsSeeker seeker) throws ChartException {
            if (seeker.isSingle()) {
                double iSize = this.lia.getThickness();
                int index = seeker.getIndex();
                OvalRenderEvent ore = this.eventObjCache.getEventObject(this.createDataPointSource(index), OvalRenderEvent.class);
                ore.setOutline(this.liaShadow);
                ore.setBackground(this.liaShadow.getColor());
                this.boSingle.set(this.loa[index].getX(), this.loa[index].getY() + 3.0, iSize, iSize);
                ore.setBounds(this.boSingle);
                this.context.ipr.drawOval(ore);
                this.context.ipr.fillOval(ore);
            }
        }

        protected void processDataPoint(DataPointsSeeker seeker) throws ChartException {
            this.drawSinglePoint(seeker);
            int pindex = seeker.getPrevIndex();
            if (pindex > -1) {
                int index = seeker.getIndex();
                DataPointHints dph = seeker.getDataPointHints();
                this.loStart.set(this.loa[pindex].getX(), this.loa[pindex].getY() + 3.0);
                this.loEnd.set(this.loa[index].getX(), this.loa[index].getY() + 3.0);
                this.addInteractivity(dph, this.lre);
                this.dc.addLine(this.lre);
            }
        }
    }

    protected static class LineDataPointsRenderer3D
    extends DataPointsRenderer {
        private final Location3D[] loa3d;
        private final Location3D[] loaPlane3d = Line.createLocation3DArray(4);
        private final Line3DRenderEvent lre3d;
        private final Polygon3DRenderEvent pre3d;
        private final double dTapeWidth;

        LineDataPointsRenderer3D(DataPointsRenderer.Context context, Location[] loa, double dTapeWidth) throws ChartException {
            super(context);
            this.loa3d = (Location3D[])loa;
            StructureSource sourceObj = this.createSeriesSource();
            this.lre3d = this.eventObjCache.getEventObject(sourceObj, Line3DRenderEvent.class);
            this.lre3d.setLineAttributes(this.lia);
            this.pre3d = this.eventObjCache.getEventObject(sourceObj, Polygon3DRenderEvent.class);
            this.pre3d.setDoubleSided(true);
            this.pre3d.setOutline(null);
            this.pre3d.setBackground(goFactory.brighter(this.lia.getColor()));
            this.dTapeWidth = dTapeWidth;
        }

        private void drawSinglePoint(DataPointsSeeker seeker) throws ChartException {
            if (seeker.isSingle()) {
                int index = seeker.getIndex();
                Line3DRenderEvent lre3dValue = this.eventObjCache.getEventObject(this.createDataPointSource(index), Line3DRenderEvent.class);
                this.loaPlane3d[0] = goFactory.createLocation3D(this.loa3d[index].getX(), this.loa3d[index].getY(), this.loa3d[index].getZ());
                this.loaPlane3d[1] = goFactory.createLocation3D(this.loa3d[index].getX(), this.loa3d[index].getY(), this.loa3d[index].getZ() - this.dTapeWidth);
                lre3dValue.setStart3D(this.loaPlane3d[0]);
                lre3dValue.setEnd3D(this.loaPlane3d[1]);
                lre3dValue.setLineAttributes(this.lia);
                this.dc.addLine(lre3dValue);
                this.addInteractivity(seeker.getDataPointHints(), lre3dValue);
            }
        }

        protected void afterLoop(DataPointsSeeker seeker) throws ChartException {
        }

        protected void beforeLoop(DataPointsSeeker seeker) throws ChartException {
            this.drawSinglePoint(seeker);
        }

        protected void processDataPoint(DataPointsSeeker seeker) throws ChartException {
            this.drawSinglePoint(seeker);
            int pindex = seeker.getPrevIndex();
            if (pindex > -1) {
                int index = seeker.getIndex();
                DataPointHints dph = seeker.getDataPointHints();
                this.lre3d.setStart3D(this.loa3d[pindex]);
                this.lre3d.setEnd3D(this.loa3d[index]);
                this.addInteractivity(dph, this.lre3d);
                this.dc.addLine(this.lre3d);
                this.loaPlane3d[0].set(this.loa3d[pindex].getX(), this.loa3d[pindex].getY(), this.loa3d[pindex].getZ());
                this.loaPlane3d[1].set(this.loa3d[index].getX(), this.loa3d[index].getY(), this.loa3d[index].getZ());
                this.loaPlane3d[2].set(this.loa3d[index].getX(), this.loa3d[index].getY(), this.loa3d[index].getZ() - this.dTapeWidth);
                this.loaPlane3d[3].set(this.loa3d[pindex].getX(), this.loa3d[pindex].getY(), this.loa3d[pindex].getZ() - this.dTapeWidth);
                this.pre3d.setPoints3D(this.loaPlane3d);
                this.addInteractivity(dph, this.pre3d);
                this.dc.addPlane(this.pre3d, 2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Transposition {
        TRANSPOSED{

            public double getX(Location lo) {
                return lo.getY();
            }

            public double getY(Location lo) {
                return lo.getX();
            }

            public void setX(Location lo, double value) {
                lo.setY(value);
            }

            public void setY(Location lo, double value) {
                lo.setX(value);
            }

            public void set(Location lo, double x, double y) {
                lo.set(y, x);
            }
        }
        ,
        NOT_TRANSPOSED{

            public double getX(Location lo) {
                return lo.getX();
            }

            public double getY(Location lo) {
                return lo.getY();
            }

            public void setX(Location lo, double value) {
                lo.setX(value);
            }

            public void setY(Location lo, double value) {
                lo.setY(value);
            }

            public void set(Location lo, double x, double y) {
                lo.set(x, y);
            }
        };


        public abstract double getX(Location var1);

        public abstract double getY(Location var1);

        public abstract void setX(Location var1, double var2);

        public abstract void setY(Location var1, double var2);

        public abstract void set(Location var1, double var2, double var4);
    }
}

