/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBasePreparedQuery;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.IPreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ISubCubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.engine.adapter.ModelDteApiAdapter;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.data.DataEngineFactory;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.dte.BlankResultSet;
import org.eclipse.birt.report.engine.data.dte.CubeResultSet;
import org.eclipse.birt.report.engine.data.dte.QueryResultSet;
import org.eclipse.birt.report.engine.data.dte.ReportQueryBuilder;
import org.eclipse.birt.report.engine.data.optimize.QueryCache;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;

public abstract class AbstractDataEngine
implements IDataEngine {
    protected DataEngineFactory factory;
    protected DataRequestSession dteSession;
    protected ExecutionContext context;
    protected HashMap queryIDMap = new HashMap();
    protected HashMap cachedQueryToResults = new HashMap();
    protected Map appContext;
    protected ModelDteApiAdapter adapter = null;
    protected HashMap queryMap = new HashMap();
    protected QueryCache queryCache = new QueryCache();
    protected static Logger logger = Logger.getLogger(IDataEngine.class.getName());

    public AbstractDataEngine(DataEngineFactory factory, ExecutionContext context) throws BirtException {
        this.factory = factory;
        this.context = context;
        this.adapter = new ModelDteApiAdapter(context);
    }

    public void defineDataSet(DataSetHandle dataSet) {
        try {
            this.adapter.defineDataSet(dataSet, this.dteSession);
        }
        catch (BirtException e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
    }

    public void prepare(Report report, Map appContext) {
        ReportDesignHandle rptHandle = report.getReportDesign();
        List dataSetList = rptHandle.getAllDataSets();
        int i = 0;
        while (i < dataSetList.size()) {
            DataSetHandle dataset = (DataSetHandle)dataSetList.get(i);
            if (dataset.clientsIterator().hasNext()) {
                try {
                    this.adapter.defineDataSet(dataset, this.dteSession);
                }
                catch (BirtException be) {
                    logger.log(Level.SEVERE, be.getMessage(), be);
                    this.context.addException(dataset, be);
                }
            }
            ++i;
        }
        List cubeList = rptHandle.getAllCubes();
        int i2 = 0;
        while (i2 < cubeList.size()) {
            CubeHandle cube = (CubeHandle)cubeList.get(i2);
            if (cube.clientsIterator().hasNext()) {
                try {
                    this.dteSession.defineCube(cube);
                }
                catch (BirtException be) {
                    logger.log(Level.SEVERE, be.getMessage(), be);
                    this.context.addException(cube, be);
                }
            }
            ++i2;
        }
        new ReportQueryBuilder(report, this.context, this.dteSession).build();
        this.doPrepareQuery(report, appContext);
    }

    protected void doPrepareQuery(Report report, Map appContext) {
        this.appContext = appContext;
        ArrayList queries = report.getQueries();
        int queriesSize = queries.size();
        IDataQueryDefinition[] queryArray = new IDataQueryDefinition[queriesSize];
        int index = 0;
        while (index < queriesSize) {
            queryArray[index] = (IDataQueryDefinition)queries.get(index);
            ++index;
        }
        try {
            this.dteSession.registerQueries(queryArray);
        }
        catch (AdapterException ae) {
            logger.log(Level.SEVERE, ae.getMessage(), ae);
            this.context.addException(report.getReportDesign(), (BirtException)ae);
        }
        index = 0;
        while (index < queriesSize) {
            try {
                IBasePreparedQuery preparedQuery = this.dteSession.prepare(queryArray[index], appContext);
                this.queryMap.put(queryArray[index], preparedQuery);
            }
            catch (BirtException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                this.context.addException(report.getReportDesign(), e);
            }
            ++index;
        }
    }

    public IBaseResultSet execute(IDataQueryDefinition query) throws BirtException {
        return this.execute(null, query, null, false);
    }

    public IBaseResultSet execute(IBaseResultSet parent, IDataQueryDefinition query, Object queryOwner, boolean useCache) throws BirtException {
        if (query instanceof ISubqueryDefinition) {
            if (parent == null) {
                return null;
            }
            if (parent instanceof ICubeResultSet) {
                throw new EngineException("Error.IncorrectParentResultSetError", ((ISubqueryDefinition)query).getName());
            }
            return this.doExecuteSubQuery((IQueryResultSet)parent, (ISubqueryDefinition)query);
        }
        if (query instanceof IQueryDefinition) {
            return this.doExecuteQuery(parent, (IQueryDefinition)query, queryOwner, useCache);
        }
        if (query instanceof ICubeQueryDefinition) {
            return this.doExecuteCube(parent, (ICubeQueryDefinition)query, queryOwner, useCache);
        }
        if (query instanceof ISubCubeQueryDefinition) {
            return this.doExecuteSubCubeQuery((ICubeResultSet)parent, (ISubCubeQueryDefinition)query);
        }
        throw new EngineException("Error.UnsupportedQueryTypeError", query.getClass().getName());
    }

    protected abstract IBaseResultSet doExecuteQuery(IBaseResultSet var1, IQueryDefinition var2, Object var3, boolean var4) throws BirtException;

    protected abstract IBaseResultSet doExecuteCube(IBaseResultSet var1, ICubeQueryDefinition var2, Object var3, boolean var4) throws BirtException;

    protected IBaseResultSet doExecuteSubCubeQuery(ICubeResultSet parent, ISubCubeQueryDefinition query) throws BirtException {
        IPreparedCubeQuery pQuery = this.dteSession.prepare(query, this.appContext);
        ICubeQueryResults dteResults = (ICubeQueryResults)this.dteSession.execute((IBasePreparedQuery)pQuery, parent.getQueryResults(), this.context.getScriptContext());
        CubeResultSet resultSet = new CubeResultSet((IDataEngine)this, this.context, (IBaseResultSet)parent, query, dteResults);
        return resultSet;
    }

    protected IBaseResultSet doExecuteSubQuery(IQueryResultSet parent, ISubqueryDefinition subQuery) throws BirtException {
        if (parent instanceof BlankResultSet) {
            return parent;
        }
        try {
            String subQueryName = subQuery.getName();
            IResultIterator parentRI = parent.getResultIterator();
            IResultIterator ri = parentRI.getSecondaryIterator(this.context.getScriptContext(), subQueryName);
            assert (ri != null);
            QueryResultSet resultSet = new QueryResultSet((QueryResultSet)parent, subQuery, ri);
            return resultSet;
        }
        catch (BirtException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
    }

    public void shutdown() {
        this.dteSession.shutdown();
        this.queryCache.close();
        if (this.factory != null) {
            this.factory.closeDataEngine(this);
        }
    }

    public DataRequestSession getDTESession() {
        return this.dteSession;
    }

    protected String getTempDir(ExecutionContext context) {
        EngineConfig config;
        ReportEngine engine = context.getEngine();
        if (engine != null && (config = engine.getConfig()) != null) {
            return config.getTempDir();
        }
        return null;
    }

    protected IBaseQueryResults getCachedQueryResult(IBaseQueryDefinition query, IBaseResultSet outer) throws BirtException {
        Object rsetId = this.queryCache.getCachedQuery(query);
        if (rsetId != null) {
            ((QueryDefinition)query).setQueryResultsID((String)rsetId);
            IBasePreparedQuery pQuery = this.dteSession.prepare(query, null);
            return this.dteSession.execute(pQuery, outer == null ? null : outer.getQueryResults(), this.context.getScriptContext());
        }
        return null;
    }

    protected void putCachedQueryResult(IBaseQueryDefinition query, String id) {
        this.queryCache.putCachedQuery(query, id);
    }

    public abstract String getResultID(String var1, String var2, String var3);

    public abstract String getResultIDByRowID(String var1, String var2, String var3);

    public String getQueryID(IDataQueryDefinition query) {
        return (String)this.queryIDMap.get(query);
    }

    public ExecutionContext getContext() {
        return this.context;
    }
}

