/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pdf;

import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfOutline;
import java.awt.Color;
import java.util.Set;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.api.script.instance.IScriptStyle;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

public class TOCHandler {
    private TOCNode root;
    private PdfOutline outline;
    private Set bookmarks;
    private long counter = 0L;
    private static final long MAX_COUNT = 70000L;

    public TOCHandler(TOCNode root, PdfOutline outline, Set bookmarks) {
        this.root = root;
        this.outline = outline;
        this.bookmarks = bookmarks;
    }

    public TOCNode getTOCRoot() {
        return this.root;
    }

    public void createTOC() {
        this.createTOC(this.root, this.outline, this.bookmarks);
    }

    private void createTOC(TOCNode tocNode, PdfOutline pol, Set bookmarks) {
        if (this.counter > 70000L) {
            return;
        }
        if (tocNode == null || tocNode.getChildren() == null) {
            return;
        }
        for (TOCNode node : tocNode.getChildren()) {
            if (!bookmarks.contains(node.getBookmark())) continue;
            PdfOutline outline = new PdfOutline(pol, PdfAction.gotoLocalPage((String)node.getBookmark(), (boolean)false), node.getDisplayString());
            ++this.counter;
            IScriptStyle style = node.getTOCStyle();
            String color = style.getColor();
            Color awtColor = PropertyUtil.getColor(color);
            if (awtColor != null) {
                outline.setColor(awtColor);
            }
            String fontStyle = style.getFontStyle();
            String fontWeight = style.getFontWeight();
            int styleValue = PropertyUtil.getFontStyle(fontStyle, fontWeight);
            outline.setStyle(styleValue);
            this.createTOC(node, outline, bookmarks);
        }
    }
}

