/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api.querydefn;

import java.util.List;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.BaseExpression;
import org.eclipse.birt.data.engine.api.querydefn.ExpressionCollection;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;

public class ConditionalExpression
extends BaseExpression
implements IConditionalExpression {
    protected IScriptExpression expr;
    protected int operator;
    protected IBaseExpression op1;
    protected IBaseExpression op2;

    public ConditionalExpression(String expr, int operator) {
        this(expr, operator, null, null);
    }

    public ConditionalExpression(String expr, int operator, String operand1) {
        this(expr, operator, operand1, null);
    }

    public ConditionalExpression(String expr, int operator, String operand1, String operand2) {
        this(ConditionalExpression.newJSExpression(expr), operator, ConditionalExpression.newJSExpression(operand1), ConditionalExpression.newJSExpression(operand2));
    }

    public ConditionalExpression(IScriptExpression expr, int operator, IBaseExpression op1, IBaseExpression op2) {
        this.expr = expr;
        this.operator = operator;
        this.op1 = op1;
        this.op2 = op2;
    }

    public ConditionalExpression(String expr, int operator, List operand) {
        this.expr = new ScriptExpression(expr);
        this.operator = operator;
        this.op1 = new ExpressionCollection(operand);
        this.op2 = null;
    }

    public ConditionalExpression(IScriptExpression expr, int operator, List operand) {
        this.expr = expr;
        this.operator = operator;
        this.op1 = new ExpressionCollection(operand);
    }

    public IScriptExpression getExpression() {
        return this.expr;
    }

    public int getOperator() {
        return this.operator;
    }

    public IBaseExpression getOperand1() {
        return this.op1;
    }

    public void setOperator(int operator) {
        this.operator = operator;
    }

    public IBaseExpression getOperand2() {
        return this.op2;
    }

    public int getDataType() {
        return 1;
    }

    public void setDataType(int dataType) {
        if (dataType != 1) {
            throw new UnsupportedOperationException("setDataType not supported for conditional expression.");
        }
    }

    public void setGroupName(String groupName) {
        if (this.expr != null) {
            this.expr.setGroupName(groupName);
        }
        if (this.op1 != null) {
            this.op1.setGroupName(groupName);
        }
        if (this.op2 != null) {
            this.op2.setGroupName(groupName);
        }
        super.setGroupName(groupName);
    }

    private static ScriptExpression newJSExpression(String expr) {
        return expr == null ? null : new ScriptExpression(expr);
    }
}

