/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.table;

import com.lowagie.text.Cell;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Row;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPRow;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.table.RtfBorderGroup;
import com.lowagie.text.rtf.table.RtfCell;
import com.lowagie.text.rtf.table.RtfTable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class RtfRow
extends RtfElement {
    private static final byte[] ROW_BEGIN = DocWriter.getISOBytes("\\trowd");
    private static final byte[] ROW_WIDTH_STYLE = DocWriter.getISOBytes("\\trftsWidth3");
    private static final byte[] ROW_WIDTH = DocWriter.getISOBytes("\\trwWidth");
    private static final byte[] ROW_KEEP_TOGETHER = DocWriter.getISOBytes("\\trkeep");
    private static final byte[] ROW_HEADER_ROW = DocWriter.getISOBytes("\\trhdr");
    private static final byte[] ROW_ALIGN_LEFT = DocWriter.getISOBytes("\\trql");
    private static final byte[] ROW_ALIGN_RIGHT = DocWriter.getISOBytes("\\trqr");
    private static final byte[] ROW_ALIGN_CENTER = DocWriter.getISOBytes("\\trqc");
    private static final byte[] ROW_ALIGN_JUSTIFIED = DocWriter.getISOBytes("\\trqj");
    private static final byte[] ROW_GRAPH = DocWriter.getISOBytes("\\trgaph10");
    private static final byte[] ROW_CELL_SPACING_LEFT = DocWriter.getISOBytes("\\trspdl");
    private static final byte[] ROW_CELL_SPACING_TOP = DocWriter.getISOBytes("\\trspdt");
    private static final byte[] ROW_CELL_SPACING_RIGHT = DocWriter.getISOBytes("\\trspdr");
    private static final byte[] ROW_CELL_SPACING_BOTTOM = DocWriter.getISOBytes("\\trspdb");
    private static final byte[] ROW_CELL_SPACING_LEFT_STYLE = DocWriter.getISOBytes("\\trspdfl3");
    private static final byte[] ROW_CELL_SPACING_TOP_STYLE = DocWriter.getISOBytes("\\trspdft3");
    private static final byte[] ROW_CELL_SPACING_RIGHT_STYLE = DocWriter.getISOBytes("\\trspdfr3");
    private static final byte[] ROW_CELL_SPACING_BOTTOM_STYLE = DocWriter.getISOBytes("\\trspdfb3");
    private static final byte[] ROW_CELL_PADDING_LEFT = DocWriter.getISOBytes("\\trpaddl");
    private static final byte[] ROW_CELL_PADDING_RIGHT = DocWriter.getISOBytes("\\trpaddr");
    private static final byte[] ROW_CELL_PADDING_LEFT_STYLE = DocWriter.getISOBytes("\\trpaddfl3");
    private static final byte[] ROW_CELL_PADDING_RIGHT_STYLE = DocWriter.getISOBytes("\\trpaddfr3");
    private static final byte[] ROW_END = DocWriter.getISOBytes("\\row");
    private RtfTable parentTable = null;
    private ArrayList cells = null;
    private int width = 0;
    private int rowNumber = 0;

    protected RtfRow(RtfDocument rtfDocument, RtfTable rtfTable, Row row, int n) {
        super(rtfDocument);
        this.parentTable = rtfTable;
        this.rowNumber = n;
        this.importRow(row);
    }

    protected RtfRow(RtfDocument rtfDocument, RtfTable rtfTable, PdfPRow pdfPRow, int n) {
        super(rtfDocument);
        this.parentTable = rtfTable;
        this.rowNumber = n;
        this.importRow(pdfPRow);
    }

    private void importRow(Row row) {
        this.cells = new ArrayList();
        this.width = this.document.getDocumentHeader().getPageSetting().getPageWidth() - this.document.getDocumentHeader().getPageSetting().getMarginLeft() - this.document.getDocumentHeader().getPageSetting().getMarginRight();
        this.width = (int)((float)this.width * this.parentTable.getTableWidthPercent() / 100.0f);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < row.getColumns(); ++i) {
            n2 = (int)((float)this.width * this.parentTable.getProportionalWidths()[i] / 100.0f);
            Cell cell = (Cell)row.getCell(i);
            RtfCell rtfCell = new RtfCell(this.document, this, cell);
            rtfCell.setCellRight(n += n2);
            rtfCell.setCellWidth(n2);
            this.cells.add(rtfCell);
        }
    }

    private void importRow(PdfPRow pdfPRow) {
        this.cells = new ArrayList();
        this.width = this.document.getDocumentHeader().getPageSetting().getPageWidth() - this.document.getDocumentHeader().getPageSetting().getMarginLeft() - this.document.getDocumentHeader().getPageSetting().getMarginRight();
        this.width = (int)((float)this.width * this.parentTable.getTableWidthPercent() / 100.0f);
        int n = 0;
        int n2 = 0;
        PdfPCell[] pdfPCellArray = pdfPRow.getCells();
        for (int i = 0; i < pdfPCellArray.length; ++i) {
            n2 = (int)((float)this.width * this.parentTable.getProportionalWidths()[i] / 100.0f);
            PdfPCell pdfPCell = pdfPCellArray[i];
            RtfCell rtfCell = new RtfCell(this.document, this, pdfPCell);
            rtfCell.setCellRight(n += n2);
            rtfCell.setCellWidth(n2);
            this.cells.add(rtfCell);
        }
    }

    protected void handleCellSpanning() {
        RtfCell rtfCell = new RtfCell(true);
        for (int i = 0; i < this.cells.size(); ++i) {
            RtfBasicElement rtfBasicElement;
            int n;
            RtfCell rtfCell2 = (RtfCell)this.cells.get(i);
            if (rtfCell2.getColspan() > 1) {
                int n2 = rtfCell2.getColspan();
                for (n = i + 1; n < i + n2; ++n) {
                    if (n >= this.cells.size()) continue;
                    rtfBasicElement = (RtfCell)this.cells.get(n);
                    rtfCell2.setCellRight(rtfCell2.getCellRight() + ((RtfCell)rtfBasicElement).getCellWidth());
                    rtfCell2.setCellWidth(rtfCell2.getCellWidth() + ((RtfCell)rtfBasicElement).getCellWidth());
                    this.cells.set(n, rtfCell);
                }
            }
            if (rtfCell2.getRowspan() <= 1) continue;
            ArrayList arrayList = this.parentTable.getRows();
            for (n = 1; n < rtfCell2.getRowspan(); ++n) {
                rtfBasicElement = (RtfRow)arrayList.get(this.rowNumber + n);
                if (this.rowNumber + n < arrayList.size()) {
                    RtfCell rtfCell3 = (RtfCell)((RtfRow)rtfBasicElement).getCells().get(i);
                    rtfCell3.setCellMergeChild(rtfCell2);
                }
                if (rtfCell2.getColspan() <= 1) continue;
                int n3 = rtfCell2.getColspan();
                for (int j = i + 1; j < i + n3; ++j) {
                    if (j >= ((RtfRow)rtfBasicElement).getCells().size()) continue;
                    ((RtfRow)rtfBasicElement).getCells().set(j, rtfCell);
                }
            }
        }
    }

    protected void cleanRow() {
        int n = 0;
        while (n < this.cells.size()) {
            if (((RtfCell)this.cells.get(n)).isDeleted()) {
                this.cells.remove(n);
                continue;
            }
            ++n;
        }
    }

    private void writeRowDefinition(OutputStream outputStream) throws IOException {
        outputStream.write(ROW_BEGIN);
        this.document.outputDebugLinebreak(outputStream);
        outputStream.write(ROW_WIDTH_STYLE);
        outputStream.write(ROW_WIDTH);
        outputStream.write(this.intToByteArray(this.width));
        if (this.parentTable.getCellsFitToPage()) {
            outputStream.write(ROW_KEEP_TOGETHER);
        }
        if (this.rowNumber <= this.parentTable.getHeaderRows()) {
            outputStream.write(ROW_HEADER_ROW);
        }
        switch (this.parentTable.getAlignment()) {
            case 0: {
                outputStream.write(ROW_ALIGN_LEFT);
                break;
            }
            case 2: {
                outputStream.write(ROW_ALIGN_RIGHT);
                break;
            }
            case 1: {
                outputStream.write(ROW_ALIGN_CENTER);
                break;
            }
            case 3: 
            case 8: {
                outputStream.write(ROW_ALIGN_JUSTIFIED);
            }
        }
        outputStream.write(ROW_GRAPH);
        RtfBorderGroup rtfBorderGroup = this.parentTable.getBorders();
        if (rtfBorderGroup != null) {
            rtfBorderGroup.writeContent(outputStream);
        }
        if (this.parentTable.getCellSpacing() > 0.0f) {
            outputStream.write(ROW_CELL_SPACING_LEFT);
            outputStream.write(this.intToByteArray((int)(this.parentTable.getCellSpacing() / 2.0f)));
            outputStream.write(ROW_CELL_SPACING_LEFT_STYLE);
            outputStream.write(ROW_CELL_SPACING_TOP);
            outputStream.write(this.intToByteArray((int)(this.parentTable.getCellSpacing() / 2.0f)));
            outputStream.write(ROW_CELL_SPACING_TOP_STYLE);
            outputStream.write(ROW_CELL_SPACING_RIGHT);
            outputStream.write(this.intToByteArray((int)(this.parentTable.getCellSpacing() / 2.0f)));
            outputStream.write(ROW_CELL_SPACING_RIGHT_STYLE);
            outputStream.write(ROW_CELL_SPACING_BOTTOM);
            outputStream.write(this.intToByteArray((int)(this.parentTable.getCellSpacing() / 2.0f)));
            outputStream.write(ROW_CELL_SPACING_BOTTOM_STYLE);
        }
        outputStream.write(ROW_CELL_PADDING_LEFT);
        outputStream.write(this.intToByteArray((int)(this.parentTable.getCellPadding() / 2.0f)));
        outputStream.write(ROW_CELL_PADDING_RIGHT);
        outputStream.write(this.intToByteArray((int)(this.parentTable.getCellPadding() / 2.0f)));
        outputStream.write(ROW_CELL_PADDING_LEFT_STYLE);
        outputStream.write(ROW_CELL_PADDING_RIGHT_STYLE);
        this.document.outputDebugLinebreak(outputStream);
        for (int i = 0; i < this.cells.size(); ++i) {
            RtfCell rtfCell = (RtfCell)this.cells.get(i);
            rtfCell.writeDefinition(outputStream);
        }
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        this.writeRowDefinition(outputStream);
        for (int i = 0; i < this.cells.size(); ++i) {
            RtfCell rtfCell = (RtfCell)this.cells.get(i);
            rtfCell.writeContent(outputStream);
        }
        outputStream.write(DELIMITER);
        if (this.document.getDocumentSettings().isOutputTableRowDefinitionAfter()) {
            this.writeRowDefinition(outputStream);
        }
        outputStream.write(ROW_END);
        this.document.outputDebugLinebreak(outputStream);
    }

    protected RtfTable getParentTable() {
        return this.parentTable;
    }

    protected ArrayList getCells() {
        return this.cells;
    }
}

