/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.SummaryAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalConcatenate
extends AggrFunction {
    public String getName() {
        return "CONCATENATE";
    }

    public int getType() {
        return 0;
    }

    public int getDataType() {
        return 5;
    }

    public IParameterDefn[] getParameterDefn() {
        IParameterDefn[] paramDefn = new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.ANY, Messages.getString("TotalConcatenate.paramDescription.expression")), new ParameterDefn(Messages.getString("TotalConcatenate.param.separator"), Messages.getString("TotalConcatenate.param.separator"), true, false, SupportedDataTypes.CALCULATABLE, Messages.getString("TotalConcatenate.paramDescription.separator")), new ParameterDefn(Messages.getString("TotalConcatenate.param.maxLength"), Messages.getString("TotalConcatenate.param.maxLength"), true, false, SupportedDataTypes.CALCULATABLE, Messages.getString("TotalConcatenate.paramDescription.maxLength")), new ParameterDefn(Messages.getString("TotalConcatenate.param.showAllValues"), Messages.getString("TotalConcatenate.param.showAllValues"), true, false, SupportedDataTypes.CALCULATABLE, Messages.getString("TotalConcatenate.paramDescription.showAllValues"))};
        return paramDefn;
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    public String getDescription() {
        return Messages.getString("TotalConcatenate.description");
    }

    public String getDisplayName() {
        return Messages.getString("TotalConcatenate.displayName");
    }

    private class MyAccumulator
    extends SummaryAccumulator {
        private Collection<String> values;
        private String separator;
        private int maxLength;
        private boolean isInitialized;
        private static final int DEFAULT_MAX_LENGTH = 1024;

        private MyAccumulator() {
        }

        public void start() {
            super.start();
            this.values = null;
            this.separator = "";
            this.isInitialized = false;
            this.maxLength = 1024;
        }

        public void onRow(Object[] args) throws DataException {
            assert (args != null && args.length >= 1);
            try {
                if (!this.isInitialized) {
                    this.isInitialized = true;
                    this.setSeparator(args.length >= 2 ? args[1] : null);
                    this.setMaxLength(args.length >= 3 ? args[2] : Integer.valueOf(1024));
                    this.setShowAllValues(args.length == 4 ? args[3] : Boolean.valueOf(false));
                }
                if (args[0] != null) {
                    this.values.add(DataTypeUtil.toString(args[0]));
                }
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }

        public Object getSummaryValue() {
            if (this.values == null) {
                return null;
            }
            StringBuffer buffer = new StringBuffer();
            for (String currentValue : this.values) {
                if (buffer.length() > this.maxLength - currentValue.length()) break;
                if (currentValue.trim().length() <= 0) continue;
                buffer.append(currentValue).append(this.separator);
            }
            if (buffer.length() > 0) {
                return buffer.toString().substring(0, buffer.length() - this.separator.length());
            }
            return buffer.toString();
        }

        private void setSeparator(Object source) throws BirtException {
            String value = DataTypeUtil.toString(source);
            if (value != null) {
                this.separator = value;
            }
        }

        private void setMaxLength(Object source) throws DataException {
            try {
                if (source == null || DataTypeUtil.toString(source).trim().length() == 0) {
                    this.maxLength = 1024;
                } else {
                    int value = DataTypeUtil.toInteger(source);
                    if (value < 1) {
                        throw new DataException(Messages.getString("aggregation.InvalidParameterValue"), new Object[]{TotalConcatenate.this.getParameterDefn()[2].getDisplayName(), TotalConcatenate.this.getDisplayName(), value});
                    }
                    this.maxLength = value;
                }
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }

        private void setShowAllValues(Object source) throws BirtException {
            boolean showAllValues;
            if (source == null || DataTypeUtil.toString(source).trim().length() == 0) {
                showAllValues = false;
            } else {
                if (!(source instanceof Boolean)) {
                    throw new DataException(String.valueOf(Messages.getString("aggregation.InvalidParameterType")) + TotalConcatenate.this.getName());
                }
                showAllValues = DataTypeUtil.toBoolean(source);
            }
            this.values = showAllValues ? new ArrayList<String>() : new LinkedHashSet<String>();
        }
    }
}

