/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.cache.ResultSetUtil;
import org.eclipse.birt.data.engine.impl.StringTable;
import org.eclipse.birt.data.engine.impl.index.IIndexSerializer;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryCache
implements ResultSetCache {
    private int countOfResult;
    private int currResultIndex = -1;
    private IResultClass rsMeta;
    private IResultObject currResultObject;
    private IResultObject[] resultObjects;

    public MemoryCache(IResultObject[] resultObjects, IResultClass rsMeta, Comparator comparator) {
        this.resultObjects = resultObjects;
        this.rsMeta = rsMeta;
        this.countOfResult = resultObjects.length;
        if (comparator != null) {
            Arrays.sort(this.resultObjects, comparator);
        }
    }

    @Override
    public int getCurrentIndex() throws DataException {
        return this.currResultIndex;
    }

    @Override
    public IResultObject getCurrentResult() throws DataException {
        return this.currResultObject;
    }

    @Override
    public boolean next() throws DataException {
        if (this.countOfResult == 0) {
            return false;
        }
        if (this.currResultIndex > this.countOfResult - 1) {
            this.currResultObject = null;
        } else {
            ++this.currResultIndex;
            this.currResultObject = this.currResultIndex == this.countOfResult ? null : this.resultObjects[this.currResultIndex];
        }
        return this.currResultObject != null;
    }

    @Override
    public IResultObject fetch() throws DataException {
        this.next();
        IResultObject resultObject = this.getCurrentResult();
        return resultObject;
    }

    @Override
    public void moveTo(int destIndex) throws DataException {
        this.checkValid(destIndex);
        this.currResultIndex = destIndex;
        this.currResultObject = this.currResultIndex == -1 || this.currResultIndex == this.countOfResult ? null : this.resultObjects[this.currResultIndex];
    }

    private void checkValid(int destIndex) throws DataException {
        if (destIndex < -1 || destIndex > this.countOfResult) {
            throw new DataException("data.engine.BadDestIndex", new Object[]{-1, this.countOfResult});
        }
    }

    @Override
    public int getCount() {
        return this.countOfResult;
    }

    @Override
    public void reset() {
        this.currResultIndex = -1;
        this.currResultObject = null;
    }

    @Override
    public void close() {
        this.reset();
        this.resultObjects = null;
    }

    @Override
    public void doSave(DataOutputStream outputStream, DataOutputStream rowLensStream, Map<String, StringTable> stringTable, Map<String, IIndexSerializer> index, List<IBinding> cacheRequestMap) throws DataException {
        DataOutputStream dos = new DataOutputStream(outputStream);
        Set resultSetNameSet = ResultSetUtil.getRsColumnRequestMap(cacheRequestMap);
        try {
            int rowCount = this.resultObjects.length;
            int colCount = this.getColumnCount(this.rsMeta);
            IOUtil.writeInt(dos, rowCount);
            long offset = 4L;
            int i = 0;
            while (i < rowCount) {
                IOUtil.writeLong(rowLensStream, offset);
                offset += (long)ResultSetUtil.writeResultObject(dos, this.resultObjects[i], colCount, resultSetNameSet, stringTable, index, i);
                ++i;
            }
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", e);
        }
    }

    private int getColumnCount(IResultClass meta) throws DataException {
        int count = meta.getFieldCount();
        int i = 1;
        while (i <= meta.getFieldCount()) {
            if (meta.getFieldName(i).equals("_$$_dte_inner_row_id_$$_")) {
                --count;
            }
            ++i;
        }
        return count;
    }

    @Override
    public void incrementalUpdate(OutputStream outputStream, OutputStream rowLensStream, int originalRowCount, Map<String, StringTable> stringTable, Map<String, IIndexSerializer> map, List<IBinding> cacheRequestMap) throws DataException {
        Set resultSetNameSet = ResultSetUtil.getRsColumnRequestMap(cacheRequestMap);
        try {
            int rowCount = originalRowCount + this.resultObjects.length;
            int colCount = this.rsMeta.getFieldCount();
            IOUtil.writeInt(outputStream, rowCount);
            if (outputStream instanceof RAOutputStream) {
                ((RAOutputStream)outputStream).seek(((RAOutputStream)outputStream).length());
            }
            if (rowLensStream instanceof RAOutputStream) {
                ((RAOutputStream)rowLensStream).seek(((RAOutputStream)rowLensStream).length());
            }
            DataOutputStream dos = new DataOutputStream(outputStream);
            DataOutputStream rlos = new DataOutputStream(rowLensStream);
            long offset = 4L;
            if (outputStream instanceof RAOutputStream) {
                offset = ((RAOutputStream)outputStream).length();
            }
            int i = 0;
            while (i < rowCount - originalRowCount) {
                IOUtil.writeLong(rlos, offset);
                offset += (long)ResultSetUtil.writeResultObject(dos, this.resultObjects[i], colCount, resultSetNameSet, stringTable, map, originalRowCount + i);
                ++i;
            }
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", e);
        }
    }

    @Override
    public void setResultClass(IResultClass rsMeta) throws DataException {
        this.rsMeta = rsMeta;
    }
}

