/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.ParameterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ColumnAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ComputedColumnAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ConditionAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ExpressionAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.FilterAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.GroupAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.InputParamBindingAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.JointDataSetAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.OdaDataSetAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.OdaDataSourceAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ParameterAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ScriptDataSetAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ScriptDataSourceAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.SortAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.SortHintAdapter;
import org.eclipse.birt.report.model.api.AggregationArgumentHandle;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;
import org.eclipse.birt.report.model.api.SortHintHandle;
import org.eclipse.birt.report.model.api.SortKeyHandle;
import org.mozilla.javascript.Scriptable;

public class ModelAdapter
implements IModelAdapter {
    private static Logger logger = Logger.getLogger(ModelAdapter.class.getName());
    DataSessionContext context;

    public ModelAdapter(DataSessionContext context) {
        this.context = context;
    }

    public BaseDataSourceDesign adaptDataSource(DataSourceHandle handle) throws BirtException {
        if (handle instanceof OdaDataSourceHandle) {
            Scriptable propBindingScope = this.context.hasExternalScope() ? this.context.getTopScope() : null;
            return new OdaDataSourceAdapter((OdaDataSourceHandle)handle, propBindingScope, this.context.getDataEngineContext(), this);
        }
        if (handle instanceof ScriptDataSourceHandle) {
            return new ScriptDataSourceAdapter((ScriptDataSourceHandle)handle);
        }
        logger.fine("handle type: " + (handle == null ? "" : handle.getClass().getName()));
        return null;
    }

    public BaseDataSetDesign adaptDataSet(DataSetHandle handle) throws BirtException {
        BaseDataSetDesign design = null;
        if (handle instanceof OdaDataSetHandle) {
            Scriptable propBindingScope = this.context.hasExternalScope() ? this.context.getTopScope() : null;
            design = new OdaDataSetAdapter((OdaDataSetHandle)handle, propBindingScope, this, this.context.getDataEngineContext());
        }
        if (handle instanceof ScriptDataSetHandle) {
            design = new ScriptDataSetAdapter((ScriptDataSetHandle)handle, this);
        }
        if (handle instanceof JointDataSetHandle) {
            design = new JointDataSetAdapter((JointDataSetHandle)handle, this);
        }
        if (design != null) {
            if (handle.getACLExpression() != null) {
                design.setDataSetACL(this.adaptExpression((Expression)handle.getACLExpression().getValue()));
            }
            if (handle.getRowACLExpression() != null) {
                design.setRowACL(this.adaptExpression((Expression)handle.getRowACLExpression().getValue()));
            }
            Iterator columnHintIterator = handle.columnHintsIterator();
            while (columnHintIterator.hasNext()) {
                ColumnHintHandle ch = (ColumnHintHandle)columnHintIterator.next();
                design.setDataSetColumnACL(ch.getColumnName(), this.adaptExpression((Expression)ch.getACLExpression().getValue()));
            }
        }
        if (design != null) {
            design.setCompareLocale(handle.getLocale());
            design.setNullsOrdering(handle.getNullsOrdering());
        }
        logger.fine("handle type: " + (handle == null ? "" : handle.getClass().getName()));
        return design;
    }

    public ConditionalExpression adaptConditionalExpression(String mainExpr, String operator, String operand1, String operand2) {
        return new ConditionAdapter(mainExpr, operator, operand1, operand2);
    }

    public ScriptExpression adaptExpression(Expression expr, String dataType) {
        if (expr == null || expr.getStringExpression() == null) {
            return null;
        }
        ScriptExpression jsExpr = new ExpressionAdapter(expr, dataType);
        if ("constant".equals(expr.getType())) {
            jsExpr = new ScriptExpression(JavascriptEvalUtil.transformToJsExpression(expr.getStringExpression()));
            jsExpr.setConstant(true);
            jsExpr.setConstantValue(expr.getExpression());
        }
        return jsExpr;
    }

    public FilterDefinition adaptFilter(FilterConditionHandle modelFilter) {
        try {
            return new FilterAdapter((IModelAdapter)this, modelFilter);
        }
        catch (AdapterException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public SortDefinition adaptSortHint(SortHintHandle sortHint) {
        try {
            return new SortHintAdapter(this, sortHint);
        }
        catch (AdapterException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public GroupDefinition adaptGroup(GroupHandle groupHandle) {
        try {
            return new GroupAdapter(this, groupHandle);
        }
        catch (AdapterException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public SortDefinition adaptSort(SortKeyHandle sortHandle) {
        try {
            return new SortAdapter(this, sortHandle);
        }
        catch (AdapterException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public SortDefinition adaptSort(Expression expr, String direction) {
        try {
            return new SortAdapter(this, expr, direction);
        }
        catch (AdapterException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public ParameterDefinition adaptParameter(DataSetParameterHandle paramHandle) {
        return new ParameterAdapter(paramHandle);
    }

    public InputParameterBinding adaptInputParamBinding(ParamBindingHandle modelHandle) {
        try {
            return new InputParamBindingAdapter(this, modelHandle);
        }
        catch (AdapterException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public ColumnDefinition ColumnAdaptor(ResultSetColumnHandle modelColumn) {
        return new ColumnAdapter(modelColumn);
    }

    public ComputedColumn adaptComputedColumn(ComputedColumnHandle modelHandle) throws AdapterException {
        return new ComputedColumnAdapter(this, modelHandle);
    }

    public IBinding adaptBinding(ComputedColumnHandle handle) {
        block4: {
            try {
                if (handle != null) break block4;
                return null;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
        }
        Binding result = new Binding(handle.getName());
        if (handle.getExpression() != null) {
            ScriptExpression expr = this.adaptExpression((Expression)handle.getExpressionProperty("expression").getValue(), handle.getDataType());
            expr.setGroupName(handle.getAggregateOn());
            result.setExpression(expr);
        }
        result.setDisplayName(handle.getExternalizedValue("displayNameID", "displayName", this.context.getDataEngineContext().getLocale()));
        result.setDataType(DataAdapterUtil.adaptModelDataType(handle.getDataType()));
        result.setAggrFunction(DataAdapterUtil.adaptModelAggregationType(handle.getAggregateFunction()));
        result.setFilter(handle.getFilterExpression() == null ? null : this.adaptExpression((Expression)handle.getExpressionProperty("filterExpr").getValue(), "boolean"));
        this.populateArgument(result, handle);
        this.populateAggregateOns(result, handle);
        return result;
    }

    private void populateAggregateOns(IBinding result, ComputedColumnHandle handle) throws AdapterException {
        List aggrOns = handle.getAggregateOnList();
        if (aggrOns == null) {
            return;
        }
        int i = 0;
        while (i < aggrOns.size()) {
            try {
                result.addAggregateOn(aggrOns.get(i).toString());
            }
            catch (DataException e) {
                throw new AdapterException(e.getLocalizedMessage(), e);
            }
            ++i;
        }
    }

    private void populateArgument(IBinding binding, ComputedColumnHandle modelCmptdColumn) throws AdapterException {
        Iterator it = modelCmptdColumn.argumentsIterator();
        while (it != null && it.hasNext()) {
            AggregationArgumentHandle arg = (AggregationArgumentHandle)it.next();
            try {
                Expression expr = (Expression)arg.getExpressionProperty("value").getValue();
                binding.addArgument(this.adaptExpression(expr));
            }
            catch (DataException e) {
                throw new AdapterException(e.getLocalizedMessage(), e);
            }
        }
    }

    public ConditionalExpression adaptConditionalExpression(Expression mainExpr, String operator, Expression operand1, Expression operand2) {
        return new ConditionAdapter((IScriptExpression)this.adaptExpression(mainExpr), operator, (IBaseExpression)this.adaptExpression(operand1), (IBaseExpression)this.adaptExpression(operand2));
    }

    public ScriptExpression adaptExpression(Expression expr) {
        return this.adaptExpression(expr, IModelAdapter.ExpressionLocation.TABLE);
    }

    public ScriptExpression adaptExpression(String jsExpr, String dataType) {
        if (jsExpr == null) {
            return null;
        }
        return new ExpressionAdapter(jsExpr, dataType);
    }

    public ScriptExpression adaptJSExpression(String jsExpr, String dataType) {
        if (jsExpr == null) {
            return null;
        }
        return new ExpressionAdapter(jsExpr, dataType);
    }

    public ScriptExpression adaptExpression(Expression expr, IModelAdapter.ExpressionLocation el) {
        if (expr == null) {
            return null;
        }
        ScriptExpression jsExpr = null;
        if ("constant".equals(expr.getType())) {
            jsExpr = new ScriptExpression(JavascriptEvalUtil.transformToJsExpression(expr.getStringExpression()));
            jsExpr.setConstant(true);
            jsExpr.setConstantValue(expr.getExpression());
            return jsExpr;
        }
        if (expr.getStringExpression() == null) {
            return null;
        }
        jsExpr = new ExpressionAdapter(expr, el);
        return jsExpr;
    }
}

