/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.birt.report.engine.api.IImage;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.impl.Image;
import org.eclipse.birt.report.model.api.ConfigVariableHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FactoryPropertyHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;

public abstract class DesignRunnable
implements IReportRunnable {
    protected IReportEngine engine;
    protected DesignElementHandle designHandle;

    public DesignRunnable(IReportEngine engine, DesignElementHandle designHandle) {
        this.engine = engine;
        this.designHandle = designHandle;
    }

    public Object getProperty(String propertyName) {
        FactoryPropertyHandle handle = this.getDesignHandle().getFactoryPropertyHandle(propertyName);
        if (handle != null) {
            return handle.getStringValue();
        }
        return null;
    }

    public Object getProperty(String path, String propertyName) {
        return null;
    }

    public DesignElementHandle getDesignHandle() {
        return this.designHandle;
    }

    public IReportEngine getReportEngine() {
        return this.engine;
    }

    public String getReportName() {
        ModuleHandle moduleHandle = this.getModuleHandle();
        return moduleHandle.getFileName();
    }

    public HashMap getTestConfig() {
        ModuleHandle moduleHandle = this.getModuleHandle();
        HashMap<String, String> configs = new HashMap<String, String>();
        Iterator iter = moduleHandle.configVariablesIterator();
        if (iter != null) {
            while (iter.hasNext()) {
                ConfigVariableHandle handle = (ConfigVariableHandle)iter.next();
                String name = handle.getName();
                String value = handle.getValue();
                configs.put(name, value);
            }
        }
        return configs;
    }

    public IImage getImage(String name) {
        ModuleHandle moduleHandle = this.getModuleHandle();
        EmbeddedImage embeddedImage = moduleHandle.findImage(name);
        if (embeddedImage != null) {
            Image image = new Image(embeddedImage.getData(moduleHandle.getModule()), name);
            image.setReportRunnable(this);
            return image;
        }
        return null;
    }

    protected ModuleHandle getModuleHandle() {
        return (ModuleHandle)this.designHandle;
    }
}

