/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.item.crosstab.core.CrosstabException;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabReportItemConstants;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.internal.AbstractCrosstabModelTask;
import org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabModelUtil;
import org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabViewTask;
import org.eclipse.birt.report.item.crosstab.core.de.internal.LevelViewTask;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MemberValueHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrosstabReportItemTask
extends AbstractCrosstabModelTask
implements ICrosstabReportItemConstants {
    public CrosstabReportItemTask(CrosstabReportItemHandle focus) {
        super(focus);
        this.crosstab = focus;
    }

    public CrosstabCellHandle addGrandTotal(int axisType, List<MeasureViewHandle> measureList, List<String> functionList) throws SemanticException {
        if (this.crosstab == null || !CrosstabModelUtil.isValidAxisType(axisType)) {
            return null;
        }
        CommandStack stack = this.crosstab.getCommandStack();
        stack.startTrans(Messages.getString("CrosstabReportItemTask.msg.add.grandtotal"));
        CrosstabCellHandle grandTotal = null;
        try {
            CrosstabViewHandle crosstabView = this.crosstab.getCrosstabView(axisType);
            if (crosstabView == null) {
                crosstabView = this.crosstab.addCrosstabView(axisType);
            }
            grandTotal = new CrosstabViewTask(crosstabView).addGrandTotal(measureList, functionList, false);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
        return grandTotal;
    }

    public void removeGrandTotal(int axisType) throws SemanticException {
        CrosstabViewHandle crosstabView = this.crosstab.getCrosstabView(axisType);
        if (crosstabView != null) {
            crosstabView.removeGrandTotal();
        }
    }

    public void removeGrandTotal(int axisType, int measureIndex) throws SemanticException {
        CrosstabViewHandle crosstabView = this.crosstab.getCrosstabView(axisType);
        if (crosstabView != null) {
            crosstabView.removeGrandTotal(measureIndex);
        }
    }

    public List<MeasureViewHandle> getAggregationMeasures(int axisType) {
        if (this.crosstab == null || this.crosstab.getGrandTotal(axisType) == null) {
            return Collections.emptyList();
        }
        ArrayList<MeasureViewHandle> measures = new ArrayList<MeasureViewHandle>();
        int i = 0;
        while (i < this.crosstab.getMeasureCount()) {
            MeasureViewHandle measureView = this.crosstab.getMeasure(i);
            if (!measures.contains(measureView) && CrosstabModelUtil.isAggregationOn(measureView, null, axisType)) {
                measures.add(measureView);
            }
            ++i;
        }
        return measures;
    }

    public String getAggregationFunction(int axisType, MeasureViewHandle measureView) {
        if (this.crosstab == null || this.crosstab.getGrandTotal(axisType) == null || measureView == null || this.crosstab != measureView.getCrosstab()) {
            return null;
        }
        int j = 0;
        while (j < measureView.getAggregationCount()) {
            String function;
            AggregationCellHandle cell = measureView.getAggregationCell(j);
            if ((axisType == 1 && cell.getAggregationOnColumn() == null || axisType == 0 && cell.getAggregationOnRow() == null) && (function = CrosstabModelUtil.getAggregationFunction(this.crosstab, cell)) != null) {
                return function;
            }
            ++j;
        }
        return null;
    }

    public void setAggregationFunction(int axisType, MeasureViewHandle measureView, String function) throws SemanticException {
        if (this.crosstab == null || this.crosstab.getGrandTotal(axisType) == null || measureView == null || this.crosstab != measureView.getCrosstab()) {
            return;
        }
        CommandStack stack = this.crosstab.getCommandStack();
        stack.startTrans(Messages.getString("CrosstabReportItemTask.msg.set.aggregate.function"));
        try {
            int j = 0;
            while (j < measureView.getAggregationCount()) {
                AggregationCellHandle cell = measureView.getAggregationCell(j);
                if (axisType == 1 && cell.getAggregationOnColumn() == null || axisType == 0 && cell.getAggregationOnRow() == null) {
                    CrosstabModelUtil.setAggregationFunction(this.crosstab, cell, function);
                }
                ++j;
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public void pivotCrosstab() throws SemanticException {
        CommandStack stack = this.crosstab.getCommandStack();
        stack.startTrans(Messages.getString("CrosstabReportItemTask.msg.pivot.crosstab"));
        try {
            int transfered = this.transferDimensions(0, 0);
            this.transferDimensions(1, transfered);
            CrosstabCellHandle replaced = this.transferGrandTotal(0, null, true);
            this.transferGrandTotal(1, replaced, false);
            int i = 0;
            while (i < this.crosstab.getMeasureCount()) {
                MeasureViewHandle mv = this.crosstab.getMeasure(i);
                this.swapAggregateOn(mv.getCell());
                int j = 0;
                while (j < mv.getAggregationCount()) {
                    this.swapAggregateOn(mv.getAggregationCell(j));
                    ++j;
                }
                ++i;
            }
            this.swapViewProperties();
            String oldDirction = this.crosstab.getMeasureDirection();
            String newDirection = "horizontal".equals(oldDirction) ? "vertical" : "horizontal";
            this.crosstab.getModelHandle().setStringProperty("measureDirection", newDirection);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    private void swapViewProperties() throws SemanticException {
        CrosstabViewHandle colView;
        String rowGrandTotalLocation = null;
        String colGrandTotalLocation = null;
        LevelHandle rowMirrorStartLevel = null;
        LevelHandle colMirrorStartLevel = null;
        List rowMembers = null;
        List colMembers = null;
        CrosstabViewHandle rowView = this.crosstab.getCrosstabView(0);
        if (rowView != null) {
            rowMembers = rowView.getMembers();
            rowMirrorStartLevel = rowView.getMirroredStartingLevel();
            rowGrandTotalLocation = rowView.getGrandTotalLocation();
        }
        if ((colView = this.crosstab.getCrosstabView(1)) != null) {
            colMembers = colView.getMembers();
            colMirrorStartLevel = colView.getMirroredStartingLevel();
            colGrandTotalLocation = colView.getGrandTotalLocation();
        }
        if (rowView != null) {
            this.transferViewProperties(rowView, colGrandTotalLocation, colMirrorStartLevel, colMembers);
        }
        if (colView != null) {
            this.transferViewProperties(colView, rowGrandTotalLocation, rowMirrorStartLevel, rowMembers);
        }
    }

    private void transferViewProperties(CrosstabViewHandle view, String grandTotalLocation, LevelHandle mirrorStartLevel, List members) throws SemanticException {
        view.setGrandTotalLocation(grandTotalLocation);
        view.setMirroredStartingLevel(mirrorStartLevel);
        view.getModelHandle().getPropertyHandle("members").clearValue();
        if (members != null) {
            for (Object mv : members) {
                view.addMember((MemberValueHandle)((MemberValueHandle)mv).copy().getHandle(view.getModuleHandle().getModule()));
            }
        }
    }

    private void swapAggregateOn(AggregationCellHandle aggCell) throws SemanticException {
        if (aggCell == null) {
            return;
        }
        LevelHandle rowLevel = aggCell.getAggregationOnRow();
        LevelHandle colLevel = aggCell.getAggregationOnColumn();
        aggCell.setAggregationOnColumn(rowLevel);
        aggCell.setAggregationOnRow(colLevel);
    }

    private int transferDimensions(int srcAxis, int offset) throws SemanticException {
        int transfered = 0;
        int dimCount = this.crosstab.getDimensionCount(srcAxis) - offset;
        if (dimCount > 0) {
            int targetAxis = CrosstabModelUtil.getOppositeAxisType(srcAxis);
            CrosstabViewHandle targetCrosstabView = this.crosstab.getCrosstabView(targetAxis);
            if (targetCrosstabView == null) {
                targetCrosstabView = this.crosstab.addCrosstabView(targetAxis);
            }
            DesignElementHandle targetViewHandle = targetCrosstabView.getModelHandle();
            int i = 0;
            while (i < dimCount) {
                DimensionViewHandle dv = this.crosstab.getDimension(srcAxis, offset);
                dv.getModelHandle().moveTo(targetViewHandle, "views", i);
                ++transfered;
                ++i;
            }
        }
        return transfered;
    }

    private CrosstabCellHandle transferGrandTotal(int srcAxis, CrosstabCellHandle oldGT, boolean firstMove) throws SemanticException {
        CrosstabViewHandle srcView;
        CrosstabCellHandle srcGT = null;
        srcGT = firstMove ? ((srcView = this.crosstab.getCrosstabView(srcAxis)) != null ? srcView.getGrandTotal() : null) : oldGT;
        CrosstabCellHandle targetReplaced = null;
        int targetAxis = CrosstabModelUtil.getOppositeAxisType(srcAxis);
        CrosstabViewHandle targetView = this.crosstab.getCrosstabView(targetAxis);
        if (firstMove) {
            CrosstabCellHandle crosstabCellHandle = targetReplaced = targetView == null ? null : targetView.getGrandTotal();
            if (srcGT != null && srcGT.getModelHandle().getContainer() != null) {
                CrosstabCellHandle srcClone = (CrosstabCellHandle)CrosstabUtil.getReportItem(srcGT.getModelHandle().copy().getHandle(this.crosstab.getModuleHandle().getModule()));
                srcGT.getModelHandle().drop();
                srcGT = srcClone;
            }
            if (targetReplaced != null) {
                CrosstabCellHandle targetClone = (CrosstabCellHandle)CrosstabUtil.getReportItem(targetReplaced.getModelHandle().copy().getHandle(this.crosstab.getModuleHandle().getModule()));
                targetReplaced.getModelHandle().drop();
                targetReplaced = targetClone;
            }
        }
        if (srcGT != null) {
            PropertyHandle targetPropertyHandle;
            if (targetView == null) {
                targetView = this.crosstab.addCrosstabView(targetAxis);
            }
            if ((targetPropertyHandle = targetView.getGrandTotalProperty()).getContentCount() <= 0) {
                targetPropertyHandle.add(srcGT.getModelHandle());
            }
        }
        return targetReplaced;
    }

    public void pivotDimension(String name, int targetAxisType, int targetIndex) throws SemanticException {
        DimensionViewHandle dimensionView = this.crosstab.getDimension(name);
        if (dimensionView == null) {
            this.crosstab.getLogger().log(Level.SEVERE, "Error.CrosstabException.DIMENSION_NOT_FOUND", name);
            throw new CrosstabException(this.crosstab.getModelHandle().getElement(), Messages.getString("Error.CrosstabException.DIMENSION_NOT_FOUND", name));
        }
        this.moveDimension(dimensionView, targetAxisType, targetIndex);
    }

    private void moveDimension(DimensionViewHandle dimensionView, int targetAxisType, int targetIndex) throws SemanticException {
        assert (dimensionView != null);
        HashMap functionListMap = new HashMap();
        HashMap<String, List> measureListMap = new HashMap<String, List>();
        int i = 0;
        while (i < dimensionView.getLevelCount()) {
            LevelViewHandle levelView = dimensionView.getLevel(i);
            String name = levelView.getCubeLevelName();
            if (name != null) {
                List measureList = levelView.getAggregationMeasures();
                ArrayList<String> functionList = new ArrayList<String>();
                int j = 0;
                while (j < measureList.size()) {
                    MeasureViewHandle measureView = (MeasureViewHandle)measureList.get(j);
                    String function = levelView.getAggregationFunction(measureView);
                    if (function == null) {
                        functionList.add(CrosstabModelUtil.getDefaultMeasureAggregationFunction(measureView));
                    } else {
                        functionList.add(function);
                    }
                    ++j;
                }
                functionListMap.put(name, functionList);
                measureListMap.put(name, measureList);
            }
            ++i;
        }
        List<MeasureViewHandle> grandMeasureList = this.getAggregationMeasures(targetAxisType);
        ArrayList<String> grandFunctionList = new ArrayList<String>();
        int j = 0;
        while (j < grandMeasureList.size()) {
            MeasureViewHandle measureView = grandMeasureList.get(j);
            String function = this.getAggregationFunction(targetAxisType, measureView);
            if (function == null) {
                grandFunctionList.add(CrosstabModelUtil.getDefaultMeasureAggregationFunction(measureView));
            } else {
                grandFunctionList.add(function);
            }
            ++j;
        }
        DimensionViewHandle clonedDimensionView = (DimensionViewHandle)CrosstabUtil.getReportItem(dimensionView.getModelHandle().copy().getHandle(dimensionView.getModelHandle().getModule()));
        CommandStack stack = this.crosstab.getCommandStack();
        stack.startTrans(Messages.getString("CrosstabReportItemTask.msg.pivot.dimension"));
        try {
            int i2;
            CrosstabViewHandle srcCrosstabView = (CrosstabViewHandle)dimensionView.getContainer();
            new CrosstabViewTask(srcCrosstabView).removeDimension(dimensionView, false);
            CrosstabViewHandle targetCrosstabView = this.crosstab.getCrosstabView(targetAxisType);
            if (targetCrosstabView == null) {
                targetCrosstabView = this.crosstab.addCrosstabView(targetAxisType);
            }
            ArrayList<MeasureViewHandle> transferMeasureList = new ArrayList<MeasureViewHandle>();
            ArrayList<String> transferFunctionList = new ArrayList<String>();
            if (targetCrosstabView.getDimensionCount() == 0 && targetCrosstabView.getGrandTotal() == null) {
                i2 = 0;
                while (i2 < srcCrosstabView.getDimensionCount()) {
                    DimensionViewHandle dv = srcCrosstabView.getDimension(i2);
                    int j2 = 0;
                    while (j2 < dv.getLevelCount()) {
                        LevelViewHandle lv = dv.getLevel(j2);
                        if (lv.getAggregationHeader() != null) {
                            int k = 0;
                            while (k < this.crosstab.getMeasureCount()) {
                                AggregationCellHandle aggCell;
                                MeasureViewHandle mv = this.crosstab.getMeasure(k);
                                String rowDimension = null;
                                String rowLevel = null;
                                String colDimension = dv.getCubeDimensionName();
                                String colLevel = lv.getCubeLevelName();
                                if (srcCrosstabView.getAxisType() == 0) {
                                    rowDimension = colDimension;
                                    rowLevel = colLevel;
                                    colDimension = null;
                                    colLevel = null;
                                }
                                if ((aggCell = mv.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel)) != null) {
                                    aggCell.getModelHandle().drop();
                                }
                                ++k;
                            }
                        }
                        ++j2;
                    }
                    ++i2;
                }
                if (srcCrosstabView.getGrandTotal() != null) {
                    i2 = 0;
                    while (i2 < this.crosstab.getMeasureCount()) {
                        MeasureViewHandle mv = this.crosstab.getMeasure(i2);
                        AggregationCellHandle aggCell = mv.getAggregationCell(null, null, null, null);
                        if (aggCell != null) {
                            String function = this.getAggregationFunction(srcCrosstabView.getAxisType(), mv);
                            aggCell.getModelHandle().drop();
                            transferMeasureList.add(mv);
                            transferFunctionList.add(function);
                        }
                        ++i2;
                    }
                }
            }
            targetCrosstabView.getViewsProperty().add(clonedDimensionView.getModelHandle(), targetIndex);
            if (transferMeasureList.size() > 0 && clonedDimensionView.getLevelCount() > 0) {
                this.addMeasureAggregations(clonedDimensionView.getLevel(clonedDimensionView.getLevelCount() - 1), transferMeasureList, transferFunctionList, false);
            }
            i2 = 0;
            while (i2 < clonedDimensionView.getLevelCount()) {
                LevelViewHandle levelView = clonedDimensionView.getLevel(i2);
                String levelName = levelView.getCubeLevelName();
                if (levelName != null) {
                    if (levelView.isInnerMost()) {
                        if (levelView.getAggregationHeaderProperty().getContentCount() > 0) {
                            levelView.getAggregationHeaderProperty().drop(0);
                        }
                    } else {
                        List measureList = (List)measureListMap.get(levelName);
                        List functionList = (List)functionListMap.get(levelName);
                        new LevelViewTask(levelView).addSubTotal(measureList, functionList, false);
                    }
                }
                ++i2;
            }
            if (grandMeasureList.size() > 0) {
                this.addMeasureAggregations(targetAxisType, grandMeasureList, grandFunctionList, false);
            }
            this.validateCrosstab();
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public void pivotDimension(int srcAxisType, int srcIndex, int targetAxisType, int targetIndex) throws SemanticException {
        DimensionViewHandle dimensionView = this.crosstab.getDimension(srcAxisType, srcIndex);
        if (dimensionView == null) {
            this.crosstab.getLogger().log(Level.INFO, "Error.CrosstabException.DIMENSION_NOT_FOUND", String.valueOf(srcAxisType));
            return;
        }
        this.moveDimension(dimensionView, targetAxisType, targetIndex);
    }

    public DimensionViewHandle insertDimension(DimensionHandle dimensionHandle, int axisType, int index) throws SemanticException {
        if (dimensionHandle != null && this.crosstab.getDimension(dimensionHandle.getQualifiedName()) != null) {
            this.crosstab.getLogger().log(Level.SEVERE, "Error.CrosstabException.DUPLICATE_DIMENSION", dimensionHandle.getQualifiedName());
            throw new CrosstabException(this.crosstab.getModelHandle().getElement(), Messages.getString("Error.CrosstabException.DUPLICATE_DIMENSION", dimensionHandle.getQualifiedName()));
        }
        DimensionViewHandle dimensionView = null;
        CommandStack stack = this.crosstab.getCommandStack();
        stack.startTrans(Messages.getString("CrosstabReportItemTask.msg.insert.dimension"));
        try {
            CrosstabViewHandle crosstabView = this.crosstab.getCrosstabView(axisType);
            if (crosstabView == null) {
                crosstabView = this.crosstab.addCrosstabView(axisType);
            }
            dimensionView = crosstabView.insertDimension(dimensionHandle, index);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
        return dimensionView;
    }

    public void removeDimension(String name) throws SemanticException {
        DimensionViewHandle dimensionView = this.crosstab.getDimension(name);
        if (dimensionView == null) {
            this.crosstab.getLogger().log(Level.SEVERE, "Error.CrosstabException.DIMENSION_NOT_FOUND", name);
            throw new CrosstabException(this.crosstab.getModelHandle().getElement(), Messages.getString("Error.CrosstabException.DIMENSION_NOT_FOUND", name));
        }
        this.removeDimension(dimensionView.getAxisType(), dimensionView.getIndex());
    }

    public void removeDimension(int axisType, int index) throws SemanticException {
        CrosstabViewHandle crosstabView = this.crosstab.getCrosstabView(axisType);
        if (crosstabView != null) {
            crosstabView.removeDimension(index);
        }
    }
}

