/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.Grid;
import org.eclipse.birt.chart.computation.withaxes.IntersectionValue;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location3D;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.emf.ecore.EObject;

public final class OneAxis {
    private AutoScale sc;
    private double dAxisRenderingCoordinate;
    private Location3D locAxisRenderingCoordinate;
    private double dTitleRenderingCoordinate;
    private int iOrientation;
    private int iLabelPosition;
    private int iTitlePosition;
    private LineAttributes lia = null;
    private Label la = null;
    private Label laTitle = null;
    private IntersectionValue iv = null;
    private Grid gr = null;
    private boolean bCategoryScale = false;
    private boolean bTickBwteenCategories = true;
    private final Axis axModel;
    private final int axisType;
    private boolean bShowLabels = true;
    private static final IGObjectFactory goFactory = GObjectFactory.instance();

    OneAxis(Axis axModel) {
        this.axModel = axModel;
        this.gr = new Grid();
        this.axisType = 0;
    }

    OneAxis(Axis axModel, int axisType) {
        this.axModel = axModel;
        this.gr = new Grid();
        this.axisType = axisType;
    }

    public int getAxisType() {
        return this.axisType;
    }

    void set(int _iOrientation, int _iLabelPosition, int _iTitlePosition, boolean _bCategoryScale, boolean _bTickBwteenCategories) {
        this.iOrientation = _iOrientation;
        this.iLabelPosition = _iLabelPosition;
        this.iTitlePosition = _iTitlePosition;
        this.bCategoryScale = _bCategoryScale;
        this.bTickBwteenCategories = _bTickBwteenCategories;
    }

    public void setAxisCoordinate(double _dAxisRenderingCoordinate) {
        this.dAxisRenderingCoordinate = _dAxisRenderingCoordinate;
    }

    void setAxisCoordinate3D(Location3D loc3d) {
        this.locAxisRenderingCoordinate = loc3d;
    }

    public void setTitleCoordinate(double _dTitleRenderingCoordinate) {
        this.dTitleRenderingCoordinate = _dTitleRenderingCoordinate;
    }

    public int getCombinedTickStyle() {
        return this.gr.getTickStyle(0) | this.gr.getTickStyle(1);
    }

    public final double getAxisCoordinate() {
        return this.dAxisRenderingCoordinate;
    }

    public final Location3D getAxisCoordinate3D() {
        return this.locAxisRenderingCoordinate;
    }

    public final double getTitleCoordinate() {
        return this.dTitleRenderingCoordinate;
    }

    public final int getLabelPosition() {
        return this.iLabelPosition;
    }

    public final int getTitlePosition() {
        return this.iTitlePosition;
    }

    public final Axis getModelAxis() {
        return this.axModel;
    }

    final void setGridProperties(LineAttributes laMajorGrid, LineAttributes laMinorGrid, LineAttributes laMajorTicks, LineAttributes laMinorTicks, int iMajorTickStyle, int iMinorTickStyle, int iMinorUnitsPerMajorUnit) {
        this.gr.laMajorGrid = laMajorGrid;
        this.gr.laMinorGrid = laMinorGrid;
        this.gr.laMajorTicks = laMajorTicks;
        this.gr.laMinorTicks = laMinorTicks;
        this.gr.iMajorTickStyle = iMajorTickStyle;
        this.gr.iMinorTickStyle = iMinorTickStyle;
        this.gr.iMinorUnitsPerMajorUnit = iMinorUnitsPerMajorUnit;
    }

    public final Grid getGrid() {
        return this.gr;
    }

    public final int getOrientation() {
        return this.iOrientation;
    }

    public final boolean isCategoryScale() {
        return this.bCategoryScale;
    }

    public final boolean isTickBwtweenCategories() {
        return !this.bCategoryScale || this.bTickBwteenCategories;
    }

    public final Chart getChartModel() {
        if (this.axModel == null) {
            return null;
        }
        EObject ct = this.axModel.eContainer();
        while (ct != null) {
            if (ct instanceof ChartWithAxes) {
                return (Chart)ct;
            }
            ct = ct.eContainer();
        }
        return null;
    }

    final boolean isAxisLabelStaggered() {
        if (this.axModel == null) {
            return false;
        }
        ChartDimension dim = null;
        Chart cm = this.getChartModel();
        if (cm != null) {
            dim = cm.getDimension();
        }
        if (dim == ChartDimension.THREE_DIMENSIONAL_LITERAL) {
            return false;
        }
        return this.axModel.isStaggered();
    }

    final int getLableShowingInterval() {
        if (this.axModel == null) {
            return 1;
        }
        int i = this.axModel.getInterval();
        if (i < 1) {
            return 1;
        }
        return i;
    }

    void set(AutoScale _sc) {
        this.sc = _sc;
    }

    public AutoScale getScale() {
        return this.sc;
    }

    void set(IntersectionValue _iv) {
        this.iv = _iv;
    }

    void set(Label _laAxisLabels, Label _laAxisTitle) {
        this.la = goFactory.copyOf(_laAxisLabels);
        this.laTitle = goFactory.copyOf(_laAxisTitle);
    }

    void set(LineAttributes _la) {
        this.lia = _la;
    }

    public final LineAttributes getLineAttributes() {
        return this.lia;
    }

    public final IntersectionValue getIntersectionValue() {
        return this.iv;
    }

    public final Label getLabel() {
        return this.la;
    }

    public final Label getTitle() {
        return this.laTitle;
    }

    public final FormatSpecifier getFormatSpecifier() {
        return this.axModel.getFormatSpecifier();
    }

    public final RunTimeContext getRunTimeContext() {
        return this.sc.getRunTimeContext();
    }

    public final boolean isShowLabels() {
        return this.bShowLabels;
    }

    public final void setShowLabels(boolean bShowLabels) {
        this.bShowLabels = bShowLabels;
    }
}

