/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc.authentication;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.apache.derby.authentication.UserAuthenticator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.authentication.AuthenticationServiceBase;

public final class BasicAuthenticationServiceImpl
extends AuthenticationServiceBase
implements UserAuthenticator {
    public boolean canSupport(Properties properties) {
        if (!this.requireAuthentication(properties)) {
            return false;
        }
        String string = PropertyUtil.getPropertyFromSet(properties, "derby.authentication.provider");
        return string == null || string.length() == 0 || StringUtil.SQLEqualsIgnoreCase(string, "BUILTIN");
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        super.boot(bl, properties);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.reset();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw Monitor.exceptionStartingModule(noSuchAlgorithmException);
        }
        this.setAuthenticationService(this);
    }

    public boolean authenticateUser(String string, String string2, String string3, Properties properties) {
        String string4;
        String string5 = null;
        int n = 0;
        if (string == null) {
            return false;
        }
        String string6 = null;
        String string7 = null;
        string5 = properties.getProperty("drdaSecMec");
        if (string5 != null) {
            n = Integer.parseInt(string5);
        }
        if ((string6 = this.getDatabaseProperty(string4 = "derby.user.".concat(string))) != null) {
            if (n != 8) {
                string7 = this.encryptPassword(string2);
            } else {
                string6 = this.substitutePassword(string, string6, properties, true);
                string7 = string2;
            }
        } else {
            string6 = this.getSystemProperty(string4);
            string7 = string2;
            if (string6 != null && n == 8) {
                string6 = this.substitutePassword(string, string6, properties, false);
            }
        }
        if (string6 == null) {
            return false;
        }
        return string6.equals(string7);
    }
}

