/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.viewer.internal;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.script.IExternalContext;
import org.eclipse.birt.chart.style.IStyleProcessor;
import org.eclipse.birt.chart.viewer.internal.util.ChartImageManager;
import org.eclipse.birt.chart.viewer.internal.util.ChartWebHelper;
import org.eclipse.birt.chart.viewer.internal.util.ImageHTMLEmitter;

public class ChartRendererTag
extends TagSupport {
    private static final long serialVersionUID = 1417590567722837605L;
    private double width;
    private double height;
    private String renderURL;
    private String output = "PNG";
    private Object model;
    private transient Chart chartModel;
    private transient IDataRowExpressionEvaluator data;
    private transient IStyleProcessor styleProcessor;
    private RunTimeContext runtimeContext;
    private IExternalContext externalContext;

    public int doEndTag() throws JspException {
        try {
            File file;
            Object object;
            if (!ChartWebHelper.checkOutputType(this.output)) {
                this.printError("Specified output type(" + this.output + ") is invalid!");
                return 6;
            }
            HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
            if (this.model instanceof String) {
                object = (String)this.model;
                file = new File((String)object);
                if (!file.exists()) {
                    object = ChartWebHelper.getRealPath(this.getServletContext(), (String)object);
                }
                this.chartModel = ChartWebHelper.parseChart((String)object);
                if (this.chartModel == null) {
                    this.printError("Following file does not exist: " + this.model);
                    return 6;
                }
            } else if (this.model instanceof Chart) {
                this.chartModel = (Chart)this.model;
            }
            if (this.chartModel == null) {
                this.printError("No chart model");
                return 6;
            }
            object = this.chartModel.getBlock().getBounds();
            object.setWidth(this.width);
            object.setHeight(this.height);
            object = new ChartImageManager(httpServletRequest, this.chartModel, this.output, this.data, this.runtimeContext, this.getExternalContext(), this.styleProcessor);
            file = ((ChartImageManager)object).getImage();
            String string = file.getName();
            string = string.substring(0, string.lastIndexOf(46));
            this.pageContext.getOut().println(this.createEmitter(string, ((ChartImageManager)object).getRelativeImageFolder() + "/" + file.getName(), ((ChartImageManager)object).getImageMap()).generateHTML());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 6;
    }

    private ImageHTMLEmitter createEmitter(String string, String string2, String string3) {
        ImageHTMLEmitter imageHTMLEmitter = new ImageHTMLEmitter();
        imageHTMLEmitter.ext = this.output;
        imageHTMLEmitter.height = (int)this.height;
        imageHTMLEmitter.width = (int)this.width;
        imageHTMLEmitter.id = string;
        imageHTMLEmitter.src = string2;
        imageHTMLEmitter.alt = this.chartModel != null ? this.chartModel.getTitle().getLabel().getCaption().getValue() : string;
        imageHTMLEmitter.imageMap = string3;
        return imageHTMLEmitter;
    }

    private void printError(String string) throws IOException {
        this.pageContext.getOut().println("Error: " + string);
    }

    public void setWidth(double d) {
        this.width = d;
    }

    public double getWidth() {
        return this.width;
    }

    public void setHeight(double d) {
        this.height = d;
    }

    public double getHeight() {
        return this.height;
    }

    public void setRenderURL(String string) {
        this.renderURL = string;
    }

    public String getRenderURL() {
        return this.renderURL;
    }

    public void setOutput(String string) {
        this.output = string;
    }

    public String getOutput() {
        return this.output;
    }

    public void setModel(Object object) {
        this.model = object;
    }

    public Object getModel() {
        return this.model;
    }

    public void setData(IDataRowExpressionEvaluator iDataRowExpressionEvaluator) {
        this.data = iDataRowExpressionEvaluator;
    }

    public IDataRowExpressionEvaluator getData() {
        return this.data;
    }

    public void setStyleProcessor(IStyleProcessor iStyleProcessor) {
        this.styleProcessor = iStyleProcessor;
    }

    public IStyleProcessor getStyleProcessor() {
        return this.styleProcessor;
    }

    public void setRuntimeContext(RunTimeContext runTimeContext) {
        this.runtimeContext = runTimeContext;
    }

    public RunTimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public void setExternalContext(IExternalContext iExternalContext) {
        this.externalContext = iExternalContext;
    }

    public IExternalContext getExternalContext() {
        return this.externalContext;
    }

    protected ServletContext getServletContext() {
        return this.pageContext.getServletContext();
    }
}

