/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.viewer.internal.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.Serializer;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.impl.SerializerImpl;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.emf.common.util.EList;

public class ChartWebHelper {
    public static Chart parseChart(String string) throws ChartException {
        if (string == null) {
            return null;
        }
        Chart chart = null;
        File file = new File(string);
        InputStream inputStream = null;
        try {
            if (file.exists()) {
                Serializer serializer = SerializerImpl.instance();
                inputStream = new FileInputStream(file);
                chart = serializer.read(inputStream);
            }
        }
        catch (Exception exception) {
            throw new ChartException("org.eclipse.birt.chart.engine", 6, (Throwable)exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return chart;
    }

    public static boolean checkOutputType(String string) {
        try {
            return ChartUtil.isOutputFormatSupport((String)string);
        }
        catch (ChartException chartException) {
            return false;
        }
    }

    public static boolean isChartInRuntime(Chart chart) {
        block4: {
            block3: {
                if (!(chart instanceof ChartWithAxes)) break block3;
                Axis axis = (Axis)((ChartWithAxes)chart).getAxes().get(0);
                EList eList = axis.getAssociatedAxes();
                for (int i = 0; i < eList.size(); ++i) {
                    Axis axis2 = (Axis)eList.get(i);
                    EList eList2 = axis2.getSeriesDefinitions();
                    for (int j = 0; j < eList2.size(); ++j) {
                        SeriesDefinition seriesDefinition = (SeriesDefinition)eList2.get(j);
                        if (seriesDefinition.getRunTimeSeries().size() <= 0) continue;
                        return true;
                    }
                }
                break block4;
            }
            if (!(chart instanceof ChartWithoutAxes)) break block4;
            SeriesDefinition seriesDefinition = (SeriesDefinition)((ChartWithoutAxes)chart).getSeriesDefinitions().get(0);
            EList eList = seriesDefinition.getSeriesDefinitions();
            for (int i = 0; i < eList.size(); ++i) {
                SeriesDefinition seriesDefinition2 = (SeriesDefinition)eList.get(i);
                if (seriesDefinition2.getRunTimeSeries().size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static String getRealPath(ServletContext servletContext, String string) {
        String string2 = servletContext.getRealPath("/");
        if (string2 == null) {
            try {
                URL uRL = servletContext.getResource("/");
                string2 = uRL.getPath();
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
        if (string2 != null && string2.length() > 0 && (string2.charAt(string2.length() - 1) != '\\' || string2.charAt(string2.length() - 1) != '/')) {
            string2 = string2 + File.separator;
        }
        return string2 + string;
    }
}

