/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.index;

import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;
import org.eclipse.birt.data.engine.impl.index.IIndexSerializer;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableDataSetNumberIndex<T>
implements IIndexSerializer {
    private static int BLOCKNUMBER = 5000;
    private Map<T, List<Integer>> numberAndIndex = new HashMap<T, List<Integer>>();
    private String fileName = null;
    private StreamManager manager = null;

    public SerializableDataSetNumberIndex(String fileName, StreamManager manager) {
        this.fileName = fileName;
        this.manager = manager;
    }

    @Override
    public Object put(Object number, Object index) throws DataException {
        if (this.numberAndIndex.containsKey(number)) {
            this.numberAndIndex.get(number).add((Integer)index);
        } else {
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add((Integer)index);
            this.numberAndIndex.put(number, list);
        }
        return null;
    }

    @Override
    public void close() throws DataException {
        try {
            ArrayList<T> keyList = new ArrayList<T>();
            keyList.addAll(this.numberAndIndex.keySet());
            if (keyList.size() == 0) {
                return;
            }
            RAOutputStream output = this.manager.getOutStream(this.fileName);
            Collections.sort(keyList, new NumberComparator());
            int segs = (keyList.size() - 1) / BLOCKNUMBER + 1;
            IOUtil.writeInt(output, segs);
            long intOffset = output.getOffset();
            DataOutputStream dout = new DataOutputStream(output);
            long[] offsets = new long[segs];
            Object[] boundaryValues = new Object[segs];
            int i = 0;
            while (i < segs) {
                IOUtil.writeLong(dout, 0L);
                boundaryValues[i] = keyList.get(i * BLOCKNUMBER);
                ++i;
            }
            i = 0;
            while (i < boundaryValues.length) {
                IOUtil.writeObject(dout, boundaryValues[i]);
                ++i;
            }
            i = 0;
            while (i < segs) {
                offsets[i] = output.getOffset();
                IOUtil.writeInt(dout, i == segs - 1 ? keyList.size() % BLOCKNUMBER : BLOCKNUMBER);
                int j = i * BLOCKNUMBER;
                while (j < (i + 1) * BLOCKNUMBER && j < keyList.size()) {
                    IOUtil.writeObject(dout, keyList.get(j));
                    IOUtil.writeList(dout, this.numberAndIndex.get(keyList.get(j)));
                    ++j;
                }
                ++i;
            }
            output.seek(intOffset);
            i = 0;
            while (i < offsets.length) {
                IOUtil.writeLong(dout, offsets[i]);
                ++i;
            }
            output.close();
        }
        catch (Exception e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NumberComparator<T1>
    implements Comparator<T> {
        private NumberComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            try {
                return ScriptEvalUtil.compare(o1, o2);
            }
            catch (DataException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

