/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart.api.script;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.MarkerRange;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.MarkerRangeImpl;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.report.tests.chart.ChartTestCase;

public class BeforeDrawMarkerRange
extends ChartTestCase {
    private static String OUTPUT = "BeforeDrawMarkerRange.jpg";
    private static final long serialVersionUID = 1L;
    private Chart cm = null;
    private IDeviceRenderer dRenderer = null;
    private GeneratedChartState gcs = null;

    public static void main(String[] args) {
        new BeforeDrawMarkerRange();
    }

    public BeforeDrawMarkerRange() {
        PluginSettings ps = PluginSettings.instance();
        try {
            this.dRenderer = ps.getDevice("dv.JPG");
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        this.cm = BeforeDrawMarkerRange.createLineChart();
        BufferedImage img = new BufferedImage(500, 500, 2);
        Graphics g = img.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        this.dRenderer.setProperty("device.output.context", (Object)g2d);
        this.dRenderer.setProperty("device.file.identifier", (Object)this.genOutputFile(OUTPUT));
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)500.0, (double)500.0);
        bo.scale(72.0 / (double)this.dRenderer.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        try {
            this.gcs = gr.build(this.dRenderer.getDisplayServer(), this.cm, bo, null, null, null);
            gr.render(this.dRenderer, this.gcs);
        }
        catch (ChartException e) {
            e.printStackTrace();
        }
    }

    public static final Chart createLineChart() {
        ChartWithAxes cwaLine = ChartWithAxesImpl.create();
        cwaLine.setType("Bar Chart");
        cwaLine.setScript("function beforeDrawMarkerRange(axis, range, scriptContext){importPackage(Packages.org.eclipse.birt.chart.model.attribute); if (axis.getType() == AxisType.TEXT_LITERAL){range.getLabel().getCaption().getColor().set(21, 244, 231);range.getLabel().getCaption().getFont().setItalic(true);range.getLabel().getCaption().getFont().setRotation(30);range.getLabel().getCaption().getFont().setStrikethrough(true);range.getLabel().getCaption().getFont().setSize(14);range.getLabel().getCaption().getFont().setName(\"Arial\");range.getLabel().getOutline().setVisible(true);range.getLabel().getOutline().setThickness(3);}else{range.getLabel().getCaption().getColor().set(244, 21, 231);range.getLabel().getCaption().getFont().setRotation(45);range.getLabel().getCaption().getFont().setStrikethrough(false);range.getLabel().getCaption().getFont().setSize(14);range.getLabel().getCaption().getFont().setName(\"Curse\");range.getLabel().getOutline().setVisible(false);}}");
        cwaLine.getTitle().getLabel().getCaption().setValue("Computer Hardware Sales");
        cwaLine.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        Legend lg = cwaLine.getLegend();
        lg.setVisible(false);
        Axis xAxisPrimary = ((ChartWithAxesImpl)cwaLine).getPrimaryBaseAxes()[0];
        xAxisPrimary.getTitle().setVisible(false);
        xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        xAxisPrimary.getLabel().getCaption().setColor(ColorDefinitionImpl.GREEN().darker());
        MarkerRange mrx = MarkerRangeImpl.create((Axis)xAxisPrimary, (DataElement)NumberDataElementImpl.create((double)1.0), (DataElement)NumberDataElementImpl.create((double)2.0), null);
        mrx.setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.create((int)239, (int)33, (int)3), (LineStyle)LineStyle.DOTTED_LITERAL, (int)2));
        Axis yAxisPrimary = ((ChartWithAxesImpl)cwaLine).getPrimaryOrthogonalAxis(xAxisPrimary);
        yAxisPrimary.getLabel().getCaption().setValue("Sales Growth");
        yAxisPrimary.getLabel().getCaption().setColor(ColorDefinitionImpl.BLUE());
        yAxisPrimary.getTitle().setVisible(false);
        yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        yAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        MarkerRange mry = MarkerRangeImpl.create((Axis)yAxisPrimary, (DataElement)NumberDataElementImpl.create((double)40.0), (DataElement)NumberDataElementImpl.create((double)100.0), null);
        mry.setOutline(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.GREY(), (LineStyle)LineStyle.DASH_DOTTED_LITERAL, (int)4));
        TextDataSet dsStringValue = TextDataSetImpl.create((Object)new String[]{"Keyboards", "Moritors", "Printers", "Mortherboards"});
        NumberDataSet dsNumericValues1 = NumberDataSetImpl.create((Object)new double[]{143.26, 156.55, 95.25, 47.56});
        Series seBase = SeriesImpl.create();
        seBase.setDataSet((DataSet)dsStringValue);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)seBase);
        LineSeries ls = (LineSeries)LineSeriesImpl.create();
        ls.getLabel().getCaption().setColor(ColorDefinitionImpl.RED());
        ls.getLabel().setBackground((Fill)ColorDefinitionImpl.CYAN());
        ls.getLabel().setVisible(true);
        ls.setDataSet((DataSet)dsNumericValues1);
        ls.setStacked(true);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY);
        sdY.getSeriesPalette().update((Fill)ColorDefinitionImpl.GREEN());
        sdY.getSeries().add((Object)ls);
        return cwaLine;
    }
}

