/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart.regression;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.eclipse.birt.chart.device.ICallBackNotifier;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.CallBackValue;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.TooltipValueImpl;
import org.eclipse.birt.chart.model.attribute.impl.URLValueImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.ActionImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.exception.BirtException;

public final class Regression_117986_swing
extends JPanel
implements ICallBackNotifier,
ComponentListener {
    private static final long serialVersionUID = 1L;
    private boolean bNeedsGeneration = true;
    private GeneratedChartState gcs = null;
    private Chart cm = null;
    private IDeviceRenderer idr = null;
    private BufferedImage bi = null;
    private Map contextMap = new HashMap();

    public static void main(String[] args) {
        Regression_117986_swing siv = new Regression_117986_swing();
        JFrame jf = new JFrame();
        jf.setDefaultCloseOperation(2);
        jf.addComponentListener(siv);
        Container co = jf.getContentPane();
        co.setLayout(new BorderLayout());
        co.add((Component)siv, "Center");
        Dimension dScreen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dApp = new Dimension(600, 400);
        jf.setSize(dApp);
        jf.setLocation((dScreen.width - dApp.width) / 2, (dScreen.height - dApp.height) / 2);
        jf.setTitle(String.valueOf(siv.getClass().getName()) + " [device=" + siv.idr.getClass().getName() + "]");
        Regression_117986_swing regression_117986_swing = siv;
        regression_117986_swing.getClass();
        ControlPanel cp = regression_117986_swing.new ControlPanel(siv);
        co.add((Component)cp, "South");
        siv.idr.setProperty("device.component", (Object)siv);
        jf.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Regression_117986_swing.this.idr.dispose();
            }
        });
        jf.setVisible(true);
    }

    Regression_117986_swing() {
        PluginSettings ps = PluginSettings.instance();
        try {
            this.idr = ps.getDevice("dv.SWING");
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        this.cm = Regression_117986_swing.barChart();
    }

    public void regenerateChart() {
        this.bNeedsGeneration = true;
        this.updateBuffer();
        this.repaint();
    }

    public void repaintChart() {
        this.repaint();
    }

    public Object peerInstance() {
        return this;
    }

    public Chart getDesignTimeModel() {
        return this.cm;
    }

    public Chart getRunTimeModel() {
        return this.gcs.getChartModel();
    }

    public Object getContext(Object key) {
        return this.contextMap.get(key);
    }

    public Object putContext(Object key, Object value) {
        return this.contextMap.put(key, value);
    }

    public Object removeContext(Object key) {
        return this.contextMap.remove(key);
    }

    public void updateBuffer() {
        Dimension d = this.getSize();
        if (this.bi == null || this.bi.getWidth() != d.width || this.bi.getHeight() != d.height) {
            this.bi = new BufferedImage(d.width, d.height, 2);
        }
        Graphics2D g2d = (Graphics2D)this.bi.getGraphics();
        this.idr.setProperty("device.output.context", (Object)g2d);
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)d.width, (double)d.height);
        bo.scale(72.0 / (double)this.idr.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        if (this.bNeedsGeneration) {
            this.bNeedsGeneration = false;
            try {
                this.gcs = gr.build(this.idr.getDisplayServer(), this.cm, bo, null, null, null);
            }
            catch (ChartException ex) {
                this.showException(g2d, (Exception)((Object)ex));
            }
        }
        try {
            try {
                gr.render(this.idr, this.gcs);
            }
            catch (ChartException rex) {
                this.showException(g2d, (Exception)((Object)rex));
                g2d.dispose();
            }
        }
        finally {
            g2d.dispose();
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.bi == null) {
            this.updateBuffer();
        }
        g.drawImage(this.bi, 0, 0, this);
    }

    private final void showException(Graphics2D g2d, Exception ex) {
        String sWrappedException = ex.getClass().getName();
        Exception th = ex;
        while (ex.getCause() != null) {
            ex = (Exception)ex.getCause();
        }
        String sException = ex.getClass().getName();
        if (sWrappedException.equals(sException)) {
            sWrappedException = null;
        }
        String sMessage = null;
        sMessage = th instanceof BirtException ? ((BirtException)th).getLocalizedMessage() : ex.getMessage();
        if (sMessage == null) {
            sMessage = "<null>";
        }
        StackTraceElement[] stea = ex.getStackTrace();
        Dimension d = this.getSize();
        Font fo = new Font("Monospaced", 1, 14);
        g2d.setFont(fo);
        FontMetrics fm = g2d.getFontMetrics();
        g2d.setColor(Color.WHITE);
        g2d.fillRect(20, 20, d.width - 40, d.height - 40);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(20, 20, d.width - 40, d.height - 40);
        g2d.setClip(20, 20, d.width - 40, d.height - 40);
        int x = 25;
        int y = 20 + fm.getHeight();
        g2d.drawString("Exception:", x, y);
        g2d.setColor(Color.RED);
        g2d.drawString(sException, x += fm.stringWidth("Exception:") + 5, y);
        x = 25;
        y += fm.getHeight();
        if (sWrappedException != null) {
            g2d.setColor(Color.BLACK);
            g2d.drawString("Wrapped In:", x, y);
            g2d.setColor(Color.RED);
            g2d.drawString(sWrappedException, x += fm.stringWidth("Wrapped In:") + 5, y);
            x = 25;
            y += fm.getHeight();
        }
        g2d.setColor(Color.BLACK);
        g2d.drawString("Message:", x, y += 10);
        g2d.setColor(Color.BLUE);
        g2d.drawString(sMessage, x += fm.stringWidth("Message:") + 5, y);
        x = 25;
        y += fm.getHeight();
        g2d.setColor(Color.BLACK);
        g2d.drawString("Trace:", x, y += 10);
        x = 40;
        y += fm.getHeight();
        g2d.setColor(Color.GREEN.darker());
        int i = 0;
        while (i < stea.length) {
            g2d.drawString(String.valueOf(stea[i].getClassName()) + ":" + stea[i].getMethodName() + "(...):" + stea[i].getLineNumber(), x, y);
            x = 40;
            y += fm.getHeight();
            ++i;
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.bNeedsGeneration = true;
    }

    public void componentShown(ComponentEvent e) {
    }

    public void callback(Object event, Object source, CallBackValue value) {
        JOptionPane.showMessageDialog(this, value.getIdentifier());
    }

    public static final Chart barChart() {
        ChartWithAxes cwaBar = ChartWithAxesImpl.create();
        cwaBar.setType("Bar Chart");
        cwaBar.setSubType("Stacked");
        cwaBar.getTitle().getLabel().getCaption().setValue("Computer Hardware Sales");
        cwaBar.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        Axis xAxisPrimary = ((ChartWithAxesImpl)cwaBar).getPrimaryBaseAxes()[0];
        xAxisPrimary.getTitle().setVisible(false);
        xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        xAxisPrimary.getOrigin().setType(IntersectionType.MAX_LITERAL);
        xAxisPrimary.getLabel().getCaption().setColor(ColorDefinitionImpl.GREEN().darker());
        Axis yAxisPrimary = ((ChartWithAxesImpl)cwaBar).getPrimaryOrthogonalAxis(xAxisPrimary);
        yAxisPrimary.getLabel().getCaption().setValue("Sales Growth");
        yAxisPrimary.getLabel().getCaption().setColor(ColorDefinitionImpl.BLUE());
        yAxisPrimary.getTitle().setVisible(false);
        yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        yAxisPrimary.getOrigin().setType(IntersectionType.MAX_LITERAL);
        TextDataSet dsStringValue = TextDataSetImpl.create((Object)new String[]{"Keyboards", "Moritors", "Printers", "Mortherboards"});
        NumberDataSet dsNumericValues1 = NumberDataSetImpl.create((Object)new double[]{143.26, 156.55, 95.25, 47.56});
        Series seBase = SeriesImpl.create();
        seBase.setDataSet((DataSet)dsStringValue);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)seBase);
        BarSeries bs = (BarSeries)BarSeriesImpl.create();
        bs.setSeriesIdentifier((Object)"Actuate");
        bs.getLabel().getCaption().setColor(ColorDefinitionImpl.RED());
        bs.getLabel().setBackground((Fill)ColorDefinitionImpl.CYAN());
        bs.getLabel().setVisible(true);
        bs.setDataSet((DataSet)dsNumericValues1);
        bs.setStacked(true);
        bs.getTriggers().add((Object)TriggerImpl.create((TriggerCondition)TriggerCondition.ONMOUSEMOVE_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.SHOW_TOOLTIP_LITERAL, (ActionValue)TooltipValueImpl.create((int)500, null))));
        Trigger triger = TriggerImpl.create((TriggerCondition)TriggerCondition.ONCLICK_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.URL_REDIRECT_LITERAL, (ActionValue)URLValueImpl.create((String)"http://www.actuate.com", null, null, null, null)));
        bs.getTriggers().add((Object)triger);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY);
        sdY.getSeriesPalette().update((Fill)ColorDefinitionImpl.BLUE());
        sdY.getSeries().add((Object)bs);
        return cwaBar;
    }

    private final class ControlPanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private JComboBox jcbModels = null;
        private JButton jbUpdate = null;
        private final Regression_117986_swing siv;

        ControlPanel(Regression_117986_swing siv) {
            this.siv = siv;
            this.setLayout(new GridLayout(0, 1, 0, 0));
            JPanel jp = new JPanel();
            jp.setLayout(new FlowLayout(0, 3, 3));
            jp.add(new JLabel("Choose:"));
            this.jcbModels = new JComboBox();
            this.jcbModels.addItem("Bar Chart");
            this.jcbModels.setSelectedIndex(0);
            jp.add(this.jcbModels);
            this.jbUpdate = new JButton("Update");
            this.jbUpdate.addActionListener(this);
            jp.add(this.jbUpdate);
            this.add(jp);
        }

        public void componentHidden(ComponentEvent cev) {
            this.setVisible(false);
        }

        public void componentMoved(ComponentEvent cev) {
            JFrame jf = (JFrame)cev.getComponent();
            Rectangle r = jf.getBounds();
            this.setLocation(r.x, r.y + r.height);
            this.setSize(r.width, 50);
        }

        public void componentResized(ComponentEvent cev) {
            JFrame jf = (JFrame)cev.getComponent();
            Rectangle r = jf.getBounds();
            this.setLocation(r.x, r.y + r.height);
            this.setSize(r.width, 50);
        }

        public void componentShown(ComponentEvent cev) {
            JFrame jf = (JFrame)cev.getComponent();
            Rectangle r = jf.getBounds();
            this.setLocation(r.x, r.y + r.height);
            this.setSize(r.width, 50);
            this.setVisible(true);
        }

        public void actionPerformed(ActionEvent e) {
            int i = this.jcbModels.getSelectedIndex();
            Regression_117986_swing.this.cm = null;
            switch (i) {
                case 0: {
                    Regression_117986_swing.this.cm = Regression_117986_swing.barChart();
                }
            }
            Regression_117986_swing.this.bNeedsGeneration = true;
            this.siv.updateBuffer();
            this.siv.repaint();
        }
    }
}

