/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart.regression;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.FontDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextAlignmentImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.report.tests.chart.ChartTestCase;

public class Regression_144511
extends ChartTestCase {
    private static String OUTPUT = "Regression_144511.jpg";
    private static final long serialVersionUID = 1L;
    private Chart cm = null;
    private IDeviceRenderer dRenderer = null;
    private GeneratedChartState gcs = null;

    public static void main(String[] args) {
        new Regression_144511();
    }

    public Regression_144511() {
        PluginSettings ps = PluginSettings.instance();
        try {
            this.dRenderer = ps.getDevice("dv.JPG");
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        this.cm = Regression_144511.createBarChart();
        BufferedImage img = new BufferedImage(500, 500, 2);
        Graphics g = img.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        this.dRenderer.setProperty("device.output.context", (Object)g2d);
        this.dRenderer.setProperty("device.file.identifier", (Object)this.genOutputFile(OUTPUT));
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)500.0, (double)500.0);
        bo.scale(72.0 / (double)this.dRenderer.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        try {
            this.gcs = gr.build(this.dRenderer.getDisplayServer(), this.cm, bo, null, null, null);
            gr.render(this.dRenderer, this.gcs);
            Regression_144511.fail();
        }
        catch (ChartException chartException) {}
    }

    public void test_regression_144511() throws Exception {
        new Regression_144511();
    }

    public static final Chart createBarChart() {
        ChartWithAxes cwaBar = ChartWithAxesImpl.create();
        cwaBar.setType("Bar Chart");
        cwaBar.setSubType("Side-by-side");
        cwaBar.getTitle().getLabel().getCaption().setValue("Computer Hardware Sales");
        cwaBar.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        cwaBar.getPlot().getClientArea().getOutline().setVisible(false);
        cwaBar.getPlot().getClientArea().setBackground((Fill)ColorDefinitionImpl.create((int)255, (int)255, (int)225));
        Axis xAxisPrimary = ((ChartWithAxesImpl)cwaBar).getPrimaryBaseAxes()[0];
        xAxisPrimary.getTitle().setVisible(false);
        xAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        xAxisPrimary.getLabel().getCaption().setColor(ColorDefinitionImpl.GREEN().darker());
        Axis yAxisPrimary = ((ChartWithAxesImpl)cwaBar).getPrimaryOrthogonalAxis(xAxisPrimary);
        yAxisPrimary.getLabel().getCaption().setValue("Sales Growth");
        FontDefinition fd = FontDefinitionImpl.create((String)"Arial", (float)10.0f, (boolean)true, (boolean)true, (boolean)false, (boolean)true, (boolean)false, (double)0.0, (TextAlignment)TextAlignmentImpl.create());
        yAxisPrimary.getLabel().getCaption().setFont(fd);
        yAxisPrimary.getLabel().getCaption().setColor(ColorDefinitionImpl.BLUE());
        yAxisPrimary.getTitle().setVisible(false);
        yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        yAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        TextDataSet dsStringValue = TextDataSetImpl.create((Object)new String[]{"Keyboards", "Moritors", "Printers", "Mortherboards"});
        NumberDataSet dsNumericValues1 = NumberDataSetImpl.create((Object)new Double[1]);
        Series seBase = SeriesImpl.create();
        seBase.setDataSet((DataSet)dsStringValue);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)seBase);
        BarSeries bs = (BarSeries)BarSeriesImpl.create();
        bs.setSeriesIdentifier((Object)"Actuate");
        bs.getLabel().getCaption().setColor(ColorDefinitionImpl.RED());
        bs.getLabel().setBackground((Fill)ColorDefinitionImpl.CYAN());
        bs.getLabel().setVisible(true);
        bs.setDataSet((DataSet)dsNumericValues1);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY);
        sdY.getSeriesPalette().update((Fill)ColorDefinitionImpl.BLUE());
        sdY.getSeries().add((Object)bs);
        return cwaBar;
    }
}

