/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart.test;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.tests.chart.ChartTestCase;

public class imageCompare
extends ChartTestCase {
    private static final String INPUT = "blankReport.rptdesign";
    protected SessionHandle sessionHandle = null;
    protected ReportDesignHandle designHandle = null;
    protected ReportDesign design = null;
    protected IReportEngine engine = null;
    protected IEngineTask engineTask = null;

    public void setUp() throws Exception {
        super.setUp();
        EngineConfig config = new EngineConfig();
        this.engine = this.createReportEngine(config);
        this.removeResource();
        this.copyResource_INPUT(INPUT, INPUT);
    }

    public void tearDown() {
        this.removeResource();
    }

    public void testMoveOutput() throws Exception {
        File testOutput;
        if (new File(this.genOutputFolder()).exists()) {
            this.removeFile(this.genOutputFolder());
        }
        if ((testOutput = new File(this.genOutputFolder())).getParentFile() != null) {
            testOutput.getParentFile().mkdirs();
            testOutput.mkdir();
        }
        this.AcceptanceGolden();
        this.RegressionGolden();
        this.SmokeGolden();
    }

    public void AcceptanceGolden() throws Exception {
        String folderName = "acceptance";
        this.creatImageCompare(folderName);
    }

    public void RegressionGolden() throws Exception {
        String folderName = "regression";
        this.creatImageCompare(folderName);
    }

    public void SmokeGolden() throws Exception {
        String folderName = "smoke";
        this.creatImageCompare(folderName);
    }

    protected void creatImageCompare(String folderName) throws Exception {
        String path = String.valueOf(this.getOutputResourceFolder()) + "/" + "org.eclipse.birt.report.tests.chart" + "/" + folderName;
        String outputFolder = String.valueOf(path) + "/diffOutput/";
        String goldenFolder = String.valueOf(path) + "/diffGolden/";
        String reportFile = this.genOutputFile(String.valueOf(folderName) + ".rptdesign");
        String htmlFile = this.genOutputFile(String.valueOf(folderName) + ".html");
        File diffImages = new File(goldenFolder);
        try {
            if (!diffImages.isDirectory() || !diffImages.exists()) {
                throw new Exception("Output foler: " + outputFolder + " doesn't exist.");
            }
        }
        catch (Exception exception) {
            System.out.println(String.valueOf(folderName) + " is not exist.");
            return;
        }
        File[] diffreports = diffImages.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jpg");
            }
        });
        String fileName = this.genInputFile(INPUT);
        this.sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(ULocale.getDefault());
        imageCompare.assertNotNull((Object)this.sessionHandle);
        ReportDesignHandle designHandle = this.sessionHandle.openDesign(fileName);
        int i = 0;
        while (i < diffreports.length) {
            try {
                File diffImage = diffreports[i];
                String imageName = diffImage.getName().substring(0, diffImage.getName().indexOf(46));
                GridHandle gridHandle = designHandle.getElementFactory().newGridItem(imageName, 2, 2);
                designHandle.getBody().add((DesignElementHandle)gridHandle);
                CellHandle cellGoldenHandle11 = gridHandle.getCell(1, 1);
                CellHandle cellGoldenHandle12 = gridHandle.getCell(1, 2);
                CellHandle cellGoldenHandle21 = gridHandle.getCell(2, 1);
                CellHandle cellGoldenHandle22 = gridHandle.getCell(2, 2);
                LabelHandle labelGoldenHandle = designHandle.getElementFactory().newLabel("goldenLabel");
                LabelHandle labelOutputHandle = designHandle.getElementFactory().newLabel("outputLabel");
                ImageHandle imageGoldenHandle = designHandle.getElementFactory().newImage("goldenImage");
                ImageHandle imageOutputHandle = designHandle.getElementFactory().newImage("outputImage");
                labelGoldenHandle.setText("golden: " + diffImage.getName());
                labelOutputHandle.setText("output: " + diffImage.getName());
                imageGoldenHandle.setURI("\"" + (String.valueOf(goldenFolder) + diffImage.getName()).replace('\\', '/') + "\"");
                imageOutputHandle.setURI("\"" + (String.valueOf(outputFolder) + diffImage.getName()).replace('\\', '/') + "\"");
                cellGoldenHandle11.getContent().add((DesignElementHandle)imageGoldenHandle);
                cellGoldenHandle12.getContent().add((DesignElementHandle)imageOutputHandle);
                cellGoldenHandle21.getContent().add((DesignElementHandle)labelGoldenHandle);
                cellGoldenHandle22.getContent().add((DesignElementHandle)labelOutputHandle);
                System.out.println("Image: " + diffImage.getName());
            }
            catch (Exception exception) {
                System.out.println("image can not be found!!");
            }
            ++i;
        }
        designHandle.saveAs(reportFile);
        String outputFile = htmlFile;
        String input = reportFile;
        input = input.replace('\\', '/');
        File inputFiles = new File(input);
        if (!inputFiles.exists()) {
            System.out.println(String.valueOf(input) + " is not exist");
        }
        IReportRunnable runnable = this.engine.openReportDesign(input);
        IRunAndRenderTask task = this.engine.createRunAndRenderTask(runnable);
        this.engineTask = task;
        task.setLocale(ULocale.getDefault());
        HTMLRenderOption options = null;
        options = new HTMLRenderOption();
        options.setOutputFileName(outputFile);
        options.setHtmlPagination(false);
        HTMLRenderContext renderContext = new HTMLRenderContext();
        renderContext.setImageDirectory("images");
        HashMap<String, HTMLRenderContext> appContext = new HashMap<String, HTMLRenderContext>();
        appContext.put("HTML_RENDER_CONTEXT", renderContext);
        task.setAppContext(appContext);
        options.setOutputFormat("html");
        options.getOutputSetting().put("url-encoding", "UTF-8");
        task.setRenderOption((IRenderOption)options);
        task.run();
        task.close();
        this.removeFile(reportFile);
    }

    public IReportEngine createReportEngine(EngineConfig config) throws BirtException {
        if (config == null) {
            config = new EngineConfig();
        }
        Platform.startup((PlatformConfig)new PlatformConfig());
        Object factory = Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
        if (factory instanceof IReportEngineFactory) {
            return ((IReportEngineFactory)factory).createReportEngine(config);
        }
        return null;
    }
}

