/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.api;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.adapter.oda.IAmbiguousAttribute;
import org.eclipse.birt.report.model.adapter.oda.IAmbiguousOption;
import org.eclipse.birt.report.model.adapter.oda.IAmbiguousParameterNode;
import org.eclipse.birt.report.model.adapter.oda.IAmbiguousResultSetNode;
import org.eclipse.birt.report.model.adapter.oda.ModelOdaAdapter;
import org.eclipse.birt.report.model.adapter.oda.util.BaseTestCase;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.elements.structures.OdaDataSetParameter;
import org.eclipse.birt.report.model.api.elements.structures.OdaResultSetColumn;
import org.eclipse.datatools.connectivity.oda.design.AxisAttributes;
import org.eclipse.datatools.connectivity.oda.design.AxisType;
import org.eclipse.datatools.connectivity.oda.design.ColumnDefinition;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataElementUIHints;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ElementNullability;
import org.eclipse.datatools.connectivity.oda.design.InputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.InputElementUIHints;
import org.eclipse.datatools.connectivity.oda.design.InputParameterAttributes;
import org.eclipse.datatools.connectivity.oda.design.InputParameterUIHints;
import org.eclipse.datatools.connectivity.oda.design.InputPromptControlStyle;
import org.eclipse.datatools.connectivity.oda.design.OutputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.Properties;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ValueFormatHints;

public class AdvancedDataSetAdapterTest
extends BaseTestCase {
    private DataSetDesign createDataSetDesign() {
        DataSetDesign setDesign = DesignFactory.eINSTANCE.createDataSetDesign();
        setDesign.setName("myDataSet1");
        setDesign.setDisplayName("data set display name");
        setDesign.setOdaExtensionDataSetId("org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        Properties props = DesignFactory.eINSTANCE.createProperties();
        props.setProperty("queryTimeOut", "new public query time out");
        setDesign.setPublicProperties(props);
        props = DesignFactory.eINSTANCE.createProperties();
        props.setProperty("queryTimeOut", "new private query time out");
        setDesign.setPrivateProperties(props);
        DataSetParameters params = DesignFactory.eINSTANCE.createDataSetParameters();
        ParameterDefinition paramDefn = DesignFactory.eINSTANCE.createParameterDefinition();
        DataElementAttributes dataAttrs = DesignFactory.eINSTANCE.createDataElementAttributes();
        dataAttrs.setName("param1");
        dataAttrs.setNullability(ElementNullability.get((int)2));
        dataAttrs.setPosition(1);
        dataAttrs.setNativeDataTypeCode(2);
        paramDefn.setInOutMode(ParameterMode.get((int)2));
        DataElementUIHints uiHints = DesignFactory.eINSTANCE.createDataElementUIHints();
        uiHints.setDescription("updated param help text");
        uiHints.setDescriptionKey("updatedHelpKey");
        uiHints.setDisplayName("updated param prompt text");
        uiHints.setDisplayNameKey("updatedPromptKey");
        dataAttrs.setUiHints(uiHints);
        paramDefn.setAttributes(dataAttrs);
        InputParameterAttributes inParamAttrs = DesignFactory.eINSTANCE.createInputParameterAttributes();
        InputElementAttributes inputElementAttrs = DesignFactory.eINSTANCE.createInputElementAttributes();
        inputElementAttrs.setOptional(false);
        inputElementAttrs.setDefaultScalarValue("default param value");
        inputElementAttrs.setMasksValue(false);
        InputElementUIHints hints = DesignFactory.eINSTANCE.createInputElementUIHints();
        hints.setAutoSuggestThreshold(100);
        hints.setPromptStyle(InputPromptControlStyle.SELECTABLE_LIST_LITERAL);
        inputElementAttrs.setUiHints(hints);
        inParamAttrs.setElementAttributes(inputElementAttrs);
        InputParameterUIHints parameterUIHints = DesignFactory.eINSTANCE.createInputParameterUIHints();
        parameterUIHints.setGroupPromptDisplayName("updated group");
        inParamAttrs.setUiHints(parameterUIHints);
        paramDefn.setInputAttributes(inParamAttrs);
        params.getParameterDefinitions().add((Object)paramDefn);
        paramDefn = DesignFactory.eINSTANCE.createParameterDefinition();
        dataAttrs = DesignFactory.eINSTANCE.createDataElementAttributes();
        dataAttrs.setName("param2");
        paramDefn.setAttributes(dataAttrs);
        params.getParameterDefinitions().add((Object)paramDefn);
        paramDefn = DesignFactory.eINSTANCE.createParameterDefinition();
        dataAttrs = DesignFactory.eINSTANCE.createDataElementAttributes();
        dataAttrs.setName("param3");
        dataAttrs.setPosition(3);
        paramDefn.setAttributes(dataAttrs);
        params.getParameterDefinitions().add((Object)paramDefn);
        paramDefn = DesignFactory.eINSTANCE.createParameterDefinition();
        dataAttrs = DesignFactory.eINSTANCE.createDataElementAttributes();
        dataAttrs.setName("param4");
        dataAttrs.setNativeDataTypeCode(4);
        dataAttrs.setPosition(4);
        paramDefn.setAttributes(dataAttrs);
        params.getParameterDefinitions().add((Object)paramDefn);
        setDesign.setParameters(params);
        setDesign.setDataSourceDesign(this.createDataSourceDesign());
        setDesign.setQueryText("new query text");
        return setDesign;
    }

    private DataSourceDesign createDataSourceDesign() {
        DataSourceDesign sourceDesign = DesignFactory.eINSTANCE.createDataSourceDesign();
        sourceDesign.setName("myDataSource1");
        sourceDesign.setDisplayName("data source display name");
        sourceDesign.setOdaExtensionId("org.eclipse.birt.report.data.oda.jdbc");
        Properties props = DesignFactory.eINSTANCE.createProperties();
        props.setProperty("odaDriverClass", "new drivers");
        props.setProperty("odaURL", "jdbc:sqlserver://localhost");
        props.setProperty("odaUser", "new user");
        sourceDesign.setPublicProperties(props);
        props = DesignFactory.eINSTANCE.createProperties();
        props.setProperty("odaDriverClass", "new drivers");
        props.setProperty("odaPassword", "new password");
        sourceDesign.setPrivateProperties(props);
        return sourceDesign;
    }

    public void testGetAmbiguousParameters() throws Exception {
        DataSetDesign setDesign = this.createDataSetDesign();
        this.openDesign("AdvancedDataSetAdapterTest.xml");
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        IAmbiguousOption option = new ModelOdaAdapter().getAmbiguousOption(setDesign, setHandle);
        List ambiguousParameters = option.getAmbiguousParameters();
        AdvancedDataSetAdapterTest.assertEquals((int)2, (int)ambiguousParameters.size());
        IAmbiguousParameterNode node = (IAmbiguousParameterNode)ambiguousParameters.get(0);
        AdvancedDataSetAdapterTest.assertEquals((String)"dataSetParam1", (String)node.getOdaDataSetParameterHandle().getName());
        List attributes = node.getAmbiguousAttributes();
        AdvancedDataSetAdapterTest.assertNotNull((Object)attributes);
        IAmbiguousAttribute attr = (IAmbiguousAttribute)attributes.get(0);
        AdvancedDataSetAdapterTest.assertEquals((String)"nativeName", (String)attr.getAttributeName());
        AdvancedDataSetAdapterTest.assertNull((Object)attr.getPreviousValue());
        AdvancedDataSetAdapterTest.assertEquals((Object)"param1", (Object)attr.getRevisedValue());
        attr = (IAmbiguousAttribute)attributes.get(1);
        AdvancedDataSetAdapterTest.assertEquals((String)"allowNull", (String)attr.getAttributeName());
        AdvancedDataSetAdapterTest.assertEquals((Object)Boolean.TRUE, (Object)attr.getPreviousValue());
        AdvancedDataSetAdapterTest.assertEquals((Object)Boolean.FALSE, (Object)attr.getRevisedValue());
        attr = (IAmbiguousAttribute)attributes.get(2);
        AdvancedDataSetAdapterTest.assertEquals((String)"isInput", (String)attr.getAttributeName());
        AdvancedDataSetAdapterTest.assertEquals((Object)Boolean.FALSE, (Object)attr.getPreviousValue());
        AdvancedDataSetAdapterTest.assertEquals((Object)Boolean.TRUE, (Object)attr.getRevisedValue());
        attr = (IAmbiguousAttribute)attributes.get(3);
        AdvancedDataSetAdapterTest.assertEquals((String)"isOutput", (String)attr.getAttributeName());
        AdvancedDataSetAdapterTest.assertEquals((Object)Boolean.FALSE, (Object)attr.getPreviousValue());
        AdvancedDataSetAdapterTest.assertEquals((Object)Boolean.TRUE, (Object)attr.getRevisedValue());
        attr = (IAmbiguousAttribute)attributes.get(4);
        AdvancedDataSetAdapterTest.assertEquals((String)"isOptional", (String)attr.getAttributeName());
        AdvancedDataSetAdapterTest.assertEquals((Object)Boolean.TRUE, (Object)attr.getPreviousValue());
        AdvancedDataSetAdapterTest.assertEquals((Object)Boolean.FALSE, (Object)attr.getRevisedValue());
        attr = (IAmbiguousAttribute)attributes.get(5);
        AdvancedDataSetAdapterTest.assertEquals((String)"isRequired", (String)attr.getAttributeName());
        AdvancedDataSetAdapterTest.assertEquals((Object)Boolean.FALSE, (Object)attr.getPreviousValue());
        AdvancedDataSetAdapterTest.assertEquals((Object)Boolean.TRUE, (Object)attr.getRevisedValue());
        AdvancedDataSetAdapterTest.assertTrue((boolean)attr.isLinkedReportParameterAttribute());
        attr = (IAmbiguousAttribute)attributes.get(6);
        AdvancedDataSetAdapterTest.assertEquals((String)"promptText", (String)attr.getAttributeName());
        AdvancedDataSetAdapterTest.assertEquals((Object)"param1 prompt text", (Object)attr.getPreviousValue());
        AdvancedDataSetAdapterTest.assertEquals((Object)"updated param prompt text", (Object)attr.getRevisedValue());
        AdvancedDataSetAdapterTest.assertTrue((boolean)attr.isLinkedReportParameterAttribute());
        attr = (IAmbiguousAttribute)attributes.get(7);
        AdvancedDataSetAdapterTest.assertEquals((String)"helpText", (String)attr.getAttributeName());
        AdvancedDataSetAdapterTest.assertEquals((Object)"scalar para help", (Object)attr.getPreviousValue());
        AdvancedDataSetAdapterTest.assertEquals((Object)"updated param help text", (Object)attr.getRevisedValue());
        AdvancedDataSetAdapterTest.assertTrue((boolean)attr.isLinkedReportParameterAttribute());
        attr = (IAmbiguousAttribute)attributes.get(8);
        AdvancedDataSetAdapterTest.assertEquals((String)"concealValue", (String)attr.getAttributeName());
        AdvancedDataSetAdapterTest.assertEquals((Object)Boolean.TRUE, (Object)attr.getPreviousValue());
        AdvancedDataSetAdapterTest.assertEquals((Object)Boolean.FALSE, (Object)attr.getRevisedValue());
        AdvancedDataSetAdapterTest.assertTrue((boolean)attr.isLinkedReportParameterAttribute());
        attr = (IAmbiguousAttribute)attributes.get(9);
        AdvancedDataSetAdapterTest.assertEquals((String)"autoSuggestThreshold", (String)attr.getAttributeName());
        AdvancedDataSetAdapterTest.assertEquals((Object)112, (Object)attr.getPreviousValue());
        AdvancedDataSetAdapterTest.assertEquals((Object)100, (Object)attr.getRevisedValue());
        AdvancedDataSetAdapterTest.assertTrue((boolean)attr.isLinkedReportParameterAttribute());
        attr = (IAmbiguousAttribute)attributes.get(10);
        AdvancedDataSetAdapterTest.assertEquals((String)"controlType", (String)attr.getAttributeName());
        AdvancedDataSetAdapterTest.assertEquals((Object)"check-box", (Object)attr.getPreviousValue());
        AdvancedDataSetAdapterTest.assertEquals((Object)"list-box", (Object)attr.getRevisedValue());
        AdvancedDataSetAdapterTest.assertTrue((boolean)attr.isLinkedReportParameterAttribute());
        attr = (IAmbiguousAttribute)attributes.get(11);
        AdvancedDataSetAdapterTest.assertEquals((String)"displayName", (String)attr.getAttributeName());
        AdvancedDataSetAdapterTest.assertEquals((Object)"Group 1", (Object)attr.getPreviousValue());
        AdvancedDataSetAdapterTest.assertEquals((Object)"updated group", (Object)attr.getRevisedValue());
        AdvancedDataSetAdapterTest.assertTrue((boolean)attr.isLinkedReportParameterAttribute());
        node = (IAmbiguousParameterNode)ambiguousParameters.get(1);
        AdvancedDataSetAdapterTest.assertEquals((String)"dataSetParam3", (String)node.getOdaDataSetParameterHandle().getName());
        attributes = node.getAmbiguousAttributes();
        AdvancedDataSetAdapterTest.assertEquals((int)2, (int)attributes.size());
        attr = (IAmbiguousAttribute)attributes.get(0);
        AdvancedDataSetAdapterTest.assertEquals((String)"nativeName", (String)attr.getAttributeName());
        attr = (IAmbiguousAttribute)attributes.get(1);
        AdvancedDataSetAdapterTest.assertEquals((String)"defaultValue", (String)attr.getAttributeName());
        AdvancedDataSetAdapterTest.assertNull((Object)attr.getRevisedValue());
        Expression oldValue = (Expression)attr.getPreviousValue();
        AdvancedDataSetAdapterTest.assertEquals((String)"data set param default value 3", (String)oldValue.getStringExpression());
    }

    public void testUpdateDataSetHandle() throws Exception {
        DataSetDesign setDesign = this.createDataSetDesign();
        this.openDesign("AdvancedDataSetAdapterTest.xml");
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        ArrayList<OdaDataSetParameter> parameterList = new ArrayList<OdaDataSetParameter>();
        List setDefinedParams = setHandle.getListProperty("parameters");
        parameterList.add((OdaDataSetParameter)setDefinedParams.get(0));
        new ModelOdaAdapter().updateDataSetHandle(setDesign, setHandle, parameterList, null, true);
        this.save();
        AdvancedDataSetAdapterTest.assertTrue((boolean)this.compareTextFile("AdvancedDataSetAdapterTest_golden.xml"));
    }

    private DataSetDesign createDataSetDesign_1() {
        DataSetDesign setDesign = DesignFactory.eINSTANCE.createDataSetDesign();
        setDesign.setName("myDataSet1");
        setDesign.setDisplayName("data set display name");
        setDesign.setOdaExtensionDataSetId("org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
        ResultSetColumns setColumns = DesignFactory.eINSTANCE.createResultSetColumns();
        ColumnDefinition columnDefn = DesignFactory.eINSTANCE.createColumnDefinition();
        DataElementAttributes dataAttrs = DesignFactory.eINSTANCE.createDataElementAttributes();
        dataAttrs.setName("user-name");
        dataAttrs.setPosition(1);
        dataAttrs.setNativeDataTypeCode(10);
        columnDefn.setAttributes(dataAttrs);
        DataElementUIHints uiHints = DesignFactory.eINSTANCE.createDataElementUIHints();
        uiHints.setDisplayName("display name for user name");
        uiHints.setDisplayNameKey("displayNameForUserNameKey");
        dataAttrs.setUiHints(uiHints);
        OutputElementAttributes outAttrs = DesignFactory.eINSTANCE.createOutputElementAttributes();
        outAttrs.setHelpText("help text for user name");
        outAttrs.setHelpTextKey("helpTextForUserNameKey");
        ValueFormatHints formatHints = DesignFactory.eINSTANCE.createValueFormatHints();
        formatHints.setDisplayFormat("##.#");
        outAttrs.setFormattingHints(formatHints);
        columnDefn.setUsageHints(outAttrs);
        AxisAttributes axisAttrs = DesignFactory.eINSTANCE.createAxisAttributes();
        axisAttrs.setAxisType(AxisType.DIMENSION_MEMBER_LITERAL);
        axisAttrs.setOnColumnLayout(true);
        columnDefn.setMultiDimensionAttributes(axisAttrs);
        setColumns.getResultColumnDefinitions().add((Object)columnDefn);
        columnDefn = DesignFactory.eINSTANCE.createColumnDefinition();
        dataAttrs = DesignFactory.eINSTANCE.createDataElementAttributes();
        dataAttrs.setName("user-id");
        dataAttrs.setPosition(2);
        dataAttrs.setNativeDataTypeCode(10);
        columnDefn.setAttributes(dataAttrs);
        uiHints = DesignFactory.eINSTANCE.createDataElementUIHints();
        uiHints.setDisplayName("display name for user id");
        uiHints.setDisplayNameKey("displayNameForUserIDKey");
        dataAttrs.setUiHints(uiHints);
        outAttrs = DesignFactory.eINSTANCE.createOutputElementAttributes();
        outAttrs.setHelpText("help text for user id");
        outAttrs.setHelpTextKey("helpTextForUserIDKey");
        formatHints = DesignFactory.eINSTANCE.createValueFormatHints();
        formatHints.setDisplayFormat("#.#");
        outAttrs.setFormattingHints(formatHints);
        columnDefn.setUsageHints(outAttrs);
        axisAttrs = DesignFactory.eINSTANCE.createAxisAttributes();
        axisAttrs.setAxisType(AxisType.DIMENSION_ATTRIBUTE_LITERAL);
        axisAttrs.setOnColumnLayout(true);
        columnDefn.setMultiDimensionAttributes(axisAttrs);
        setColumns.getResultColumnDefinitions().add((Object)columnDefn);
        columnDefn = DesignFactory.eINSTANCE.createColumnDefinition();
        dataAttrs = DesignFactory.eINSTANCE.createDataElementAttributes();
        dataAttrs.setName("credit");
        dataAttrs.setPosition(3);
        dataAttrs.setNativeDataTypeCode(3);
        columnDefn.setAttributes(dataAttrs);
        uiHints = DesignFactory.eINSTANCE.createDataElementUIHints();
        uiHints.setDisplayName("display name for credit");
        uiHints.setDisplayNameKey("displayNameForCreditKey");
        dataAttrs.setUiHints(uiHints);
        outAttrs = DesignFactory.eINSTANCE.createOutputElementAttributes();
        outAttrs.setHelpText("help text for credit");
        outAttrs.setHelpTextKey("helpTextForCreditKey");
        formatHints = DesignFactory.eINSTANCE.createValueFormatHints();
        formatHints.setDisplayFormat("#.##");
        outAttrs.setFormattingHints(formatHints);
        columnDefn.setUsageHints(outAttrs);
        axisAttrs = DesignFactory.eINSTANCE.createAxisAttributes();
        axisAttrs.setAxisType(AxisType.MEASURE_LITERAL);
        axisAttrs.setOnColumnLayout(true);
        columnDefn.setMultiDimensionAttributes(axisAttrs);
        setColumns.getResultColumnDefinitions().add((Object)columnDefn);
        resultSetDefn.setResultSetColumns(setColumns);
        setDesign.setPrimaryResultSet(resultSetDefn);
        setDesign.setPrimaryResultSetName("resultset1");
        setDesign.setQueryText("new query text");
        setDesign.setDataSourceDesign(this.createDataSourceDesign());
        return setDesign;
    }

    public void testGetAmbiguousResultSets() throws Exception {
        DataSetDesign setDesign = this.createDataSetDesign_1();
        this.openDesign("AdvancedDataSetAdapterTest_1.xml");
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        IAmbiguousOption option = new ModelOdaAdapter().getAmbiguousOption(setDesign, setHandle);
        List resultSets = option.getAmbiguousResultSets();
        AdvancedDataSetAdapterTest.assertEquals((int)2, (int)resultSets.size());
        IAmbiguousResultSetNode node = (IAmbiguousResultSetNode)resultSets.get(0);
        AdvancedDataSetAdapterTest.assertEquals((String)"userName", (String)node.getOdaResultSetColumnHandle().getColumnName());
        List attrs = node.getAmbiguousAttributes();
        AdvancedDataSetAdapterTest.assertEquals((int)8, (int)attrs.size());
        IAmbiguousAttribute attr = (IAmbiguousAttribute)attrs.get(0);
        AdvancedDataSetAdapterTest.assertEquals((String)"nativeDataType", (String)attr.getAttributeName());
        AdvancedDataSetAdapterTest.assertEquals(null, (Object)attr.getPreviousValue());
        AdvancedDataSetAdapterTest.assertEquals((Object)10, (Object)attr.getRevisedValue());
        node = (IAmbiguousResultSetNode)resultSets.get(1);
        AdvancedDataSetAdapterTest.assertEquals((String)"customerName", (String)node.getOdaResultSetColumnHandle().getColumnName());
        attrs = node.getAmbiguousAttributes();
        AdvancedDataSetAdapterTest.assertEquals((int)1, (int)attrs.size());
        attr = (IAmbiguousAttribute)attrs.get(0);
        AdvancedDataSetAdapterTest.assertEquals((String)"nativeName", (String)attr.getAttributeName());
        AdvancedDataSetAdapterTest.assertEquals(null, (Object)attr.getPreviousValue());
        AdvancedDataSetAdapterTest.assertEquals((Object)"user-id", (Object)attr.getRevisedValue());
    }

    public void testUpdateResultSets() throws Exception {
        DataSetDesign setDesign = this.createDataSetDesign_1();
        this.openDesign("AdvancedDataSetAdapterTest_1.xml");
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        ArrayList<OdaResultSetColumn> columnList = new ArrayList<OdaResultSetColumn>();
        List setDefinedColumns = setHandle.getListProperty("resultSet");
        columnList.add((OdaResultSetColumn)setDefinedColumns.get(0));
        new ModelOdaAdapter().updateDataSetHandle(setDesign, setHandle, null, columnList, true);
        this.save();
        AdvancedDataSetAdapterTest.assertTrue((boolean)this.compareTextFile("AdvancedDataSetAdapterTest_golden_1.xml"));
    }
}

