/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.api;

import org.eclipse.birt.report.model.adapter.oda.ModelOdaAdapter;
import org.eclipse.birt.report.model.adapter.oda.util.BaseTestCase;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.OdaDesignerStateHandle;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignerState;
import org.eclipse.datatools.connectivity.oda.design.DesignerStateContent;
import org.eclipse.datatools.connectivity.oda.design.Properties;

public class OdaDataSourceAdapterTest
extends BaseTestCase {
    private static final String INPUT_FILE = "OdaDataSourceConvertTest.xml";
    private static final String GOLDEN_FILE = "OdaDataSourceConvertTest_golden.xml";
    private static final String INPUT_FILE_WITH_EMPTY_PROPS = "OdaDataSourceEmptyProps.xml";
    private static final String GOLDEN_FILE_WITH_EMPTY_PROPS = "OdaDataSourceEmptyProps_golden.xml";
    private static final String GOLDEN_FILE1_WITH_EMPTY_PROPS = "OdaDataSourceEmptyProps_golden_1.xml";
    private static final String DATA_SOURCE_EXTENSIONID = "org.eclipse.birt.report.data.oda.jdbc";

    public void testROMDataSourceToODADataSource() throws Exception {
        this.openDesign(INPUT_FILE);
        OdaDataSourceHandle sourceHandle = (OdaDataSourceHandle)this.designHandle.findDataSource("myDataSource1");
        DataSourceDesign sourceDesign = new ModelOdaAdapter().createDataSourceDesign(sourceHandle);
        OdaDataSourceAdapterTest.assertEquals((String)"myDataSource1", (String)sourceDesign.getName());
        OdaDataSourceAdapterTest.assertEquals((String)DATA_SOURCE_EXTENSIONID, (String)sourceDesign.getOdaExtensionId());
        OdaDataSourceAdapterTest.assertEquals((String)"My Data Source One", (String)sourceDesign.getDisplayName());
        Properties props = sourceDesign.getPublicProperties();
        OdaDataSourceAdapterTest.assertEquals((int)9, (int)props.getProperties().size());
        OdaDataSourceAdapterTest.assertEquals((String)"com.mysql.jdbc.Driver", (String)props.findProperty("odaDriverClass").getValue());
        OdaDataSourceAdapterTest.assertEquals((String)"jdbc:mysql://localhost:3306/birt", (String)props.findProperty("odaURL").getValue());
        OdaDataSourceAdapterTest.assertNull((Object)props.findProperty("odaUser").getValue());
        OdaDataSourceAdapterTest.assertNull((Object)props.findProperty("odaPassword").getValue());
        props = sourceDesign.getPrivateProperties();
        OdaDataSourceAdapterTest.assertEquals((int)2, (int)props.getProperties().size());
        OdaDataSourceAdapterTest.assertEquals((String)"User", (String)props.findProperty("odaUser").getValue());
        OdaDataSourceAdapterTest.assertEquals((String)"Password", (String)props.findProperty("odaPassword").getValue());
    }

    public void testODADataSourceToROMDataSource() throws Exception {
        DataSourceDesign sourceDesign = this.createDataSourceDesign();
        this.createDesign();
        OdaDataSourceHandle sourceHandle = new ModelOdaAdapter().createDataSourceHandle(sourceDesign, (ModuleHandle)this.designHandle);
        OdaDataSourceAdapterTest.assertFalse((boolean)this.designHandle.getCommandStack().canUndo());
        OdaDataSourceAdapterTest.assertFalse((boolean)this.designHandle.getCommandStack().canRedo());
        this.designHandle.getDataSources().add((DesignElementHandle)sourceHandle);
        this.save();
        OdaDataSourceAdapterTest.assertTrue((boolean)this.compareTextFile(GOLDEN_FILE));
    }

    public void testUpdateROMDataSourceWithODADataSource() throws Exception {
        this.openDesign(INPUT_FILE_WITH_EMPTY_PROPS);
        OdaDataSourceHandle sourceHandle = (OdaDataSourceHandle)this.designHandle.findDataSource("myDataSource1");
        DataSourceDesign sourceDesign = this.createDataSourceDesign();
        new ModelOdaAdapter().updateDataSourceHandle(sourceDesign, sourceHandle);
        OdaDataSourceAdapterTest.assertTrue((boolean)this.designHandle.getCommandStack().canUndo());
        OdaDataSourceAdapterTest.assertFalse((boolean)this.designHandle.getCommandStack().canRedo());
        this.designHandle.getCommandStack().undo();
        OdaDataSourceAdapterTest.assertFalse((boolean)this.designHandle.getCommandStack().canUndo());
        OdaDataSourceAdapterTest.assertTrue((boolean)this.designHandle.getCommandStack().canRedo());
        this.save();
        OdaDataSourceAdapterTest.assertTrue((boolean)this.compareTextFile(GOLDEN_FILE_WITH_EMPTY_PROPS));
        this.designHandle.getCommandStack().redo();
        this.save();
        OdaDataSourceAdapterTest.assertTrue((boolean)this.compareTextFile(GOLDEN_FILE1_WITH_EMPTY_PROPS));
    }

    private DataSourceDesign createDataSourceDesign() {
        DataSourceDesign sourceDesign = DesignFactory.eINSTANCE.createDataSourceDesign();
        sourceDesign.setName("my data source design");
        sourceDesign.setDisplayName("data source display name");
        sourceDesign.setOdaExtensionId(DATA_SOURCE_EXTENSIONID);
        Properties props = DesignFactory.eINSTANCE.createProperties();
        props.setProperty("odaDriverClass", "new drivers");
        props.setProperty("odaURL", "jdbc:sqlserver://localhost");
        props.setProperty("odaUser", "new user");
        sourceDesign.setPublicProperties(props);
        props = DesignFactory.eINSTANCE.createProperties();
        props.setProperty("odaDriverClass", "new drivers");
        props.setProperty("odaPassword", "new password");
        sourceDesign.setPrivateProperties(props);
        return sourceDesign;
    }

    public void testDesignerState() throws Exception {
        this.openDesign(INPUT_FILE);
        OdaDataSourceHandle sourceHandle = (OdaDataSourceHandle)this.designHandle.findDataSource("myDataSource1");
        DesignerState designerState = new ModelOdaAdapter().newOdaDesignerState(sourceHandle);
        OdaDataSourceAdapterTest.assertEquals((String)"1.1", (String)designerState.getVersion());
        DesignerStateContent stateContent = designerState.getStateContent();
        OdaDataSourceAdapterTest.assertEquals((String)"content as blob", (String)new String(stateContent.getStateContentAsBlob(), "8859_1"));
        OdaDataSourceAdapterTest.assertNull((Object)stateContent.getStateContentAsString());
        designerState.setVersion("2.0");
        designerState.setNewStateContentAsString("content as string 2.0");
        new ModelOdaAdapter().updateROMDesignerState(designerState, sourceHandle);
        this.compareTextFile("UpdateROMDesignerState_golden.xml");
        sourceHandle.setDesignerState(null);
        OdaDataSourceAdapterTest.assertNull((Object)sourceHandle.getDesignerState());
        new ModelOdaAdapter().updateROMDesignerState(designerState, sourceHandle);
        OdaDesignerStateHandle romDesignerState = sourceHandle.getDesignerState();
        OdaDataSourceAdapterTest.assertNotNull((Object)romDesignerState);
        OdaDataSourceAdapterTest.assertEquals((String)"2.0", (String)romDesignerState.getVersion());
    }
}

